/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CounterPanel
extends Composite {
    protected Text fNumberOfErrors;
    protected Text fNumberOfFailures;
    protected Text fNumberOfRuns;
    protected int fTotal;
    protected int fIgnoredCount;
    protected int fAssumptionFailedCount;
    private final Image fErrorIcon = JUnitPlugin.createImage("ovr16/error_ovr.gif");
    private final Image fFailureIcon = JUnitPlugin.createImage("ovr16/failed_ovr.gif");

    public CounterPanel(Composite parent) {
        super(parent, 64);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 9;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.fNumberOfRuns = this.createLabel(JUnitMessages.CounterPanel_label_runs, null, " 0/0  ");
        this.fNumberOfErrors = this.createLabel(JUnitMessages.CounterPanel_label_errors, this.fErrorIcon, " 0 ");
        this.fNumberOfFailures = this.createLabel(JUnitMessages.CounterPanel_label_failures, this.fFailureIcon, " 0 ");
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CounterPanel.this.disposeIcons();
            }
        });
    }

    private void disposeIcons() {
        this.fErrorIcon.dispose();
        this.fFailureIcon.dispose();
    }

    private Text createLabel(String name, Image image, String init) {
        Label label = new Label((Composite)this, 0);
        if (image != null) {
            image.setBackground(label.getBackground());
            label.setImage(image);
        }
        label.setLayoutData((Object)new GridData(32));
        label = new Label((Composite)this, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData(32));
        Text value = new Text((Composite)this, 8);
        value.setText(init);
        SWTUtil.fixReadonlyTextBackground((Text)value);
        value.setLayoutData((Object)new GridData(800));
        return value;
    }

    public void reset() {
        this.setErrorValue(0);
        this.setFailureValue(0);
        this.setRunValue(0, 0, 0);
        this.fTotal = 0;
    }

    public void setTotal(int value) {
        this.fTotal = value;
    }

    public int getTotal() {
        return this.fTotal;
    }

    public void setRunValue(int value, int ignoredCount, int assumptionFailureCount) {
        String runStringTooltip;
        String runString;
        if (ignoredCount == 0 && assumptionFailureCount == 0) {
            runStringTooltip = runString = Messages.format((String)JUnitMessages.CounterPanel_runcount, (Object[])new String[]{Integer.toString(value), Integer.toString(this.fTotal)});
        } else if (ignoredCount != 0 && assumptionFailureCount == 0) {
            runString = Messages.format((String)JUnitMessages.CounterPanel_runcount_skipped, (Object[])new String[]{Integer.toString(value), Integer.toString(this.fTotal), Integer.toString(ignoredCount)});
            runStringTooltip = Messages.format((String)JUnitMessages.CounterPanel_runcount_ignored, (Object[])new String[]{Integer.toString(value), Integer.toString(this.fTotal), Integer.toString(ignoredCount)});
        } else if (ignoredCount == 0 && assumptionFailureCount != 0) {
            runString = Messages.format((String)JUnitMessages.CounterPanel_runcount_skipped, (Object[])new String[]{Integer.toString(value), Integer.toString(this.fTotal), Integer.toString(assumptionFailureCount)});
            runStringTooltip = Messages.format((String)JUnitMessages.CounterPanel_runcount_assumptionsFailed, (Object[])new String[]{Integer.toString(value), Integer.toString(this.fTotal), Integer.toString(assumptionFailureCount)});
        } else {
            runString = Messages.format((String)JUnitMessages.CounterPanel_runcount_skipped, (Object[])new String[]{Integer.toString(value), Integer.toString(this.fTotal), Integer.toString(ignoredCount + assumptionFailureCount)});
            runStringTooltip = Messages.format((String)JUnitMessages.CounterPanel_runcount_ignored_assumptionsFailed, (Object[])new String[]{Integer.toString(value), Integer.toString(this.fTotal), Integer.toString(ignoredCount), Integer.toString(assumptionFailureCount)});
        }
        this.fNumberOfRuns.setText(runString);
        this.fNumberOfRuns.setToolTipText(runStringTooltip);
        if (this.fIgnoredCount == 0 && ignoredCount > 0 || this.fIgnoredCount != 0 && ignoredCount == 0) {
            this.layout();
        } else if (this.fAssumptionFailedCount == 0 && assumptionFailureCount > 0 || this.fAssumptionFailedCount != 0 && assumptionFailureCount == 0) {
            this.layout();
        } else {
            this.fNumberOfRuns.redraw();
            this.redraw();
        }
        this.fIgnoredCount = ignoredCount;
        this.fAssumptionFailedCount = assumptionFailureCount;
    }

    public void setErrorValue(int value) {
        this.fNumberOfErrors.setText(Integer.toString(value));
        this.redraw();
    }

    public void setFailureValue(int value) {
        this.fNumberOfFailures.setText(Integer.toString(value));
        this.redraw();
    }
}

