/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.extquantfiles.process;

import org.apache.log4j.Logger;
import org.grits.toolbox.entry.ms.extquantfiles.process.ExternalQuantColumnInfo;
import org.grits.toolbox.entry.ms.extquantfiles.process.FullMzXMLDataProcessor;
import org.grits.toolbox.entry.ms.extquantfiles.process.QuantFileProcessor;
import org.grits.toolbox.ms.file.extquant.data.ExternalQuantSettings;
import org.grits.toolbox.ms.file.extquant.data.QuantPeakMatch;
import org.grits.toolbox.ms.om.data.Peak;

public class FullMzXMLExternalQuantDataProcessor
extends FullMzXMLDataProcessor {
    private static final Logger logger = Logger.getLogger(FullMzXMLExternalQuantDataProcessor.class);

    public FullMzXMLExternalQuantDataProcessor(ExternalQuantSettings a_parameter) {
        super(a_parameter);
    }

    @Override
    public boolean setExternalPeakData(Peak a_peak, QuantPeakMatch cPeak) {
        String sKey = QuantFileProcessor.getExternalQuantProcessorKey(this.getKeyID(), "full_ms");
        String sLabel = QuantFileProcessor.getExternalQuantProcessorLabel(this.getLabelAlias(), "Full MS");
        String sDeconvoIntKey = ExternalQuantColumnInfo.getExternalQuantDeconvolutedIntensity(sKey, sLabel).getKey();
        String sIntKey = ExternalQuantColumnInfo.getExternalQuantIntensity(sKey, sLabel).getKey();
        String sMzKey = ExternalQuantColumnInfo.getExternalQuantIntensityMz(sKey, sLabel).getKey();
        if (cPeak == null) {
            a_peak.getDoubleProp().remove(sDeconvoIntKey);
            a_peak.getDoubleProp().remove(sIntKey);
            a_peak.getDoubleProp().remove(sMzKey);
            return true;
        }
        boolean bAdd = true;
        if (a_peak.getDoubleProp().containsKey(sDeconvoIntKey) && a_peak.getDoubleProp().containsKey(sIntKey) && a_peak.getDoubleProp().containsKey(sMzKey)) {
            bAdd = false;
            Double dVal1 = (Double)a_peak.getDoubleProp().get(sDeconvoIntKey);
            Double dVal2 = cPeak.getParent().getSumIntensity();
            if (dVal2 != null && (dVal1 == null || Double.compare(dVal1, dVal2) != 0)) {
                bAdd = true;
            }
            dVal1 = (Double)a_peak.getDoubleProp().get(sIntKey);
            dVal2 = cPeak.getIntensitySum();
            if (dVal2 != null && (dVal1 == null || Double.compare(dVal1, dVal2) != 0)) {
                bAdd = true;
            }
            dVal1 = (Double)a_peak.getDoubleProp().get(sMzKey);
            dVal2 = cPeak.getMzMostAbundant();
            if (dVal2 != null && (dVal1 == null || Double.compare(dVal1, dVal2) != 0)) {
                bAdd = true;
            }
        }
        if (bAdd) {
            a_peak.addDoubleProp(sDeconvoIntKey, cPeak.getParent().getSumIntensity());
            a_peak.addDoubleProp(sIntKey, cPeak.getIntensitySum());
            a_peak.addDoubleProp(sMzKey, cPeak.getMzMostAbundant());
        }
        return bAdd;
    }
}

