/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.views.tabbed;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.DataModelHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.editor.ScrollableEntryEditorPart;
import org.grits.toolbox.core.img.ImageShare;
import org.grits.toolbox.core.utilShare.ComboPopupSelectionListener;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.core.utilShare.ListenerFactory;
import org.grits.toolbox.entry.ms.ImageRegistry;
import org.grits.toolbox.entry.ms.command.ViewMassSpecOverviewCommandExecutor;
import org.grits.toolbox.entry.ms.dialog.MassSpecFileAddDialog;
import org.grits.toolbox.entry.ms.preference.MassSpecPreference;
import org.grits.toolbox.entry.ms.preference.MassSpecPreferenceLoader;
import org.grits.toolbox.entry.ms.property.CopyFilesRunnableWithProgress;
import org.grits.toolbox.entry.ms.property.FileLock;
import org.grits.toolbox.entry.ms.property.FileLockManager;
import org.grits.toolbox.entry.ms.property.FileLockingUtils;
import org.grits.toolbox.entry.ms.property.LockEntry;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecMetaData;
import org.grits.toolbox.entry.ms.views.tabbed.content.MassSpecFileListTableComposite;
import org.grits.toolbox.ms.file.FileCategory;
import org.grits.toolbox.ms.file.MSFile;
import org.grits.toolbox.ms.om.data.Method;

public class MassSpecOverviewPage
extends ScrollableEntryEditorPart {
    private static final Logger logger = Logger.getLogger(MassSpecOverviewPage.class);
    private static final ImageDescriptor MSCONVERT_ICON = ImageRegistry.getImageDescriptor("org.grits.toolbox.entry.ms", ImageRegistry.MSImage.MSCONVERT_ICON);
    private static final ImageDescriptor GLYCRESOFT_ICON = ImageRegistry.getImageDescriptor("org.grits.toolbox.entry.ms", ImageRegistry.MSImage.GLYCRESOFT_ICON);
    private Label msTypeLabel;
    private Label descriptionLabel;
    private Text descriptionText;
    private Combo experimentTypeCombo;
    private Label instrumentLabel;
    private Text instrumentText;
    private MassSpecPreference preferences = null;
    MPart part;
    private Tree fileTree;
    private TreeViewer fileTableViewer;
    FileLockManager fileLockManager;
    @Inject
    private MDirtyable dirtyable;

    @Inject
    public MassSpecOverviewPage(MPart part) {
        this.loadWorkspacePreferences();
        this.entry = (Entry)part.getTransientData().get("org.grits.toolbox.entry.current");
    }

    private FileLockManager loadLockFile() {
        MassSpecProperty pp = (MassSpecProperty)this.entry.getProperty();
        try {
            return FileLockingUtils.readLockFile(pp.getLockFilePath(this.entry));
        }
        catch (IOException | JAXBException e) {
            logger.error((Object)"Cannot load the lock file", e);
            return null;
        }
    }

    @PostConstruct
    public void postConstruct(MPart part, Composite parent) {
        this.part = part;
        this.createPartControl(parent);
    }

    protected void initializeComponents() {
        this.part.setLabel(this.entry.getDisplayName());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.numColumns = 3;
        this.getParent().setLayout((Layout)layout);
        MassSpecProperty pp = (MassSpecProperty)this.entry.getProperty();
        this.createDescription(pp);
        String sMSType = pp.getMassSpecMetaData() != null && pp.getMassSpecMetaData().getMsExperimentType() != null ? pp.getMassSpecMetaData().getMsExperimentType() : "";
        this.experimentTypeCombo = this.createCombo(this.msTypeLabel, this.experimentTypeCombo, "MS Experiment Type", this.preferences.getAllExperimentTypes(), sMSType);
        this.createInstrument(pp);
        this.createFileTable(pp);
    }

    private void createInstrument(MassSpecProperty pp) {
        this.instrumentLabel = new Label(this.getParent(), 16384);
        this.instrumentLabel.setText("Instrument");
        this.instrumentLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 6));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.instrumentText = new Text(this.getParent(), 2048);
        String sInstr = pp.getMassSpecMetaData() != null && pp.getMassSpecMetaData().getInstrument() != null ? pp.getMassSpecMetaData().getInstrument() : "";
        this.instrumentText.setText(sInstr);
        this.instrumentText.setLayoutData((Object)gridData);
        this.instrumentText.addModifyListener(this.getModListener());
        this.instrumentText.addTraverseListener(ListenerFactory.getTabTraverseListener());
        this.instrumentText.addKeyListener(ListenerFactory.getCTRLAListener());
    }

    private void createFileTable(final MassSpecProperty pp) {
        Composite sectionParentComposite = new Composite(this.getParent(), 4);
        sectionParentComposite.setLayout((Layout)new TableWrapLayout());
        GridData compositeLayoutData = new GridData(1808);
        compositeLayoutData.verticalSpan = 10;
        compositeLayoutData.horizontalSpan = 3;
        sectionParentComposite.setLayoutData((Object)compositeLayoutData);
        Color sectionColor = new Color((Device)Display.getCurrent(), 20, 199, 255);
        Color backgroundColor = Display.getCurrent().getSystemColor(25);
        Section section2 = new Section(sectionParentComposite, 320);
        section2.setText("Files");
        section2.setTitleBarBackground(sectionColor);
        section2.setBackground(backgroundColor);
        section2.setTitleBarForeground(Display.getCurrent().getSystemColor(10));
        ToolBarManager toolBarManager2 = new ToolBarManager();
        toolBarManager2.add((IAction)new Action("Show Selected Data"){

            public String getToolTipText() {
                return this.getText();
            }

            public ImageDescriptor getImageDescriptor() {
                return ImageShare.SHOW_SELECTED_ICON;
            }

            public void run() {
                TreeItem[] items = MassSpecOverviewPage.this.fileTree.getSelection();
                if (items.length > 0) {
                    TreeItem selected = items[0];
                    MSPropertyDataFile selectedFile = (MSPropertyDataFile)((Object)selected.getData());
                    MassSpecOverviewPage.this.openMassSpecViewer(selectedFile);
                }
            }
        });
        toolBarManager2.add((IAction)new Action("Upload file"){

            public ImageDescriptor getImageDescriptor() {
                return ImageShare.ADD_ICON;
            }

            public String getToolTipText() {
                return "Upload a new file";
            }

            public void run() {
                TreeItem[] items = MassSpecOverviewPage.this.fileTree.getSelection();
                if (items.length > 0) {
                    TreeItem selected = items[0];
                    if (selected.getParentItem() == null) {
                        MSPropertyDataFile parentFile = (MSPropertyDataFile)((Object)selected.getData());
                        MassSpecOverviewPage.this.addFileToEntry(Display.getCurrent().getActiveShell(), pp, parentFile);
                    } else {
                        MassSpecOverviewPage.this.addFileToEntry(Display.getCurrent().getActiveShell(), pp, null);
                    }
                } else {
                    MassSpecOverviewPage.this.addFileToEntry(Display.getCurrent().getActiveShell(), pp, null);
                }
            }
        });
        toolBarManager2.add((IAction)new Action("Edit"){

            public ImageDescriptor getImageDescriptor() {
                return ImageShare.EDIT_ICON;
            }

            public String getToolTipText() {
                return "Edit selected file";
            }

            public void run() {
                TreeItem[] items = MassSpecOverviewPage.this.fileTree.getSelection();
                if (items.length > 0) {
                    TreeItem selected = items[0];
                    MSPropertyDataFile selectedFile = (MSPropertyDataFile)((Object)selected.getData());
                    MassSpecOverviewPage.this.editAction(Display.getCurrent().getActiveShell(), pp, selectedFile);
                } else {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"No selection", (String)"Please select an entry to edit");
                }
            }
        });
        toolBarManager2.add((IAction)new Action("Delete"){

            public ImageDescriptor getImageDescriptor() {
                return ImageShare.DELETE_ICON;
            }

            public String getToolTipText() {
                return "Delete selected file";
            }

            public void run() {
                TreeItem[] items = MassSpecOverviewPage.this.fileTree.getSelection();
                if (items.length > 0) {
                    TreeItem selected = items[0];
                    MSPropertyDataFile dataFile = (MSPropertyDataFile)((Object)selected.getData());
                    boolean cont = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Confirm", (String)"Are you sure to delete this file? Your action cannot be reverted");
                    if (cont) {
                        MassSpecOverviewPage.this.deleteAction(Display.getCurrent().getActiveShell(), pp, dataFile);
                        if (MassSpecOverviewPage.this.isDirty()) {
                            MassSpecOverviewPage.this.saveFileChanges();
                        }
                    }
                } else {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"No selection", (String)"Please select a file entry below to delete");
                }
            }
        });
        toolBarManager2.add((IAction)new Action("Download file"){

            public ImageDescriptor getImageDescriptor() {
                return ImageShare.DOWNLOAD_ICON;
            }

            public String getToolTipText() {
                return "Download selected file";
            }

            public void run() {
                TreeItem[] items = MassSpecOverviewPage.this.fileTree.getSelection();
                if (items.length > 0) {
                    TreeItem selected = items[0];
                    MSPropertyDataFile file = (MSPropertyDataFile)((Object)selected.getData());
                    String filename = file.getName();
                    if (filename == null || filename.isEmpty()) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"No File", (String)"No file to download for this selection!");
                        return;
                    }
                    MassSpecOverviewPage.this.downloadAction(Display.getCurrent().getActiveShell(), filename);
                } else {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"No selection", (String)"Please select a file entry below to download");
                }
            }
        });
        toolBarManager2.add((IAction)new Action("Convert"){

            public ImageDescriptor getImageDescriptor() {
                return MSCONVERT_ICON;
            }

            public String getToolTipText() {
                return "Convert selected instrument file using MSConvert";
            }

            public boolean isEnabled() {
                return System.getProperty("os.name").startsWith("Windows");
            }

            public void run() {
                TreeItem[] items = MassSpecOverviewPage.this.fileTree.getSelection();
                if (items.length > 0) {
                    TreeItem selected = items[0];
                    MSPropertyDataFile file = (MSPropertyDataFile)((Object)selected.getData());
                    String filename = file.getName();
                    if (filename == null || filename.isEmpty() || !file.getMSFileType().equals("Instrument")) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"No File", (String)"No valid file selected for conversion!");
                        return;
                    }
                    String msPath = MassSpecOverviewPage.getMSPath(MassSpecOverviewPage.this.entry);
                    String convertedFile = MassSpecOverviewPage.this.convertFile(msPath, filename);
                    if (convertedFile != null) {
                        File cFile = new File(String.valueOf(msPath) + File.separator + convertedFile);
                        if (!cFile.exists()) {
                            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Converted file cannot be found. Something went wrong with MSConvert!");
                            return;
                        }
                        String fileFormat = MassSpecOverviewPage.findFileFormatType(file.getCategory(), convertedFile);
                        MSPropertyDataFile newDataFile = new MSPropertyDataFile(convertedFile, "1.0", fileFormat, file.getCategory(), MassSpecOverviewPage.findMSFileType(fileFormat), convertedFile, file.getPurpose(), false);
                        if (!file.containsChild(newDataFile)) {
                            file.addChild(newDataFile);
                            MassSpecOverviewPage.this.saveFileChanges();
                            MassSpecOverviewPage.this.fileTableViewer.refresh();
                            MassSpecOverviewPage.this.fileTableViewer.expandAll();
                        }
                    }
                } else {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"No File", (String)"No valid file selected for conversion! Please select an instrument file");
                    return;
                }
            }
        });
        toolBarManager2.add((IAction)new Action("Glycresoft"){

            public ImageDescriptor getImageDescriptor() {
                return GLYCRESOFT_ICON;
            }

            public String getToolTipText() {
                return "Convert mass spectral data files into deisotoped neutral mass peak lists using Glycresoft";
            }

            public void run() {
                TreeItem[] items = MassSpecOverviewPage.this.fileTree.getSelection();
                if (items.length > 0) {
                    TreeItem selected = items[0];
                    MSPropertyDataFile file = (MSPropertyDataFile)((Object)selected.getData());
                    String filename = file.getName();
                    if (filename == null || filename.isEmpty() || !file.getType().equals("mzML") && !file.getType().equals("mzXML")) {
                        MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"No File", (String)"No valid file selected for processing! Please select an annotation (mzxml/mzml) file");
                        return;
                    }
                    String msPath = MassSpecOverviewPage.getMSPath(MassSpecOverviewPage.this.entry);
                    String convertedFile = MassSpecOverviewPage.this.convertWithGlycresoft(msPath, filename);
                    if (convertedFile != null) {
                        File cFile = new File(convertedFile);
                        if (!cFile.exists()) {
                            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)"Processed file cannot be found. Something went wrong with Glycresoft!");
                            return;
                        }
                        convertedFile = convertedFile.replace(msPath, "");
                        MSPropertyDataFile newDataFile = new MSPropertyDataFile(convertedFile, "1.0", "mzML", FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY, "Processed", convertedFile, file.getPurpose(), false);
                        MSPropertyDataFile parent = MassSpecOverviewPage.this.findParentFile(pp, file);
                        if (parent != null && !parent.containsChild(newDataFile)) {
                            parent.addChild(newDataFile);
                            MassSpecOverviewPage.this.saveFileChanges();
                            MassSpecOverviewPage.this.fileTableViewer.refresh();
                            MassSpecOverviewPage.this.fileTableViewer.expandAll();
                        }
                    }
                } else {
                    MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"No File", (String)"No valid file selected for processing! Please select an annotation (mzxml/mzml) file");
                    return;
                }
            }
        });
        ToolBar toolbar2 = toolBarManager2.createControl((Composite)section2);
        TableWrapData sectionLayoutData = new TableWrapData(128, 64);
        sectionLayoutData.grabHorizontal = true;
        sectionLayoutData.grabVertical = true;
        section2.setLayoutData((Object)sectionLayoutData);
        section2.setTextClient((Control)toolbar2);
        this.fileLockManager = this.loadLockFile();
        MassSpecFileListTableComposite comp = new MassSpecFileListTableComposite((Composite)section2, 64);
        comp.setFileList(pp.getMassSpecMetaData().getFileList());
        comp.setFileLockManager(this.fileLockManager);
        comp.setBackground(backgroundColor);
        comp.setBackgroundMode(2);
        comp.initComponents();
        this.fileTableViewer = comp.getFileTableViewer();
        this.fileTree = this.fileTableViewer.getTree();
        this.fileTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MassSpecOverviewPage.this.mouseDoubleClick(event);
            }
        });
        section2.setClient((Control)comp);
    }

    protected MSPropertyDataFile findParentFile(MassSpecProperty pp, MSPropertyDataFile file) {
        if (pp.getMassSpecMetaData().getFileList() != null) {
            for (MSPropertyDataFile p : pp.getMassSpecMetaData().getFileList()) {
                if (!p.containsChild(file)) continue;
                return p;
            }
        }
        return null;
    }

    protected String convertWithGlycresoft(String msPath, String filename) {
        ECommandService commandService = (ECommandService)this.context.get(ECommandService.class);
        EHandlerService handlerService = (EHandlerService)this.context.get(EHandlerService.class);
        this.context.set("msPath", (Object)msPath);
        this.context.set("mzXMLFile_Path", (Object)filename);
        Object result = handlerService.executeHandler(commandService.createCommand("org.grits.toolbox.entry.ms.command.glycresoft", null));
        if (result != null) {
            return (String)result;
        }
        return null;
    }

    protected String convertFile(String msPath, String filename) {
        ECommandService commandService = (ECommandService)this.context.get(ECommandService.class);
        EHandlerService handlerService = (EHandlerService)this.context.get(EHandlerService.class);
        this.context.set("msPath", (Object)msPath);
        this.context.set("instrumentfile_Path", (Object)filename);
        Object result = handlerService.executeHandler(commandService.createCommand("org.grits.toolbox.entry.ms.command.msconvert", null));
        if (result != null) {
            return (String)result;
        }
        return null;
    }

    protected void openMassSpecViewer(MSPropertyDataFile selectedFile) {
        if (selectedFile != null && (selectedFile.getType().equals("mzML") || selectedFile.getType().equals("mzXML"))) {
            MassSpecEntityProperty msEntityProp = new MassSpecEntityProperty((MassSpecProperty)this.entry.getProperty());
            msEntityProp.setDataFile(selectedFile);
            msEntityProp.setScanNum(-1);
            msEntityProp.setParentScanNum(-1);
            msEntityProp.setMz(0.0);
            msEntityProp.setParentMz(0.0);
            msEntityProp.setMsLevel(1);
            Entry newEntry = new Entry();
            newEntry.setProperty((Property)msEntityProp);
            newEntry.setDisplayName(this.entry.getDisplayName());
            newEntry.setParent(this.entry);
            ViewMassSpecOverviewCommandExecutor.showMSOverview(this.part.getContext(), newEntry);
        }
    }

    protected void mouseDoubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        MSPropertyDataFile selectedFile = (MSPropertyDataFile)((Object)selection.getFirstElement());
        this.openMassSpecViewer(selectedFile);
    }

    protected void editAction(Shell shell, MassSpecProperty pp, MSPropertyDataFile selectedFile) {
        if (selectedFile == null) {
            return;
        }
        MassSpecFileAddDialog dialog = new MassSpecFileAddDialog(shell, pp.getMassSpecMetaData().getFileList(), null, selectedFile, true);
        if (dialog.open() == 0) {
            String file = dialog.getFileName();
            boolean modified = false;
            if (!(file == null || file.isEmpty() || file.equals(selectedFile.getName()) || file.equals(selectedFile.getOriginalFileName()))) {
                try {
                    String format = MassSpecOverviewPage.findFileFormatType(dialog.getFileCategory(), file);
                    String originalFileName = file == null || file.isEmpty() ? "" : file.substring(file.lastIndexOf(File.separator) + 1);
                    selectedFile.setType(format);
                    String msFiletype = MassSpecOverviewPage.findMSFileType(selectedFile.getType());
                    selectedFile.setMSFileType(msFiletype);
                    selectedFile.setName(file);
                    selectedFile.setOriginalFileName(originalFileName);
                    this.processFile(shell, pp, selectedFile, msFiletype);
                    modified = true;
                }
                catch (IOException | JAXBException e) {
                    logger.error((Object)"Could not update the file", e);
                    MessageDialog.openError((Shell)shell, (String)"Edit Error", (String)("Could not update the file info. Reason: " + e.getMessage()));
                    return;
                }
            }
            if (!dialog.getFileCategory().equals((Object)selectedFile.getCategory())) {
                selectedFile.setCategory(dialog.getFileCategory());
                if (selectedFile.getChildren() != null) {
                    for (MSPropertyDataFile f : selectedFile.getChildren()) {
                        f.setCategory(dialog.getFileCategory());
                    }
                }
                modified = true;
            }
            if (modified) {
                this.saveFileChanges();
                this.fileTableViewer.refresh();
                this.fileTableViewer.expandAll();
            }
        }
    }

    protected void deleteAction(Shell activeShell, MassSpecProperty pp, MSPropertyDataFile dataFile) {
        boolean locked;
        if (dataFile == null) {
            return;
        }
        if (dataFile.getIsParent().booleanValue() && dataFile.getChildren() != null && !dataFile.getChildren().isEmpty()) {
            logger.debug((Object)((Object)((Object)dataFile) + " cannot be deleted since it has children. Delete them first then try to delete this entry again!"));
            MessageDialog.openInformation((Shell)activeShell, (String)"Parent", (String)(String.valueOf(dataFile.getOriginalFileName()) + " cannot be deleted since it has children. Delete them first then try to delete this entry again!"));
            return;
        }
        if (dataFile.getIsParent().booleanValue() && (dataFile.getName() == null || dataFile.getName().isEmpty())) {
            pp.getMassSpecMetaData().getFileList().remove((Object)dataFile);
            this.saveFileChanges();
            this.fileTableViewer.refresh();
            this.fileTableViewer.expandAll();
            return;
        }
        String fileName = dataFile.getName();
        if (fileName == null || fileName.isEmpty()) {
            return;
        }
        this.fileLockManager = this.loadLockFile();
        DataModelHandler dm = DataModelHandler.instance();
        if (this.fileLockManager != null && (locked = this.fileLockManager.isFileLocked(fileName))) {
            FileLock fileLock = this.fileLockManager.findFile(fileName);
            ArrayList<String> entryNames = new ArrayList<String>();
            if (fileLock != null && fileLock.getUsedBy() != null) {
                for (LockEntry e : fileLock.getUsedBy()) {
                    Entry entry1 = dm.findEntryById(e.getEntryId());
                    if (entry1 == null) continue;
                    entryNames.add(entry1.getDisplayName());
                }
            }
            MessageDialog.openInformation((Shell)activeShell, (String)"File in Use", (String)(String.valueOf(dataFile.getOriginalFileName()) + " cannot be deleted since it is in use by the following entries: " + entryNames));
            return;
        }
        String msPath = MassSpecOverviewPage.getMSPath(this.entry);
        File file = new File(String.valueOf(msPath) + File.separator + fileName);
        File parentDir = file.getParentFile();
        try {
            if (file.exists()) {
                boolean d = file.delete();
                if (d) {
                    parentDir.delete();
                    if (this.fileLockManager != null) {
                        this.fileLockManager.deleteFile(fileName);
                        FileLockingUtils.writeLockFile(this.fileLockManager, pp.getLockFilePath(this.entry));
                    }
                    this.removeDataFileFromProperty(pp, dataFile);
                    this.saveFileChanges();
                    this.fileTableViewer.refresh();
                    this.fileTableViewer.expandAll();
                } else {
                    MessageDialog.openError((Shell)activeShell, (String)"Error", (String)"File could not be removed");
                }
            } else {
                this.removeDataFileFromProperty(pp, dataFile);
                this.saveFileChanges();
                this.fileTableViewer.refresh();
                this.fileTableViewer.expandAll();
                MessageDialog.openWarning((Shell)activeShell, (String)"Warning", (String)("The file: " + file.getName() + " has already been removed from the workspace"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Could not update lock file", (Throwable)e);
        }
        MSPropertyDataFile emptyParent = null;
        for (MSPropertyDataFile f : pp.getMassSpecMetaData().getFileList()) {
            if (f.getChildren() == null || !f.getChildren().isEmpty() || f.getName() == null || !f.getName().isEmpty()) continue;
            emptyParent = f;
            break;
        }
        if (emptyParent != null) {
            pp.getMassSpecMetaData().getFileList().remove((Object)emptyParent);
            this.saveFileChanges();
            this.fileTableViewer.refresh();
            this.fileTableViewer.expandAll();
        }
    }

    private void removeDataFileFromProperty(MassSpecProperty pp, MSPropertyDataFile dataFile) {
        if (pp.getMassSpecMetaData().getFileList().contains((Object)dataFile)) {
            pp.getMassSpecMetaData().getFileList().remove((Object)dataFile);
        } else {
            for (PropertyDataFile propertyDataFile : pp.getMassSpecMetaData().getFileList()) {
                if (!(propertyDataFile instanceof MSPropertyDataFile) || ((MSPropertyDataFile)propertyDataFile).getChildren() == null || !((MSPropertyDataFile)propertyDataFile).getChildren().contains((Object)dataFile)) continue;
                ((MSPropertyDataFile)propertyDataFile).getChildren().remove((Object)dataFile);
                break;
            }
        }
    }

    private void addFileToEntry(Shell shell, MassSpecProperty pp, MSPropertyDataFile parentFile) {
        MassSpecFileAddDialog dialog = new MassSpecFileAddDialog(shell, pp.getMassSpecMetaData().getFileList(), parentFile);
        if (dialog.open() == 0) {
            boolean modified = false;
            String file = dialog.getFileName();
            String newFileName = "";
            String fileFormat = "";
            try {
                if (file != null && !file.isEmpty()) {
                    fileFormat = MassSpecOverviewPage.findFileFormatType(dialog.getFileCategory(), file);
                    newFileName = file;
                }
                if (fileFormat.equals("")) {
                    MessageDialog.openInformation((Shell)shell, (String)"Error", (String)("Unable to determine file format type for file: " + dialog.getFileName() + "\nPlease make sure the extension of the file is one of the recognized ones by GRITS"));
                    logger.error((Object)("Unable to determine file format type for file: " + dialog.getFileName()));
                    return;
                }
                String msFileType = MassSpecOverviewPage.findMSFileType(fileFormat);
                String originalFileName = file == null || file.isEmpty() ? "" : file.substring(file.lastIndexOf(File.separator) + 1);
                MSPropertyDataFile newDataFile = new MSPropertyDataFile(newFileName, "1.3", fileFormat, dialog.getFileCategory(), msFileType, originalFileName, Arrays.asList(dialog.getFileCategory().getLabel()));
                this.processFile(shell, pp, newDataFile, msFileType);
                MSPropertyDataFile selectedParentFile = dialog.getParentFile();
                if (selectedParentFile != null) {
                    if (!newFileName.isEmpty()) {
                        if (selectedParentFile.containsChild(newDataFile)) {
                            MessageDialog.openInformation((Shell)shell, (String)"Info", (String)"This file is already in the list. Not adding it again");
                        } else {
                            selectedParentFile.addChild(newDataFile);
                            modified = true;
                        }
                    } else {
                        MessageDialog.openError((Shell)shell, (String)"Error", (String)"File name cannot be empty. Not adding the new entry!");
                    }
                } else if (dialog.isInstrumentFile()) {
                    newDataFile.setIsParent(true);
                    MSPropertyDataFile existing = pp.getMassSpecMetaData().addFile(newDataFile);
                    if (existing != null) {
                        MessageDialog.openInformation((Shell)shell, (String)"Info", (String)"This file is already in the list. Not adding it again");
                    } else {
                        modified = true;
                    }
                } else {
                    List<String> purpose = dialog.getFileCategory().equals((Object)FileCategory.ANNOTATION_CATEGORY) ? Arrays.asList(FileCategory.ANNOTATION_CATEGORY.getLabel()) : Arrays.asList(FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY.getLabel());
                    MSPropertyDataFile newParent = new MSPropertyDataFile("", "1.3", "raw", dialog.getFileCategory(), "Instrument", "", purpose);
                    newParent.setIsParent(true);
                    MSPropertyDataFile existing = pp.getMassSpecMetaData().addFile(newParent);
                    if (existing != null) {
                        if (existing.containsChild(newDataFile)) {
                            MessageDialog.openInformation((Shell)shell, (String)"Info", (String)"This file is already in the list. Not adding it again");
                        } else {
                            existing.addChild(newDataFile);
                            modified = true;
                        }
                    } else {
                        newParent.addChild(newDataFile);
                        modified = true;
                    }
                }
                if (modified) {
                    this.saveFileChanges();
                    this.fileTableViewer.setInput(pp.getMassSpecMetaData().getFileList());
                    this.fileTableViewer.refresh();
                    this.fileTableViewer.expandAll();
                }
            }
            catch (IOException | JAXBException e) {
                logger.error((Object)"Could not upload the file", e);
                MessageDialog.openError((Shell)shell, (String)"Upload Error", (String)("Could not upload the file. Reason: " + e.getMessage()));
            }
        }
    }

    public static String findMSFileType(String type) {
        switch (type) {
            case "RAW": {
                return "Instrument";
            }
            case "mzML": {
                return "Converted";
            }
            case "mzXML": {
                return "Converted";
            }
            case "ThermoExtract": {
                return "Processed";
            }
            case "MascotGeneric": {
                return "Processed";
            }
            case "TabDelimited": {
                return "Processed";
            }
        }
        return "";
    }

    public static String findFileFormatType(FileCategory category, String filename) {
        block39: {
            String sExtension;
            block40: {
                int extensionIdx;
                if (filename == null || filename.isEmpty() || (extensionIdx = filename.lastIndexOf(".")) == -1) break block39;
                sExtension = filename.substring(extensionIdx + 1);
                if (!category.equals((Object)FileCategory.ANNOTATION_CATEGORY)) break block40;
                switch (sExtension) {
                    case "mzML": {
                        return "mzML";
                    }
                    case "mzXML": {
                        return "mzXML";
                    }
                    case "RAW": 
                    case "raw": {
                        return "RAW";
                    }
                }
                return "RAW";
            }
            if (!category.equals((Object)FileCategory.EXTERNAL_QUANTIFICATION_CATEGORY)) break block39;
            switch (sExtension) {
                case "mzML": {
                    return "mzML";
                }
                case "mzXML": {
                    return "mzXML";
                }
                case "RAW": 
                case "raw": {
                    return "RAW";
                }
                case "xml": {
                    return "ThermoExtract";
                }
                case "mgf": {
                    return "MascotGeneric";
                }
                case "*.txt": {
                    return "TabDelimited";
                }
            }
            return "RAW";
        }
        return "";
    }

    public void processFile(Shell shell, final MassSpecProperty msProperty, final MSPropertyDataFile newDataFile, String fileType) throws IOException, JAXBException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    boolean bPass;
                    List<MSPropertyDataFile> existingFiles = msProperty.getMassSpecMetaData().getFileList();
                    monitor.beginTask("Validating the file...", -1);
                    MSFile msFile = newDataFile.getMSFileWithReader("", msProperty.getMassSpecMetaData().getMsExperimentType());
                    if ((newDataFile.getMSFileType().equals("Converted") || newDataFile.getMSFileType().equals("Processed")) && msFile.getReader() == null) {
                        throw new Exception("The specified MS File (" + newDataFile.getName() + ") cannot be read.\nMake sure you've selected the correct categorty and type");
                    }
                    if (msFile.getReader() != null && !(bPass = msFile.getReader().isValid(msFile))) {
                        throw new Exception("The specified MS File (" + newDataFile.getName() + ") is not valid.\nPlease correct this and continue.");
                    }
                    String msPath = MassSpecOverviewPage.getMSPath(MassSpecOverviewPage.this.entry);
                    String entryPath = "";
                    if (existingFiles != null && !existingFiles.isEmpty()) {
                        String f = existingFiles.get(0).getName();
                        if (f.contains(File.separator)) {
                            entryPath = f.substring(0, f.lastIndexOf(File.separator));
                        }
                    } else {
                        SimpleDateFormat formater = new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss.SSSS");
                        Date date = new Date();
                        entryPath = formater.format(date);
                        File destMSPath = new File(String.valueOf(msPath) + File.separator + entryPath);
                        destMSPath.mkdirs();
                    }
                    ArrayList<MSPropertyDataFile> allFiles = new ArrayList<MSPropertyDataFile>();
                    allFiles.add(newDataFile);
                    CopyFilesRunnableWithProgress runner = new CopyFilesRunnableWithProgress(allFiles, MassSpecOverviewPage.this.entry, msPath, entryPath);
                    runner.run(monitor);
                    if (!runner.isSuccessful()) {
                        throw new Exception("Error occurred while copying files into workspace.");
                    }
                    if (!runner.iCanceled()) {
                        String newFileName = newDataFile.getName();
                        MassSpecOverviewPage.this.addFilesToLockFile(newFileName, msProperty.getLockFilePath(MassSpecOverviewPage.this.entry));
                    }
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
        try {
            progressMonitorDialog.run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            String cause = "";
            if (e.getTargetException() instanceof InvocationTargetException) {
                if (((InvocationTargetException)e.getTargetException()).getTargetException() != null) {
                    cause = ((InvocationTargetException)e.getTargetException()).getTargetException().getMessage();
                }
            } else if (e.getTargetException() instanceof Throwable) {
                cause = e.getTargetException().getMessage();
            }
            MessageDialog.openError((Shell)shell, (String)"Error", (String)cause);
            logger.error((Object)"Error occurred while copying files into workspace.");
        }
        catch (InterruptedException e) {
            logger.info((Object)"Copying files interrupted", (Throwable)e);
        }
    }

    private static String getMSPath(Entry entry) {
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        Entry projectEntry = DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.project");
        String projectName = projectEntry.getDisplayName();
        File msFolder = new File(String.valueOf(workspaceLocation) + projectName + File.separator + MassSpecProperty.getFoldername());
        return msFolder.getAbsolutePath();
    }

    private void addFilesToLockFile(String filePath, String lockFilePath) throws IOException, JAXBException {
        this.fileLockManager = FileLockingUtils.readLockFile(lockFilePath);
        this.fileLockManager.addFile(filePath);
        FileLockingUtils.writeLockFile(this.fileLockManager, lockFilePath);
    }

    private void downloadAction(Shell shell, String filename) {
        FileDialog fd = new FileDialog(shell, 8192);
        fd.setText("Download");
        fd.setFileName(filename);
        fd.setOverwrite(true);
        String selected = fd.open();
        try {
            if (selected != null && selected.trim().length() != 0) {
                this.downloadFile(filename, selected);
            }
        }
        catch (IOException e1) {
            logger.error((Object)"Could not download file", (Throwable)e1);
            MessageDialog.openError((Shell)shell, (String)"File Download Error", (String)"Could not download the file. It has been removed from the workspace");
        }
    }

    protected void downloadFile(String file, String newPath) throws IOException {
        String msPath = MassSpecOverviewPage.getMSPath(this.entry);
        String filePath = String.valueOf(msPath) + File.separator + file;
        File workspaceFile = new File(filePath);
        FileOutputStream out = new FileOutputStream(newPath);
        Files.copy(workspaceFile.toPath(), out);
        out.close();
    }

    private Combo createCombo(Label label, Combo combo, String labelName, Set<String> values, String selected) {
        GridData derivatizationLabelData = new GridData();
        label = new Label(this.getParent(), 0);
        label.setText(labelName);
        label.setLayoutData((Object)derivatizationLabelData);
        combo = new Combo(this.getParent(), 0x800008);
        GridData comboData = new GridData();
        comboData.grabExcessHorizontalSpace = true;
        comboData.horizontalAlignment = 4;
        comboData.horizontalSpan = 2;
        combo.setLayoutData((Object)comboData);
        combo.add("");
        int count = 1;
        int sel = -1;
        if (values != null) {
            for (String tt : values) {
                if (selected != null && tt.equals(selected)) {
                    sel = count;
                }
                combo.add(tt);
                ++count;
            }
        }
        if (sel == -1 && selected != null && !selected.equals("")) {
            String selectedLabel = Method.getMsLabelByType((String)selected);
            if (selectedLabel != null && combo.indexOf(selectedLabel) != -1) {
                combo.select(combo.indexOf(selectedLabel));
            } else {
                combo.add(selected);
                combo.select(values.size() + 1);
            }
            combo.add("other");
            this.updateThisCombo(labelName, selected, combo.getItems());
        } else {
            combo.select(sel);
            combo.add("other");
        }
        ComboPopupSelectionListener comboLister = new ComboPopupSelectionListener();
        comboLister.setParent(this.getParent());
        combo.addSelectionListener((SelectionListener)comboLister);
        combo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                MassSpecOverviewPage.this.setDirty(true);
            }
        });
        return combo;
    }

    private void createDescription(MassSpecProperty pp) {
        this.descriptionLabel = new Label(this.getParent(), 16384);
        this.descriptionLabel.setText("Description");
        this.descriptionLabel.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 6));
        GridData descriptionTextData = new GridData();
        descriptionTextData.horizontalSpan = 2;
        descriptionTextData.verticalSpan = 6;
        descriptionTextData.horizontalAlignment = 4;
        descriptionTextData.verticalAlignment = 4;
        descriptionTextData.grabExcessVerticalSpace = true;
        descriptionTextData.grabExcessHorizontalSpace = true;
        this.descriptionText = new Text(this.getParent(), 2626);
        String sDesc = pp.getMassSpecMetaData() != null && pp.getMassSpecMetaData().getDescription() != null ? pp.getMassSpecMetaData().getDescription() : "";
        this.descriptionText.setText(sDesc);
        this.descriptionText.setLayoutData((Object)descriptionTextData);
        this.descriptionText.addModifyListener(this.getModListener());
        this.descriptionText.addTraverseListener(ListenerFactory.getTabTraverseListener());
        this.descriptionText.addKeyListener(ListenerFactory.getCTRLAListener());
    }

    protected boolean isValidInput() {
        return this.checkBasicLengthCheck(this.descriptionLabel, this.descriptionText, 0, Integer.parseInt(PropertyHandler.getVariable((String)"descriptionLength")));
    }

    private void saveFileChanges() {
        try {
            Entry projectEntry = DataModelSearch.findParentByType((Entry)this.entry, (String)"org.grits.toolbox.property.project");
            MassSpecProperty property = null;
            property = this.entry.getProperty() instanceof MassSpecEntityProperty ? (MassSpecProperty)((MassSpecEntityProperty)this.entry.getProperty()).getParentProperty() : (MassSpecProperty)this.entry.getProperty();
            MassSpecMetaData settings = property.getMassSpecMetaData();
            String settingsFile = String.valueOf(MassSpecProperty.getFullyQualifiedFolderName(projectEntry)) + File.separator + property.getMSSettingsFile().getName();
            MassSpecProperty.marshallSettingsFile(settingsFile, settings);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected void updateProjectProperty() {
        try {
            Entry projectEntry = DataModelSearch.findParentByType((Entry)this.entry, (String)"org.grits.toolbox.property.project");
            MassSpecProperty property = null;
            property = this.entry.getProperty() instanceof MassSpecEntityProperty ? (MassSpecProperty)((MassSpecEntityProperty)this.entry.getProperty()).getParentProperty() : (MassSpecProperty)this.entry.getProperty();
            MassSpecMetaData settings = property.getMassSpecMetaData();
            settings.setDescription(this.descriptionText.getText());
            settings.setInstrument(this.instrumentText.getText());
            settings.setUpdateDate(new Date());
            if (this.experimentTypeCombo.getSelectionIndex() != -1) {
                String selectedLabel = this.experimentTypeCombo.getItem(this.experimentTypeCombo.getSelectionIndex());
                settings.setMsExperimentType(Method.getMsTypeByLabel((String)selectedLabel));
            }
            String settingsFile = String.valueOf(MassSpecProperty.getFullyQualifiedFolderName(projectEntry)) + File.separator + property.getMSSettingsFile().getName();
            MassSpecProperty.marshallSettingsFile(settingsFile, settings);
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    @Focus
    public void setFocus() {
        this.getParent().setFocus();
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setFocus();
        }
    }

    public void setDirty(boolean d) {
        this.dirtyable.setDirty(d);
    }

    public boolean isDirty() {
        return this.dirtyable.isDirty();
    }

    public Label getDescriptionLabel() {
        return this.descriptionLabel;
    }

    private void updateThisCombo(String labelName, String selected, String[] values) {
        try {
            if (labelName.equals("MS Experiment Type")) {
                this.preferences.getAllExperimentTypes().add(selected);
            }
            this.preferences.saveValues();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ErrorUtils.createErrorMessageBox((Shell)this.getParent().getShell(), (String)"Preference Error", (Exception)e);
        }
    }

    protected void savePreference() {
        try {
            this.preferences.saveValues();
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private boolean loadWorkspacePreferences() {
        try {
            this.preferences = MassSpecPreferenceLoader.getMassSpecPreferences();
        }
        catch (Exception ex) {
            logger.error((Object)"Error getting the mass spec preferences", (Throwable)ex);
        }
        return this.preferences != null;
    }
}

