/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.views.tabbed;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessor;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecResultsComposite;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecScansView;

public class MassSpecPeaksView
extends MassSpecScansView {
    private static final Logger logger = Logger.getLogger(MassSpecPeaksView.class);
    public static final String VIEW_ID = "plugin.ms.annotation.views.MassSpecPeaks";
    private Composite compositeTop = null;

    @Inject
    public MassSpecPeaksView(@Optional Entry entry, @Optional Property msEntityProperty, @Named(value="MinMSLevelContext") int iMinMSLevel) {
        super(entry, msEntityProperty, iMinMSLevel);
    }

    @Override
    public String toString() {
        return "MassSpecPeaksView (" + this.entry + ")";
    }

    @Override
    protected void initResultsView(Composite parent) throws Exception {
        this.parent = parent.getParent().getParent();
        this.compositeTop = new Composite(parent, 2048);
        this.compositeTop.setLayout((Layout)new GridLayout(1, false));
        try {
            this.resultsComposite = this.getNewResultsComposite(this.compositeTop, 0);
            this.resultsComposite.createPartControl(this.compositeTop, this, this.entityProperty, this.dataProcessor, FillTypes.PeakList);
            this.resultsComposite.setLayout((Layout)new FillLayout());
            this.viewBase = this.resultsComposite.getBaseView();
        }
        catch (Exception e) {
            this.viewBase = null;
            this.resultsComposite = null;
            logger.error((Object)"Error in MassSpecScansView: initResultsView");
            throw new Exception(e.getMessage());
        }
    }

    protected void createPeaksView(Composite container) throws Exception {
        this.initResultsView(container);
    }

    @Override
    public void createPartControl(Composite parent) {
        try {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new FillLayout());
            this.entry = this.getEntry();
            this.createPeaksView(container);
            this.addListeners(container);
        }
        catch (Exception exception) {
            this.viewBase = null;
            this.resultsComposite = null;
        }
    }

    @Override
    protected MassSpecResultsComposite getNewResultsComposite(Composite composite, int style) {
        return new MassSpecResultsComposite(composite, style);
    }

    public Composite getTopPane() {
        return this.compositeTop;
    }

    @Override
    protected TableDataProcessor getNewTableDataProcessor(Entry entry, Property entityProperty) {
        MassSpecTableDataProcessor proc = new MassSpecTableDataProcessor(entry, entityProperty, FillTypes.PeakList, this.getMinMSLevel());
        proc.initializeTableDataObject(entityProperty);
        return proc;
    }

    @Override
    protected TableDataProcessor getNewTableDataProcessor(Property entityProperty) {
        MassSpecMultiPageViewer parentViewer = MassSpecMultiPageViewer.getActiveViewerForEntry(this.context, this.getEntry().getParent());
        if (parentViewer == null || parentViewer.getPeaksView().isEmpty()) {
            return null;
        }
        TableDataProcessor parentProc = parentViewer.getPeaksView().get(0).getTableDataProcessor();
        if (parentProc == null) {
            return null;
        }
        if (!parentProc.getSourceProperty().equals(entityProperty)) {
            return null;
        }
        MassSpecTableDataProcessor proc = new MassSpecTableDataProcessor(parentProc, entityProperty, FillTypes.PeakList);
        proc.initializeTableDataObject(entityProperty);
        return proc;
    }

    @Override
    protected void updateProjectProperty() {
    }

    @Override
    protected void savePreference() {
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void setDirty(boolean d) {
        super.setDirty(d);
    }

    @Persist
    public void doSave(IProgressMonitor monitor) {
        this.viewBase.doSave(monitor);
        this.setDirty(false);
    }

    @Override
    public boolean isDirty() {
        return super.isDirty();
    }
}

