/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.tablehelpers;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataProvider;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.display.control.table.tablecore.DoubleFormat;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationCellOverrideLabelAccumulator;

public class MSGlycanAnnotationCellOverrideLabelAccumulator<T>
extends MSAnnotationCellOverrideLabelAccumulator<T> {
    private List<Integer> alCartoonCols = null;

    public MSGlycanAnnotationCellOverrideLabelAccumulator(IRowDataProvider<T> dataProvider, List<Integer> alCartoonCols, Integer filterCol, Integer commentCol, Integer ratioCol, List<Integer> intensityCols) {
        super(dataProvider, null, filterCol, commentCol, ratioCol, intensityCols);
        this.alCartoonCols = alCartoonCols;
    }

    public MSGlycanAnnotationCellOverrideLabelAccumulator(IRowDataProvider<T> dataProvider, List<Integer> alCartoonCols, Integer iSelectedCol, Integer filterCol, Integer commentCol, Integer ratioCol, List<Integer> intensityCols) {
        super(dataProvider, iSelectedCol, filterCol, commentCol, ratioCol, intensityCols);
        this.alCartoonCols = alCartoonCols;
    }

    public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
        Integer filterVal;
        super.accumulateConfigLabels(configLabels, columnPosition, rowPosition);
        GRITSListDataRow rowObj = ((GRITSListDataProvider)this.dataProvider).getGRITSListDataRow(rowPosition);
        if (rowObj == null) {
            return;
        }
        if (this.filterCol != null) {
            filterVal = (Integer)rowObj.getDataRow().get(this.filterCol);
            if (filterVal != null && filterVal.equals(11)) {
                configLabels.addLabel("filteredAndSelected");
            } else if (filterVal != null && filterVal.equals(1)) {
                configLabels.addLabel("filteredNotSelected");
            }
        }
        if (this.filterCol != null && columnPosition == this.filterCol) {
            filterVal = (Integer)rowObj.getDataRow().get(this.filterCol);
            if (filterVal == null || filterVal < 0) {
                configLabels.addLabel("notfiltered");
            } else if (filterVal != null && filterVal.equals(0)) {
                configLabels.addLabel("No Match");
            } else if (filterVal != null && filterVal.equals(11)) {
                configLabels.addLabel("Match");
            } else if (filterVal != null && filterVal.equals(1)) {
                configLabels.addLabel("Hidden Match");
            }
        }
        if (this.alCartoonCols.contains(columnPosition)) {
            String sCartoonFile = (String)rowObj.getDataRow().get(columnPosition);
            if (sCartoonFile == null || sCartoonFile.equals("")) {
                return;
            }
            configLabels.addLabel(sCartoonFile);
        } else if (this.iSelectedCol != null && columnPosition == this.iSelectedCol) {
            configLabels.addLabel(TableDataProcessor.selColHeader.getLabel());
        }
        if (this.intensityCols != null && this.intensityCols.contains(columnPosition)) {
            configLabels.addLabel(DoubleFormat.SCIENTIFIC_NOTATION.name());
        }
    }
}

