/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.content;

import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.content.AnnotationSettingsTableComposite;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.Fragment;
import org.grits.toolbox.ms.om.data.FragmentPerActivationMethod;
import org.grits.toolbox.ms.om.data.FragmentPerMsLevel;
import org.grits.toolbox.ms.om.data.GlycanSettings;

public class GlycanSettingsTableComposite
extends AnnotationSettingsTableComposite {
    public GlycanSettingsTableComposite(Composite parent, int style) {
        super(parent, style);
    }

    public void createAnalyteSettingsTable() {
        Label label = new Label((Composite)this, 0);
        label.setText("Glycan Settings");
        Tree glycanSettingsTree = new Tree((Composite)this, 0);
        glycanSettingsTree.setHeaderVisible(true);
        glycanSettingsTree.setLinesVisible(true);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        gd.heightHint = 100;
        glycanSettingsTree.setLayoutData((Object)gd);
        TreeColumn nameColumn = new TreeColumn(glycanSettingsTree, 0);
        nameColumn.setText("Setting");
        nameColumn.setWidth(200);
        TreeColumn valueColumn = new TreeColumn(glycanSettingsTree, 0);
        valueColumn.setText("Value");
        valueColumn.setWidth(150);
        if (!this.method.getAnalyteSettings().isEmpty() && this.method.getAnalyteSettings().get(0) != null) {
            this.addTreeData(glycanSettingsTree, ((AnalyteSettings)this.method.getAnalyteSettings().get(0)).getGlycanSettings());
        }
        glycanSettingsTree.redraw();
    }

    private void addTreeData(Tree glycanSettingsTree, GlycanSettings gSettings) {
        TreeItem item = new TreeItem(glycanSettingsTree, 0);
        String sIons = "";
        String sw = "";
        for (Fragment frag : gSettings.getGlycanFragments()) {
            sIons = String.valueOf(sIons) + sw + frag.getType();
            sw = ", ";
        }
        item.setText(new String[]{"Cleavage Types", sIons});
        item = new TreeItem(glycanSettingsTree, 0);
        item.setText(new String[]{"Max # Cleavages", String.valueOf(gSettings.getMaxNumOfCleavages())});
        item = new TreeItem(glycanSettingsTree, 0);
        item.setText(new String[]{"Max # Cross-ring Cleavages", String.valueOf(gSettings.getMaxNumOfCrossRingCleavages())});
        if (gSettings.getGlycanFragments() != null && !gSettings.getGlycanFragments().isEmpty()) {
            item = new TreeItem(glycanSettingsTree, 0);
            item.setText(0, "Fragments:");
            item.setText(1, "");
            this.addFragments(item, gSettings.getGlycanFragments());
            item.setExpanded(true);
        }
        if (gSettings.getPerActivation() != null && !gSettings.getPerActivation().isEmpty()) {
            item = new TreeItem(glycanSettingsTree, 0);
            item.setText(0, "Fragments Per Activation:");
            item.setText(1, "");
            this.addFragmentsPerActivation(item, gSettings.getPerActivation());
            item.setExpanded(true);
        }
        if (gSettings.getPerMsLevel() != null && !gSettings.getPerMsLevel().isEmpty()) {
            item = new TreeItem(glycanSettingsTree, 0);
            item.setText(0, "Fragments Per Ms Level:");
            item.setText(1, "");
            this.addFragmentsPerMsLevel(item, gSettings.getPerMsLevel());
            item.setExpanded(true);
        }
    }

    private void addFragments(TreeItem parent, List<Fragment> glycanFragments) {
        int i = 0;
        for (Fragment fragment : glycanFragments) {
            TreeItem item = new TreeItem(parent, 0);
            item.setText(0, "Fragment Num: " + (i + 1));
            item.setText(1, "");
            TreeItem child1 = new TreeItem(item, 0);
            child1.setText(new String[]{"Fragmentation Type", fragment.getType()});
            TreeItem child2 = new TreeItem(item, 0);
            child2.setText(new String[]{"Fragmentation Number", fragment.getNumber()});
            item.setExpanded(true);
            ++i;
        }
    }

    private void addFragmentsPerActivation(TreeItem parent, List<FragmentPerActivationMethod> perActivation) {
        int i = 0;
        for (FragmentPerActivationMethod frag : perActivation) {
            TreeItem item = new TreeItem(parent, 0);
            item.setText(0, "Fragments Per Activation: " + (i + 1));
            item.setText(1, "");
            TreeItem child1 = new TreeItem(item, 0);
            child1.setText(new String[]{"Activation Method", frag.getActivationMethod()});
            TreeItem child2 = new TreeItem(item, 0);
            child2.setText(new String[]{"Max Num Cleavages", String.valueOf(frag.getMaxNumOfCleavages())});
            TreeItem child3 = new TreeItem(item, 0);
            child3.setText(new String[]{"Max Num Cross-ring Cleavages", String.valueOf(frag.getMaxNumOfCrossRingCleavages())});
            TreeItem child4 = new TreeItem(item, 0);
            child4.setText(0, "Fragments:");
            child4.setText(1, "");
            if (frag.getFragments() != null) {
                this.addFragments(child4, frag.getFragments());
            }
            child4.setExpanded(true);
            item.setExpanded(true);
            ++i;
        }
    }

    private void addFragmentsPerMsLevel(TreeItem parent, List<FragmentPerMsLevel> perMsLevel) {
        int i = 0;
        for (FragmentPerMsLevel frag : perMsLevel) {
            TreeItem item = new TreeItem(parent, 0);
            item.setText(0, "Fragments Per MS Level: " + (i + 1));
            item.setText(1, "");
            TreeItem child1 = new TreeItem(item, 0);
            child1.setText(new String[]{"MS Level", "" + frag.getMsLevel()});
            TreeItem child2 = new TreeItem(item, 0);
            child2.setText(new String[]{"Max Num Cleavages", String.valueOf(frag.getM_maxNumOfCleavages())});
            TreeItem child3 = new TreeItem(item, 0);
            child3.setText(new String[]{"Max Num Cross-ring Cleavages", String.valueOf(frag.getM_maxNumOfCrossRingCleavages())});
            TreeItem child4 = new TreeItem(item, 0);
            child4.setText(0, "Fragments:");
            child4.setText(1, "");
            if (frag.getFragments() != null) {
                this.addFragments(child4, frag.getFragments());
            }
            child4.setExpanded(true);
            item.setExpanded(true);
            ++i;
        }
    }
}

