/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.widgets.heatmap.gui;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.internal.widgets.introspection.DefaultWidgetIntrospector;
import org.eclipse.nebula.visualization.internal.widgets.introspection.Introspectable;
import org.eclipse.nebula.visualization.widgets.datadefinition.ByteArrayWrapper;
import org.eclipse.nebula.visualization.widgets.datadefinition.ColorMap;
import org.eclipse.nebula.visualization.widgets.datadefinition.DoubleArrayWrapper;
import org.eclipse.nebula.visualization.widgets.datadefinition.FloatArrayWrapper;
import org.eclipse.nebula.visualization.widgets.datadefinition.IPrimaryArrayWrapper;
import org.eclipse.nebula.visualization.widgets.datadefinition.IntArrayWrapper;
import org.eclipse.nebula.visualization.widgets.datadefinition.LongArrayWrapper;
import org.eclipse.nebula.visualization.widgets.datadefinition.ShortArrayWrapper;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.nebula.visualization.xygraph.util.SingleSourceHelper2;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.grits.toolbox.widgets.heatmap.clustering.DendrogramPanel;
import org.grits.toolbox.widgets.heatmap.gui.GritsAxis;
import org.grits.toolbox.widgets.heatmap.gui.HeatMapChart;
import org.grits.toolbox.widgets.heatmap.gui.ROIFigure;

public class GritsHeatMapFigure
extends Figure
implements Introspectable {
    private static final int MAX_ARRAY_SIZE = 10000000;
    HeatMapChart chart;
    private int dataWidth;
    private int dataHeight;
    private int cropLeft;
    private int cropRight;
    private int cropTop;
    private int cropBottom;
    private IPrimaryArrayWrapper dataArray;
    private IPrimaryArrayWrapper croppedDataArray;
    private int croppedDataWidth;
    private int croppedDataHeight;
    private double max;
    private double min;
    private DendrogramPanel rowDendrogram;
    private DendrogramPanel columnDendrogram;
    private GraphArea graphArea;
    private ColorMap colorMap;
    private final Axis xAxis;
    private final Axis yAxis;
    private Range xAxisRange = null;
    private Range yAxisRange = null;
    private Rectangle originalCrop = null;
    private Point start;
    private Point end;
    private boolean armed;
    private boolean dataDirty;
    private ImageData bufferedImageData;
    private Image bufferedImage;
    private List<IProfileDataChangeLisenter> profileListeners;
    private List<IPixelInfoProvider> pixelInfoProviders;
    private List<ICroppedDataSizeListener> croppedDataSizeListeners;
    private boolean runMode;
    private boolean xAxisOnTop = false;
    private boolean yAxisOnRight = false;
    private Map<String, ROIFigure> roiMap;
    private final Color WHITE_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_WHITE);
    private final Color BLACK_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_BLACK);
    private final Color TRANSPARENT_COLOR = XYGraphMediaFactory.getInstance().getColor(new RGB(123, 0, 23));
    private boolean inRGBMode = false;
    private ColorDepth colorDepth = ColorDepth.BIT8;
    private PaletteData palette = new PaletteData(255, 65280, 0xFF0000);
    private boolean isSingleLineProfiling = false;
    private Color roiColor = ColorConstants.cyan;

    public GritsHeatMapFigure(HeatMapChart chart) {
        this(true);
        this.chart = chart;
    }

    public GritsHeatMapFigure(boolean runMode) {
        this.runMode = runMode;
        this.dataArray = new DoubleArrayWrapper(new double[0]);
        this.max = 255.0;
        this.min = 0.0;
        this.dataWidth = 0;
        this.dataHeight = 0;
        this.profileListeners = new ArrayList<IProfileDataChangeLisenter>();
        this.colorMap = new ColorMap(ColorMap.PredefinedColorMap.GrayScale, true, true);
        this.graphArea = new GraphArea();
        this.xAxis = new GritsAxis("", false);
        this.yAxis = new GritsAxis("", true);
        this.rowDendrogram = new DendrogramPanel();
        this.columnDendrogram = new DendrogramPanel();
        this.columnDendrogram.setHorizontal(true);
        this.add((IFigure)this.graphArea);
        this.add((IFigure)this.xAxis);
        this.add((IFigure)this.yAxis);
        this.add((IFigure)this.rowDendrogram);
        this.add((IFigure)this.columnDendrogram);
        this.roiMap = new HashMap<String, ROIFigure>(2);
        this.setFocusTraversable(true);
        this.setRequestFocusEnabled(true);
    }

    public void addProfileDataListener(IProfileDataChangeLisenter listener) {
        if (listener != null) {
            this.profileListeners.add(listener);
        }
    }

    public void addPixelInfoProvider(IPixelInfoProvider pixelInfoProvider) {
        if (pixelInfoProvider != null) {
            if (this.pixelInfoProviders == null) {
                this.pixelInfoProviders = new ArrayList<IPixelInfoProvider>();
            }
            this.pixelInfoProviders.add(pixelInfoProvider);
        }
    }

    public void addCroppedDataSizeListener(ICroppedDataSizeListener listener) {
        if (this.croppedDataSizeListeners == null) {
            this.croppedDataSizeListeners = new ArrayList<ICroppedDataSizeListener>();
        }
        this.croppedDataSizeListeners.add(listener);
    }

    public void addROI(String name, IROIListener roiListener, IROIInfoProvider roiInfoProvider) {
        ROIFigure roiFigure = new ROIFigure(this, name, this.roiColor, roiListener, roiInfoProvider);
        this.roiMap.put(name, roiFigure);
        this.graphArea.add((IFigure)roiFigure);
    }

    public void removeROI(String name) {
        if (this.roiMap.containsKey(name)) {
            ROIFigure roiFigure = this.roiMap.get(name);
            this.roiMap.remove(name);
            this.graphArea.remove((IFigure)roiFigure);
        }
    }

    public void setROIVisible(String name, boolean visible) {
        if (this.roiMap.containsKey(name)) {
            this.roiMap.get(name).setVisible(visible);
        }
    }

    private double[] calculateXProfileData(IPrimaryArrayWrapper data, int dw, int dh) {
        double[] output = new double[dw];
        if (this.isSingleLineProfiling()) {
            PrecisionPoint dataloc = this.graphArea.getDataLocation(this.graphArea.crossHair.crossX, this.graphArea.crossHair.crossY);
            int i = 0;
            while (i < dw) {
                if (this.inRGBMode) {
                    int index = dataloc.y * dw * 3 + i * 3;
                    output[i] = (data.get(index) + data.get(index + 1) + data.get(index + 2)) / 3.0;
                } else {
                    output[i] = data.get(dataloc.y * dw + i);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < dw) {
                int j = 0;
                while (j < dh) {
                    if (this.inRGBMode) {
                        int index = j * dw * 3 + i * 3;
                        int n = i;
                        output[n] = output[n] + (data.get(index) + data.get(index + 1) + data.get(index + 2)) / 3.0;
                    } else {
                        int n = i;
                        output[n] = output[n] + data.get(j * dw + i);
                    }
                    ++j;
                }
                int n = i++;
                output[n] = output[n] / (double)dh;
            }
        }
        return output;
    }

    private double[] calculateYProfileData(IPrimaryArrayWrapper data, int dw, int dh) {
        double[] output = new double[dh];
        if (this.isSingleLineProfiling()) {
            PrecisionPoint dataloc = this.graphArea.getDataLocation(this.graphArea.crossHair.crossX, this.graphArea.crossHair.crossY);
            int i = 0;
            while (i < dh) {
                if (this.inRGBMode) {
                    int index = dataloc.x * 3 + i * dw * 3;
                    output[i] = (data.get(index) + data.get(index + 1) + data.get(index + 2)) / 3.0;
                } else {
                    output[i] = data.get(dataloc.x + i * dw);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < dh) {
                int j = 0;
                while (j < dw) {
                    if (this.inRGBMode) {
                        int index = i * dw * 3 + j * 3;
                        int n = i;
                        output[n] = output[n] + (data.get(index) + data.get(index + 1) + data.get(index + 2)) / 3.0;
                    } else {
                        int n = i;
                        output[n] = output[n] + data.get(i * dw + j);
                    }
                    ++j;
                }
                int n = i++;
                output[n] = output[n] / (double)dw;
            }
        }
        return output;
    }

    public void dispose() {
        if (this.bufferedImage != null) {
            this.bufferedImage.dispose();
            this.bufferedImage = null;
        }
    }

    private ImageData drawRGBImage(IPrimaryArrayWrapper dataArray, int dataWidth, int dataHeight, double max, double min, ImageData imageData, boolean shrink) {
        if (dataWidth < 1 || dataHeight < 1 || dataWidth * dataHeight * 3 > dataArray.getSize() || dataWidth * dataHeight < 0) {
            return null;
        }
        if (imageData == null) {
            imageData = new ImageData(dataWidth, dataHeight, 24, this.palette);
        }
        if (shrink) {
            int height = imageData.height;
            int width = imageData.width;
            int x_ratio = (dataWidth << 16) / width + 1;
            int y_ratio = (dataHeight << 16) / height + 1;
            int i = 0;
            while (i < height) {
                int j = 0;
                while (j < width) {
                    int x2 = j * x_ratio >> 16;
                    int y2 = i * y_ratio >> 16;
                    int index = y2 * dataWidth * 3 + x2 * 3;
                    int pixel = this.calcRGBPixel(dataArray, max, min, index);
                    imageData.setPixel(j, i, pixel);
                    ++j;
                }
                ++i;
            }
        } else {
            int y = 0;
            while (y < dataHeight) {
                int x = 0;
                while (x < dataWidth) {
                    int index = y * dataWidth * 3 + x * 3;
                    int pixel = this.calcRGBPixel(dataArray, max, min, index);
                    imageData.setPixel(x, y, pixel);
                    ++x;
                }
                ++y;
            }
        }
        return imageData;
    }

    protected int calcRGBPixel(IPrimaryArrayWrapper dataArray, double max, double min, int index) {
        int r = (int)dataArray.get(index);
        int g = (int)dataArray.get(index + 1);
        int b = (int)dataArray.get(index + 2);
        switch (this.colorDepth) {
            case BIT16: {
                r >>= 8;
                g >>= 8;
                b >>= 8;
                break;
            }
            case BIT24: {
                r >>= 16;
                g >>= 16;
                b >>= 16;
                break;
            }
            case BIT30: {
                r >>= 22;
                g >>= 22;
                b >>= 22;
                break;
            }
            case LOWER8BIT: {
                r &= 0xFF;
                b &= 0xFF;
                g &= 0xFF;
                break;
            }
            case SCALE: {
                r = (int)((dataArray.get(index) - min) / (max - min) * 255.0);
                g = (int)((dataArray.get(index + 1) - min) / (max - min) * 255.0);
                b = (int)((dataArray.get(index + 2) - min) / (max - min) * 255.0);
                break;
            }
        }
        int pixel = this.palette.getPixel(new RGB(r, g, b));
        return pixel;
    }

    private synchronized void fireProfileDataChanged(IPrimaryArrayWrapper data, int dw, int dh) {
        if (this.profileListeners.size() <= 0) {
            return;
        }
        double[] xProfileData = this.calculateXProfileData(data, dw, dh);
        double[] yProfileData = this.calculateYProfileData(data, dw, dh);
        for (IProfileDataChangeLisenter lisenter : this.profileListeners) {
            lisenter.profileDataChanged(xProfileData, yProfileData, this.xAxis.getRange(), this.yAxis.getRange());
        }
    }

    public ColorMap getColorMap() {
        return this.colorMap;
    }

    public int getCropBottom() {
        return this.cropBottom;
    }

    public int getCropLeft() {
        return this.cropLeft;
    }

    public int getCropRight() {
        return this.cropRight;
    }

    public int getCropTop() {
        return this.cropTop;
    }

    public void setxAxisOnTop(boolean xAxisOnTop) {
        this.xAxisOnTop = xAxisOnTop;
    }

    public boolean isxAxisOnTop() {
        return this.xAxisOnTop;
    }

    public void setyAxisOnRight(boolean yAxisOnRight) {
        this.yAxisOnRight = yAxisOnRight;
    }

    public boolean isyAxisOnRight() {
        return this.yAxisOnRight;
    }

    public double[] getDataArray() {
        double[] data = new double[this.dataArray.getSize()];
        int i = 0;
        while (i < this.dataArray.getSize()) {
            data[i] = this.dataArray.get(i);
            ++i;
        }
        return data;
    }

    public int getDataHeight() {
        return this.dataHeight;
    }

    public int getDataWidth() {
        return this.dataWidth;
    }

    public GraphArea getGraphArea() {
        return this.graphArea;
    }

    public Dimension getGraphAreaInsets() {
        int width = this.getInsets().getWidth();
        int height = this.getInsets().getHeight();
        boolean yVisible = true;
        boolean xVisible = true;
        if (yVisible) {
            width += this.yAxis.getPreferredSize((int)this.getClientArea().width, (int)this.getClientArea().height).width;
            height += this.yAxis.getMargin();
            if (!xVisible) {
                height += this.yAxis.getMargin();
            }
        }
        if (xVisible) {
            height += this.xAxis.getPreferredSize((int)this.getClientArea().width, (int)this.getClientArea().height).height;
            width += this.xAxis.getMargin();
            if (!yVisible) {
                width += this.xAxis.getMargin();
            }
        }
        return new Dimension(width, height);
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public final Axis getXAxis() {
        return this.xAxis;
    }

    public final Axis getYAxis() {
        return this.yAxis;
    }

    public DendrogramPanel getRowDendrogram() {
        return this.rowDendrogram;
    }

    public DendrogramPanel getColumnDendrogram() {
        return this.columnDendrogram;
    }

    public boolean isInRGBMode() {
        return this.inRGBMode;
    }

    public boolean isRunMode() {
        return this.runMode;
    }

    protected void layout() {
        Dimension dendrogramSize;
        Rectangle clientArea = this.getClientArea().getCopy();
        Rectangle yAxisBounds = null;
        Rectangle xAxisBounds = null;
        Rectangle rowDendrogramBounds = null;
        Rectangle columnDendrogramBounds = null;
        boolean xVisible = this.xAxis.isVisible();
        boolean yVisible = this.yAxis.isVisible();
        if (yVisible) {
            Dimension yAxisSize = this.yAxis.getPreferredSize(clientArea.width, clientArea.height);
            if (this.yAxisOnRight) {
                yAxisBounds = new Rectangle(clientArea.x + clientArea.width - yAxisSize.width, clientArea.y, yAxisSize.width, yAxisSize.height);
                clientArea.y += this.yAxis.getMargin();
            } else {
                yAxisBounds = new Rectangle(clientArea.x, clientArea.y, yAxisSize.width, yAxisSize.height);
                clientArea.x += yAxisSize.width;
                clientArea.y += this.yAxis.getMargin();
            }
            clientArea.height = clientArea.height - (xVisible ? this.yAxis.getMargin() : 2 * this.yAxis.getMargin() - 1);
            clientArea.width -= yAxisSize.width;
        }
        if (xVisible) {
            Dimension xAxisSize = this.xAxis.getPreferredSize(clientArea.width, clientArea.height);
            xAxisSize = ((GritsAxis)this.xAxis).adjustForRotatedTickLabels(xAxisSize);
            if (yVisible && !this.yAxisOnRight) {
                if (this.xAxisOnTop) {
                    xAxisBounds = new Rectangle(yAxisBounds.x + yAxisBounds.width - this.xAxis.getMargin() - 1, clientArea.y - this.yAxis.getMargin(), xAxisSize.width, xAxisSize.height);
                    clientArea.y += xAxisSize.height - this.yAxis.getMargin();
                } else {
                    xAxisBounds = new Rectangle(yAxisBounds.x + yAxisBounds.width - this.xAxis.getMargin() - 1, clientArea.y + clientArea.height - xAxisSize.height, xAxisSize.width, xAxisSize.height);
                }
            } else if (this.xAxisOnTop) {
                xAxisBounds = new Rectangle(clientArea.x, clientArea.y - this.yAxis.getMargin(), xAxisSize.width, xAxisSize.height);
                clientArea.y += xAxisSize.height - this.yAxis.getMargin();
                clientArea.height -= this.xAxis.getMargin();
            } else {
                xAxisBounds = new Rectangle(clientArea.x, clientArea.y + clientArea.height - xAxisSize.height, xAxisSize.width, xAxisSize.height);
            }
            clientArea.height -= xAxisSize.height;
            if (yVisible) {
                yAxisBounds.height -= xAxisSize.height - this.yAxis.getMargin() + 1;
                if (this.xAxisOnTop) {
                    yAxisBounds.y += xAxisSize.height - this.yAxis.getMargin();
                }
                if (this.yAxisOnRight) {
                    clientArea.x += this.xAxis.getMargin();
                }
            } else {
                clientArea.x += this.xAxis.getMargin();
                clientArea.width -= this.xAxis.getMargin() - 1;
            }
        }
        if (xVisible) {
            if (yVisible) {
                xAxisBounds.width += this.xAxis.getMargin();
                if (this.xAxisOnTop) {
                    yAxisBounds.height -= this.xAxis.getMargin();
                }
            }
            clientArea.width -= this.xAxis.getMargin();
        }
        if (this.rowDendrogram.isVisible()) {
            if (this.yAxis.isVisible() && this.yAxisOnRight || !this.yAxis.isVisible()) {
                dendrogramSize = this.rowDendrogram.getPreferredSize(clientArea.width, clientArea.height);
                rowDendrogramBounds = new Rectangle(clientArea.x, clientArea.y, dendrogramSize.width, dendrogramSize.height);
                clientArea.width -= dendrogramSize.width;
                clientArea.x += dendrogramSize.width;
                if (this.xAxis.isVisible()) {
                    xAxisBounds.x += dendrogramSize.width;
                    xAxisBounds.width -= dendrogramSize.width;
                }
            } else {
                dendrogramSize = this.rowDendrogram.getPreferredSize(clientArea.width, clientArea.height);
                rowDendrogramBounds = new Rectangle(clientArea.x + clientArea.width - dendrogramSize.width, clientArea.y, dendrogramSize.width, dendrogramSize.height);
                clientArea.width -= dendrogramSize.width;
                if (this.xAxis.isVisible()) {
                    xAxisBounds.width -= dendrogramSize.width;
                }
            }
        }
        if (this.columnDendrogram.isVisible()) {
            if (this.xAxis.isVisible() && !this.xAxisOnTop || !this.xAxis.isVisible()) {
                dendrogramSize = this.columnDendrogram.getPreferredSize(clientArea.width, clientArea.height);
                columnDendrogramBounds = new Rectangle(clientArea.x, clientArea.y, dendrogramSize.width, dendrogramSize.height);
                clientArea.height -= dendrogramSize.height;
                clientArea.y += dendrogramSize.height;
                if (this.yAxis.isVisible()) {
                    yAxisBounds.y += dendrogramSize.height;
                    yAxisBounds.height -= dendrogramSize.height;
                }
                if (this.rowDendrogram.isVisible()) {
                    rowDendrogramBounds.y += dendrogramSize.height;
                    rowDendrogramBounds.height -= dendrogramSize.height;
                }
            } else {
                dendrogramSize = this.columnDendrogram.getPreferredSize(clientArea.width, clientArea.height);
                columnDendrogramBounds = new Rectangle(clientArea.x, clientArea.y + clientArea.height - dendrogramSize.height, dendrogramSize.width, dendrogramSize.height);
                clientArea.height -= dendrogramSize.height;
                if (this.yAxis.isVisible()) {
                    yAxisBounds.height -= dendrogramSize.height;
                }
                if (this.rowDendrogram.isVisible()) {
                    rowDendrogramBounds.height -= dendrogramSize.height;
                }
            }
        }
        if (yVisible) {
            this.yAxis.setBounds(yAxisBounds);
        }
        if (xVisible) {
            this.xAxis.setBounds(xAxisBounds);
        }
        if (this.rowDendrogram.isVisible()) {
            this.rowDendrogram.setBounds(rowDendrogramBounds);
        }
        if (this.columnDendrogram.isVisible()) {
            this.columnDendrogram.setBounds(columnDendrogramBounds);
        }
        this.graphArea.setBounds(clientArea);
        super.layout();
    }

    public final void setColorMap(ColorMap colorMap) {
        if (colorMap == null) {
            return;
        }
        this.colorMap = colorMap;
        this.dataDirty = true;
        this.repaint();
    }

    public final void setCropBottom(int cropBottom) {
        if (cropBottom < 0 || cropBottom + this.cropTop > this.dataHeight) {
            throw new IllegalArgumentException();
        }
        if (this.cropBottom == cropBottom) {
            return;
        }
        this.cropBottom = cropBottom;
        this.dataDirty = true;
        this.updateCroppedDataSize();
        this.repaint();
    }

    public final void setCropLeft(int cropLeft) {
        if (cropLeft < 0 || cropLeft + this.cropRight > this.dataWidth) {
            throw new IllegalArgumentException();
        }
        if (this.cropLeft == cropLeft) {
            return;
        }
        this.cropLeft = cropLeft;
        this.dataDirty = true;
        this.updateCroppedDataSize();
        this.repaint();
    }

    public final void setCropRight(int cropRight) {
        if (cropRight < 0 || cropRight + this.cropLeft > this.dataWidth) {
            throw new IllegalArgumentException();
        }
        if (this.cropRight == cropRight) {
            return;
        }
        this.cropRight = cropRight;
        this.dataDirty = true;
        this.updateCroppedDataSize();
        this.repaint();
    }

    public final void setCropTop(int cropTop) {
        if (cropTop < 0 || cropTop + this.cropBottom > this.dataHeight) {
            throw new IllegalArgumentException();
        }
        if (this.cropTop == cropTop) {
            return;
        }
        this.cropTop = cropTop;
        this.dataDirty = true;
        this.updateCroppedDataSize();
        this.repaint();
    }

    public final void setDataArray(double[] data) {
        if (this.dataArray instanceof DoubleArrayWrapper) {
            ((DoubleArrayWrapper)this.dataArray).setData(data);
        } else {
            this.dataArray = new DoubleArrayWrapper(data);
        }
        this.setDataArray(this.dataArray);
    }

    public final void setDataArray(short[] data) {
        if (this.dataArray instanceof ShortArrayWrapper) {
            ((ShortArrayWrapper)this.dataArray).setData(data);
        } else {
            this.dataArray = new ShortArrayWrapper(data);
        }
        this.setDataArray(this.dataArray);
    }

    public final void setDataArray(byte[] data) {
        if (this.dataArray instanceof ByteArrayWrapper) {
            ((ByteArrayWrapper)this.dataArray).setData(data);
        } else {
            this.dataArray = new ByteArrayWrapper(data);
        }
        this.setDataArray(this.dataArray);
    }

    public final void setDataArray(int[] data) {
        if (this.dataArray instanceof IntArrayWrapper) {
            ((IntArrayWrapper)this.dataArray).setData(data);
        } else {
            this.dataArray = new IntArrayWrapper(data);
        }
        this.setDataArray(this.dataArray);
    }

    public final void setDataArray(long[] data) {
        if (this.dataArray instanceof LongArrayWrapper) {
            ((LongArrayWrapper)this.dataArray).setData(data);
        } else {
            this.dataArray = new LongArrayWrapper(data);
        }
        this.setDataArray(this.dataArray);
    }

    public final void setDataArray(float[] data) {
        if (this.dataArray instanceof FloatArrayWrapper) {
            ((FloatArrayWrapper)this.dataArray).setData(data);
        } else {
            this.dataArray = new FloatArrayWrapper(data);
        }
        this.setDataArray(this.dataArray);
    }

    public final synchronized void setDataArray(IPrimaryArrayWrapper dataWrapper) {
        this.dataArray = dataWrapper;
        this.croppedDataArray = null;
        this.dataDirty = true;
        this.graphArea.repaint();
    }

    public final void setDataHeight(int dataHeight) {
        if (dataHeight < 0 || this.dataWidth * dataHeight > 10000000 || this.dataWidth * dataHeight < 0) {
            throw new IllegalArgumentException();
        }
        if (this.dataHeight == dataHeight) {
            return;
        }
        this.dataHeight = dataHeight;
        this.updateCroppedDataSize();
        this.dataDirty = true;
        this.repaint();
    }

    public final void setDataWidth(int dataWidth) {
        if (dataWidth < 0 || dataWidth * this.dataHeight > 10000000 || dataWidth * this.dataHeight < 0) {
            throw new IllegalArgumentException();
        }
        if (this.dataWidth == dataWidth) {
            return;
        }
        this.dataWidth = dataWidth;
        this.updateCroppedDataSize();
        this.dataDirty = true;
        this.repaint();
    }

    public synchronized void setInRGBMode(boolean inRGBMode) {
        if (this.isInRGBMode() == inRGBMode) {
            return;
        }
        this.inRGBMode = inRGBMode;
        this.dataDirty = true;
        this.repaint();
    }

    public final void setMax(double max) {
        if (this.max == max) {
            return;
        }
        this.max = max;
        this.dataDirty = true;
        this.repaint();
    }

    public void setFont(Font f) {
        super.setFont(f);
    }

    public final void setMin(double min) {
        if (this.min == min) {
            return;
        }
        this.min = min;
        this.dataDirty = true;
        this.repaint();
    }

    public void setROIColor(Color roiColor) {
        this.roiColor = roiColor;
        for (ROIFigure f : this.roiMap.values()) {
            f.setROIColor(roiColor);
        }
    }

    public Color getRoiColor() {
        return this.roiColor;
    }

    public void setROIDataBounds(String name, int xIndex, int yIndex, int width, int height) {
        if (!this.roiMap.containsKey(name)) {
            throw new IllegalArgumentException(String.valueOf(name) + " is not an existing ROI");
        }
        this.roiMap.get(name).setROIDataBounds(xIndex, yIndex, width, height);
    }

    public ROIFigure getROI(String name) {
        return this.roiMap.get(name);
    }

    public void setRunMode(boolean runMode) {
        this.runMode = runMode;
    }

    public Range getxAxisRange() {
        return this.xAxisRange;
    }

    public void setxAxisRange(Range xAxisRange) {
        this.xAxisRange = xAxisRange;
    }

    public Range getyAxisRange() {
        return this.yAxisRange;
    }

    public void setyAxisRange(Range yAxisRange) {
        this.yAxisRange = yAxisRange;
    }

    public Rectangle getOriginalCrop() {
        return this.originalCrop;
    }

    public void setOriginalCrop(Rectangle originalCrop) {
        this.originalCrop = originalCrop;
    }

    private void zoom() {
        if (this.xAxisRange == null || this.yAxisRange == null) {
            this.xAxisRange = this.xAxis.getRange();
            this.yAxisRange = this.yAxis.getRange();
        }
        if (this.originalCrop == null) {
            this.originalCrop = new Rectangle(this.cropLeft, this.cropTop, this.cropRight, this.cropBottom);
        }
        PrecisionPoint leftTop = this.graphArea.getDataLocation(Math.min(this.start.x, this.end.x), Math.min(this.start.y, this.end.y));
        PrecisionPoint rightBottom = this.graphArea.getDataLocation(Math.max(this.start.x, this.end.x), Math.max(this.start.y, this.end.y));
        if (leftTop == null || rightBottom == null || leftTop.equals((Object)rightBottom)) {
            return;
        }
        int toBeCropLeft = this.cropLeft + leftTop.x;
        int toBeCropTop = this.cropTop + leftTop.y;
        int toBeCropRight = this.cropRight + this.croppedDataWidth - rightBottom.x;
        int toBeCropBottom = this.cropBottom + this.croppedDataHeight - rightBottom.y;
        if (toBeCropLeft + toBeCropRight >= this.dataWidth || toBeCropBottom + toBeCropTop >= this.dataHeight) {
            return;
        }
        this.setCropLeft(toBeCropLeft);
        this.setCropTop(toBeCropTop);
        this.setCropRight(toBeCropRight);
        this.setCropBottom(toBeCropBottom);
        double t1 = this.xAxis.getPositionValue(this.start.x, false);
        double t2 = this.xAxis.getPositionValue(this.end.x, false);
        this.xAxis.setRange(t1, t2, true);
        double t3 = this.yAxis.getPositionValue(this.start.y, false);
        double t4 = this.yAxis.getPositionValue(this.end.y, false);
        this.yAxis.setRange(t3, t4, true);
        try {
            this.chart.recalculateClusters(t1, t2, t3, t4);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.rowDendrogram.repaint();
        this.columnDendrogram.repaint();
        this.chart.setDataArray();
        this.graphArea.validate();
    }

    public BeanInfo getBeanInfo() throws IntrospectionException {
        return new DefaultWidgetIntrospector().getBeanInfo(((Object)((Object)this)).getClass());
    }

    public ColorDepth getColorDepth() {
        return this.colorDepth;
    }

    public void setColorDepth(ColorDepth colorDepth) {
        this.colorDepth = colorDepth;
        this.dataDirty = true;
        this.repaint();
    }

    public boolean isSingleLineProfiling() {
        return this.isSingleLineProfiling;
    }

    public void setSingleLineProfiling(boolean isSingleLineProfiling) {
        if (this.isSingleLineProfiling() == isSingleLineProfiling) {
            return;
        }
        this.isSingleLineProfiling = isSingleLineProfiling;
        this.graphArea.setSinglePixelProfiling(isSingleLineProfiling);
    }

    public String getPixelInfo(int xIndex, int yIndex, double xCoordinate, double yCoordinate, double pixelValue) {
        String result = "";
        if (this.pixelInfoProviders == null) {
            return result;
        }
        for (IPixelInfoProvider p : this.pixelInfoProviders) {
            result = String.valueOf(result) + " " + p.getPixelInfo(xIndex, yIndex, xCoordinate, yCoordinate, pixelValue);
        }
        return result;
    }

    protected void updateCroppedDataSize() {
        this.croppedDataWidth = this.dataWidth - this.cropLeft - this.cropRight;
        this.croppedDataHeight = this.dataHeight - this.cropTop - this.cropBottom;
        if (this.croppedDataSizeListeners != null) {
            for (ICroppedDataSizeListener listener : this.croppedDataSizeListeners) {
                listener.croppedDataSizeChanged(this.croppedDataWidth, this.croppedDataHeight);
            }
        }
    }

    public static enum ColorDepth {
        BIT8("8 bit"),
        BIT16("16 bit"),
        BIT24("24 bit"),
        BIT30("30 bit"),
        SCALE("Scaled to [Max, Min]"),
        LOWER8BIT("Use only lower 8 bits");

        private String description;

        private ColorDepth(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        public static String[] stringValues() {
            String[] sv = new String[ColorDepth.values().length];
            int i = 0;
            ColorDepth[] colorDepthArray = ColorDepth.values();
            int n = colorDepthArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColorDepth p = colorDepthArray[n2];
                sv[i++] = p.toString();
                ++n2;
            }
            return sv;
        }
    }

    public class GraphArea
    extends Figure {
        private static final int CURSOR_SIZE = 14;
        private SinglePixelProfileCrossHair crossHair;

        public GraphArea() {
            if (GritsHeatMapFigure.this.runMode) {
                this.setCursor(null);
                GraphAreaZoomer zoomer = new GraphAreaZoomer();
                this.addMouseMotionListener((MouseMotionListener)zoomer);
                this.addMouseListener(zoomer);
            }
            this.setSinglePixelProfiling(GritsHeatMapFigure.this.isSingleLineProfiling());
        }

        protected void setSinglePixelProfiling(boolean isSinglePixelProfiling) {
            if (!GritsHeatMapFigure.this.runMode) {
                return;
            }
            if (GritsHeatMapFigure.this.isSingleLineProfiling()) {
                if (this.crossHair == null) {
                    this.crossHair = new SinglePixelProfileCrossHair();
                }
                this.add((IFigure)this.crossHair);
            } else if (this.crossHair != null && this.crossHair.getParent() == this) {
                this.remove((IFigure)this.crossHair);
            }
            GritsHeatMapFigure.this.dataDirty = true;
            this.repaint();
        }

        protected void layout() {
            Rectangle clientArea = this.getClientArea();
            if (GritsHeatMapFigure.this.runMode && GritsHeatMapFigure.this.isSingleLineProfiling()) {
                this.crossHair.setBounds(clientArea);
            }
            for (ROIFigure roiFigure : GritsHeatMapFigure.this.roiMap.values()) {
                roiFigure.setBounds(clientArea);
            }
        }

        private synchronized IPrimaryArrayWrapper cropDataArray(int left, int right, int top, int bottom) {
            if ((left != 0 || right != 0 || top != 0 || bottom != 0) && (GritsHeatMapFigure.this.dataWidth - left - right) * (GritsHeatMapFigure.this.dataHeight - top - bottom) > 0) {
                int i = 0;
                if ((GritsHeatMapFigure.this.dataWidth - left - right) * (GritsHeatMapFigure.this.dataHeight - top - bottom) > 10000000) {
                    return GritsHeatMapFigure.this.dataArray;
                }
                double[] result = null;
                if (GritsHeatMapFigure.this.inRGBMode) {
                    result = new double[(GritsHeatMapFigure.this.dataWidth - left - right) * (GritsHeatMapFigure.this.dataHeight - top - bottom) * 3];
                    int y = top;
                    while (y < GritsHeatMapFigure.this.dataHeight - bottom) {
                        int x = left;
                        while (x < GritsHeatMapFigure.this.dataWidth - right) {
                            int p = y * GritsHeatMapFigure.this.dataWidth * 3 + x * 3;
                            result[i] = GritsHeatMapFigure.this.dataArray.get(p);
                            result[i + 1] = GritsHeatMapFigure.this.dataArray.get(p + 1);
                            result[i + 2] = GritsHeatMapFigure.this.dataArray.get(p + 2);
                            i += 3;
                            ++x;
                        }
                        ++y;
                    }
                } else {
                    result = new double[(GritsHeatMapFigure.this.dataWidth - left - right) * (GritsHeatMapFigure.this.dataHeight - top - bottom)];
                    int y = top;
                    while (y < GritsHeatMapFigure.this.dataHeight - bottom) {
                        int x = left;
                        while (x < GritsHeatMapFigure.this.dataWidth - right) {
                            result[i++] = GritsHeatMapFigure.this.dataArray.get(y * GritsHeatMapFigure.this.dataWidth + x);
                            ++x;
                        }
                        ++y;
                    }
                }
                return new DoubleArrayWrapper(result);
            }
            return GritsHeatMapFigure.this.dataArray;
        }

        public PrecisionPoint getDataLocation(double x, double y) {
            Rectangle clientArea = this.getClientArea();
            double hIndex = (double)GritsHeatMapFigure.this.croppedDataWidth * (x - (double)clientArea.x) / (double)clientArea.width;
            double vIndex = (double)GritsHeatMapFigure.this.croppedDataHeight * (y - (double)clientArea.y) / (double)clientArea.height;
            return new PrecisionPoint(hIndex, vIndex);
        }

        public PrecisionPoint getGeoLocation(double xIndex, double yIndex) {
            Rectangle clientArea = this.getClientArea();
            if (GritsHeatMapFigure.this.croppedDataHeight == 0 || GritsHeatMapFigure.this.croppedDataWidth == 0) {
                return new PrecisionPoint(clientArea.x, clientArea.y);
            }
            double x = xIndex * (double)clientArea.width / (double)GritsHeatMapFigure.this.croppedDataWidth + (double)clientArea.x;
            double y = yIndex * (double)clientArea.height / (double)GritsHeatMapFigure.this.croppedDataHeight + (double)clientArea.y;
            return new PrecisionPoint(x, y);
        }

        protected synchronized void paintClientArea(Graphics graphics) {
            if (GritsHeatMapFigure.this.dataArray == null) {
                return;
            }
            Rectangle clientArea = this.getClientArea();
            if (GritsHeatMapFigure.this.dataDirty || GritsHeatMapFigure.this.bufferedImage == null) {
                GritsHeatMapFigure.this.dataDirty = false;
                if (GritsHeatMapFigure.this.bufferedImage != null) {
                    GritsHeatMapFigure.this.bufferedImage.dispose();
                    GritsHeatMapFigure.this.bufferedImage = null;
                }
                if (clientArea.width < 0 || clientArea.height < 0) {
                    return;
                }
                if (GritsHeatMapFigure.this.dataWidth == 0 || GritsHeatMapFigure.this.dataHeight == 0 || !GritsHeatMapFigure.this.isInRGBMode() && GritsHeatMapFigure.this.dataArray.getSize() < GritsHeatMapFigure.this.dataWidth * GritsHeatMapFigure.this.dataHeight || GritsHeatMapFigure.this.isInRGBMode() && GritsHeatMapFigure.this.dataArray.getSize() < 3 * GritsHeatMapFigure.this.dataWidth * GritsHeatMapFigure.this.dataHeight) {
                    graphics.drawRectangle(new Rectangle(clientArea.x - (GritsHeatMapFigure.this.yAxis.isVisible() ? 1 : 0), clientArea.y, clientArea.width - (GritsHeatMapFigure.this.yAxis.isVisible() ? 0 : 1), clientArea.height - (GritsHeatMapFigure.this.xAxis.isVisible() ? 0 : 1)));
                    if (GritsHeatMapFigure.this.dataArray.getSize() == 0) {
                        graphics.drawText("No data.", clientArea.getLocation());
                    } else if (!GritsHeatMapFigure.this.isInRGBMode() && GritsHeatMapFigure.this.dataArray.getSize() < GritsHeatMapFigure.this.dataWidth * GritsHeatMapFigure.this.dataHeight) {
                        graphics.drawText("Size of input data is less than dataWidth*dataHeight!", clientArea.getLocation());
                    } else if (GritsHeatMapFigure.this.isInRGBMode() && GritsHeatMapFigure.this.dataArray.getSize() < 3 * GritsHeatMapFigure.this.dataWidth * GritsHeatMapFigure.this.dataHeight) {
                        graphics.drawText("Size of input data is less than 3*dataWidth*dataHeight!\nPlease make sure the data is in RGB mode.", clientArea.getLocation());
                    }
                    return;
                }
                if (GritsHeatMapFigure.this.dataWidth - GritsHeatMapFigure.this.cropLeft - GritsHeatMapFigure.this.cropRight < 0 || GritsHeatMapFigure.this.dataHeight - GritsHeatMapFigure.this.cropTop - GritsHeatMapFigure.this.cropBottom < 0) {
                    return;
                }
                GritsHeatMapFigure.this.croppedDataArray = this.cropDataArray(GritsHeatMapFigure.this.cropLeft, GritsHeatMapFigure.this.cropRight, GritsHeatMapFigure.this.cropTop, GritsHeatMapFigure.this.cropBottom);
                GritsHeatMapFigure.this.fireProfileDataChanged(GritsHeatMapFigure.this.croppedDataArray, GritsHeatMapFigure.this.croppedDataWidth, GritsHeatMapFigure.this.croppedDataHeight);
                boolean shrink = false;
                if (clientArea.width * clientArea.height < GritsHeatMapFigure.this.croppedDataHeight * GritsHeatMapFigure.this.croppedDataWidth) {
                    shrink = true;
                }
                if (shrink) {
                    if (GritsHeatMapFigure.this.bufferedImageData == null || ((GritsHeatMapFigure)GritsHeatMapFigure.this).bufferedImageData.width != clientArea.width || ((GritsHeatMapFigure)GritsHeatMapFigure.this).bufferedImageData.height != clientArea.height) {
                        GritsHeatMapFigure.this.bufferedImageData = new ImageData(clientArea.width, clientArea.height, 24, GritsHeatMapFigure.this.colorMap.getPalette());
                    }
                } else if (GritsHeatMapFigure.this.bufferedImageData == null || ((GritsHeatMapFigure)GritsHeatMapFigure.this).bufferedImageData.width != GritsHeatMapFigure.this.croppedDataWidth || ((GritsHeatMapFigure)GritsHeatMapFigure.this).bufferedImageData.height != GritsHeatMapFigure.this.croppedDataHeight) {
                    GritsHeatMapFigure.this.bufferedImageData = new ImageData(GritsHeatMapFigure.this.croppedDataWidth, GritsHeatMapFigure.this.croppedDataHeight, 24, GritsHeatMapFigure.this.colorMap.getPalette());
                }
                ImageData imageData = null;
                if (GritsHeatMapFigure.this.inRGBMode) {
                    try {
                        imageData = GritsHeatMapFigure.this.drawRGBImage(GritsHeatMapFigure.this.croppedDataArray, GritsHeatMapFigure.this.croppedDataWidth, GritsHeatMapFigure.this.croppedDataHeight, GritsHeatMapFigure.this.max, GritsHeatMapFigure.this.min, GritsHeatMapFigure.this.bufferedImageData, shrink);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        graphics.drawText("Drawing Exception: RGB value is not between 0 and 255.\nPlease check if the data or color depth is correct.", clientArea.getLocation());
                    }
                } else {
                    imageData = GritsHeatMapFigure.this.colorMap.drawImage(GritsHeatMapFigure.this.croppedDataArray, GritsHeatMapFigure.this.croppedDataWidth, GritsHeatMapFigure.this.croppedDataHeight, GritsHeatMapFigure.this.max, GritsHeatMapFigure.this.min, GritsHeatMapFigure.this.bufferedImageData, shrink);
                }
                if (imageData == null) {
                    return;
                }
                GritsHeatMapFigure.this.bufferedImage = new Image((Device)Display.getCurrent(), imageData);
            }
            graphics.setInterpolation(0);
            graphics.drawImage(GritsHeatMapFigure.this.bufferedImage, new Rectangle(GritsHeatMapFigure.this.bufferedImage.getBounds()), clientArea);
            if (GritsHeatMapFigure.this.armed && GritsHeatMapFigure.this.end != null && GritsHeatMapFigure.this.start != null) {
                graphics.setLineStyle(3);
                graphics.setLineWidth(1);
                graphics.setForegroundColor(GritsHeatMapFigure.this.BLACK_COLOR);
                graphics.drawRectangle(((GritsHeatMapFigure)GritsHeatMapFigure.this).start.x, ((GritsHeatMapFigure)GritsHeatMapFigure.this).start.y, ((GritsHeatMapFigure)GritsHeatMapFigure.this).end.x - ((GritsHeatMapFigure)GritsHeatMapFigure.this).start.x, ((GritsHeatMapFigure)GritsHeatMapFigure.this).end.y - ((GritsHeatMapFigure)GritsHeatMapFigure.this).start.y);
            }
            super.paintClientArea(graphics);
        }

        private synchronized void updateTextCursor(MouseEvent me) {
            double valueUnderMouse;
            int index;
            if (SWT.getPlatform().startsWith("rap")) {
                return;
            }
            if (GritsHeatMapFigure.this.croppedDataArray == null) {
                return;
            }
            if (this.getCursor() != null) {
                this.getCursor().dispose();
            }
            double xCoordinate = GritsHeatMapFigure.this.xAxis.getPositionValue(me.x, false);
            double yCoordinate = GritsHeatMapFigure.this.yAxis.getPositionValue(me.y, false);
            PrecisionPoint dataLocation = this.getDataLocation(me.x, me.y);
            if (dataLocation == null) {
                return;
            }
            if (dataLocation.y * GritsHeatMapFigure.this.croppedDataWidth + dataLocation.x >= GritsHeatMapFigure.this.croppedDataArray.getSize()) {
                return;
            }
            if (GritsHeatMapFigure.this.inRGBMode) {
                index = dataLocation.y * GritsHeatMapFigure.this.croppedDataWidth * 3 + dataLocation.x * 3;
                if (index >= GritsHeatMapFigure.this.croppedDataArray.getSize() - 3) {
                    return;
                }
                valueUnderMouse = (GritsHeatMapFigure.this.croppedDataArray.get(index) + GritsHeatMapFigure.this.croppedDataArray.get(index + 1) + GritsHeatMapFigure.this.croppedDataArray.get(index + 2)) / 3.0;
            } else {
                index = dataLocation.y * GritsHeatMapFigure.this.croppedDataWidth + dataLocation.x;
                if (index >= GritsHeatMapFigure.this.croppedDataArray.getSize()) {
                    return;
                }
                valueUnderMouse = GritsHeatMapFigure.this.croppedDataArray.get(index);
            }
            String text = "(" + GritsHeatMapFigure.this.xAxis.format((Object)xCoordinate) + ", " + GritsHeatMapFigure.this.yAxis.format((Object)yCoordinate) + ", " + GritsHeatMapFigure.this.yAxis.format((Object)valueUnderMouse) + ")";
            text = String.valueOf(text) + GritsHeatMapFigure.this.getPixelInfo(dataLocation.x + GritsHeatMapFigure.this.cropLeft, dataLocation.y + GritsHeatMapFigure.this.cropTop, xCoordinate, yCoordinate, valueUnderMouse);
            Dimension size = FigureUtilities.getTextExtents((String)text, (Font)Display.getDefault().getSystemFont());
            Image image = new Image((Device)Display.getDefault(), size.width + 14, size.height + 14);
            GC gc = SingleSourceHelper2.getImageGC((Image)image);
            gc.setBackground(GritsHeatMapFigure.this.TRANSPARENT_COLOR);
            gc.fillRectangle(image.getBounds());
            gc.setForeground(GritsHeatMapFigure.this.BLACK_COLOR);
            gc.drawLine(0, 7, 14, 7);
            gc.drawLine(7, 0, 7, 14);
            gc.setBackground(GritsHeatMapFigure.this.WHITE_COLOR);
            gc.fillRectangle(14, 14, image.getBounds().width - 14, image.getBounds().height - 14);
            gc.drawText(text, 14, 14, true);
            ImageData imageData = image.getImageData();
            imageData.transparentPixel = imageData.palette.getPixel(GritsHeatMapFigure.this.TRANSPARENT_COLOR.getRGB());
            this.setCursor(SingleSourceHelper2.createCursor((Display)Display.getCurrent(), (ImageData)imageData, (int)7, (int)7, (int)2));
            gc.dispose();
            image.dispose();
        }
    }

    class GraphAreaZoomer
    extends MouseMotionListener.Stub
    implements MouseListener {
        GraphAreaZoomer() {
        }

        public void mouseDoubleClicked(MouseEvent me) {
            if (me.button != 1) {
                return;
            }
            if (GritsHeatMapFigure.this.xAxisRange != null) {
                GritsHeatMapFigure.this.xAxis.setRange(GritsHeatMapFigure.this.xAxisRange);
            }
            if (GritsHeatMapFigure.this.yAxisRange != null) {
                GritsHeatMapFigure.this.yAxis.setRange(GritsHeatMapFigure.this.yAxisRange);
            }
            if (GritsHeatMapFigure.this.originalCrop != null) {
                GritsHeatMapFigure.this.setCropLeft(((GritsHeatMapFigure)GritsHeatMapFigure.this).originalCrop.x);
                GritsHeatMapFigure.this.setCropTop(((GritsHeatMapFigure)GritsHeatMapFigure.this).originalCrop.y);
                GritsHeatMapFigure.this.setCropRight(((GritsHeatMapFigure)GritsHeatMapFigure.this).originalCrop.width);
                GritsHeatMapFigure.this.setCropBottom(((GritsHeatMapFigure)GritsHeatMapFigure.this).originalCrop.height);
                GritsHeatMapFigure.this.chart.recalculateWithOriginalData();
                GritsHeatMapFigure.this.chart.setDataArray();
            }
        }

        public void mouseDragged(MouseEvent me) {
            if (!GritsHeatMapFigure.this.armed) {
                return;
            }
            if (GritsHeatMapFigure.this.graphArea.getClientArea().contains(me.getLocation())) {
                GritsHeatMapFigure.this.graphArea.updateTextCursor(me);
                GritsHeatMapFigure.this.end = me.getLocation();
                GritsHeatMapFigure.this.graphArea.repaint();
            }
        }

        public void mouseMoved(MouseEvent me) {
            GritsHeatMapFigure.this.graphArea.updateTextCursor(me);
        }

        public void mousePressed(MouseEvent me) {
            GritsHeatMapFigure.this.requestFocus();
            if (me.button != 1) {
                return;
            }
            GritsHeatMapFigure.this.armed = true;
            GritsHeatMapFigure.this.start = me.getLocation();
            GritsHeatMapFigure.this.end = null;
            me.consume();
        }

        public void mouseReleased(MouseEvent me) {
            if (GritsHeatMapFigure.this.armed && GritsHeatMapFigure.this.end != null && GritsHeatMapFigure.this.start != null) {
                GritsHeatMapFigure.this.zoom();
            }
            GritsHeatMapFigure.this.armed = false;
            GritsHeatMapFigure.this.end = null;
            GritsHeatMapFigure.this.start = null;
        }
    }

    public static interface ICroppedDataSizeListener {
        public void croppedDataSizeChanged(int var1, int var2);
    }

    public static interface IPixelInfoProvider {
        public String getPixelInfo(int var1, int var2, double var3, double var5, double var7);
    }

    public static interface IProfileDataChangeLisenter {
        public void profileDataChanged(double[] var1, double[] var2, Range var3, Range var4);
    }

    public static interface IROIInfoProvider {
        public String getROIInfo(int var1, int var2, int var3, int var4);
    }

    public static interface IROIListener {
        public void roiUpdated(int var1, int var2, int var3, int var4);
    }

    class SinglePixelProfileCrossHair
    extends Figure {
        private int crossX;
        private int crossY;
        private Point crossDataIndex;
        private boolean inDefaultPosition = true;
        private Polyline hLine = new Polyline();
        private Polyline vLine;
        private Figure crossPoint;

        public SinglePixelProfileCrossHair() {
            this.hLine.setCursor(Cursors.SIZENS);
            this.hLine.setForegroundColor(ColorConstants.yellow);
            this.hLine.setTolerance(3);
            this.hLine.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

                public void mouseDragged(MouseEvent me) {
                    SinglePixelProfileCrossHair.this.setCrossPosition(SinglePixelProfileCrossHair.this.crossX, me.y, true);
                    me.consume();
                }
            });
            this.hLine.addMouseListener((MouseListener)new MouseListener.Stub(){

                public void mousePressed(MouseEvent me) {
                    me.consume();
                }
            });
            this.vLine = new Polyline();
            this.vLine.setCursor(Cursors.SIZEWE);
            this.vLine.setForegroundColor(ColorConstants.yellow);
            this.vLine.setTolerance(3);
            this.vLine.addMouseListener((MouseListener)new MouseListener.Stub(){

                public void mousePressed(MouseEvent me) {
                    me.consume();
                }
            });
            this.vLine.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

                public void mouseDragged(MouseEvent me) {
                    SinglePixelProfileCrossHair.this.setCrossPosition(me.x, SinglePixelProfileCrossHair.this.crossY, true);
                    me.consume();
                }
            });
            this.crossPoint = new Figure();
            this.crossPoint.setCursor(Cursors.SIZEALL);
            this.crossPoint.addMouseListener((MouseListener)new MouseListener.Stub(){

                public void mousePressed(MouseEvent me) {
                    me.consume();
                }
            });
            this.crossPoint.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

                public void mouseDragged(MouseEvent me) {
                    SinglePixelProfileCrossHair.this.setCrossPosition(me.x, me.y, true);
                    me.consume();
                }
            });
            this.add((IFigure)this.hLine);
            this.add((IFigure)this.vLine);
            this.add((IFigure)this.crossPoint);
            this.addFigureListener(new FigureListener(){

                public void figureMoved(IFigure source) {
                    if (SinglePixelProfileCrossHair.this.crossDataIndex != null) {
                        PrecisionPoint p = GritsHeatMapFigure.this.graphArea.getGeoLocation(((SinglePixelProfileCrossHair)SinglePixelProfileCrossHair.this).crossDataIndex.x, ((SinglePixelProfileCrossHair)SinglePixelProfileCrossHair.this).crossDataIndex.y);
                        SinglePixelProfileCrossHair.this.setCrossPosition(p.x, p.y, false);
                    }
                }
            });
            GritsHeatMapFigure.this.addCroppedDataSizeListener(new ICroppedDataSizeListener(){

                @Override
                public void croppedDataSizeChanged(int croppedDataWidth, int croppedDataHeight) {
                    SinglePixelProfileCrossHair.this.crossDataIndex = (Point)GritsHeatMapFigure.this.graphArea.getDataLocation(SinglePixelProfileCrossHair.this.crossX, SinglePixelProfileCrossHair.this.crossY);
                }
            });
        }

        public boolean containsPoint(int x, int y) {
            return this.hLine.containsPoint(x, y) || this.vLine.containsPoint(x, y) || this.crossPoint.containsPoint(x, y);
        }

        protected void layout() {
            Rectangle bounds = this.getBounds();
            if (this.inDefaultPosition) {
                this.setCrossPosition(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2, true);
            } else {
                PrecisionPoint p = GritsHeatMapFigure.this.graphArea.getGeoLocation(this.crossDataIndex.x, this.crossDataIndex.y);
                this.setCrossPosition(p.x, p.y, false);
            }
        }

        public void setCrossHairColor(Color crossHairColor) {
            this.hLine.setForegroundColor(crossHairColor);
            this.vLine.setForegroundColor(crossHairColor);
        }

        public void setCrossPosition(int x, int y, boolean updatedCrossDataIndex) {
            Rectangle bounds = this.getBounds();
            this.crossX = x < bounds.x ? bounds.x : (x >= bounds.x + bounds.width ? bounds.x + bounds.width - 1 : x);
            this.crossY = y < bounds.y ? bounds.y : (y >= bounds.y + bounds.height ? bounds.y + bounds.height - 1 : y);
            this.inDefaultPosition = false;
            if (updatedCrossDataIndex) {
                this.crossDataIndex = GritsHeatMapFigure.this.graphArea.getDataLocation(this.crossX, this.crossY);
                if (GritsHeatMapFigure.this.croppedDataArray != null) {
                    GritsHeatMapFigure.this.fireProfileDataChanged(GritsHeatMapFigure.this.croppedDataArray, GritsHeatMapFigure.this.croppedDataWidth, GritsHeatMapFigure.this.croppedDataHeight);
                }
            }
            this.hLine.setPoints(new PointList(new int[]{bounds.x, this.crossY, bounds.width + bounds.x, this.crossY}));
            this.vLine.setPoints(new PointList(new int[]{this.crossX, bounds.y, this.crossX, bounds.y + bounds.height}));
            this.crossPoint.setBounds(new Rectangle(this.crossX - 5, this.crossY - 5, 10, 10));
        }
    }
}

