/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.databasebot.wizards;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.tools.databasebot.om.DatabaseBotSettings;
import org.grits.toolbox.tools.databasebot.utils.DatabaseBotException;
import org.grits.toolbox.tools.databasebot.utils.ImageCache;
import org.grits.toolbox.tools.databasebot.wizards.createnew.DatabaseInformationPage;
import org.grits.toolbox.tools.databasebot.wizards.createnew.DatabaseTypePage;
import org.grits.toolbox.tools.databasebot.wizards.createnew.FilterPage;
import org.grits.toolbox.tools.databasebot.wizards.createnew.SourcePage;

public class CreateNewDatabaseWizard
extends Wizard {
    public static ImageDescriptor DIALOG_IMAGE = null;
    private static final Logger logger = Logger.getLogger(CreateNewDatabaseWizard.class);
    private SourcePage m_pageSource = null;
    private DatabaseInformationPage m_pageInformation = null;
    private DatabaseTypePage m_pageDatabaseType = null;
    private FilterPage m_pageFilter = null;
    protected GlycanWorkspace m_gwb = null;
    private DatabaseBotSettings m_settings = new DatabaseBotSettings();

    public CreateNewDatabaseWizard() {
        this.setWindowTitle("Start Database Bot");
        try {
            DIALOG_IMAGE = ImageCache.getImageDescriptor(CreateNewDatabaseWizard.class, "icons/wizard-logo.png");
        }
        catch (IOException e) {
            logger.error((Object)"Unable to load dialog image", (Throwable)e);
        }
        this.m_pageSource = new SourcePage(DIALOG_IMAGE);
        this.m_pageInformation = new DatabaseInformationPage(DIALOG_IMAGE);
        this.m_pageDatabaseType = new DatabaseTypePage(DIALOG_IMAGE);
        this.m_pageFilter = new FilterPage(DIALOG_IMAGE);
        try {
            this.m_gwb = new GlycanWorkspace((GlycanRenderer)new GlycanRendererAWT());
        }
        catch (Exception e) {
            logger.error((Object)"Unable to initialitze GWB", (Throwable)e);
        }
    }

    public IWizardPage getNextPage(IWizardPage a_page) {
        return super.getNextPage(a_page);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.m_pageDatabaseType);
        this.addPage((IWizardPage)this.m_pageInformation);
        this.addPage((IWizardPage)this.m_pageSource);
        this.addPage((IWizardPage)this.m_pageFilter);
    }

    public boolean performFinish() {
        try {
            this.m_pageDatabaseType.fillCreateDatabaseSettings(this.m_settings);
        }
        catch (DatabaseBotException e) {
            ErrorUtils.createErrorMessageBox((Shell)this.getShell(), (String)"Error creating settings for DatabaseBot", (String)e.getMessage());
            logger.error((Object)"Error creating database settings settings", (Throwable)e);
            return false;
        }
        this.m_pageInformation.fillCreateDatabaseSettings(this.m_settings);
        this.m_pageSource.fillCreateDatabaseSettings(this.m_settings);
        this.m_pageFilter.fillCreateDatabaseSettings(this.m_settings);
        return true;
    }

    public DatabaseBotSettings getSettings() {
        return this.m_settings;
    }
}

