/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.display.control.table.datamodel;

import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.apache.poi.ss.formula.functions.T;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnTableFormat;
import org.grits.toolbox.display.control.table.datamodel.GRITSComparatorChooser;
import org.grits.toolbox.display.control.table.tablecore.GRITSTable;

public class GRITSSortModel
implements ISortModel {
    public static final String PERSISTENCE_KEY_GLAZEDLISTS_SORT_MODEL = ".glazedListsSortModel";
    private GRITSComparatorChooser<T> comparatorChooser;
    private GRITSColumnTableFormat<T> tableFormat;
    protected final SortedList<T> sortedList;
    protected final IConfigRegistry configRegistry;
    protected final ILayer columnHeaderDataLayer;
    protected final GRITSTable parent;

    public GRITSSortModel(SortedList<T> sortedList, IConfigRegistry configRegistry, GRITSTable parent) {
        this.sortedList = sortedList;
        this.configRegistry = configRegistry;
        this.parent = parent;
        this.columnHeaderDataLayer = parent.getColumnHeaderDataLayer();
    }

    protected GRITSComparatorChooser<T> getComparatorChooser() {
        if (this.comparatorChooser == null) {
            this.tableFormat = new GRITSColumnTableFormat(this.configRegistry, this.columnHeaderDataLayer);
            this.comparatorChooser = new GRITSComparatorChooser<T>(this.sortedList, (TableFormat<T>)this.tableFormat);
        }
        return this.comparatorChooser;
    }

    public int getRowPositionFromIndex(int _iIndex) {
        return _iIndex;
    }

    public List<Integer> getSortedColumnIndexes() {
        return this.getComparatorChooser().getSortingColumns();
    }

    public int getSortOrder(int columnIndex) {
        return this.getComparatorChooser().getClickSequence(columnIndex);
    }

    public SortDirectionEnum getSortDirection(int columnIndex) {
        return this.getComparatorChooser().getSortDirectionForColumnIndex(columnIndex);
    }

    public boolean isColumnIndexSorted(int columnIndex) {
        return this.getComparatorChooser().isColumnIndexSorted(columnIndex);
    }

    public List<Comparator> getComparatorsForColumnIndex(int columnIndex) {
        return this.getComparatorChooser().getComparatorsForColumn(columnIndex);
    }

    public void sort(int columnIndex, SortDirectionEnum sortDirection, boolean accumulate) {
        this.getComparatorChooser().sort(columnIndex, sortDirection, accumulate);
    }

    public void loadState(String prefix, Properties properties) {
        Object savedObject = properties.get(String.valueOf(prefix) + PERSISTENCE_KEY_GLAZEDLISTS_SORT_MODEL);
        if (savedObject == null) {
            return;
        }
        this.getComparatorChooser().fromString(savedObject.toString());
    }

    public void saveState(String prefix, Properties properties) {
        properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_GLAZEDLISTS_SORT_MODEL, this.getComparatorChooser().toString());
    }

    public void clear() {
        this.getComparatorChooser().clearComparator();
    }

    public String toString() {
        return super.toString();
    }

    public Comparator<?> getColumnComparator(int columnIndex) {
        return this.tableFormat.getColumnComparator(columnIndex);
    }
}

