/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.views.tabbed;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.editor.ScrollableEntryEditorPart;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.content.AnnotationSettingsTableComposite;
import org.grits.toolbox.ms.om.data.AnalyteSettings;
import org.grits.toolbox.ms.om.data.DataHeader;
import org.grits.toolbox.ms.om.data.Method;

public class MSAnnotationPropertyView
extends ScrollableEntryEditorPart {
    private static final Logger logger = Logger.getLogger(MSAnnotationPropertyView.class);
    private Composite parent = null;
    private Composite container = null;
    protected Method msAnnotationMethod = null;
    protected DataHeader msDataHeader = null;
    private Label descriptionLabel;
    private Text descriptionText;
    private MPart part;

    @Inject
    public MSAnnotationPropertyView(Entry entry) {
        this.entry = entry;
    }

    @PostConstruct
    public void postConstruct(MPart part) {
        this.setPart(part);
    }

    public void createPartControl(Composite parent) {
        ModifyListener modListener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                MSAnnotationPropertyView.this.setDirty(true);
            }
        };
        parent.setLayout((Layout)new FillLayout());
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        Composite c = new Composite((Composite)sc, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.numColumns = 6;
        c.setLayout((Layout)layout);
        this.parent = parent.getParent().getParent();
        this.container = c;
        MSAnnotationEntityProperty msep = (MSAnnotationEntityProperty)this.entry.getProperty();
        MSAnnotationProperty pp = (MSAnnotationProperty)msep.getParentProperty();
        try {
            this.addDisplayNameLine();
            this.addDescriptionLine(pp, modListener);
            AnnotationSettingsTableComposite settingsComposite = this.getSettingsComposite();
            settingsComposite.setMethod(this.msAnnotationMethod);
            settingsComposite.setLayoutData(new GridData(4, 128, true, false, 6, 1));
            settingsComposite.createGeneralSettingsTable();
            settingsComposite.createIonsTable();
            settingsComposite.createIonExchangesTable();
            settingsComposite.createNeutralLossTable();
            List<AnalyteSettings> aSettings = this.getAnalyteSettings();
            this.addAnalyteSettings(aSettings, settingsComposite);
        }
        catch (Exception e) {
            logger.error((Object)"Error adding property elements.", (Throwable)e);
        }
        sc.setContent((Control)c);
        sc.setMinSize(c.computeSize(-1, -1));
    }

    protected AnnotationSettingsTableComposite getSettingsComposite() {
        return new AnnotationSettingsTableComposite(this.getContainer(), 0);
    }

    private void addDisplayNameLine() {
        Label lblDisplayName = new Label(this.getContainer(), 0);
        lblDisplayName.setText("Display Name");
        GridData gdDisplayData = new GridData();
        gdDisplayData.horizontalSpan = 5;
        lblDisplayName.setLayoutData((Object)gdDisplayData);
        Text txtDisplayName = new Text(this.getContainer(), 2048);
        txtDisplayName.setText(this.getEntry().getDisplayName());
        txtDisplayName.setEditable(false);
        GridData gdTxtDisplayData = new GridData();
        gdTxtDisplayData.grabExcessHorizontalSpace = true;
        gdTxtDisplayData.horizontalAlignment = 4;
        gdTxtDisplayData.horizontalSpan = 1;
        txtDisplayName.setLayoutData((Object)gdTxtDisplayData);
    }

    private void addDescriptionLine(MSAnnotationProperty pp, ModifyListener modListener) {
        this.descriptionLabel = new Label(this.getContainer(), 0);
        this.descriptionLabel.setText("Description");
        GridData descriptionLabelData = new GridData();
        descriptionLabelData.horizontalSpan = 5;
        this.descriptionLabel.setLayoutData((Object)descriptionLabelData);
        this.descriptionText = new Text(this.getContainer(), 2626);
        this.descriptionText.setText(pp.getMSAnnotationMetaData().getDescription());
        this.descriptionText.addModifyListener(this.getModListener());
        GridData gdTxtGridData = new GridData();
        gdTxtGridData.grabExcessHorizontalSpace = true;
        gdTxtGridData.horizontalAlignment = 4;
        gdTxtGridData.verticalAlignment = 4;
        gdTxtGridData.horizontalSpan = 1;
        gdTxtGridData.verticalSpan = 3;
        this.descriptionText.setLayoutData((Object)gdTxtGridData);
    }

    protected List<AnalyteSettings> getAnalyteSettings() {
        return this.msAnnotationMethod.getAnalyteSettings();
    }

    protected void addAnalyteSettings(List<AnalyteSettings> aSettings, AnnotationSettingsTableComposite settingsComposite) {
        if (aSettings != null) {
            settingsComposite.createAnalyteSettingsTable();
        }
    }

    public void setMsAnnotationMethod(Method msAnnotationMethod) {
        this.msAnnotationMethod = msAnnotationMethod;
    }

    public Method getMsAnnotationMethod() {
        return this.msAnnotationMethod;
    }

    protected boolean isValidInput() {
        return this.checkBasicLengthCheck(this.descriptionLabel, this.descriptionText, 0, Integer.parseInt(PropertyHandler.getVariable((String)"descriptionLength")));
    }

    protected void updateProjectProperty() {
        try {
            Entry projectEntry = DataModelSearch.findParentByType((Entry)this.entry, (String)"org.grits.toolbox.property.project");
            MSAnnotationProperty property = null;
            property = this.entry.getProperty() instanceof MSAnnotationEntityProperty ? (MSAnnotationProperty)((MSAnnotationEntityProperty)this.entry.getProperty()).getParentProperty() : (MSAnnotationProperty)this.entry.getProperty();
            property.getMSAnnotationMetaData().setDescription(this.descriptionText.getText());
            String settingsFile = property.getFullyQualifiedMetaDataFileName(projectEntry);
            MSAnnotationProperty.marshallSettingsFile(settingsFile, property.getMSAnnotationMetaData());
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    @Focus
    public void setFocus() {
        this.descriptionLabel.setFocus();
    }

    protected Composite getParent() {
        return this.parent;
    }

    protected Composite getContainer() {
        return this.container;
    }

    protected void savePreference() {
    }

    protected void initializeComponents() {
    }

    public MPart getPart() {
        return this.part;
    }

    public void setPart(MPart part) {
        this.part = part;
    }
}

