/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.views.tabbed;

import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.grits.toolbox.display.control.table.tablecore.GRITSTable;
import org.grits.toolbox.entry.ms.annotation.tablehelpers.MSAnnotationTable;

public class MSAnnotationSelectionView {
    private static final Logger logger = Logger.getLogger(MSAnnotationSelectionView.class);
    protected MSAnnotationTable parentTable = null;
    protected String sParentRowId;
    protected int iParentRowIndex;
    protected int iParentScanNum;
    protected MSAnnotationTable subTable = null;
    protected Composite parent = null;
    protected MyPaintListener paintListener = null;

    public MSAnnotationSelectionView(Composite parent) {
        this.parent = parent;
    }

    public String toString() {
        return "MSAnnotationSelectionView (" + (Object)((Object)this.parentTable) + ")";
    }

    public boolean isOpen(GRITSTable parentTable, int iParentScanNum, String sParentRowId) {
        return this.parentTable != null && this.parentTable.getID() == parentTable.getID() && this.sParentRowId.equals(sParentRowId) && this.iParentScanNum == iParentScanNum;
    }

    public int getParentRowIndex() {
        return this.iParentRowIndex;
    }

    public String getParentPeakId() {
        return this.sParentRowId;
    }

    public int getParentScanNum() {
        return this.iParentScanNum;
    }

    public MSAnnotationTable getSubTable() {
        return this.subTable;
    }

    public void setSubTable(MSAnnotationTable subTable) {
        this.subTable = subTable;
    }

    public void setParams(MSAnnotationTable parentTable, int iParentRowIndex, int iParentScanNum, String sParentRowId) {
        this.parentTable = parentTable;
        this.sParentRowId = sParentRowId;
        this.iParentRowIndex = iParentRowIndex;
        this.iParentScanNum = iParentScanNum;
    }

    @PostConstruct
    public void createPartControl(Composite parent) {
        this.parent = parent;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 10;
        parent.setLayout((Layout)gridLayout);
    }

    public void createView() {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.subTable.setLayoutData(gridData);
    }

    protected void initTable() {
        this.subTable = new MSAnnotationTable(this.parent, this.parentTable, this.iParentRowIndex, this.iParentScanNum, this.sParentRowId);
        this.subTable.createSubsetTable();
        this.addListeners();
    }

    protected void addListeners() {
        this.paintListener = new MyPaintListener();
        this.subTable.addPaintListener(this.paintListener);
    }

    public boolean updateTable() {
        if (this.subTable == null) {
            this.initTable();
            return true;
        }
        this.paintListener.reset();
        this.subTable.reInit(this.parent, this.parentTable, this.iParentRowIndex, this.iParentScanNum, this.sParentRowId);
        this.subTable.redraw();
        Listener[] listeners = this.subTable.getListeners(11);
        if (listeners.length >= 1) {
            Event e = new Event();
            listeners[0].handleEvent(e);
        }
        return false;
    }

    @Focus
    public void setFocus() {
    }

    class MyPaintListener
    implements PaintListener {
        boolean[] bValues = null;

        MyPaintListener() {
        }

        public void reset() {
            this.bValues = null;
        }

        public void paintControl(PaintEvent e) {
            if (this.bValues == null) {
                this.bValues = this.initValues();
            } else if (this.changed()) {
                this.bValues = this.initValues();
                boolean bDirty = MSAnnotationSelectionView.this.parentTable.startUpdateHiddenRowsAfterEdit(MSAnnotationSelectionView.this.subTable);
                MSAnnotationSelectionView.this.parentTable.finishUpdateHiddenRowsAfterEdit(bDirty);
            }
        }

        private boolean[] initValues() {
            boolean[] bValues = new boolean[MSAnnotationSelectionView.this.subTable.getBottomDataLayer().getRowCount()];
            int i = 0;
            while (i < MSAnnotationSelectionView.this.subTable.getBottomDataLayer().getRowCount()) {
                Boolean bObj = (Boolean)MSAnnotationSelectionView.this.subTable.getBottomDataLayer().getDataValueByPosition(0, i);
                bValues[i] = bObj == null ? false : bObj;
                ++i;
            }
            return bValues;
        }

        private boolean changed() {
            int i = 0;
            while (i < MSAnnotationSelectionView.this.subTable.getBottomDataLayer().getRowCount()) {
                Boolean bObj = (Boolean)MSAnnotationSelectionView.this.subTable.getBottomDataLayer().getDataValueByPosition(0, i);
                if (bObj != null && this.bValues[i] != bObj) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

