/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.datamodel.ms.annotation.glycan.preference.cartoon;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.preference.PreferenceHandler;
import org.grits.toolbox.core.preference.share.PreferenceEntity;
import org.grits.toolbox.core.preference.share.PreferenceReader;
import org.grits.toolbox.core.preference.share.PreferenceWriter;
import org.grits.toolbox.core.utilShare.XMLUtils;

@XmlRootElement(name="msGlycanAnnotationCartoonPreferences")
public class MSGlycanAnnotationCartoonPreferences {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationCartoonPreferences.class);
    private static final String PREFERENCE_NAME_ALL = "org.grits.toolbox.datamodel.ms.annotation.glycan.preference.MSGlycanAnnotationCartoonPreferences.all";
    private static final String CURRENT_VERSION = "1.0";
    private static final String DEFAULT_IMAGE_LAYOUT_FILE = "cartoonTypes.imageLayout.xml";
    private static final String DEFAULT_IMAGE_ORIENTATION_FILE = "cartoonTypes.imageOrientation.xml";
    private static final String DEFAULT_IMAGE_STYLE_FILE = "cartoonTypes.imageStyle.xml";
    private String imageLayout = null;
    private String imageStyle = null;
    private String orientation = null;
    private String scaleFactor = "0.5";
    private boolean showInfo = true;
    private boolean showMasses = false;
    private boolean showRedEnd = true;
    private Set<String> allLayouts = null;
    private Set<String> allOrientations = null;
    private Set<String> allStyles = null;

    public Set<String> getAllLayouts() {
        return this.allLayouts;
    }

    @XmlTransient
    public void setAllLayouts(Set<String> allLayouts) {
        this.allLayouts = allLayouts;
    }

    public Set<String> getAllOrientations() {
        return this.allOrientations;
    }

    @XmlTransient
    public void setAllOrientations(Set<String> allOrientations) {
        this.allOrientations = allOrientations;
    }

    public Set<String> getAllStyles() {
        return this.allStyles;
    }

    @XmlTransient
    public void setAllStyles(Set<String> allStyles) {
        this.allStyles = allStyles;
    }

    public String getOrientation() {
        return this.orientation;
    }

    @XmlAttribute(name="orientation")
    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public boolean isShowInfo() {
        return this.showInfo;
    }

    @XmlAttribute(name="showInfo")
    public void setShowInfo(boolean showInfo) {
        this.showInfo = showInfo;
    }

    public boolean isShowMasses() {
        return this.showMasses;
    }

    @XmlAttribute(name="showMasses")
    public void setShowMasses(boolean showMasses) {
        this.showMasses = showMasses;
    }

    public boolean isShowRedEnd() {
        return this.showRedEnd;
    }

    @XmlAttribute(name="showRedEnd")
    public void setShowRedEnd(boolean showRedEnd) {
        this.showRedEnd = showRedEnd;
    }

    public String getImageScaleFactor() {
        return this.scaleFactor;
    }

    @XmlAttribute(name="scaleFactor")
    public void setImageScaleFactor(String scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public String getImageLayout() {
        return this.imageLayout;
    }

    @XmlAttribute(name="imageLayout")
    public void setImageLayout(String imageLayout) {
        this.imageLayout = imageLayout;
    }

    public String getImageStyle() {
        return this.imageStyle;
    }

    @XmlAttribute(name="imageStyle")
    public void setImageStyle(String imageStyle) {
        this.imageStyle = imageStyle;
    }

    public static int getGWBOrientationCode(String orientation) {
        if (orientation == null || orientation.equals("RL")) {
            return 0;
        }
        if (orientation.equals("LR")) {
            return 2;
        }
        if (orientation.equals("TB")) {
            return 3;
        }
        if (orientation.equals("BT")) {
            return 1;
        }
        Exception e = new Exception("Invalid orientation.");
        logger.error((Object)e.getMessage(), (Throwable)e);
        return 0;
    }

    public static String getGWBlayoutString(String layout) throws Exception {
        if (layout.equals("CFG")) {
            return "cfg";
        }
        if (layout.equals("Oxford")) {
            return "uoxf";
        }
        if (layout.equals("Text")) {
            return "text";
        }
        if (layout.equals("CFG-BW")) {
            return "cfgbw";
        }
        if (layout.equals("Oxford-Color")) {
            return "uoxfcol";
        }
        if (layout.equals("CFG-Hybrid")) {
            return "cfglink";
        }
        Exception e = new Exception("Invalid layout.");
        logger.error((Object)e.getMessage(), (Throwable)e);
        return "cfg";
    }

    public static String getGWBStyleString(String layout) throws Exception {
        if (layout.equals("Normal")) {
            return "normal";
        }
        if (layout.equals("Compact")) {
            return "compact";
        }
        if (layout.equals("Complete")) {
            return "normalinfo";
        }
        Exception e = new Exception("Invalid style.");
        logger.error((Object)e.getMessage(), (Throwable)e);
        return "normalinfo";
    }

    private static MSGlycanAnnotationCartoonPreferences getCartoonSettingsFromXML(String xmlString) {
        MSGlycanAnnotationCartoonPreferences cartoonSettings = (MSGlycanAnnotationCartoonPreferences)XMLUtils.getObjectFromXML((String)xmlString, MSGlycanAnnotationCartoonPreferences.class);
        return cartoonSettings;
    }

    public static String marshalXML(MSGlycanAnnotationCartoonPreferences object) {
        String xmlString = XMLUtils.marshalObjectXML((Object)object);
        return xmlString;
    }

    private String loadDefaultOptions(Set<String> _sAllPreferences, String _sDefaultPreferenceFile) {
        String sDefault = null;
        try {
            HashMap optionMap = PreferenceHandler.getPreferenceValues((String)_sDefaultPreferenceFile, (String)"org.grits.toolbox.datamodel.ms.annotation.glycan");
            for (String option : optionMap.keySet()) {
                _sAllPreferences.add(option);
                if (!((Boolean)optionMap.get(option)).booleanValue()) continue;
                sDefault = option;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error loading default options from xml files.", (Throwable)ex);
            throw ex;
        }
        return sDefault;
    }

    public void loadDefaultOptions() {
        this.allLayouts = new HashSet<String>();
        this.allOrientations = new HashSet<String>();
        this.allStyles = new HashSet<String>();
        try {
            String sDefault = null;
            try {
                sDefault = this.loadDefaultOptions(this.allLayouts, DEFAULT_IMAGE_LAYOUT_FILE);
                if (this.imageLayout == null) {
                    this.imageLayout = sDefault;
                }
            }
            catch (Exception ex) {
                throw new Exception("Unable to load layout preferences", ex);
            }
            try {
                sDefault = this.loadDefaultOptions(this.allOrientations, DEFAULT_IMAGE_ORIENTATION_FILE);
                if (this.orientation == null) {
                    this.orientation = sDefault;
                }
            }
            catch (Exception ex) {
                throw new Exception("Unable to load orientation preferences", ex);
            }
            try {
                sDefault = this.loadDefaultOptions(this.allStyles, DEFAULT_IMAGE_STYLE_FILE);
                if (this.imageStyle == null) {
                    this.imageStyle = sDefault;
                }
            }
            catch (Exception ex) {
                throw new Exception("Unable to load style preferences", ex);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error loading default options", (Throwable)ex);
        }
    }

    public static MSGlycanAnnotationCartoonPreferences getCartoonSettings(PreferenceEntity preferenceEntity) throws UnsupportedVersionException {
        MSGlycanAnnotationCartoonPreferences preferenceSettings = null;
        if (preferenceEntity != null) {
            preferenceSettings = MSGlycanAnnotationCartoonPreferences.getCartoonSettingsFromXML(preferenceEntity.getValue());
            preferenceSettings.loadDefaultOptions();
        }
        return preferenceSettings;
    }

    public boolean saveValues() {
        PreferenceEntity preferenceEntity = new PreferenceEntity(PREFERENCE_NAME_ALL);
        preferenceEntity.setVersion(CURRENT_VERSION);
        preferenceEntity.setValue(MSGlycanAnnotationCartoonPreferences.marshalXML(this));
        return PreferenceWriter.savePreference((PreferenceEntity)preferenceEntity);
    }

    public static PreferenceEntity getPreferenceEntity() throws UnsupportedVersionException {
        PreferenceEntity preferenceEntity = PreferenceReader.getPreferenceByName((String)PREFERENCE_NAME_ALL);
        return preferenceEntity;
    }

    public static String getPreferenceID() {
        return PREFERENCE_NAME_ALL;
    }
}

