/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.figures;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.widgets.figures.AbstractLinearMarkedFigure;
import org.eclipse.nebula.visualization.widgets.util.GraphicsUtil;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScale;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScaledMarker;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ThermometerFigure
extends AbstractLinearMarkedFigure {
    private Color fillColor;
    private Color fillBackgroundColor = GRAY_COLOR;
    private Color contrastFillColor;
    private TemperatureUnit temperatureUnit;
    private Pipe pipe;
    private Bulb bulb;
    private Label unit;
    private boolean effect3D = true;
    private static final Color RED_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_RED);
    private static final Color GRAY_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_GRAY);
    private static final Color WHITE_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_WHITE);
    private static final Color BLACK_COLOR = XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_BLACK);

    public ThermometerFigure() {
        ((LinearScale)this.scale).setOrientation(LinearScale.Orientation.VERTICAL);
        this.scale.setScaleLineVisible(false);
        this.pipe = new Pipe();
        this.bulb = new Bulb();
        this.unit = new Label();
        this.setLayoutManager((LayoutManager)new ThermoLayout());
        this.add((IFigure)this.scale, "scale");
        this.add((IFigure)this.marker, "markers");
        this.add((IFigure)this.pipe, "pipe");
        this.add((IFigure)this.unit, "unit");
        this.add((IFigure)this.bulb, "bulb");
        this.setFillColor(RED_COLOR);
        this.setTemperatureUnit(TemperatureUnit.CELSIUS);
    }

    public Color getFillBackgroundColor() {
        return this.fillBackgroundColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public TemperatureUnit getTemperatureUnit() {
        return this.temperatureUnit;
    }

    public boolean isEffect3D() {
        return this.effect3D;
    }

    @Override
    public boolean isOpaque() {
        return false;
    }

    public void setEffect3D(boolean effect3D) {
        if (this.effect3D == effect3D) {
            return;
        }
        this.effect3D = effect3D;
        this.repaint();
    }

    public void setFillBackgroundColor(Color fillBackgroundColor) {
        if (this.fillBackgroundColor != null && this.fillBackgroundColor.equals((Object)fillBackgroundColor)) {
            return;
        }
        this.fillBackgroundColor = fillBackgroundColor;
        this.repaint();
    }

    public void setFillColor(Color fillColor) {
        if (this.fillColor != null && this.fillColor.equals((Object)fillColor)) {
            return;
        }
        this.fillColor = fillColor;
        int blue = 255 - fillColor.getBlue();
        int green = 255 - fillColor.getGreen();
        int red = fillColor.getRed();
        this.contrastFillColor = XYGraphMediaFactory.getInstance().getColor(new RGB(red, green, blue));
        this.repaint();
    }

    public void setForegroundColor(Color fg) {
        super.setForegroundColor(fg);
    }

    public void setShowBulb(boolean showBulb) {
        this.bulb.setVisible(showBulb);
        this.revalidate();
    }

    public void setTemperatureUnit(TemperatureUnit temperatureUnit) {
        if (this.temperatureUnit == temperatureUnit) {
            return;
        }
        this.temperatureUnit = temperatureUnit;
        this.unit.setText(temperatureUnit.getUnitString());
    }

    @Override
    public void setValue(double value) {
        super.setValue(value);
    }

    class Bulb
    extends Ellipse {
        public static final int MAX_DIAMETER = 40;
        private final Color EFFECT3D_BULB_COLOR = XYGraphMediaFactory.getInstance().getColor(new RGB(140, 140, 140));

        public Bulb() {
            this.setOutline(true);
        }

        protected void fillShape(Graphics graphics) {
            graphics.setAntialias(1);
            boolean support3D = false;
            if (ThermometerFigure.this.effect3D) {
                support3D = GraphicsUtil.testPatternSupported(graphics);
            }
            if (ThermometerFigure.this.effect3D && support3D) {
                graphics.setBackgroundColor(ThermometerFigure.this.fillColor);
                super.fillShape(graphics);
                Pattern backPattern = null;
                backPattern = GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), this.bounds.x + this.lineWidth, this.bounds.y + this.lineWidth, this.bounds.x + this.bounds.width - this.lineWidth, this.bounds.y + this.bounds.height - this.lineWidth, WHITE_COLOR, 255, ThermometerFigure.this.fillColor, 0);
                graphics.setBackgroundPattern(backPattern);
                super.fillShape(graphics);
                backPattern.dispose();
            } else {
                graphics.setBackgroundColor(ThermometerFigure.this.fillColor);
                super.fillShape(graphics);
            }
            String valueString = ThermometerFigure.this.getValueText();
            Dimension valueSize = FigureUtilities.getTextExtents((String)valueString, (Font)this.getFont());
            if (valueSize.width < this.bounds.width) {
                graphics.setForegroundColor(ThermometerFigure.this.contrastFillColor);
                graphics.drawText(valueString, new Point(this.bounds.x + this.bounds.width / 2 - valueSize.width / 2, this.bounds.y + this.bounds.height / 2 - valueSize.height / 2));
            }
        }

        protected void outlineShape(Graphics graphics) {
            boolean support3D = false;
            if (ThermometerFigure.this.effect3D) {
                support3D = GraphicsUtil.testPatternSupported(graphics);
            }
            if (ThermometerFigure.this.effect3D && support3D) {
                graphics.setForegroundColor(this.EFFECT3D_BULB_COLOR);
            } else {
                graphics.setForegroundColor(BLACK_COLOR);
            }
            super.outlineShape(graphics);
            if (ThermometerFigure.this.effect3D && support3D) {
                graphics.setBackgroundColor(ThermometerFigure.this.fillColor);
                graphics.fillRectangle(new Rectangle(((ThermometerFigure)ThermometerFigure.this).pipe.getBounds().x + ThermometerFigure.this.pipe.getLineWidth(), ((LinearScale)ThermometerFigure.this.scale).getValuePosition(ThermometerFigure.this.scale.getRange().getLower(), false), 15 - ThermometerFigure.this.pipe.getLineWidth() * 2, 2));
                Pattern backPattern = GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), ((ThermometerFigure)ThermometerFigure.this).pipe.getBounds().x, ((LinearScale)ThermometerFigure.this.scale).getValuePosition(ThermometerFigure.this.scale.getRange().getLower(), false), ((ThermometerFigure)ThermometerFigure.this).pipe.getBounds().x + 15, ((LinearScale)ThermometerFigure.this.scale).getValuePosition(ThermometerFigure.this.scale.getRange().getLower(), false), WHITE_COLOR, 255, ThermometerFigure.this.fillColor, 0);
                graphics.setBackgroundPattern(backPattern);
                graphics.fillRectangle(new Rectangle(((ThermometerFigure)ThermometerFigure.this).pipe.getBounds().x + ThermometerFigure.this.pipe.getLineWidth(), ((LinearScale)ThermometerFigure.this.scale).getValuePosition(ThermometerFigure.this.scale.getRange().getLower(), false), 15 - ThermometerFigure.this.pipe.getLineWidth() * 2, 2));
                backPattern.dispose();
            } else {
                graphics.setBackgroundColor(ThermometerFigure.this.fillColor);
                graphics.fillRoundRectangle(new Rectangle(((ThermometerFigure)ThermometerFigure.this).pipe.getBounds().x + ThermometerFigure.this.pipe.getLineWidth(), ((LinearScale)ThermometerFigure.this.scale).getValuePosition(ThermometerFigure.this.scale.getRange().getLower(), false), 15 - ThermometerFigure.this.pipe.getLineWidth() * 2, ((LinearScale)ThermometerFigure.this.scale).getMargin()), 3, 3);
            }
        }
    }

    class Pipe
    extends RoundedRectangle {
        public static final int FILL_CORNER = 3;
        public static final int PIPE_WIDTH = 15;
        private final Color EFFECT3D_PIPE_COLOR = XYGraphMediaFactory.getInstance().getColor(new RGB(160, 160, 160));

        public Pipe() {
            this.setOutline(true);
        }

        protected void fillShape(Graphics graphics) {
            this.corner.height = 7;
            this.corner.width = 7;
            graphics.setBackgroundColor(ThermometerFigure.this.fillBackgroundColor);
            int valuePosition = ((LinearScale)ThermometerFigure.this.scale).getValuePosition(ThermometerFigure.this.getCoercedValue(), false);
            if (ThermometerFigure.this.maximum > ThermometerFigure.this.minimum) {
                if (ThermometerFigure.this.value > ThermometerFigure.this.maximum) {
                    valuePosition -= 10;
                } else if (ThermometerFigure.this.value < ThermometerFigure.this.minimum) {
                    valuePosition += 10;
                }
            } else if (ThermometerFigure.this.value > ThermometerFigure.this.minimum) {
                valuePosition += 10;
            } else if (ThermometerFigure.this.value < ThermometerFigure.this.maximum) {
                valuePosition -= 10;
            }
            boolean support3D = false;
            if (ThermometerFigure.this.effect3D) {
                support3D = GraphicsUtil.testPatternSupported(graphics);
            }
            if (ThermometerFigure.this.effect3D && support3D) {
                graphics.setForegroundColor(this.EFFECT3D_PIPE_COLOR);
                super.fillShape(graphics);
                Pattern backPattern = GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y, WHITE_COLOR, 255, ThermometerFigure.this.fillBackgroundColor, 0);
                graphics.setBackgroundPattern(backPattern);
                super.fillShape(graphics);
                backPattern.dispose();
                graphics.setBackgroundColor(ThermometerFigure.this.fillColor);
                graphics.fillRoundRectangle(new Rectangle(this.bounds.x + this.lineWidth, valuePosition, this.bounds.width - 2 * this.lineWidth, this.bounds.height - (valuePosition - this.bounds.y)), 3, 3);
                backPattern = GraphicsUtil.createScaledPattern(graphics, (Device)Display.getCurrent(), this.bounds.x, this.bounds.y, this.bounds.x + this.bounds.width, this.bounds.y, WHITE_COLOR, 255, ThermometerFigure.this.fillColor, 0);
                graphics.setBackgroundPattern(backPattern);
                graphics.fillRoundRectangle(new Rectangle(this.bounds.x + this.lineWidth, valuePosition, this.bounds.width - 2 * this.lineWidth, this.bounds.height - (valuePosition - this.bounds.y)), 3, 3);
                backPattern.dispose();
            } else {
                super.fillShape(graphics);
                graphics.setBackgroundColor(ThermometerFigure.this.fillColor);
                graphics.fillRoundRectangle(new Rectangle(this.bounds.x + this.lineWidth, valuePosition, this.bounds.width - 2 * this.lineWidth, this.bounds.height - (valuePosition - this.bounds.y)), 3, 3);
            }
        }

        public Dimension getCorner() {
            return this.corner;
        }

        public Dimension getPreferredSize(int wHint, int hHint) {
            return new Dimension(15, hHint + 2 * this.corner.height);
        }
    }

    public static enum TemperatureUnit {
        CELSIUS("Celsius", "\u2103"),
        FAHRENHEIT("Fahrenheit", "\u2109"),
        KELVIN("Kelvin", "K"),
        NONE("None", "");

        private String name;
        private String unitString;

        public static String[] stringValues() {
            String[] result = new String[TemperatureUnit.values().length];
            int i = 0;
            TemperatureUnit[] temperatureUnitArray = TemperatureUnit.values();
            int n = temperatureUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                TemperatureUnit t = temperatureUnitArray[n2];
                result[i++] = t.toString();
                ++n2;
            }
            return result;
        }

        private TemperatureUnit(String name, String unitString) {
            this.name = name;
            this.unitString = unitString;
        }

        public String getUnitString() {
            return this.unitString;
        }

        public String toString() {
            return this.name;
        }
    }

    static class ThermoLayout
    extends AbstractLayout {
        public static final String SCALE = "scale";
        public static final String PIPE = "pipe";
        public static final String MARKERS = "markers";
        public static final String BULB = "bulb";
        public static final String UNIT = "unit";
        private LinearScale scale;
        private LinearScaledMarker marker;
        private Pipe pipe;
        private IFigure bulb;
        private IFigure unit;

        ThermoLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int w, int h) {
            Insets insets = container.getInsets();
            Dimension d = new Dimension(64, 256);
            d.expand(insets.getWidth(), insets.getHeight());
            return d;
        }

        public void layout(IFigure container) {
            Rectangle area = container.getClientArea();
            if (this.bulb != null && this.bulb.isVisible()) {
                int diameter = area.width / 2;
                if (diameter > 40) {
                    diameter = 40;
                }
                int x = area.x + area.width / 2 - diameter / 2;
                int spareHeight = area.height < diameter ? 0 : area.height - diameter;
                int y = area.y + spareHeight;
                this.bulb.setBounds(new Rectangle(x, y, diameter, diameter));
                area.height = spareHeight + this.scale.getMargin();
            }
            Dimension unitSize = new Dimension(0, 0);
            if (this.unit != null && this.unit.isVisible()) {
                unitSize = this.unit.getPreferredSize();
                this.unit.setBounds(new Rectangle(area.x + area.width / 2 - 7 - unitSize.width, area.y, unitSize.width, unitSize.height));
            }
            if (this.scale != null) {
                Dimension scaleSize = this.scale.getPreferredSize(-1, area.height - unitSize.height);
                this.scale.setBounds(new Rectangle(area.x + area.width / 2 - 7 - scaleSize.width, area.y + unitSize.height, scaleSize.width, scaleSize.height));
            }
            if (this.marker != null && this.marker.isVisible()) {
                Dimension markerSize = this.marker.getPreferredSize();
                this.marker.setBounds(new Rectangle(area.x + area.width / 2 + 7, this.marker.getScale().getBounds().y, markerSize.width, markerSize.height));
            }
            if (this.pipe != null) {
                Dimension pipeSize = this.pipe.getPreferredSize(-1, this.scale.getTickLength());
                this.pipe.setBounds(new Rectangle(area.x + area.width / 2 - 7, this.scale.getValuePosition(this.scale.getRange().getUpper(), false) - this.pipe.getCorner().height, pipeSize.width, pipeSize.height));
            }
        }

        public void setConstraint(IFigure child, Object constraint) {
            if (constraint.equals(SCALE)) {
                this.scale = (LinearScale)child;
            } else if (constraint.equals(MARKERS)) {
                this.marker = (LinearScaledMarker)child;
            } else if (constraint.equals(PIPE)) {
                this.pipe = (Pipe)child;
            } else if (constraint.equals(BULB)) {
                this.bulb = child;
            } else if (constraint.equals(UNIT)) {
                this.unit = child;
            }
        }
    }
}

