/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.part;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.grits.toolbox.entry.sample.config.Config;
import org.grits.toolbox.entry.sample.model.Component;
import org.grits.toolbox.entry.sample.model.Sample;
import org.grits.toolbox.entry.sample.model.Template;
import org.grits.toolbox.entry.sample.ontologymanager.ISampleOntologyApi;
import org.grits.toolbox.entry.sample.part.IAnalytePartTab;
import org.grits.toolbox.entry.sample.part.action.AddDescriptorAction;
import org.grits.toolbox.entry.sample.part.action.AddDescriptorGroupAction;
import org.grits.toolbox.entry.sample.part.action.DeleteDescriptorDescriptorGroupAction;
import org.grits.toolbox.entry.sample.part.action.EditDescriptorDescriptorGroupAction;
import org.grits.toolbox.entry.sample.part.action.sort.CategoryColumnSelectionListener;
import org.grits.toolbox.entry.sample.part.action.sort.CategoryDescriptorViewerComparator;
import org.grits.toolbox.entry.sample.part.providers.CategoryTreeContentProvider;
import org.grits.toolbox.entry.sample.part.providers.TreeViewerSetup;
import org.grits.toolbox.entry.sample.utilities.MaintainTreeColumnRatioListener;

public class ComponentTab
implements IAnalytePartTab {
    private static Logger logger = Logger.getLogger(ComponentTab.class);
    private Component component = null;
    private CTabItem cTabItem = null;
    @Inject
    MDirtyable dirtyable;
    @Inject
    IEventBroker eventBroker;
    @Inject
    ISampleOntologyApi sampleOntologyApi;
    @Inject
    private IEclipseContext eclipseContext;
    private Text descriptionText = null;
    private TreeViewer treeViewer1 = null;
    private TreeViewer treeViewer2 = null;
    private TreeViewer treeViewer3 = null;
    private TreeViewer treeViewer4 = null;
    private Template loadedTemplate = null;

    @Inject
    public ComponentTab(Component component, CTabItem cTabItem) {
        this.component = component;
        this.cTabItem = cTabItem;
    }

    @PostConstruct
    public void createTab() {
        logger.info((Object)"Creating component tab");
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this.cTabItem.getParent(), 768);
        GridData layoutData = new GridData();
        scrolledComposite.setLayoutData((Object)layoutData);
        scrolledComposite.setLayout((Layout)new GridLayout());
        Composite composite = new Composite((Composite)scrolledComposite, 4);
        GridLayout firstLevelLayout = new GridLayout(1, true);
        firstLevelLayout.verticalSpacing = 30;
        composite.setLayout((Layout)firstLevelLayout);
        composite.setBackground(Display.getCurrent().getSystemColor(37));
        Composite comp1 = this.createDescriptionPart(composite);
        GridData comp1Data = new GridData();
        comp1Data.horizontalSpan = 1;
        comp1Data.heightHint = 120;
        comp1Data.minimumWidth = 400;
        comp1Data.grabExcessHorizontalSpace = true;
        comp1Data.horizontalAlignment = 4;
        comp1.setLayoutData((Object)comp1Data);
        Composite comp2 = this.createTreeViewersPart(composite);
        GridData comp2Data = new GridData(1808);
        comp2Data.grabExcessHorizontalSpace = true;
        comp2Data.horizontalAlignment = 4;
        comp2Data.grabExcessVerticalSpace = true;
        comp2Data.horizontalSpan = 1;
        comp2.setLayoutData((Object)comp2Data);
        GridData fullCompositeData = new GridData();
        composite.setLayoutData((Object)fullCompositeData);
        scrolledComposite.setContent((Control)composite);
        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        this.cTabItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ComponentTab.this.setTemplateForTab();
            }
        });
        this.cTabItem.setControl((Control)scrolledComposite);
    }

    private Composite createDescriptionPart(Composite composite) {
        Composite descriptionComposite = new Composite(composite, 4);
        GridLayout descriptionPartLayout = new GridLayout(2, false);
        descriptionComposite.setLayout((Layout)descriptionPartLayout);
        descriptionComposite.setBackground(Display.getCurrent().getSystemColor(37));
        Label descriptionLabel = new Label(descriptionComposite, 16384);
        descriptionLabel.setBackground(Display.getCurrent().getSystemColor(1));
        descriptionLabel.setText("Description :");
        GridData gd = new GridData(128);
        gd.verticalAlignment = 1;
        descriptionLabel.setLayoutData((Object)gd);
        this.descriptionText = new Text(descriptionComposite, 2624);
        if (this.component.getDescription() != null) {
            this.descriptionText.setText(this.component.getDescription());
        }
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.descriptionText.setLayoutData((Object)gd);
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Text text = (Text)event.widget;
                ComponentTab.this.component.setDescription(text.getText().trim());
                ComponentTab.this.dirtyable.setDirty(true);
            }
        });
        this.descriptionText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && e.keyCode == 97) {
                    ((Text)e.getSource()).selectAll();
                }
            }
        });
        return descriptionComposite;
    }

    private Composite createTreeViewersPart(Composite fullComposite) {
        Composite treeViewersComposite = new Composite(fullComposite, 17);
        treeViewersComposite.setBackground(Display.getCurrent().getSystemColor(37));
        TableWrapLayout treeViewersCompositeLayout = new TableWrapLayout();
        treeViewersCompositeLayout.numColumns = 2;
        treeViewersCompositeLayout.makeColumnsEqualWidth = true;
        treeViewersCompositeLayout.verticalSpacing = 10;
        treeViewersCompositeLayout.horizontalSpacing = 10;
        treeViewersComposite.setLayout((Layout)treeViewersCompositeLayout);
        logger.info((Object)"Creating Info tree viewer");
        this.treeViewer1 = this.createTreeViewer(treeViewersComposite, "Component Info", 300);
        logger.info((Object)"Creating Tracking tree viewer");
        this.treeViewer2 = this.createTreeViewer(treeViewersComposite, "Tracking", 300);
        logger.info((Object)"Creating Amount tree viewer");
        this.treeViewer3 = this.createTreeViewer(treeViewersComposite, "Amount", 200);
        logger.info((Object)"Creating Purity Q.C. tree viewer");
        this.treeViewer4 = this.createTreeViewer(treeViewersComposite, "Purity Q.C.", 200);
        this.treeViewer1.setInput((Object)this.component.getSampleInformation());
        this.treeViewer2.setInput((Object)this.component.getTracking());
        this.treeViewer3.setInput((Object)this.component.getAmount());
        this.treeViewer4.setInput((Object)this.component.getPurityQC());
        return treeViewersComposite;
    }

    private TreeViewer createTreeViewer(Composite tableComposite, String sectionLabel, int height) {
        Section section = new Section(tableComposite, 324);
        section.setText(sectionLabel);
        section.setBackground(Display.getCurrent().getSystemColor(37));
        section.setTitleBarBackground(Config.TREE_TITLE_BAR_BACKGROUND_COLOR);
        section.setTitleBarForeground(Config.TEXT_COLOR);
        section.setLayout((Layout)new TableWrapLayout());
        Composite sectionComposite = new Composite((Composite)section, 0);
        sectionComposite.setBackground(Display.getCurrent().getSystemColor(1));
        sectionComposite.setLayout((Layout)new GridLayout());
        Tree tree = new Tree(sectionComposite, 68356);
        TreeViewer categoryTreeViewer = new TreeViewer(tree);
        this.getTreeViewer(categoryTreeViewer, height);
        ToolBarManager toolBarManager = new ToolBarManager();
        AddDescriptorAction addDescriptorAction = (AddDescriptorAction)((Object)ContextInjectionFactory.make(AddDescriptorAction.class, (IEclipseContext)this.eclipseContext));
        addDescriptorAction.init(this.component, categoryTreeViewer);
        toolBarManager.add((IAction)addDescriptorAction);
        AddDescriptorGroupAction addDescriptorGroupAction = (AddDescriptorGroupAction)((Object)ContextInjectionFactory.make(AddDescriptorGroupAction.class, (IEclipseContext)this.eclipseContext));
        addDescriptorGroupAction.init(this.component, categoryTreeViewer);
        toolBarManager.add((IAction)addDescriptorGroupAction);
        final EditDescriptorDescriptorGroupAction editAction = (EditDescriptorDescriptorGroupAction)((Object)ContextInjectionFactory.make(EditDescriptorDescriptorGroupAction.class, (IEclipseContext)this.eclipseContext));
        editAction.init(this.component, categoryTreeViewer);
        toolBarManager.add((IAction)editAction);
        DeleteDescriptorDescriptorGroupAction deleteAction = (DeleteDescriptorDescriptorGroupAction)((Object)ContextInjectionFactory.make(DeleteDescriptorDescriptorGroupAction.class, (IEclipseContext)this.eclipseContext));
        deleteAction.init(this.component, categoryTreeViewer);
        toolBarManager.add((IAction)deleteAction);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        section.setTextClient((Control)toolbar);
        categoryTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                editAction.run();
            }
        });
        TableWrapData sectionCompositeLayoutData = new TableWrapData();
        sectionComposite.setLayoutData((Object)sectionCompositeLayoutData);
        TableWrapData sectionLayoutData = new TableWrapData(256, 256);
        sectionLayoutData.grabHorizontal = true;
        sectionLayoutData.grabVertical = true;
        sectionLayoutData.maxHeight = height + 100;
        section.setLayoutData((Object)sectionLayoutData);
        section.setClient((Control)sectionComposite);
        return categoryTreeViewer;
    }

    private void getTreeViewer(TreeViewer treeViewer, int height) {
        TreeViewerSetup viewerSetup = new TreeViewerSetup(treeViewer, this.dirtyable);
        viewerSetup.setupColumns();
        treeViewer.setContentProvider((IContentProvider)new CategoryTreeContentProvider());
        viewerSetup.setLabelProviders();
        treeViewer.getTree().addControlListener((ControlListener)new MaintainTreeColumnRatioListener(350, 5, 4, 2));
        CategoryDescriptorViewerComparator comparator = new CategoryDescriptorViewerComparator();
        treeViewer.setComparator((ViewerComparator)comparator);
        CategoryColumnSelectionListener columnSelectionListener = new CategoryColumnSelectionListener(treeViewer);
        treeViewer.getTree().getColumn(0).addSelectionListener((SelectionListener)columnSelectionListener);
        treeViewer.getTree().getColumn(1).addSelectionListener((SelectionListener)columnSelectionListener);
        treeViewer.getTree().getColumn(2).addSelectionListener((SelectionListener)columnSelectionListener);
        GridData gridDataTree = new GridData(1808);
        gridDataTree.grabExcessHorizontalSpace = true;
        gridDataTree.grabExcessVerticalSpace = true;
        gridDataTree.minimumHeight = height;
        gridDataTree.minimumWidth = 350;
        treeViewer.getTree().setLayoutData((Object)gridDataTree);
        treeViewer.getTree().setHeaderVisible(true);
        treeViewer.getTree().setLinesVisible(true);
        treeViewer.expandAll();
    }

    @Optional
    @Inject
    public void openTab(@UIEventTopic(value="analyte_part_switch_to_component_tab") Component component) {
        if (this.component == component) {
            this.cTabItem.getParent().setSelection(this.cTabItem);
            this.cTabItem.getParent().notifyListeners(13, new Event());
        }
    }

    @Optional
    @Inject
    public void refreshTab(@UIEventTopic(value="component_modified_in_a_tab") Component component, Sample sample, MDirtyable dirtyable) {
        if (this.component == component) {
            this.cTabItem.setText(component.getLabel());
            this.setTemplateForTab();
            dirtyable.setDirty(true);
            this.eventBroker.post("analyte_modified_in_the_part", (Object)sample);
        }
    }

    private void setTemplateForTab() {
        boolean templateChanged = false;
        if (this.component.getTemplateUri() == null) {
            if (this.loadedTemplate != null) {
                this.loadedTemplate = null;
                templateChanged = true;
            }
        } else if (this.loadedTemplate == null || !this.component.getTemplateUri().equals(this.loadedTemplate.getUri())) {
            this.loadedTemplate = this.sampleOntologyApi.getTemplate(this.component.getTemplateUri());
            if (this.loadedTemplate == null) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Template Not Found", (String)("The template uri \"" + this.component.getTemplateUri() + "\" was not found in the ontologies. Template will be removed."));
                this.component.setTemplateUri(null);
                this.dirtyable.setDirty(true);
            }
            templateChanged = true;
        }
        if (!templateChanged) {
            return;
        }
        if (this.loadedTemplate == null) {
            ((CategoryTreeContentProvider)this.treeViewer1.getContentProvider()).setCategoryTemplate(null);
            ((CategoryTreeContentProvider)this.treeViewer2.getContentProvider()).setCategoryTemplate(null);
            ((CategoryTreeContentProvider)this.treeViewer3.getContentProvider()).setCategoryTemplate(null);
            ((CategoryTreeContentProvider)this.treeViewer4.getContentProvider()).setCategoryTemplate(null);
        } else {
            ((CategoryTreeContentProvider)this.treeViewer1.getContentProvider()).setCategoryTemplate(this.loadedTemplate.getSampleInformationTemplate());
            ((CategoryTreeContentProvider)this.treeViewer2.getContentProvider()).setCategoryTemplate(this.loadedTemplate.getTrackingTemplate());
            ((CategoryTreeContentProvider)this.treeViewer3.getContentProvider()).setCategoryTemplate(this.loadedTemplate.getAmountTemplate());
            ((CategoryTreeContentProvider)this.treeViewer4.getContentProvider()).setCategoryTemplate(this.loadedTemplate.getPurityQCTemplate());
        }
        this.treeViewer1.refresh();
        this.treeViewer2.refresh();
        this.treeViewer3.refresh();
        this.treeViewer4.refresh();
    }

    @Override
    public Component getInput() {
        return this.component;
    }

    @Override
    public void setFocus() {
        this.descriptionText.setFocus();
    }

    @PreDestroy
    public void dispose() {
        logger.info((Object)"Disposing component tab");
    }
}

