/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.process.loader;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.datamodel.ms.annotation.preference.MSAnnotationViewerPreference;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.MSAnnotationTableDataObject;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.dmtranslate.DMAnnotation;
import org.grits.toolbox.datamodel.ms.annotation.tablemodel.dmtranslate.DMFeature;
import org.grits.toolbox.datamodel.ms.preference.MassSpecViewerPreference;
import org.grits.toolbox.datamodel.ms.tablemodel.FillTypes;
import org.grits.toolbox.datamodel.ms.tablemodel.MassSpecTableDataObject;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPeak;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMPrecursorPeak;
import org.grits.toolbox.datamodel.ms.tablemodel.dmtranslate.DMScan;
import org.grits.toolbox.display.control.table.datamodel.GRITSColumnHeader;
import org.grits.toolbox.display.control.table.datamodel.GRITSListDataRow;
import org.grits.toolbox.display.control.table.preference.TableViewerColumnSettings;
import org.grits.toolbox.display.control.table.preference.TableViewerPreference;
import org.grits.toolbox.display.control.table.process.TableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessorUtil;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.property.datamodel.MSAnnotationMetaData;
import org.grits.toolbox.entry.ms.extquantfiles.process.CorrectedQuantColumnInfo;
import org.grits.toolbox.entry.ms.extquantfiles.process.CustomAnnotationDataProcessor;
import org.grits.toolbox.entry.ms.extquantfiles.process.ExternalQuantColumnInfo;
import org.grits.toolbox.entry.ms.extquantfiles.process.ExtractDataProcessor;
import org.grits.toolbox.entry.ms.extquantfiles.process.FullMzXMLDataProcessor;
import org.grits.toolbox.entry.ms.extquantfiles.process.QuantFileProcessor;
import org.grits.toolbox.entry.ms.extquantfiles.process.StandardQuantColumnInfo;
import org.grits.toolbox.entry.ms.extquantfiles.process.StandardQuantDataProcessor;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotation;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotationPeak;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecStandardQuant;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessor;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessorUtil;
import org.grits.toolbox.entry.ms.property.MassSpecEntityProperty;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantAlias;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantFileToAlias;
import org.grits.toolbox.entry.ms.property.datamodel.InternalStandardQuantFileList;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecUISettings;
import org.grits.toolbox.ms.annotation.utils.AnnotationRowExtraction;
import org.grits.toolbox.ms.file.extquant.data.ExternalQuantSettings;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.CustomExtraData;
import org.grits.toolbox.ms.om.data.Data;
import org.grits.toolbox.ms.om.data.DataHeader;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.FeatureSelection;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.ms.om.data.Scan;
import org.grits.toolbox.ms.om.data.ScanFeatures;
import org.grits.toolbox.ms.om.io.xml.AnnotationReader;
import org.grits.toolbox.ms.om.io.xml.AnnotationWriter;
import org.grits.toolbox.widgets.progress.IProgressListener;

public class MSAnnotationTableDataProcessor
extends MassSpecTableDataProcessor {
    private static final Logger logger = Logger.getLogger(MSAnnotationTableDataProcessor.class);
    protected Method method = null;
    protected ScanFeatures curScanFeatures = null;
    protected Feature curFeature = null;
    protected Annotation curAnnotation = null;
    protected AnnotationReader xmlReader = null;
    protected AnnotationWriter xmlWriter = null;
    public static final Integer READ_FEATURES = 3;
    protected MSAnnotationEntityProperty msProp = null;
    private GRITSListDataRow overviewRow = null;
    private Integer iCurDirtyParentScanNum = null;
    private List<Integer> dirtyParentScans = new ArrayList<Integer>();

    public MSAnnotationTableDataProcessor(Entry _entry, Property _sourceProperty, int iMinMSLevel) {
        super(_entry, _sourceProperty, iMinMSLevel);
    }

    public MSAnnotationTableDataProcessor(Entry _entry, Property _sourceProperty, FillTypes fillType, int iMinMSLevel) {
        super(_entry, _sourceProperty, fillType, iMinMSLevel);
    }

    public MSAnnotationTableDataProcessor(TableDataProcessor _parent, Property _sourceProperty, FillTypes fillType, int iMinMSLevel) {
        super(_parent.getEntry(), _sourceProperty, fillType, iMinMSLevel);
        this.data = ((MSAnnotationTableDataProcessor)_parent).getData();
        this.method = ((MSAnnotationTableDataProcessor)_parent).getMethod();
        this.quantFileProcessors = ((MassSpecTableDataProcessor)_parent).getQuantFileProcessors();
    }

    public Integer getCurDirtyParentScanNum() {
        return this.iCurDirtyParentScanNum;
    }

    public void setCurDirtyParentScanNum(Integer iCurDirtyParentScanNum) {
        this.iCurDirtyParentScanNum = iCurDirtyParentScanNum;
    }

    public void addDirtyParentScan(Integer iParentScan) {
        if (!this.dirtyParentScans.contains(iParentScan)) {
            this.dirtyParentScans.add(iParentScan);
        }
    }

    public void clearDirtyParentScans() {
        this.dirtyParentScans.clear();
    }

    protected int addUnrecognizedHeaders(MassSpecViewerPreference _preference) {
        int iColCnt = 0;
        if (this.fillType != FillTypes.Scans) {
            if (this.getGRITSdata().getDataHeader().getFeatureCustomExtraData() != null) {
                iColCnt += MSAnnotationTableDataProcessorUtil.fillColumnSettingsCustomExtraData(_preference.getPreferenceSettings(), this.getGRITSdata().getDataHeader().getFeatureCustomExtraData(), _preference.getPreferenceSettings().getUnrecognizedHeaders());
            }
            if (this.getGRITSdata().getDataHeader().getAnnotationCustomExtraData() != null) {
                iColCnt += MSAnnotationTableDataProcessorUtil.fillColumnSettingsCustomExtraData(_preference.getPreferenceSettings(), this.getGRITSdata().getDataHeader().getAnnotationCustomExtraData(), _preference.getPreferenceSettings().getUnrecognizedHeaders());
            }
        }
        iColCnt = this.getGRITSdata().getDataHeader().getPeakCustomExtraData() != null && !this.getGRITSdata().getDataHeader().getPeakCustomExtraData().isEmpty() ? (iColCnt += MSAnnotationTableDataProcessorUtil.fillColumnSettingsCustomExtraData(_preference.getPreferenceSettings(), this.getGRITSdata().getDataHeader().getPeakCustomExtraData(), _preference.getPreferenceSettings().getUnrecognizedHeaders())) : (iColCnt += super.addUnrecognizedHeaders(_preference));
        return iColCnt;
    }

    public void initializeTableDataObject(Property _sourceProperty) {
        this.setSimianTableDataObject((MassSpecTableDataObject)new MSAnnotationTableDataObject(((MassSpecEntityProperty)_sourceProperty).getMsLevel().intValue(), this.fillType));
        this.getSimianTableDataObject().initializePreferences();
        if (this.getSimianTableDataObject().getTablePreferences().settingsNeedInitialization()) {
            TableViewerPreference tvp = this.initializePreferences();
            MSAnnotationTableDataProcessor.setDefaultColumnViewSettings(this.fillType, tvp.getPreferenceSettings());
            this.getSimianTableDataObject().setTablePreferences(tvp);
            this.getSimianTableDataObject().getTablePreferences().writePreference();
        }
    }

    protected MSAnnotationEntityProperty getMSAnnotationEntityProperty() {
        if (this.sourceProperty instanceof MSAnnotationEntityProperty) {
            return (MSAnnotationEntityProperty)this.sourceProperty;
        }
        return null;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Data getGRITSdata() {
        return (Data)this.data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    protected void addScansTableData() {
        int iCnt = 1;
        for (Integer iScan : this.getGRITSdata().getScans().keySet()) {
            Scan msScan = (Scan)this.getGRITSdata().getScans().get(iScan);
            if (iCnt % 100 == 0) {
                this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Building scans table. Scan: " + iCnt + " of " + this.getScanData().size());
                this.progressBarDialog.getMinorProgressBarListener(0).setProgressValue(iCnt);
            }
            ++iCnt;
            this.addScanRow(msScan);
            if (!this.bCancel) continue;
            this.setSimianTableDataObject(null);
            return;
        }
    }

    public boolean saveChanges() throws Exception {
        try {
            this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Updating data...");
            this.progressBarDialog.getMinorProgressBarListener(0).setProgressValue(0);
            this.progressBarDialog.getMinorProgressBarListener(0).setMaxValue(this.dirtyParentScans.size());
            this.xmlWriter = new AnnotationWriter();
            int i = 0;
            while (i < this.dirtyParentScans.size()) {
                Integer iParentScan = this.dirtyParentScans.get(i);
                this.setCurDirtyParentScanNum(iParentScan);
                this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Updating scan: " + iParentScan);
                this.updateAnnotationDataSingleScan(iParentScan);
                this.progressBarDialog.getMinorProgressBarListener(0).setProgressValue(i + 1);
                ++i;
            }
            this.clearDirtyParentScans();
        }
        catch (Exception e) {
            this.clearDirtyParentScans();
            throw new Exception("Unable to write XML File", e);
        }
        return true;
    }

    public static final List<CustomExtraData> getMSAnnotationFeatureCustomExtraData(Entry _entry) {
        try {
            Property property = _entry.getProperty();
            if (property instanceof MSAnnotationEntityProperty) {
                property = ((MSAnnotationEntityProperty)property).getMSAnnotationParentProperty();
            }
            String origFile = ((MSAnnotationProperty)property).getFullyQualifiedArchiveFileNameByAnnotationID(_entry);
            DataHeader dHeader = null;
            AnnotationReader xmlReader = new AnnotationReader();
            dHeader = xmlReader.readDataHeader(origFile);
            return dHeader.getFeatureCustomExtraData();
        }
        catch (Exception e) {
            logger.error((Object)("Unable to read data file for entry: " + _entry), (Throwable)e);
            return null;
        }
    }

    public String getArchiveFile() {
        if (this.entry == null) {
            return null;
        }
        String sArchiveFile = null;
        if (this.getEntry().getProperty() instanceof MSAnnotationEntityProperty) {
            MSAnnotationEntityProperty msAnnotEntityProp = (MSAnnotationEntityProperty)this.getEntry().getProperty();
            MSAnnotationProperty msAnnotProp = (MSAnnotationProperty)msAnnotEntityProp.getParentProperty();
            if (this.getMethod() != null && this.getMethod().getMsType().equals("LC-MS/MS")) {
                MSAnnotationEntityProperty curMSAnnotEntityProp = this.getCurEntityProperty();
                if (msAnnotEntityProp != null && msAnnotEntityProp.getParentScanNum() == null && this.getCurDirtyParentScanNum() != null) {
                    sArchiveFile = msAnnotProp.getFullyQualifiedArchiveFileNameByScanNum(this.getEntry(), this.getCurDirtyParentScanNum());
                } else if (curMSAnnotEntityProp != null && curMSAnnotEntityProp.getScanNum() != null && curMSAnnotEntityProp.getParentScanNum() != null) {
                    sArchiveFile = msAnnotProp.getFullyQualifiedArchiveFileNameByScanNum(this.getEntry(), curMSAnnotEntityProp.getParentScanNum());
                } else if (msAnnotEntityProp.getScanNum() > 0) {
                    sArchiveFile = msAnnotProp.getFullyQualifiedArchiveFileNameByScanNum(this.getEntry(), msAnnotEntityProp.getScanNum());
                }
            } else {
                sArchiveFile = msAnnotProp.getFullyQualifiedArchiveFileNameByAnnotationID(this.getEntry());
            }
        }
        if (sArchiveFile == null) {
            logger.error((Object)"Unable to determine archive file name!");
        }
        return sArchiveFile;
    }

    protected Map<Integer, Scan> getScanData() {
        return ((Data)this.data).getScans();
    }

    protected boolean isLCMSAndNeedsScanSet() {
        MSAnnotationEntityProperty msAnnotEntityProp = (MSAnnotationEntityProperty)this.getSourceProperty();
        MassSpecProperty msProp = msAnnotEntityProp.getMassSpecParentProperty();
        if (!msProp.getMassSpecMetaData().getMsExperimentType().equals("LC-MS/MS")) {
            return false;
        }
        return msAnnotEntityProp.getMsLevel() <= 2;
    }

    protected void setScanNumber(Integer iScanNum) {
        MSAnnotationEntityProperty msAnnotEntityProp = (MSAnnotationEntityProperty)this.getEntry().getProperty();
        msAnnotEntityProp.setScanNum(iScanNum);
    }

    public boolean readDataFromFile() {
        this.progressBarDialog.getMinorProgressBarListener(0).setProgressType(IProgressListener.ProgressType.Indeterminant);
        this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Reading data file...");
        try {
            this.xmlReader = new AnnotationReader();
            String sSourceFile = this.getArchiveFile();
            logger.debug((Object)("Reading archive: " + sSourceFile));
            this.data = this.xmlReader.readDataWithoutFeatures(sSourceFile);
            this.method = this.getGRITSdata().getDataHeader().getMethod();
        }
        catch (Exception e) {
            logger.error((Object)"readDataFromFile: unable to read mzXML.", (Throwable)e);
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    protected ExternalQuantAlias getExternalQuantAlias(MSPropertyDataFile quantFile) {
        MSAnnotationProperty msap = this.getMSAnnotationEntityProperty().getMSAnnotationParentProperty();
        String sExtQuantType = MassSpecUISettings.getExternalQuantType((MSPropertyDataFile)quantFile);
        ExternalQuantFileToAlias mAliases = msap.getMSAnnotationMetaData().getExternalQuantToAliasByQuantType(sExtQuantType);
        ExternalQuantAlias foundAlias = null;
        if (mAliases != null) {
            for (String sFileName : mAliases.getSourceDataFileNameToAlias().keySet()) {
                ExternalQuantAlias aliasInfo = (ExternalQuantAlias)mAliases.getSourceDataFileNameToAlias().get(sFileName);
                if (aliasInfo == null || !sFileName.equals(quantFile.getName())) continue;
                foundAlias = aliasInfo;
            }
        }
        return foundAlias;
    }

    protected List<MassSpecCustomAnnotation> getCustomAnnotationList() {
        MSAnnotationProperty msap = this.getMSAnnotationEntityProperty().getMSAnnotationParentProperty();
        if (msap.getMSAnnotationMetaData() != null && msap.getMSAnnotationMetaData().getCustomAnnotations() != null && !msap.getMSAnnotationMetaData().getCustomAnnotations().isEmpty()) {
            return msap.getMSAnnotationMetaData().getCustomAnnotations();
        }
        return null;
    }

    protected void initializeQuantFiles() {
        super.initializeQuantFiles();
    }

    public void setCurEntityProperty(MSAnnotationEntityProperty msProp) {
        this.msProp = msProp;
    }

    protected MSAnnotationEntityProperty getCurEntityProperty() {
        return this.msProp;
    }

    protected ScanFeatures loadScanFeatureFromXML(int _iKey) {
        try {
            String sSourceFile;
            ScanFeatures features;
            if (this.xmlReader == null) {
                this.xmlReader = new AnnotationReader();
            }
            if ((features = this.xmlReader.readScanAnnotation(sSourceFile = this.getArchiveFile(), _iKey)) != null && features.getComplexRowId() != null && features.getComplexRowId().booleanValue()) {
                ScanFeatures.usesComplexRowID = true;
            }
            this.setFeatureParentAnnotations(features);
            return features;
        }
        catch (Exception ex) {
            logger.error((Object)"Error loading scan feature from xml.", (Throwable)ex);
            return null;
        }
    }

    private void setFeatureParentAnnotations(ScanFeatures scanFeatures) {
        if (scanFeatures != null && scanFeatures.getFeatures() != null && !scanFeatures.getFeatures().isEmpty()) {
            for (Feature feature : scanFeatures.getFeatures()) {
                if (feature.getParentAnnotation() != null || feature.getAnnotationId() == null) continue;
                Annotation parentAnnotation = AnnotationRowExtraction.getAnnotation((Data)this.getGRITSdata(), (Integer)feature.getAnnotationId());
                feature.setParentAnnotation(parentAnnotation);
            }
        }
    }

    private void verifyFeatureUsesRowIds(ScanFeatures scanFeatures) {
        if (scanFeatures != null && scanFeatures.getFeatures() != null && !scanFeatures.getFeatures().isEmpty()) {
            for (Feature feature : scanFeatures.getFeatures()) {
                if (!feature.getPeaks().isEmpty() || feature.getPeaks().size() <= 1) continue;
                logger.debug((Object)"Got peaks!");
            }
        }
    }

    public static void setDefaultColumnViewSettings(FillTypes fillType, TableViewerColumnSettings tvs) {
        MassSpecTableDataProcessor.setDefaultColumnViewSettings((FillTypes)fillType, (TableViewerColumnSettings)tvs);
        if (fillType == FillTypes.PeaksWithFeatures) {
            GRITSColumnHeader header = tvs.getColumnHeader(DMAnnotation.annotation_id.name());
            if (header != null) {
                tvs.setVisColInx(header, Integer.valueOf(-1));
            }
            if ((header = tvs.getColumnHeader(DMAnnotation.annotation_sequence.name())) != null) {
                tvs.setVisColInx(header, Integer.valueOf(-1));
            }
            if ((header = tvs.getColumnHeader(DMAnnotation.annotation_num_candidates.name())) != null) {
                tvs.setVisColInx(header, Integer.valueOf(-1));
            }
            if ((header = tvs.getColumnHeader(DMFeature.feature_id.name())) != null) {
                tvs.setVisColInx(header, Integer.valueOf(-1));
            }
            if ((header = tvs.getColumnHeader(DMFeature.feature_sequence.name())) != null) {
                tvs.setVisColInx(header, Integer.valueOf(-1));
            }
            if ((header = tvs.getColumnHeader(DMFeature.feature_precursor_id.name())) != null) {
                tvs.setVisColInx(header, Integer.valueOf(-1));
            }
            if ((header = tvs.getColumnHeader(DMPeak.peak_id.name())) != null) {
                tvs.setVisColInx(header, Integer.valueOf(-1));
            }
        }
    }

    protected TableViewerPreference getNewTableViewerPreferences() {
        return new MSAnnotationViewerPreference();
    }

    protected TableViewerColumnSettings initializeColumnSettings() {
        TableViewerColumnSettings newSettings = super.initializeColumnSettings();
        MSAnnotationTableDataProcessorUtil.fillMassSpecColumnSettingsScan(newSettings, this.getMassSpecEntityProperty().getMsLevel());
        if (this.fillType == FillTypes.PeaksWithFeatures) {
            this.addAnnotationColumns(newSettings);
            this.addFeatureColumns(newSettings);
        }
        return newSettings;
    }

    public TableViewerPreference initializePreferences() {
        MSAnnotationViewerPreference newPreferences = (MSAnnotationViewerPreference)super.initializePreferences();
        MSAnnotationViewerPreference oldPreferences = (MSAnnotationViewerPreference)this.getSimianTableDataObject().getTablePreferences();
        if (oldPreferences != null) {
            newPreferences.setHideUnannotatedPeaks(oldPreferences.isHideUnannotatedPeaks());
        }
        return newPreferences;
    }

    protected List<CustomExtraData> getCurrentListOfCustomExtraData(String sExtQuantFileName) {
        ArrayList<CustomExtraData> lNewCED = new ArrayList<CustomExtraData>();
        List lCurCED = this.getGRITSdata().getDataHeader().getPeakCustomExtraData();
        for (CustomExtraData ced : lCurCED) {
            if (!ced.getDescription().equals(sExtQuantFileName)) continue;
            lNewCED.add(ced);
        }
        return lNewCED;
    }

    protected boolean loadSubScanExternalQuant(QuantFileProcessor _processor, Scan msScan) {
        int iScanNum = msScan.getScanNo();
        ((CustomAnnotationDataProcessor)_processor).setCurScan(msScan);
        _processor.loadExternalData();
        _processor.getQuantPeakData().setScanNo(iScanNum);
        _processor.getSettings().setTargetScanNumber(Integer.valueOf(iScanNum));
        _processor.setSourcePeakList(this.getScanData());
        boolean bUpdated = _processor.matchExternalPeaks(false);
        return bUpdated;
    }

    protected boolean processExternalQuant() {
        return this.processExternalQuant(false);
    }

    protected boolean processExternalQuant(boolean _bForceWrite) {
        if (this.quantFileProcessors == null) {
            return false;
        }
        boolean bLoaded = false;
        try {
            bLoaded = super.processExternalQuant();
        }
        catch (Exception e) {
            logger.error((Object)"processExternalQuant: error processing external quant.", (Throwable)e);
        }
        try {
            if (bLoaded || _bForceWrite) {
                this.writeArchive();
            }
        }
        catch (Exception e) {
            logger.error((Object)"processExternalQuant: error writing external quant to archive.", (Throwable)e);
        }
        return bLoaded;
    }

    public void writeArchive() {
        AnnotationWriter xmlWriter = new AnnotationWriter();
        String sSourceFile = this.getArchiveFile();
        xmlWriter.writeDataToZip(this.getGRITSdata(), sSourceFile);
        xmlWriter.writeDataHeaderToArchive(this.getGRITSdata().getDataHeader(), sSourceFile);
    }

    public void buildTable() throws Exception {
        this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Building table...");
        int iMax = this.getGRITSdata().getScans().size();
        this.progressBarDialog.getMinorProgressBarListener(0).setMaxValue(iMax);
        this.getMySimianTableDataObject().setUnAnnotatedRows(new ArrayList());
        ArrayList alHeader = new ArrayList();
        try {
            this.addHeaderLine(alHeader);
        }
        catch (Exception e) {
            throw new Exception("Unable to build table", e);
        }
        this.getSimianTableDataObject().getTableHeader().add(alHeader);
        this.processExternalQuant();
        if (this.fillType == FillTypes.Scans) {
            this.addScansTableData();
        } else if (this.fillType == FillTypes.PeakList) {
            this.addPeaksTableData();
        } else if (this.fillType == FillTypes.PeaksWithFeatures) {
            this.addPeaksTableData();
        }
        if (!this.bCancel && this.getSimianTableDataObject().getTableData().isEmpty()) {
            this.getSimianTableDataObject().getTableData().add(TableDataProcessor.getNewRow((int)this.getSimianTableDataObject().getLastHeader().size(), (int)this.getSimianTableDataObject().getTableData().size()));
            this.getSimianTableDataObject().getTableData().add(TableDataProcessor.getNewRow((int)this.getSimianTableDataObject().getLastHeader().size(), (int)this.getSimianTableDataObject().getTableData().size()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean loadSubScanExternalQuant(QuantFileProcessor _processor) {
        Collection annotatedPeaks;
        MassSpecCustomAnnotation msca;
        DataHeader dHeader;
        boolean bLoaded;
        block7: {
            bLoaded = super.loadSubScanExternalQuant(_processor);
            dHeader = this.getGRITSdata().getDataHeader();
            if (!(_processor instanceof CustomAnnotationDataProcessor)) throw new Exception("Processor type not supported: " + _processor.getClass());
            msca = ((CustomAnnotationDataProcessor)_processor).getMassSpecCustomAnnotation();
            annotatedPeaks = msca.getAnnotatedPeaks().values();
            if (annotatedPeaks != null && !annotatedPeaks.isEmpty()) break block7;
            return false;
        }
        try {
            for (MassSpecCustomAnnotationPeak mscap : annotatedPeaks) {
                Double dMz = mscap.getPeakMz();
                String sKey = dMz.toString();
                String sLabel = dMz.toString();
                if (msca.getAnnotatedPeaks().containsKey(dMz)) {
                    sLabel = String.valueOf(sKey) + " - " + ((MassSpecCustomAnnotationPeak)msca.getAnnotatedPeaks().get(dMz)).getPeakLabel();
                }
                CustomExtraData cedInt = ExternalQuantColumnInfo.getExternalQuantIntensity((String)sKey, (String)sLabel);
                cedInt.setDescription(msca.getAnnotationName());
                CustomExtraData cedIntMz = ExternalQuantColumnInfo.getExternalQuantIntensityMz((String)sKey, (String)sLabel);
                cedIntMz.setDescription(msca.getAnnotationName());
                if (!dHeader.getPeakCustomExtraData().contains(cedIntMz)) {
                    dHeader.getPeakCustomExtraData().add(cedIntMz);
                    bLoaded = true;
                }
                if (dHeader.getPeakCustomExtraData().contains(cedInt)) continue;
                dHeader.getPeakCustomExtraData().add(cedInt);
                bLoaded = true;
            }
            return bLoaded;
        }
        catch (IOException e) {
            logger.error((Object)"loadExternalQuantData: error writing Data Header with external quant changes.", (Throwable)e);
            return bLoaded;
        }
        catch (Exception e) {
            logger.error((Object)"loadExternalQuantData: error writing Data Header with external quant changes.", (Throwable)e);
        }
        return bLoaded;
    }

    protected void setQuantFiles(List<QuantFileProcessor> lQuantFileProcessors) {
        if (this.quantFileProcessors != null && !this.quantFileProcessors.isEmpty()) {
            ArrayList<QuantFileProcessor> toRemove = new ArrayList<QuantFileProcessor>();
            for (QuantFileProcessor curQuantFileProcessor : this.quantFileProcessors) {
                if (curQuantFileProcessor instanceof CustomAnnotationDataProcessor) continue;
                String sCurKeyID = curQuantFileProcessor.getKeyID();
                boolean bFound = false;
                for (QuantFileProcessor newQuantFileProcessor : lQuantFileProcessors) {
                    String sNewKeyID;
                    if (newQuantFileProcessor instanceof CustomAnnotationDataProcessor || !newQuantFileProcessor.getClass().equals(curQuantFileProcessor.getClass()) || !sCurKeyID.equals(sNewKeyID = newQuantFileProcessor.getKeyID())) continue;
                    bFound = true;
                    break;
                }
                if (bFound) continue;
                toRemove.add(curQuantFileProcessor);
            }
            if (!toRemove.isEmpty()) {
                this.quantFileProcessorsToRemove = toRemove;
                for (QuantFileProcessor oldQuantFileProcessor : this.quantFileProcessorsToRemove) {
                    this.removePrecursorExternalQuantHeaderData(oldQuantFileProcessor);
                    this.removePrecursorExternalQuantPeakData(oldQuantFileProcessor);
                }
                this.writeArchive();
            }
        }
        super.setQuantFiles(lQuantFileProcessors);
    }

    protected boolean removePrecursorExternalQuantHeaderData(StandardQuantDataProcessor sqdp) {
        boolean bRemoved = false;
        try {
            DataHeader dHeader = this.getGRITSdata().getDataHeader();
            for (Peak peak : sqdp.getSourcePeakListToMatch()) {
                Double dMz = peak.getMz();
                String sKey = String.valueOf(sqdp.getKeyID()) + "-" + dMz.toString();
                String sLabel = dMz.toString();
                if (sqdp.getLabelAlias() != null && !sqdp.getLabelAlias().equals("")) {
                    sLabel = String.valueOf(sqdp.getLabelAlias()) + "-" + dMz.toString();
                }
                CustomExtraData cedInt = ExternalQuantColumnInfo.getExternalQuantIntensity((String)sKey, (String)sLabel);
                CustomExtraData cedTotalInt = ExternalQuantColumnInfo.getExternalQuantDeconvolutedIntensity((String)sKey, (String)sLabel);
                CustomExtraData cedIntMz = ExternalQuantColumnInfo.getExternalQuantIntensityMz((String)sKey, (String)sLabel);
                if (dHeader.getPeakCustomExtraData().contains(cedIntMz)) {
                    dHeader.getPeakCustomExtraData().remove(cedIntMz);
                    bRemoved = true;
                }
                if (dHeader.getPeakCustomExtraData().contains(cedInt)) {
                    dHeader.getPeakCustomExtraData().remove(cedInt);
                    bRemoved = true;
                }
                if (dHeader.getPeakCustomExtraData().contains(cedTotalInt)) {
                    dHeader.getPeakCustomExtraData().remove(cedTotalInt);
                    bRemoved = true;
                }
                CustomExtraData cedCorInt = ExternalQuantColumnInfo.getExternalQuantCorrectedIntensity((String)sKey, (String)sLabel);
                if (dHeader.getPeakCustomExtraData().contains(cedCorInt)) {
                    dHeader.getPeakCustomExtraData().remove(cedCorInt);
                    bRemoved = true;
                }
                CustomExtraData cedQuantRelInt = StandardQuantColumnInfo.getStandardQuantRelativeIntensity((String)sKey, (String)sKey);
                if (dHeader.getPeakCustomExtraData().contains(cedQuantRelInt)) {
                    dHeader.getPeakCustomExtraData().remove(cedQuantRelInt);
                    bRemoved = true;
                }
                CustomExtraData cedFileName = ExternalQuantSettings.getExternalQuantFileName((String)sKey, (String)sLabel);
                CustomExtraData cedTolerance = ExternalQuantSettings.getExternalQuantMatchingTolerance((String)sKey, (String)sLabel);
                CustomExtraData cedScanNumber = ExternalQuantSettings.getExternalQuantScanNumber((String)sKey, (String)sLabel);
                CustomExtraData cedUsePPM = ExternalQuantSettings.getExternalQuantUsePPM((String)sKey, (String)sLabel);
                if (dHeader.getStringProp().containsKey(cedFileName.getKey())) {
                    dHeader.getStringProp().remove(cedFileName.getKey());
                    bRemoved = true;
                }
                if (dHeader.getDoubleProp().containsKey(cedTolerance.getKey())) {
                    dHeader.getDoubleProp().remove(cedTolerance.getKey());
                    bRemoved = true;
                }
                if (dHeader.getIntegerProp().containsKey(cedScanNumber.getKey())) {
                    dHeader.getIntegerProp().remove(cedScanNumber.getKey());
                    bRemoved = true;
                }
                if (!dHeader.getBooleanProp().containsKey(cedUsePPM.getKey())) continue;
                dHeader.getBooleanProp().remove(cedUsePPM.getKey());
                bRemoved = true;
            }
        }
        catch (Exception exception) {
            logger.error((Object)"removePrecursorExternalQuantHeaderData: error removing external quant data from DataHeader.");
        }
        return bRemoved;
    }

    protected boolean removePrecursorExternalQuantHeaderData(QuantFileProcessor _processor) {
        boolean bRemoved = false;
        try {
            DataHeader dHeader = this.getGRITSdata().getDataHeader();
            String sKey = null;
            String sLabel = null;
            if (_processor instanceof ExtractDataProcessor) {
                sKey = QuantFileProcessor.getExternalQuantProcessorKey((String)_processor.getKeyID(), (String)"extract");
                sLabel = QuantFileProcessor.getExternalQuantProcessorLabel((String)_processor.getLabelAlias(), (String)"Extract");
            } else if (_processor instanceof FullMzXMLDataProcessor) {
                sKey = QuantFileProcessor.getExternalQuantProcessorKey((String)_processor.getKeyID(), (String)"full_ms");
                sLabel = QuantFileProcessor.getExternalQuantProcessorLabel((String)_processor.getLabelAlias(), (String)"Full MS");
            } else {
                if (_processor instanceof StandardQuantDataProcessor) {
                    return this.removePrecursorExternalQuantHeaderData((StandardQuantDataProcessor)_processor);
                }
                throw new Exception("Processor type not supported: " + _processor.getClass());
            }
            CustomExtraData cedFileName = ExternalQuantSettings.getExternalQuantFileName((String)sKey, (String)sLabel);
            CustomExtraData cedTolerance = ExternalQuantSettings.getExternalQuantMatchingTolerance((String)sKey, (String)sLabel);
            CustomExtraData cedScanNumber = ExternalQuantSettings.getExternalQuantScanNumber((String)sKey, (String)sLabel);
            CustomExtraData cedUsePPM = ExternalQuantSettings.getExternalQuantUsePPM((String)sKey, (String)sLabel);
            if (dHeader.getStringProp().containsKey(cedFileName.getKey())) {
                dHeader.getStringProp().remove(cedFileName.getKey());
                bRemoved = true;
            }
            if (dHeader.getDoubleProp().containsKey(cedTolerance.getKey())) {
                dHeader.getDoubleProp().remove(cedTolerance.getKey());
                bRemoved = true;
            }
            if (dHeader.getIntegerProp().containsKey(cedScanNumber.getKey())) {
                dHeader.getIntegerProp().remove(cedScanNumber.getKey());
                bRemoved = true;
            }
            if (dHeader.getBooleanProp().containsKey(cedUsePPM.getKey())) {
                dHeader.getBooleanProp().remove(cedUsePPM.getKey());
                bRemoved = true;
            }
            CustomExtraData cedInt = ExternalQuantColumnInfo.getExternalQuantIntensity((String)sKey, (String)sLabel);
            CustomExtraData cedTotalInt = ExternalQuantColumnInfo.getExternalQuantDeconvolutedIntensity((String)sKey, (String)sLabel);
            CustomExtraData cedIntMz = ExternalQuantColumnInfo.getExternalQuantIntensityMz((String)sKey, (String)sLabel);
            CustomExtraData cedCharge = ExternalQuantColumnInfo.getExternalQuantCharge((String)sKey, (String)sLabel);
            CustomExtraData cedCorrected = ExternalQuantColumnInfo.getExternalQuantCorrectedIntensity((String)sKey, (String)sLabel);
            if (dHeader.getPeakCustomExtraData().contains(cedIntMz)) {
                dHeader.getPeakCustomExtraData().remove(cedIntMz);
                bRemoved = true;
            }
            if (dHeader.getPeakCustomExtraData().contains(cedInt)) {
                dHeader.getPeakCustomExtraData().remove(cedInt);
                bRemoved = true;
            }
            if (dHeader.getPeakCustomExtraData().contains(cedTotalInt)) {
                dHeader.getPeakCustomExtraData().remove(cedTotalInt);
                bRemoved = true;
            }
            if (dHeader.getPeakCustomExtraData().contains(cedCharge)) {
                dHeader.getPeakCustomExtraData().remove(cedCharge);
                bRemoved = true;
            }
            if (dHeader.getPeakCustomExtraData().contains(cedCorrected)) {
                dHeader.getPeakCustomExtraData().remove(cedCorrected);
                bRemoved = true;
            }
            CustomExtraData cedCorInt = CorrectedQuantColumnInfo.getCorrectedQuantIntensity((String)DMPrecursorPeak.precursor_peak_intensity.name(), (String)DMPrecursorPeak.precursor_peak_intensity.getLabel());
            if (dHeader.getPeakCustomExtraData().contains(cedCorInt)) {
                dHeader.getPeakCustomExtraData().remove(cedCorInt);
                bRemoved = true;
            }
            cedCorInt = CorrectedQuantColumnInfo.getCorrectedQuantIntensity((String)DMPeak.peak_id.name(), (String)DMPeak.peak_id.getLabel());
            if (dHeader.getPeakCustomExtraData().contains(cedCorInt)) {
                dHeader.getPeakCustomExtraData().remove(cedCorInt);
                bRemoved = true;
            }
        }
        catch (Exception exception) {
            logger.error((Object)"removePrecursorExternalQuantHeaderData: error removing external quant data from DataHeader.");
        }
        return bRemoved;
    }

    protected void removePrecursorExternalQuantPeakData(QuantFileProcessor _processor) {
        int iParentScanNum = -1;
        if (this.getMassSpecEntityProperty().getParentScanNum() != null) {
            iParentScanNum = this.getMassSpecEntityProperty().getParentScanNum();
        }
        if (iParentScanNum != -1) {
            super.loadPrecursorExternalQuantData(iParentScanNum, _processor, true);
        }
    }

    protected boolean loadPrecursorExternalQuantHeaderData(QuantFileProcessor _processor, String sKey, String sLabel) {
        boolean bLoaded;
        block40: {
            bLoaded = false;
            try {
                DataHeader dHeader = this.getGRITSdata().getDataHeader();
                CustomExtraData cedFileName = ExternalQuantSettings.getExternalQuantFileName((String)sKey, (String)sLabel);
                CustomExtraData cedInt = ExternalQuantColumnInfo.getExternalQuantIntensity((String)sKey, (String)sLabel);
                CustomExtraData cedTotalInt = ExternalQuantColumnInfo.getExternalQuantDeconvolutedIntensity((String)sKey, (String)sLabel);
                CustomExtraData cedIntMz = ExternalQuantColumnInfo.getExternalQuantIntensityMz((String)sKey, (String)sLabel);
                CustomExtraData cedCharge = ExternalQuantColumnInfo.getExternalQuantCharge((String)sKey, (String)sLabel);
                CustomExtraData cedTolerance = ExternalQuantSettings.getExternalQuantMatchingTolerance((String)sKey, (String)sLabel);
                CustomExtraData cedScanNumber = ExternalQuantSettings.getExternalQuantScanNumber((String)sKey, (String)sLabel);
                CustomExtraData cedUsePPM = ExternalQuantSettings.getExternalQuantUsePPM((String)sKey, (String)sLabel);
                if (!dHeader.getStringProp().containsKey(cedFileName.getKey())) {
                    dHeader.getStringProp().put(cedFileName.getKey(), sKey);
                    bLoaded = true;
                }
                if (!dHeader.getDoubleProp().containsKey(cedTolerance.getKey())) {
                    dHeader.addDoubleProp(cedTolerance.getKey(), _processor.getSettings().getIntensityCorrectionValue());
                    bLoaded = true;
                }
                if (!dHeader.getIntegerProp().containsKey(cedScanNumber.getKey())) {
                    dHeader.addIntegerProp(cedScanNumber.getKey(), _processor.getSettings().getTargetScanNumber());
                    bLoaded = true;
                }
                if (!dHeader.getBooleanProp().containsKey(cedUsePPM.getKey())) {
                    dHeader.addbooleanProp(cedUsePPM.getKey(), Boolean.valueOf(_processor.getSettings().isIntensityCorrectionPpm()));
                    bLoaded = true;
                }
                boolean bRemove = false;
                for (CustomExtraData ced : dHeader.getPeakCustomExtraData()) {
                    if (!ced.getKey().equals(cedIntMz.getKey()) || ced.getLabel().equals(cedIntMz.getLabel())) continue;
                    bRemove = true;
                }
                if (bRemove) {
                    dHeader.getPeakCustomExtraData().remove(cedIntMz);
                }
                if (!dHeader.getPeakCustomExtraData().contains(cedIntMz)) {
                    dHeader.getPeakCustomExtraData().add(cedIntMz);
                    bLoaded = true;
                }
                bRemove = false;
                for (CustomExtraData ced : dHeader.getPeakCustomExtraData()) {
                    if (!ced.getKey().equals(cedInt.getKey()) || ced.getLabel().equals(cedInt.getLabel())) continue;
                    bRemove = true;
                }
                if (bRemove) {
                    dHeader.getPeakCustomExtraData().remove(cedInt);
                }
                if (!dHeader.getPeakCustomExtraData().contains(cedInt)) {
                    dHeader.getPeakCustomExtraData().add(cedInt);
                    bLoaded = true;
                }
                bRemove = false;
                for (CustomExtraData ced : dHeader.getPeakCustomExtraData()) {
                    if (!ced.getKey().equals(cedTotalInt.getKey()) || ced.getLabel().equals(cedTotalInt.getLabel())) continue;
                    bRemove = true;
                }
                if (bRemove) {
                    dHeader.getPeakCustomExtraData().remove(cedTotalInt);
                }
                if (!dHeader.getPeakCustomExtraData().contains(cedTotalInt)) {
                    dHeader.getPeakCustomExtraData().add(cedTotalInt);
                    bLoaded = true;
                }
                boolean bFound = false;
                if (this.getSimianTableDataObject().getLastHeader() != null) {
                    CustomExtraData cedCorInt = CorrectedQuantColumnInfo.getCorrectedQuantIntensity((String)DMPrecursorPeak.precursor_peak_intensity.name(), (String)DMPrecursorPeak.precursor_peak_intensity.getLabel());
                    for (GRITSColumnHeader gritsHeader : this.getSimianTableDataObject().getLastHeader()) {
                        if (!gritsHeader.getKeyValue().equals(cedCorInt.getKey())) continue;
                        bFound = true;
                    }
                    if (bFound) {
                        bRemove = false;
                        for (CustomExtraData ced : dHeader.getPeakCustomExtraData()) {
                            if (!ced.getKey().equals(cedCorInt.getKey()) || ced.getLabel().equals(cedCorInt.getLabel())) continue;
                            bRemove = true;
                        }
                        if (bRemove) {
                            dHeader.getPeakCustomExtraData().remove(cedCorInt);
                        }
                        if (!dHeader.getPeakCustomExtraData().contains(cedCorInt)) {
                            dHeader.getPeakCustomExtraData().add(cedCorInt);
                            bLoaded = true;
                        }
                    }
                    bFound = false;
                    cedCorInt = CorrectedQuantColumnInfo.getCorrectedQuantIntensity((String)DMPeak.peak_id.name(), (String)DMPeak.peak_id.getLabel());
                    for (GRITSColumnHeader gritsHeader : this.getSimianTableDataObject().getLastHeader()) {
                        if (!gritsHeader.getKeyValue().equals(cedCorInt.getKey())) continue;
                        bFound = true;
                    }
                    if (bFound) {
                        bRemove = false;
                        for (CustomExtraData ced : dHeader.getPeakCustomExtraData()) {
                            if (!ced.getKey().equals(cedCorInt.getKey()) || ced.getLabel().equals(cedCorInt.getLabel())) continue;
                            bRemove = true;
                        }
                        if (bRemove) {
                            dHeader.getPeakCustomExtraData().remove(cedCorInt);
                        }
                        if (!dHeader.getPeakCustomExtraData().contains(cedCorInt)) {
                            dHeader.getPeakCustomExtraData().add(cedCorInt);
                            bLoaded = true;
                        }
                    }
                    bFound = false;
                    cedCorInt = ExternalQuantColumnInfo.getExternalQuantCorrectedIntensity((String)sKey, (String)sLabel);
                    for (GRITSColumnHeader gritsHeader : this.getSimianTableDataObject().getLastHeader()) {
                        if (!gritsHeader.getKeyValue().equals(cedCorInt.getKey())) continue;
                        bFound = true;
                    }
                    if (bFound) {
                        bRemove = false;
                        for (CustomExtraData ced : dHeader.getPeakCustomExtraData()) {
                            if (!ced.getKey().equals(cedCorInt.getKey()) || ced.getLabel().equals(cedCorInt.getLabel())) continue;
                            bRemove = true;
                        }
                        if (bRemove) {
                            dHeader.getPeakCustomExtraData().remove(cedCorInt);
                        }
                        if (!dHeader.getPeakCustomExtraData().contains(cedCorInt)) {
                            dHeader.getPeakCustomExtraData().add(cedCorInt);
                            bLoaded = true;
                        }
                    }
                }
                if (_processor instanceof ExtractDataProcessor) {
                    bRemove = false;
                    for (CustomExtraData ced : dHeader.getPeakCustomExtraData()) {
                        if (!ced.getKey().equals(cedCharge.getKey()) || ced.getLabel().equals(cedCharge.getLabel())) continue;
                        bRemove = true;
                    }
                    if (bRemove) {
                        dHeader.getPeakCustomExtraData().remove(cedCharge);
                    }
                    if (!dHeader.getPeakCustomExtraData().contains(cedCharge)) {
                        dHeader.getPeakCustomExtraData().add(cedCharge);
                        bLoaded = true;
                    }
                    break block40;
                }
                if (_processor instanceof FullMzXMLDataProcessor) break block40;
                if (_processor instanceof StandardQuantDataProcessor) {
                    CustomExtraData cedRelInt = StandardQuantColumnInfo.getStandardQuantRelativeIntensity((String)sKey, (String)sLabel);
                    bRemove = false;
                    for (CustomExtraData ced : dHeader.getPeakCustomExtraData()) {
                        if (!ced.getKey().equals(cedRelInt.getKey()) || ced.getLabel().equals(cedRelInt.getLabel())) continue;
                        bRemove = true;
                    }
                    if (bRemove) {
                        dHeader.getPeakCustomExtraData().remove(cedRelInt);
                    }
                    if (!dHeader.getPeakCustomExtraData().contains(cedRelInt)) {
                        dHeader.getPeakCustomExtraData().add(cedRelInt);
                        bLoaded = true;
                    }
                    break block40;
                }
                throw new Exception("Processor type not supported: " + _processor.getClass());
            }
            catch (IOException e) {
                logger.error((Object)"loadExternalQuantData: error writing Data Header with external quant changes.", (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)"loadExternalQuantData: error writing Data Header with external quant changes.", (Throwable)e);
            }
        }
        return bLoaded;
    }

    protected boolean loadPrecursorExternalQuantHeaderData(QuantFileProcessor _processor) {
        boolean bLoaded;
        block8: {
            bLoaded = false;
            try {
                if (_processor instanceof ExtractDataProcessor) {
                    String sKey = QuantFileProcessor.getExternalQuantProcessorKey((String)_processor.getKeyID(), (String)"extract");
                    String sLabel = QuantFileProcessor.getExternalQuantProcessorLabel((String)_processor.getLabelAlias(), (String)"Extract");
                    bLoaded = this.loadPrecursorExternalQuantHeaderData(_processor, sKey, sLabel);
                    break block8;
                }
                if (_processor instanceof FullMzXMLDataProcessor) {
                    String sKey = QuantFileProcessor.getExternalQuantProcessorKey((String)_processor.getKeyID(), (String)"full_ms");
                    String sLabel = QuantFileProcessor.getExternalQuantProcessorLabel((String)_processor.getLabelAlias(), (String)"Full MS");
                    bLoaded = this.loadPrecursorExternalQuantHeaderData(_processor, sKey, sLabel);
                    break block8;
                }
                if (_processor instanceof StandardQuantDataProcessor) {
                    StandardQuantDataProcessor sqdp = (StandardQuantDataProcessor)_processor;
                    for (Peak peak : sqdp.getSourcePeakListToMatch()) {
                        Double dMz = peak.getMz();
                        String sKey = String.valueOf(sqdp.getKeyID()) + "-" + dMz.toString();
                        String sLabel = dMz.toString();
                        if (sqdp.getLabelAlias() != null && !sqdp.getLabelAlias().equals("")) {
                            sLabel = String.valueOf(sqdp.getLabelAlias()) + "-" + dMz.toString();
                        }
                        bLoaded = this.loadPrecursorExternalQuantHeaderData(_processor, sKey, sLabel);
                    }
                    break block8;
                }
                throw new Exception("Processor type not supported: " + _processor.getClass());
            }
            catch (IOException e) {
                logger.error((Object)"loadExternalQuantData: error writing Data Header with external quant changes.", (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)"loadExternalQuantData: error writing Data Header with external quant changes.", (Throwable)e);
            }
        }
        return bLoaded;
    }

    protected boolean loadPrecursorExternalQuantData(int _iParentScanNum, QuantFileProcessor _processor, boolean _bRemove) {
        boolean bLoaded = super.loadPrecursorExternalQuantData(_iParentScanNum, _processor, _bRemove);
        return bLoaded |= this.loadPrecursorExternalQuantHeaderData(_processor);
    }

    private MSAnnotationTableDataObject getMySimianTableDataObject() {
        return (MSAnnotationTableDataObject)this.getSimianTableDataObject();
    }

    protected void addHeaderLine(int iPrefColNum, GRITSColumnHeader colHeader, ArrayList<GRITSColumnHeader> alHeader) {
        if (colHeader.getKeyValue().equals(DMScan.scan_scanNo.name()) || colHeader.getKeyValue().equals(DMScan.scan_pseudoScanNo.name())) {
            this.getMySimianTableDataObject().addScanNoCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMScan.scan_parentScan.name())) {
            this.getMySimianTableDataObject().addParentNoCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMFeature.feature_id.name())) {
            this.getMySimianTableDataObject().addFeatureIdCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMFeature.feature_sequence.name())) {
            this.getMySimianTableDataObject().addSequenceCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMAnnotation.annotation_id.name())) {
            this.getMySimianTableDataObject().addAnnotationIdCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMAnnotation.annotation_string_id.name())) {
            this.getMySimianTableDataObject().addAnnotationStringIdCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPeak.peak_id.name())) {
            this.getMySimianTableDataObject().addPeakIdCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPeak.peak_mz.name())) {
            this.getMySimianTableDataObject().addMzCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPeak.peak_intensity.name())) {
            this.getSimianTableDataObject().addPeakIntensityCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPeak.peak_is_precursor.name())) {
            this.getSimianTableDataObject().addPeakIsPrecursorCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMPrecursorPeak.precursor_peak_intensity.name())) {
            this.getSimianTableDataObject().addPrecursorIntensityCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(TableDataProcessor.filterColHeader.getKeyValue())) {
            this.getMySimianTableDataObject().addFilterCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(TableDataProcessor.commentColHeader.getKeyValue())) {
            this.getMySimianTableDataObject().addCommentCol(iPrefColNum);
        } else if (colHeader.getKeyValue().equals(DMAnnotation.annotation_ratio.name())) {
            this.getMySimianTableDataObject().addRatioCol(iPrefColNum);
        }
        MassSpecTableDataProcessorUtil.setHeaderValue((int)iPrefColNum, (GRITSColumnHeader)colHeader, alHeader);
    }

    protected InternalStandardQuantFileList getInternalStandardQuantFileList(MSPropertyDataFile quantFile) {
        MSAnnotationMetaData msSettings = this.getMSAnnotationEntityProperty().getMSAnnotationParentProperty().getMSAnnotationMetaData();
        String sExtQuantType = MassSpecUISettings.getExternalQuantType((MSPropertyDataFile)quantFile);
        if (msSettings.getInternalStandardQuantFiles() == null || msSettings.getInternalStandardQuantFiles().isEmpty()) {
            return null;
        }
        InternalStandardQuantFileList isqfl = (InternalStandardQuantFileList)msSettings.getInternalStandardQuantFiles().get(sExtQuantType);
        return isqfl;
    }

    protected List<MassSpecStandardQuant> getStandardQuantitationList() {
        if (this.getMSAnnotationEntityProperty().getMSAnnotationParentProperty().getMSAnnotationMetaData() != null && this.getMSAnnotationEntityProperty().getMSAnnotationParentProperty().getMSAnnotationMetaData().getStandardQuant() != null && !this.getMSAnnotationEntityProperty().getMSAnnotationParentProperty().getMSAnnotationMetaData().getStandardQuant().isEmpty()) {
            MSAnnotationMetaData msSettings = this.getMSAnnotationEntityProperty().getMSAnnotationParentProperty().getMSAnnotationMetaData();
            return msSettings.getStandardQuant();
        }
        return null;
    }

    protected HashMap<String, InternalStandardQuantFileList> getStandardQuantitationFileList() {
        if (this.getMSAnnotationEntityProperty().getMSAnnotationParentProperty().getMSAnnotationMetaData() != null && this.getMSAnnotationEntityProperty().getMSAnnotationParentProperty().getMSAnnotationMetaData().getInternalStandardQuantFiles() != null && !this.getMSAnnotationEntityProperty().getMSAnnotationParentProperty().getMSAnnotationMetaData().getInternalStandardQuantFiles().isEmpty()) {
            MSAnnotationMetaData msSettings = this.getMSAnnotationEntityProperty().getMSAnnotationParentProperty().getMSAnnotationMetaData();
            return msSettings.getInternalStandardQuantFiles();
        }
        return null;
    }

    protected void addScanRow(Scan msScan) {
        Double dCurScanEnd;
        Double dCurScanStart;
        DecimalFormat formatDec4 = new DecimalFormat("0.0000");
        if (!this.getMethod().getMsType().equals("LC-MS/MS")) {
            super.addScanRow(msScan);
            return;
        }
        if (this.getMassSpecEntityProperty().getScanNum() != null && this.getMassSpecEntityProperty().getScanNum() != -1 || this.getMassSpecEntityProperty().getParentScanNum() != null && this.getMassSpecEntityProperty().getParentScanNum() != -1 || this.getMassSpecEntityProperty().getMsLevel() != null && this.getMassSpecEntityProperty().getMsLevel() != 1) {
            super.addScanRow(msScan);
        }
        if (this.overviewRow == null) {
            this.overviewRow = this.getNewRow();
            MassSpecTableDataProcessorUtil.fillMassSpecScanData((Scan)msScan, (ArrayList)this.overviewRow.getDataRow(), (TableViewerColumnSettings)this.getTempPreference().getPreferenceSettings());
            MassSpecTableDataProcessorUtil.setRowValue((int)this.getTempPreference().getPreferenceSettings().getColumnPosition(DMScan.scan_scanNo.name()), (Object)0, (ArrayList)this.overviewRow.getDataRow());
            MassSpecTableDataProcessorUtil.setRowValue((int)this.getTempPreference().getPreferenceSettings().getColumnPosition(DMScan.scan_retentionTime.name()), (Object)0.0, (ArrayList)this.overviewRow.getDataRow());
            this.getSimianTableDataObject().getTableData().add(this.overviewRow);
        }
        if (msScan.getScanStart() != null && (dCurScanStart = (Double)this.overviewRow.getDataRow().get(this.getTempPreference().getPreferenceSettings().getColumnPosition(DMScan.scan_scanStart.name()))) != null && dCurScanStart > msScan.getScanStart()) {
            MassSpecTableDataProcessorUtil.setRowValue((int)this.getTempPreference().getPreferenceSettings().getColumnPosition(DMScan.scan_scanStart.name()), (Object)new Double(formatDec4.format(msScan.getScanStart())), (ArrayList)this.overviewRow.getDataRow());
        }
        if (msScan.getScanEnd() != null && (dCurScanEnd = (Double)this.overviewRow.getDataRow().get(this.getTempPreference().getPreferenceSettings().getColumnPosition(DMScan.scan_scanEnd.name()))) != null && dCurScanEnd < msScan.getScanEnd()) {
            MassSpecTableDataProcessorUtil.setRowValue((int)this.getTempPreference().getPreferenceSettings().getColumnPosition(DMScan.scan_scanEnd.name()), (Object)new Double(formatDec4.format(msScan.getScanEnd())), (ArrayList)this.overviewRow.getDataRow());
        }
        if (msScan.getSubScans() != null) {
            Integer iNumSubScans = (Integer)this.overviewRow.getDataRow().get(this.getTempPreference().getPreferenceSettings().getColumnPosition(DMScan.scan_numsubscans.name()));
            iNumSubScans = iNumSubScans + msScan.getSubScans().size();
            MassSpecTableDataProcessorUtil.setRowValue((int)this.getTempPreference().getPreferenceSettings().getColumnPosition(DMScan.scan_numsubscans.name()), (Object)iNumSubScans, (ArrayList)this.overviewRow.getDataRow());
        }
        if (msScan.getNumAnnotatedPeaks() != null) {
            Integer iNumAnnotatedPeaks = (Integer)this.overviewRow.getDataRow().get(this.getTempPreference().getPreferenceSettings().getColumnPosition(DMScan.scan_numannotatedpeaks.name()));
            if (iNumAnnotatedPeaks == null) {
                iNumAnnotatedPeaks = 0;
            }
            iNumAnnotatedPeaks = iNumAnnotatedPeaks + msScan.getNumAnnotatedPeaks();
            MassSpecTableDataProcessorUtil.setRowValue((int)this.getTempPreference().getPreferenceSettings().getColumnPosition(DMScan.scan_numannotatedpeaks.name()), (Object)iNumAnnotatedPeaks, (ArrayList)this.overviewRow.getDataRow());
        }
        super.addScanRow(msScan);
    }

    protected void addPeaksTableDataForLCMS() {
        try {
            HashMap rawData = this.getGRITSdata().getScans();
            Set scans = rawData.keySet();
            ArrayList lScans = new ArrayList(scans.size());
            lScans.addAll(scans);
            Collections.sort(lScans);
            for (Integer iScan : lScans) {
                ((MSAnnotationEntityProperty)this.getEntry().getProperty()).setScanNum(iScan);
                String sSourceFile = this.getArchiveFile();
                if (new File(sSourceFile).exists()) {
                    this.data = this.xmlReader.readDataWithoutFeatures(sSourceFile);
                    this.getMassSpecEntityProperty().setParentScanNum(iScan);
                    this.addPeaksTableData();
                    this.getGRITSdata().getScanFeatures().clear();
                    this.getGRITSdata().getAnnotation().clear();
                    this.getGRITSdata().getScans().clear();
                }
                ((MSAnnotationEntityProperty)this.getEntry().getProperty()).setScanNum(-1);
                this.getMassSpecEntityProperty().setParentScanNum(Integer.valueOf(-1));
                if (this.progressBarDialog.isCanceled()) break;
            }
            this.getGRITSdata().setScans(rawData);
            this.getGRITSdata().getScanFeatures().clear();
            this.getGRITSdata().getAnnotation().clear();
        }
        catch (Exception e) {
            logger.error((Object)"addPeaksTableDataForLCMS: error building top level table for LC-MSMS data", (Throwable)e);
            this.getMassSpecEntityProperty().setParentScanNum(Integer.valueOf(-1));
            ((MSAnnotationEntityProperty)this.getEntry().getProperty()).setScanNum(-1);
        }
    }

    public void setPropertyScanNum(int iScanNum) {
        ((MSAnnotationEntityProperty)this.getEntry().getProperty()).setScanNum(iScanNum);
    }

    public ScanFeatures getScanFeatures(int iScanNum) {
        ScanFeatures features = null;
        features = this.getCurScanFeature() != null && this.getCurScanFeature().getScanId() == iScanNum ? this.getCurScanFeature() : this.loadScanFeatureFromXML(iScanNum);
        return features;
    }

    protected void addPeaksTableDataNonOverview() {
        Scan scan;
        if (this.getMassSpecEntityProperty().getParentScanNum() == null || this.getMassSpecEntityProperty().getParentScanNum().equals(-1)) {
            return;
        }
        int iScanNum = this.getMassSpecEntityProperty().getParentScanNum();
        if (this.getMethod().getMsType().equals("Direct Infusion") && (scan = (Scan)this.getGRITSdata().getScans().get(this.getMassSpecEntityProperty().getParentScanNum())).getMsLevel() == 1) {
            iScanNum = this.getGRITSdata().getFirstMS1Scan();
        }
        if (this.isLCMSAndNeedsScanSet()) {
            this.setScanNumber(iScanNum);
        }
        ScanFeatures features = this.getScanFeatures(iScanNum);
        boolean bUpdateFeature = false;
        if (features != null) {
            bUpdateFeature = this.addAnnotationData(features, this.getTempPreference().getPreferenceSettings());
        }
        this.setCurScanFeature(features);
        if (bUpdateFeature) {
            String sSourceFile = this.getArchiveFile();
            this.xmlWriter = new AnnotationWriter();
            try {
                this.xmlWriter.writeSingleScanToZipFile(iScanNum, features, sSourceFile);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected Annotation getCurrentParentAnnotation() {
        MSAnnotationEntityProperty prop = (MSAnnotationEntityProperty)this.getSourceProperty();
        Annotation parentAnnotation = AnnotationRowExtraction.getAnnotation((Data)this.getGRITSdata(), (Integer)prop.getAnnotationId());
        return parentAnnotation;
    }

    protected void addPeaksTableData() {
        if (!this.getMethod().getMsType().equals("LC-MS/MS")) {
            this.addPeaksTableDataNonOverview();
            Annotation parentAnnotation = this.getCurrentParentAnnotation();
            this.setCurAnnotation(parentAnnotation);
            return;
        }
        if (this.getMassSpecEntityProperty().getScanNum() != null && this.getMassSpecEntityProperty().getScanNum() != -1 || this.getMassSpecEntityProperty().getParentScanNum() != null && this.getMassSpecEntityProperty().getParentScanNum() != 0 || this.getMassSpecEntityProperty().getMsLevel() != null && this.getMassSpecEntityProperty().getMsLevel() != 2) {
            this.addPeaksTableDataNonOverview();
            Annotation parentAnnotation = this.getCurrentParentAnnotation();
            this.setCurAnnotation(parentAnnotation);
            return;
        }
        int iCnt = 1;
        int iScan = 0;
        while (iScan < this.getScanData().size()) {
            if (iCnt % 100 == 0) {
                this.progressBarDialog.getMinorProgressBarListener(0).setProgressMessage("Building overview LC-MS/MS table. Scan: " + iCnt + " of " + this.getScanData().size());
                this.progressBarDialog.getMinorProgressBarListener(0).setProgressValue(iCnt);
            }
            ++iCnt;
            Scan msScan = this.getScanData().get(iScan);
            if (msScan != null && msScan.getMsLevel() == 1) {
                this.getMassSpecEntityProperty().setParentScanNum(msScan.getScanNo());
                this.addPeaksTableDataNonOverview();
            }
            ++iScan;
        }
        this.getMassSpecEntityProperty().setParentScanNum(Integer.valueOf(0));
        logger.debug((Object)("Number of rows in table: " + this.simianTableDataObject.getTableData().size()));
        Annotation parentAnnotation = this.getCurrentParentAnnotation();
        this.setCurAnnotation(parentAnnotation);
    }

    public Annotation getAnnotation(Integer iAnnotId) {
        return AnnotationRowExtraction.getAnnotation((Data)this.getGRITSdata(), (Integer)iAnnotId);
    }

    public Scan getScan(Integer iScanNo) {
        return (Scan)this.getGRITSdata().getScans().get(iScanNo);
    }

    public HashMap<Feature, Peak> getFeaturesForPeak() {
        boolean bNeedsConvert;
        ScanFeatures features;
        HashMap htParentScanToParentPeaksToSubScan;
        HashMap htPeakToFeatures;
        block9: {
            htPeakToFeatures = null;
            htParentScanToParentPeaksToSubScan = null;
            features = this.loadScanFeatureFromXML(this.getCurEntityProperty().getParentScanNum());
            htPeakToFeatures = AnnotationRowExtraction.createRowIdToFeatureHash((ScanFeatures)features);
            bNeedsConvert = false;
            if (htPeakToFeatures.isEmpty()) {
                htPeakToFeatures = AnnotationRowExtraction.createPeakIdToFeatureHash((ScanFeatures)features);
                bNeedsConvert = true;
            }
            if (!htPeakToFeatures.isEmpty()) break block9;
            return null;
        }
        try {
            htParentScanToParentPeaksToSubScan = AnnotationRowExtraction.createParentScanToParentPeaksToSubScanHash((Data)this.getGRITSdata());
            if (this.getMethod().getMsType().equals("Direct Infusion")) {
                AnnotationRowExtraction.updateParentScanToParentPeaksToSubScanHashForDirectInfusion((HashMap)htParentScanToParentPeaksToSubScan, (Data)this.getGRITSdata());
            }
            HashMap<Feature, Peak> featList = new HashMap<Feature, Peak>();
            for (Peak peak : features.getScanPeaks()) {
                if (peak == null) continue;
                ArrayList precursorScans = AnnotationRowExtraction.getPrecursorScan((Data)this.getGRITSdata(), (Integer)this.getCurEntityProperty().getParentScanNum(), (Integer)peak.getId(), (HashMap)htParentScanToParentPeaksToSubScan);
                if (bNeedsConvert) {
                    AnnotationRowExtraction.convertPeakIdsToRowIds((Data)this.getGRITSdata(), (ScanFeatures)features, (int)this.getCurEntityProperty().getParentScanNum(), (Integer)peak.getId(), (ArrayList)precursorScans, (HashMap)htPeakToFeatures);
                }
                for (Scan precursorScan : precursorScans) {
                    String sRowId;
                    if (precursorScan == null || !this.getCurEntityProperty().getScanNum().equals(precursorScan.getScanNo()) || !htPeakToFeatures.containsKey(sRowId = Feature.getRowId((Integer)peak.getId(), (Integer)precursorScan.getScanNo()))) continue;
                    List alFeatures = (List)htPeakToFeatures.get(sRowId);
                    for (Feature feature : alFeatures) {
                        featList.put(feature, peak);
                    }
                }
            }
            return featList;
        }
        catch (Exception ex) {
            logger.error((Object)"Error getting features for peak in getFeaturesForPeak", (Throwable)ex);
            return null;
        }
    }

    protected boolean addPeaksData(Integer _parentScanNum, Scan _scan, Peak _peak, TableViewerColumnSettings _settings, GRITSListDataRow alRow) {
        return super.addPeaksData(_parentScanNum, _scan, _peak, _settings, alRow);
    }

    protected boolean addAnnotationData(ScanFeatures _features, TableViewerColumnSettings _settings) {
        List alUnAnnotatedRows = this.getMySimianTableDataObject().getUnAnnotatedRows();
        HashMap htPeakToFeatures = null;
        HashMap htParentScanToParentPeaksToSubScan = null;
        htPeakToFeatures = AnnotationRowExtraction.createRowIdToFeatureHash((ScanFeatures)_features);
        boolean bNeedsConvert = false;
        boolean bDirty = false;
        if (htPeakToFeatures.isEmpty() && !(htPeakToFeatures = AnnotationRowExtraction.createPeakIdToFeatureHash((ScanFeatures)_features)).isEmpty()) {
            bNeedsConvert = true;
            bDirty = true;
        }
        htParentScanToParentPeaksToSubScan = AnnotationRowExtraction.createParentScanToParentPeaksToSubScanHash((Data)this.getGRITSdata());
        if (this.getMethod().getMsType().equals("Direct Infusion") && this.getMassSpecEntityProperty().getMsLevel() - 1 == 1) {
            AnnotationRowExtraction.updateParentScanToParentPeaksToSubScanHashForDirectInfusion((HashMap)htParentScanToParentPeaksToSubScan, (Data)this.getGRITSdata());
        }
        Scan scan = (Scan)this.getGRITSdata().getScans().get(this.getMassSpecEntityProperty().getParentScanNum());
        Integer iParentScan = scan.getScanNo();
        int iArchiveParentScan = iParentScan;
        if (this.getMethod().getMsType().equals("Direct Infusion")) {
            iArchiveParentScan = this.getGRITSdata().getFirstMS1Scan();
        }
        Annotation parentAnnot = null;
        if (this.getMSAnnotationEntityProperty().getAnnotationId() != null) {
            parentAnnot = AnnotationRowExtraction.getAnnotation((Data)this.getGRITSdata(), (Integer)this.getMSAnnotationEntityProperty().getAnnotationId());
        }
        for (Peak peak : _features.getScanPeaks()) {
            if (peak == null) continue;
            boolean bAddedQuant = this.removeExternalQuantPeaksData(peak);
            if (bAddedQuant && !bDirty) {
                bDirty = true;
            }
            ArrayList precursorScans = AnnotationRowExtraction.getPrecursorScan((Data)this.getGRITSdata(), (Integer)iParentScan, (Integer)peak.getId(), (HashMap)htParentScanToParentPeaksToSubScan);
            if (bNeedsConvert) {
                AnnotationRowExtraction.convertPeakIdsToRowIds((Data)this.getGRITSdata(), (ScanFeatures)_features, (int)iParentScan, (Integer)peak.getId(), (ArrayList)precursorScans, (HashMap)htPeakToFeatures);
            }
            for (Scan precursorScan : precursorScans) {
                List alFeatures;
                Integer iParentScanNumber = null;
                iParentScanNumber = precursorScan != null ? precursorScan.getParentScan() : scan.getScanNo();
                boolean bAtLeastOne = false;
                String sFirstFeatureId = null;
                int iNumMatch = 0;
                String sRowId = Feature.getRowId((Integer)peak.getId(), (Integer)(precursorScan != null ? precursorScan.getScanNo() : null));
                if (htPeakToFeatures.containsKey(sRowId)) {
                    alFeatures = (List)htPeakToFeatures.get(sRowId);
                    for (Feature feature : alFeatures) {
                        if (parentAnnot != null && (feature.getParentAnnotation() == null || !feature.getParentAnnotation().getStringId().startsWith(parentAnnot.getStringId()))) continue;
                        ++iNumMatch;
                    }
                }
                if (iNumMatch > 0) {
                    alFeatures = (List)htPeakToFeatures.get(sRowId);
                    for (Feature feature : alFeatures) {
                        if (parentAnnot != null && (feature.getParentAnnotation() == null || !feature.getParentAnnotation().getStringId().startsWith(parentAnnot.getStringId()))) continue;
                        this.setCurFeature(feature);
                        if (!this.getMethod().getMsType().equals("Direct Infusion") && scan.getMsLevel() == 1 && precursorScans.size() == 1 && precursorScans.get(0) == null) continue;
                        FeatureSelection fs = Feature.getFeatureSelection((Feature)feature, (String)sRowId);
                        if (fs.getManuallySelected().booleanValue()) {
                            this.getSimianTableDataObject().addManuallyChangedPeak(Integer.valueOf(iArchiveParentScan), sRowId);
                        }
                        GRITSListDataRow alRow = this.getNewRow();
                        bAddedQuant |= this.addPeaksData(iParentScanNumber, precursorScan, peak, _settings, alRow);
                        if ((bAddedQuant |= this.addSubScanPeaksData(precursorScan, peak, _settings, alRow)) && !bDirty) {
                            bDirty = true;
                        }
                        this.fillFeatureData(feature, _settings, alRow);
                        this.fillAnnotationData(feature.getParentAnnotation(), feature, precursorScan, iNumMatch, _settings, alRow);
                        MassSpecTableDataProcessorUtil.setRowValue((int)_settings.getColumnPosition(TableDataProcessor.commentColHeader.getKeyValue()), (Object)fs.getComment(), (ArrayList)alRow.getDataRow());
                        MassSpecTableDataProcessorUtil.setRowValue((int)_settings.getColumnPosition(DMAnnotation.annotation_ratio.name()), (Object)fs.getRatio(), (ArrayList)alRow.getDataRow());
                        this.getSimianTableDataObject().getTableData().add(alRow);
                        if (!fs.getSelected().booleanValue()) {
                            this.getSimianTableDataObject().setHiddenRow(Integer.valueOf(_features.getScanId()), sRowId, feature.getId().toString());
                            if (sFirstFeatureId != null) continue;
                            sFirstFeatureId = feature.getId();
                            continue;
                        }
                        bAtLeastOne = true;
                    }
                    if (peak.getIsSelectionsLocked().booleanValue()) {
                        if (scan.getMsLevel() > 1) {
                            this.getSimianTableDataObject().addLockedPeak(iParentScanNumber, sRowId);
                        } else {
                            this.getSimianTableDataObject().addLockedPeak(Integer.valueOf(iArchiveParentScan), sRowId);
                        }
                    }
                } else {
                    if (!this.getMethod().getMsType().equals("Direct Infusion") && scan.getMsLevel() == 1 && precursorScans.size() == 1 && precursorScans.get(0) == null) continue;
                    GRITSListDataRow alRow = this.getNewRow();
                    this.addPeaksData(iParentScanNumber, precursorScan, peak, _settings, alRow);
                    this.addSubScanPeaksData(precursorScan, peak, _settings, alRow);
                    this.fillFeatureData(null, _settings, alRow);
                    this.fillAnnotationData(null, null, precursorScan, 0, _settings, alRow);
                    MassSpecTableDataProcessorUtil.setRowValue((int)_settings.getColumnPosition(TableDataProcessor.commentColHeader.getKeyValue()), (Object)peak.getComment(), (ArrayList)alRow.getDataRow());
                    alUnAnnotatedRows.add(this.getSimianTableDataObject().getTableData().size());
                    this.getSimianTableDataObject().getTableData().add(alRow);
                }
                if (bAtLeastOne) continue;
                this.getSimianTableDataObject().addInvisibleRow(Integer.valueOf(iArchiveParentScan), sRowId);
                this.getSimianTableDataObject().removeHiddenRow(Integer.valueOf(iArchiveParentScan), sRowId, sFirstFeatureId);
            }
        }
        return bDirty;
    }

    protected void addScanData(Scan _scan, TableViewerColumnSettings _settings, GRITSListDataRow alRow) {
        super.addScanData(_scan, _settings, alRow);
        MSAnnotationTableDataProcessorUtil.fillMassSpecScanData(_scan, alRow.getDataRow(), _settings);
    }

    protected void addFeatureColumns(TableViewerColumnSettings _settings) {
        MSAnnotationTableDataProcessorUtil.fillMSAnnotationColumnSettingsFeature(_settings);
        MSAnnotationTableDataProcessorUtil.fillColumnSettingsCustomExtraData(_settings, this.getGRITSdata().getDataHeader().getFeatureCustomExtraData());
    }

    protected void addAnnotationColumns(TableViewerColumnSettings _settings) {
        MSAnnotationTableDataProcessorUtil.fillMSAnnotationColumnSettingsAnnotation(_settings);
        MSAnnotationTableDataProcessorUtil.fillColumnSettingsCustomExtraData(_settings, this.getGRITSdata().getDataHeader().getAnnotationCustomExtraData());
        this.setLastVisibleCol(this.getLastVisibleCol() + 4);
    }

    protected void fillFeatureData(Feature feature, TableViewerColumnSettings _settings, GRITSListDataRow alRow) {
        MSAnnotationTableDataProcessorUtil.fillFeatureData(feature, alRow.getDataRow(), _settings);
        MSAnnotationTableDataProcessorUtil.fillMSFeatureCustomExtraData(feature, alRow.getDataRow(), _settings, this.getGRITSdata().getDataHeader().getFeatureCustomExtraData());
    }

    protected void fillAnnotationData(Annotation a_annotation, Feature feature, Scan a_scan, int _iNumCandidates, TableViewerColumnSettings _settings, GRITSListDataRow alRow) {
        MSAnnotationTableDataProcessorUtil.fillAnnotationData(a_annotation, _iNumCandidates, alRow.getDataRow(), _settings);
        MSAnnotationTableDataProcessorUtil.fillMSAnnotationCustomExtraData(a_annotation, alRow.getDataRow(), _settings, this.getGRITSdata().getDataHeader().getAnnotationCustomExtraData());
    }

    protected boolean updateAnnotationDataSingleScan(Integer iParentScan) {
        ScanFeatures features;
        block7: {
            block6: {
                block5: {
                    try {
                        if (iParentScan != null && !iParentScan.equals(-1)) break block5;
                        return false;
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                        return false;
                    }
                }
                features = this.loadScanFeatureFromXML(iParentScan);
                if (features != null) break block6;
                return false;
            }
            this.updateScanFeaturesWithFilter(features);
            boolean bIsDI = this.getMethod().getMsType().equals("Direct Infusion") && this.getMassSpecEntityProperty().getMsLevel() - 1 == 1;
            boolean bIsDirty = this.updateAnnotationData(features, iParentScan, bIsDI);
            if (bIsDirty) break block7;
            return false;
        }
        String sSourceFile = this.getArchiveFile();
        this.writeFeaturesToFile(iParentScan, features, sSourceFile);
        return true;
    }

    protected boolean writeFeaturesToFile(Integer iParentScan, ScanFeatures features, String sSourceFile) {
        try {
            this.xmlWriter.writeSingleScanToZipFile(iParentScan.intValue(), features, sSourceFile);
            return true;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    protected void updateScanFeaturesWithFilter(ScanFeatures features) {
    }

    protected boolean updateAnnotationData(ScanFeatures _features, Integer iParentScan, boolean _bIsDI) {
        boolean bIsDirty = false;
        HashMap htPeakToFeatures = null;
        HashMap htParentScanToParentPeaksToSubScan = null;
        htPeakToFeatures = AnnotationRowExtraction.createRowIdToFeatureHash((ScanFeatures)_features);
        boolean bNeedsConvert = false;
        if (htPeakToFeatures.isEmpty()) {
            htPeakToFeatures = AnnotationRowExtraction.createPeakIdToFeatureHash((ScanFeatures)_features);
            bNeedsConvert = true;
        }
        if (htPeakToFeatures.isEmpty()) {
            return false;
        }
        htParentScanToParentPeaksToSubScan = AnnotationRowExtraction.createParentScanToParentPeaksToSubScanHash((Data)this.getGRITSdata());
        if (_bIsDI) {
            AnnotationRowExtraction.updateParentScanToParentPeaksToSubScanHashForDirectInfusion((HashMap)htParentScanToParentPeaksToSubScan, (Data)this.getGRITSdata());
        }
        Annotation parentAnnot = null;
        if (this.getMSAnnotationEntityProperty().getAnnotationId() != null) {
            parentAnnot = AnnotationRowExtraction.getAnnotation((Data)this.getGRITSdata(), (Integer)this.getMSAnnotationEntityProperty().getAnnotationId());
        }
        for (Peak peak : _features.getScanPeaks()) {
            if (peak == null) continue;
            Peak precursorPeak = this.getPrecursorPeak(peak.getMz(), _features.getScanId());
            ArrayList precursorScans = AnnotationRowExtraction.getPrecursorScan((Data)this.getGRITSdata(), (Integer)_features.getScanId(), (Integer)peak.getId(), (HashMap)htParentScanToParentPeaksToSubScan);
            if (bNeedsConvert) {
                AnnotationRowExtraction.convertPeakIdsToRowIds((Data)this.getGRITSdata(), (ScanFeatures)_features, (int)iParentScan, (Integer)peak.getId(), (ArrayList)precursorScans, (HashMap)htPeakToFeatures);
            }
            for (Scan precursorScan : precursorScans) {
                String sRowId = Feature.getRowId((Integer)peak.getId(), (Integer)(precursorScan != null ? precursorScan.getScanNo() : null));
                peak.setIsSelectionsLocked(Boolean.valueOf(this.getSimianTableDataObject().isLockedPeak(Integer.valueOf(_features.getScanId()), sRowId)));
                String newComment = this.getCommentFromTable(peak.getId());
                if (newComment != null && !newComment.equals(peak.getComment())) {
                    bIsDirty = true;
                }
                peak.setComment(newComment);
                boolean bInvisible = this.getSimianTableDataObject().isInvisibleRow(Integer.valueOf(_features.getScanId()), sRowId);
                logger.debug((Object)("Scan num: " + _features.getScanId() + " , peak id: " + peak.getId()));
                boolean bManuallySelected = this.getSimianTableDataObject().isManuallyChangedPeak(Integer.valueOf(_features.getScanId()), sRowId);
                if (!htPeakToFeatures.containsKey(sRowId)) continue;
                List alFeatures = (List)htPeakToFeatures.get(sRowId);
                for (Feature feature : alFeatures) {
                    if (parentAnnot != null && (feature.getParentAnnotation() == null || !feature.getParentAnnotation().getStringId().startsWith(parentAnnot.getStringId()))) continue;
                    FeatureSelection fs = Feature.getFeatureSelection((Feature)feature, (String)sRowId);
                    boolean bHidden = this.getSimianTableDataObject().isHiddenRow(Integer.valueOf(_features.getScanId()), sRowId, feature.getId());
                    if ((bHidden || bInvisible) && fs.getSelected().booleanValue()) {
                        fs.setSelected(Boolean.valueOf(false));
                        bIsDirty = true;
                    } else if (!(bHidden || bInvisible || fs.getSelected().booleanValue())) {
                        fs.setSelected(Boolean.valueOf(true));
                        bIsDirty = true;
                    }
                    fs.setManuallySelected(Boolean.valueOf(bManuallySelected));
                    newComment = this.getCommentFromTable(feature, sRowId);
                    Double newRatio = this.getRatioFromTable(feature, sRowId);
                    if (newComment != null && !newComment.equals(fs.getComment())) {
                        bIsDirty = true;
                    }
                    if (newRatio != null && !newRatio.equals(fs.getRatio())) {
                        bIsDirty = true;
                    }
                    fs.setComment(newComment);
                    fs.setRatio(newRatio);
                    if (precursorPeak == null || peak.getId() != precursorPeak.getId()) continue;
                    peak.setIntegerProp(precursorPeak.getIntegerProp());
                    peak.setDoubleProp(precursorPeak.getDoubleProp());
                    bIsDirty = true;
                }
            }
        }
        return bIsDirty;
    }

    private String getCommentFromTable(Integer peakId) {
        if (((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getPeakIdCols() == null || ((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getPeakIdCols().isEmpty()) {
            return null;
        }
        Integer peakIdCol = (Integer)((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getPeakIdCols().get(0);
        Integer commentCol = null;
        if (((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getCommentCols() != null && !((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getCommentCols().isEmpty()) {
            commentCol = (Integer)((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getCommentCols().get(0);
        }
        for (GRITSListDataRow row : this.getSimianTableDataObject().getTableData()) {
            Object peakIdVal = row.getDataRow().get(peakIdCol);
            if (peakIdVal == null || !((Integer)peakIdVal).equals(peakId) || commentCol == null) continue;
            return (String)row.getDataRow().get(commentCol);
        }
        return null;
    }

    private String getCommentFromTable(Feature feature, String peakId) {
        if (((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getFeatureIdCols() == null || ((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getFeatureIdCols().isEmpty() || ((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getPeakIdCols() == null || ((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getPeakIdCols().isEmpty()) {
            return null;
        }
        Integer featureIdCol = (Integer)((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getFeatureIdCols().get(0);
        Integer peakIdCol = (Integer)((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getPeakIdCols().get(0);
        Integer commentCol = null;
        if (((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getCommentCols() != null && !((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getCommentCols().isEmpty()) {
            commentCol = (Integer)((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getCommentCols().get(0);
        }
        for (GRITSListDataRow row : this.getSimianTableDataObject().getTableData()) {
            Object featureId = row.getDataRow().get(featureIdCol);
            Object peakId2 = row.getDataRow().get(peakIdCol);
            if (featureId == null || !((String)featureId).equals(feature.getId()) || peakId2 == null || !((Integer)peakId2).toString().equals(peakId) || commentCol == null) continue;
            return (String)row.getDataRow().get(commentCol);
        }
        return null;
    }

    private Double getRatioFromTable(Feature feature, String peakId) {
        if (((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getFeatureIdCols() == null || ((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getFeatureIdCols().isEmpty() || ((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getPeakIdCols() == null || ((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getPeakIdCols().isEmpty()) {
            return null;
        }
        Integer featureIdCol = (Integer)((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getFeatureIdCols().get(0);
        Integer peakIdCol = (Integer)((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getPeakIdCols().get(0);
        Integer ratioCol = null;
        if (((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getRatioCols() != null && !((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getRatioCols().isEmpty()) {
            ratioCol = (Integer)((MSAnnotationTableDataObject)this.getSimianTableDataObject()).getRatioCols().get(0);
        }
        for (GRITSListDataRow row : this.getSimianTableDataObject().getTableData()) {
            Object featureId = row.getDataRow().get(featureIdCol);
            Object peakId2 = row.getDataRow().get(peakIdCol);
            if (featureId == null || !((String)featureId).equals(feature.getId()) || peakId2 == null || !((Integer)peakId2).toString().equals(peakId) || ratioCol == null) continue;
            try {
                Object val = row.getDataRow().get(ratioCol);
                if (val == null) continue;
                return Double.valueOf(val.toString());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    public Annotation getCurAnnotation() {
        return this.curAnnotation;
    }

    public void setCurAnnotation(Annotation curAnnotation) {
        this.curAnnotation = curAnnotation;
    }

    public Feature getCurFeature() {
        return this.curFeature;
    }

    public void setCurFeature(Feature curFeature) {
        this.curFeature = curFeature;
    }

    public ScanFeatures getCurScanFeature() {
        return this.curScanFeatures;
    }

    public void setCurScanFeature(ScanFeatures scanFeature) {
        this.curScanFeatures = scanFeature;
    }
}

