/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.property;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.PropertyWriter;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.datamodel.property.PropertyDataFile;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.utilShare.DeleteUtils;
import org.grits.toolbox.core.utilShare.XMLUtils;
import org.grits.toolbox.entry.ms.ImageRegistry;
import org.grits.toolbox.entry.ms.annotation.property.datamodel.MSAnnotationMetaData;
import org.grits.toolbox.entry.ms.annotation.property.io.MSAnnotationPropertyWriter;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;

public class MSAnnotationProperty
extends Property {
    private static final Logger logger = Logger.getLogger(MSAnnotationProperty.class);
    public static final String CURRENT_VERSION = "1.0";
    public static final String TYPE = "org.grits.toolbox.property.ms_annotation";
    protected static PropertyWriter writer = new MSAnnotationPropertyWriter();
    public static final String ARCHIVE_EXTENSION = ".zip";
    private static final String ARCHIVE_FOLDER = "ms-annotation";
    private static final String META_DATA_FILE = "msAnnotMetaData.xml";
    private MSAnnotationMetaData msAnnotationSettings = null;

    public boolean equals(Object obj) {
        if (!(obj instanceof MSAnnotationProperty)) {
            return false;
        }
        MSAnnotationProperty castObj = (MSAnnotationProperty)((Object)obj);
        if (this.getMSAnnotationMetaData() == null || castObj.getMSAnnotationMetaData() == null) {
            return false;
        }
        return this.getMSAnnotationMetaData().equals((Object)castObj.getMSAnnotationMetaData());
    }

    public MSAnnotationMetaData getMSAnnotationMetaData() {
        return this.msAnnotationSettings;
    }

    public void setMSAnnotationMetaData(MSAnnotationMetaData msAnnotationSettings) {
        this.msAnnotationSettings = msAnnotationSettings;
    }

    public static Entry getFirstAnnotEntry(Entry entry) {
        if (entry.getParent() != null && entry.getParent().getProperty() instanceof MassSpecProperty) {
            return entry;
        }
        if (entry.getParent() != null) {
            return MSAnnotationProperty.getFirstAnnotEntry(entry.getParent());
        }
        return null;
    }

    public Object clone() {
        MSAnnotationProperty newProp = new MSAnnotationProperty();
        if (this.getMSAnnotationMetaData() != null) {
            MSAnnotationMetaData settings = (MSAnnotationMetaData)((Object)this.getMSAnnotationMetaData().clone());
            newProp.setMSAnnotationMetaData(settings);
        }
        return newProp;
    }

    public String getType() {
        return TYPE;
    }

    public PropertyWriter getWriter() {
        return writer;
    }

    public ImageDescriptor getImage() {
        return ImageRegistry.getImageDescriptor((String)"org.grits.toolbox.entry.ms.annotation", (ImageRegistry.MSImage)ImageRegistry.MSImage.MSANNOTATION_ICON);
    }

    public void adjustPropertyFilePaths() {
        for (PropertyDataFile file : this.getDataFiles()) {
            if (file.getName().contains("\\") && !File.separator.equals("\\")) {
                file.setName(file.getName().replace("\\", File.separator));
                continue;
            }
            if (!file.getName().contains("/") || File.separator.equals("/")) continue;
            file.setName(file.getName().replace("/", File.separator));
        }
    }

    public String getAnnotationFolder(Entry entry) {
        String workspaceLocation = PropertyHandler.getVariable((String)"workspace_location");
        String projectName = DataModelSearch.findParentByType((Entry)entry, (String)"org.grits.toolbox.property.project").getDisplayName();
        String annotFolder = String.valueOf(workspaceLocation) + projectName + File.separator + this.getArchiveFolder();
        return annotFolder;
    }

    public String getFullyQualifiedArchiveFileNameByAnnotationID(Entry entry) {
        String annotFolder = this.getAnnotationFolder(entry);
        String zip = String.valueOf(annotFolder) + File.separator + this.getMSAnnotationMetaData().getAnnotationId() + this.getArchiveExtension();
        return zip;
    }

    public String getFullyQualifiedArchiveFileNameByScanNum(Entry entry, Integer scanNum) {
        String annotFolder = this.getAnnotationFolder(entry);
        String zip = String.valueOf(annotFolder) + File.separator + this.getMSAnnotationMetaData().getAnnotationId() + File.separator + scanNum + this.getArchiveExtension();
        return zip;
    }

    public String getArchiveExtension() {
        return ARCHIVE_EXTENSION;
    }

    public String getArchiveFolder() {
        return ARCHIVE_FOLDER;
    }

    public String getMetaDataFileName() {
        return String.valueOf(this.getMSAnnotationMetaData().getAnnotationId()) + "." + META_DATA_FILE;
    }

    public String getFullyQualifiedMetaDataFileName(Entry entry) {
        String projectFolder = this.getAnnotationFolder(entry);
        String annotFolder = String.valueOf(projectFolder) + File.separator + this.getMetaDataFileName();
        return annotFolder;
    }

    public static PropertyDataFile getNewSettingsFile(String msAnnotDetails, MSAnnotationMetaData metaData) {
        PropertyDataFile msMetaData = new PropertyDataFile(msAnnotDetails, metaData.getVersion(), "details");
        return msMetaData;
    }

    public PropertyDataFile getMetaDataFile() {
        for (PropertyDataFile file : this.getDataFiles()) {
            if (!file.getType().equals("details")) continue;
            return file;
        }
        return null;
    }

    public static MSAnnotationMetaData unmarshallSettingsFile(String sFileName) {
        MSAnnotationMetaData metaData = null;
        try {
            metaData = (MSAnnotationMetaData)((Object)XMLUtils.unmarshalObjectXML((String)sFileName, MSAnnotationMetaData.class));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return metaData;
    }

    public static void marshallSettingsFile(String sFileName, MSAnnotationMetaData metaData) {
        try {
            String xmlString = XMLUtils.marshalObjectXML((Object)((Object)metaData));
            FileWriter fileWriter = new FileWriter(sFileName);
            fileWriter.write(xmlString);
            fileWriter.close();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void delete(Entry entry) throws IOException {
        try {
            String annotFolder = this.getAnnotationFolder(entry);
            MSPropertyDataFile annotationFile = this.getMSAnnotationMetaData().getAnnotationFile();
            if (annotationFile != null && entry.getParent() != null && entry.getParent().getProperty() instanceof MassSpecProperty) {
                try {
                    ((MassSpecProperty)entry.getParent().getProperty()).removeLockForFile(entry.getParent(), entry, annotationFile.getName());
                }
                catch (IOException | JAXBException e) {
                    throw new IOException("Could not remove the lock for the file!", e);
                }
            }
            if (this.getMSAnnotationMetaData() != null) {
                this.deleteSettings(entry, annotFolder);
            }
            for (PropertyDataFile pdf : this.getDataFiles()) {
                String sFile = String.valueOf(annotFolder) + File.separator + pdf.getName();
                File f = new File(sFile);
                DeleteUtils.delete((File)f);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public void deleteSettings(Entry entry, String annotFolder) throws IOException {
        for (MSPropertyDataFile file : this.getMSAnnotationMetaData().getFileList()) {
            if (file.getName() == null || file.getName().trim().isEmpty()) continue;
            DeleteUtils.delete((File)new File(String.valueOf(annotFolder) + File.separator + file.getName()));
        }
    }

    public static String getRandomId() {
        Random random = new Random();
        return Integer.valueOf(random.nextInt(10000)).toString();
    }

    public Property getParentProperty() {
        return null;
    }

    public static boolean updateMSSettings(MSAnnotationMetaData metaData, String sSettingsFile) {
        try {
            MSAnnotationProperty.marshallSettingsFile(sSettingsFile, metaData);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return false;
        }
        return true;
    }
}

