/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.BBoxManager;
import org.eurocarbdb.application.glycanbuilder.BookingManager;
import org.eurocarbdb.application.glycanbuilder.GWSParser;
import org.eurocarbdb.application.glycanbuilder.Geometry;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererMode;
import org.eurocarbdb.application.glycanbuilder.GraphicOptions;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.LinkageRenderer;
import org.eurocarbdb.application.glycanbuilder.LinkageStyleDictionary;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.Paintable;
import org.eurocarbdb.application.glycanbuilder.Pair;
import org.eurocarbdb.application.glycanbuilder.PositionManager;
import org.eurocarbdb.application.glycanbuilder.ResAngle;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.ResiduePlacement;
import org.eurocarbdb.application.glycanbuilder.ResiduePlacementDictionary;
import org.eurocarbdb.application.glycanbuilder.ResidueRenderer;
import org.eurocarbdb.application.glycanbuilder.ResidueStyleDictionary;
import org.eurocarbdb.application.glycanbuilder.StyledTextCellRenderer;
import org.eurocarbdb.application.glycanbuilder.Union;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGlycanRenderer
implements GlycanRenderer {
    protected ResidueRenderer theResidueRenderer;
    protected LinkageRenderer theLinkageRenderer;
    protected ResiduePlacementDictionary theResiduePlacementDictionary;
    protected ResidueStyleDictionary theResidueStyleDictionary;
    protected LinkageStyleDictionary theLinkageStyleDictionary;
    protected GraphicOptions theGraphicOptions;
    protected GlycanRendererMode theRendererMode = GlycanRendererMode.DRAWING;

    public AbstractGlycanRenderer() {
        this.theResiduePlacementDictionary = new ResiduePlacementDictionary();
        this.theResidueStyleDictionary = new ResidueStyleDictionary();
        this.theLinkageStyleDictionary = new LinkageStyleDictionary();
        this.theGraphicOptions = new GraphicOptions();
        this.theResidueStyleDictionary.loadStyles("/conf/residue_styles_cfg");
        this.theResiduePlacementDictionary.loadPlacements("/conf/residue_placements_uoxf");
        this.theLinkageStyleDictionary.loadStyles("/conf/linkage_styles_cfglink");
        this.initialiseRenderers();
    }

    public AbstractGlycanRenderer(AbstractGlycanRenderer src) {
        if (src == null) {
            this.theResiduePlacementDictionary = new ResiduePlacementDictionary();
            this.theResidueStyleDictionary = new ResidueStyleDictionary();
            this.theLinkageStyleDictionary = new LinkageStyleDictionary();
            this.theGraphicOptions = new GraphicOptions();
        } else {
            this.theResiduePlacementDictionary = src.theResiduePlacementDictionary;
            this.theResidueStyleDictionary = src.theResidueStyleDictionary;
            this.theLinkageStyleDictionary = src.theLinkageStyleDictionary;
            this.theGraphicOptions = src.theGraphicOptions.clone();
        }
        this.initialiseRenderers();
    }

    protected abstract void initialiseRenderers();

    @Override
    public void setRenderMode(GlycanRendererMode mode) {
        this.theRendererMode = mode;
    }

    @Override
    public GlycanRendererMode getRenderMode() {
        return this.theRendererMode;
    }

    @Override
    public ResidueRenderer getResidueRenderer() {
        return this.theResidueRenderer;
    }

    @Override
    public void setResidueRenderer(ResidueRenderer r) {
        this.theResidueRenderer = r;
    }

    @Override
    public LinkageRenderer getLinkageRenderer() {
        return this.theLinkageRenderer;
    }

    @Override
    public void setLinkageRenderer(LinkageRenderer r) {
        this.theLinkageRenderer = r;
    }

    @Override
    public GraphicOptions getGraphicOptions() {
        return this.theGraphicOptions;
    }

    @Override
    public void setGraphicOptions(GraphicOptions opt) {
        this.theGraphicOptions = opt;
        this.theResidueRenderer.setGraphicOptions(this.theGraphicOptions);
        this.theLinkageRenderer.setGraphicOptions(this.theGraphicOptions);
    }

    @Override
    public ResiduePlacementDictionary getResiduePlacementDictionary() {
        return this.theResiduePlacementDictionary;
    }

    @Override
    public void setResiduePlacementDictionary(ResiduePlacementDictionary residuePlacementDictionary) {
        this.theResiduePlacementDictionary = residuePlacementDictionary;
    }

    @Override
    public ResidueStyleDictionary getResidueStyleDictionary() {
        return this.theResidueStyleDictionary;
    }

    @Override
    public void setResidueStyleDictionary(ResidueStyleDictionary residueStyleDictionary) {
        this.theResidueStyleDictionary = residueStyleDictionary;
        this.theResidueRenderer.setResidueStyleDictionary(this.theResidueStyleDictionary);
    }

    @Override
    public LinkageStyleDictionary getLinkageStyleDictionary() {
        return this.theLinkageStyleDictionary;
    }

    @Override
    public void setLinkageStyleDictionary(LinkageStyleDictionary linkageStyleDictionary) {
        this.theLinkageStyleDictionary = linkageStyleDictionary;
        this.theLinkageRenderer.setLinkageStyleDictionary(this.theLinkageStyleDictionary);
    }

    @Override
    public void paint(Paintable paintable, Glycan structure, HashSet<Residue> selected_residues, HashSet<Linkage> selected_linkages, boolean show_mass, boolean show_redend, PositionManager posManager, BBoxManager bboxManager) {
        this.paint(paintable, structure, selected_residues, selected_linkages, null, show_mass, show_redend, posManager, bboxManager);
    }

    @Override
    public void paint(Paintable paintable, Glycan structure, HashSet<Residue> selected_residues, HashSet<Linkage> selected_linkages, Collection<Residue> active_residues, boolean show_mass, boolean show_redend, PositionManager posManager, BBoxManager bboxManager) {
        if (structure == null || structure.isEmpty()) {
            return;
        }
        selected_residues = selected_residues != null ? selected_residues : new HashSet<Residue>();
        HashSet<Linkage> hashSet = selected_linkages = selected_linkages != null ? selected_linkages : new HashSet<Linkage>();
        if (structure.isComposition()) {
            this.paintComposition(paintable, structure.getRoot(), structure.getBracket(), selected_residues, posManager, bboxManager);
        } else {
            this.paintResidue(paintable, structure.getRoot(show_redend), selected_residues, selected_linkages, active_residues, posManager, bboxManager);
            this.paintBracket(paintable, structure.getBracket(), selected_residues, selected_linkages, active_residues, posManager, bboxManager);
        }
        if (show_mass) {
            this.displayMass(paintable, structure, show_redend, bboxManager);
        }
    }

    protected abstract void displayMass(Paintable var1, Glycan var2, boolean var3, BBoxManager var4);

    protected String getMassText(Glycan structure) {
        StringBuilder sb = new StringBuilder();
        DecimalFormat df = new DecimalFormat("0.0000");
        double mz = structure.computeMZ();
        sb.append("m/z: ");
        if (mz < 0.0) {
            sb.append("???");
        } else {
            sb.append(df.format(mz));
        }
        sb.append(" [");
        sb.append(structure.getMassOptions().toString());
        sb.append("]");
        return sb.toString();
    }

    protected abstract void paintComposition(Paintable var1, Residue var2, Residue var3, HashSet<Residue> var4, PositionManager var5, BBoxManager var6);

    protected abstract void paintQuantity(Paintable var1, Residue var2, int var3, BBoxManager var4);

    protected void paintResidue(Paintable paintable, Residue node, HashSet<Residue> selected_residues, HashSet<Linkage> selected_linkages, Collection<Residue> active_residues, PositionManager posManager, BBoxManager bboxManager) {
        if (node == null) {
            return;
        }
        Rectangle parent_bbox = bboxManager.getParent(node);
        Rectangle node_bbox = bboxManager.getCurrent(node);
        Rectangle border_bbox = bboxManager.getBorder(node);
        Rectangle support_bbox = bboxManager.getSupport(node);
        if (node_bbox == null) {
            return;
        }
        for (Linkage link : node.getChildrenLinkages()) {
            Residue child = link.getChildResidue();
            Rectangle child_bbox = bboxManager.getCurrent(child);
            Rectangle child_border_bbox = bboxManager.getBorder(child);
            if (child_bbox == null || posManager.isOnBorder(child)) continue;
            boolean selected = selected_residues.contains(node) && selected_residues.contains(child) || selected_linkages.contains(link);
            boolean active = active_residues == null || active_residues.contains(node) && active_residues.contains(child);
            this.theLinkageRenderer.paintEdge(paintable, link, selected, node_bbox, border_bbox, child_bbox, child_border_bbox);
        }
        boolean selected = selected_residues.contains(node);
        boolean active = active_residues == null || active_residues.contains(node);
        this.theResidueRenderer.paint(paintable, node, selected, active, posManager.isOnBorder(node), parent_bbox, node_bbox, support_bbox, posManager.getOrientation(node));
        for (Linkage link : node.getChildrenLinkages()) {
            this.paintResidue(paintable, link.getChildResidue(), selected_residues, selected_linkages, active_residues, posManager, bboxManager);
        }
        for (Linkage link : node.getChildrenLinkages()) {
            Residue child = link.getChildResidue();
            Rectangle child_bbox = bboxManager.getCurrent(child);
            Rectangle child_border_bbox = bboxManager.getBorder(child);
            if (child_bbox == null || posManager.isOnBorder(child)) continue;
            this.theLinkageRenderer.paintInfo(paintable, link, node_bbox, border_bbox, child_bbox, child_border_bbox);
        }
    }

    @Override
    public Dimension computeSize(Rectangle all_bbox) {
        if (all_bbox == null || all_bbox.width == 0 || all_bbox.height == 0) {
            return new Dimension(1, 1);
        }
        return new Dimension(this.theGraphicOptions.MARGIN_LEFT + all_bbox.width + this.theGraphicOptions.MARGIN_RIGHT, this.theGraphicOptions.MARGIN_TOP + all_bbox.height + this.theGraphicOptions.MARGIN_BOTTOM);
    }

    @Override
    public Rectangle computeBoundingBoxes(Collection<Glycan> structures, boolean show_masses, boolean show_redend, PositionManager posManager, BBoxManager bboxManager) {
        return this.computeBoundingBoxes(structures, show_masses, show_redend, posManager, bboxManager, true);
    }

    @Override
    public Rectangle computeBoundingBoxes(Collection<Glycan> structures, boolean show_masses, boolean show_redend, PositionManager posManager, BBoxManager bboxManager, boolean reset) {
        if (reset) {
            posManager.reset();
            bboxManager.reset();
        }
        Rectangle all_bbox = new Rectangle(this.theGraphicOptions.MARGIN_TOP, this.theGraphicOptions.MARGIN_LEFT, 0, 0);
        int cur_top = this.theGraphicOptions.MARGIN_TOP;
        int cur_left = this.theGraphicOptions.MARGIN_LEFT;
        Iterator<Glycan> i = structures.iterator();
        while (i.hasNext()) {
            Rectangle glycan_bbox = this.computeBoundingBoxes(i.next(), cur_left, cur_top, show_masses, show_redend, posManager, bboxManager);
            all_bbox = Geometry.union(all_bbox, glycan_bbox);
            if (this.theRendererMode == GlycanRendererMode.DRAWING) {
                cur_top = Geometry.bottom(all_bbox) + this.theGraphicOptions.STRUCTURES_SPACE;
                continue;
            }
            if (this.theRendererMode != GlycanRendererMode.TOOLBAR) continue;
            cur_left = Geometry.right(all_bbox) + this.theGraphicOptions.STRUCTURES_SPACE;
        }
        return all_bbox;
    }

    @Override
    public Rectangle computeBoundingBoxes(Glycan structure, int cur_left, int cur_top, boolean show_mass, boolean show_redend, PositionManager posManager, BBoxManager bboxManager) {
        if (structure == null) {
            return new Rectangle(cur_left, cur_top, 0, 0);
        }
        try {
            bboxManager.setGraphicOptions(this.theGraphicOptions);
            if (!structure.isEmpty()) {
                Residue bracket;
                Residue root;
                ResAngle orientation = this.theGraphicOptions.getOrientationAngle();
                if (structure.isComposition()) {
                    root = structure.getRoot();
                    bracket = structure.getBracket();
                    this.assignPositionComposition(root, posManager);
                    this.assignPositionComposition(bracket, posManager);
                    this.computeBoundingBoxesComposition(root, bracket, posManager, bboxManager);
                } else {
                    root = structure.getRoot(show_redend);
                    bracket = structure.getBracket();
                    posManager.add(root, new ResAngle(), orientation, false, true);
                    this.assignPosition(root, false, orientation, root, posManager);
                    posManager.add(bracket, new ResAngle(), orientation, false, true);
                    this.assignPosition(bracket, false, orientation, bracket, posManager);
                    this.computeBoundingBoxes(root, posManager, bboxManager);
                    this.computeBoundingBoxesBracket(bracket, root, this.theGraphicOptions.COLLAPSE_MULTIPLE_ANTENNAE, posManager, bboxManager);
                }
                Rectangle bbox = Geometry.union(bboxManager.getComplete(root), bboxManager.getComplete(bracket));
                bboxManager.setComplete(root, bbox);
                bboxManager.translate(cur_left - bbox.x, cur_top - bbox.y, root);
                bboxManager.translate(cur_left - bbox.x, cur_top - bbox.y, bracket);
                bbox.translate(cur_left - bbox.x, cur_top - bbox.y);
                if (show_mass) {
                    Dimension d = Geometry.textBounds(this.getMassText(structure), this.theGraphicOptions.MASS_TEXT_FONT_FACE, this.theGraphicOptions.MASS_TEXT_SIZE);
                    Rectangle text_bbox = new Rectangle(cur_left, Geometry.bottom(bbox) + this.theGraphicOptions.MASS_TEXT_SPACE, d.width, d.height);
                    bbox = Geometry.union(bbox, text_bbox);
                }
                return bbox;
            }
        }
        catch (Exception e) {
            LogUtils.report(e);
        }
        return new Rectangle(cur_left, cur_top, 0, 0);
    }

    @Override
    public void assignPositions(Glycan structure, PositionManager posManager) {
        if (structure == null) {
            return;
        }
        try {
            ResAngle orientation = this.theGraphicOptions.getOrientationAngle();
            Residue root = structure.getRoot(true);
            Residue bracket = structure.getBracket();
            posManager.add(root, new ResAngle(), orientation, false, true);
            this.assignPosition(root, false, orientation, root, posManager);
            posManager.add(bracket, new ResAngle(), orientation, false, true);
            this.assignPosition(bracket, false, orientation, bracket, posManager);
        }
        catch (Exception e) {
            LogUtils.report(e);
        }
    }

    private void assignPositionComposition(Residue current, PositionManager posManager) throws Exception {
        if (current == null) {
            return;
        }
        posManager.add(current, this.theGraphicOptions.getOrientationAngle(), new ResAngle(), false, false);
        for (Linkage l : current.getChildrenLinkages()) {
            this.assignPositionComposition(l.getChildResidue(), posManager);
        }
    }

    private void assignPosition(Residue current, boolean sticky, ResAngle orientation, Residue turning_point, PositionManager posManager) throws Exception {
        if (current == null) {
            return;
        }
        BookingManager bookManager = new BookingManager(posManager.getAvailablePositions(current, orientation));
        Iterator<Linkage> i = current.iterator();
        while (i.hasNext()) {
            Linkage link = i.next();
            Residue child = link.getChildResidue();
            Residue matching_child = child.getCleavedResidue() != null ? child.getCleavedResidue() : child;
            ResiduePlacement placement = matching_child.getPreferredPlacement();
            if (placement == null || !current.isSaccharide() && !current.isBracket() || !bookManager.isAvailable(placement)) {
                placement = this.theResiduePlacementDictionary.getPlacement(current, link, matching_child, sticky);
            }
            bookManager.add(child, placement);
        }
        bookManager.place();
        i = current.iterator();
        while (i.hasNext()) {
            Residue child = i.next().getChildResidue();
            ResiduePlacement child_placement = bookManager.getPlacement(child);
            ResAngle child_pos = bookManager.getPosition(child);
            posManager.add(child, orientation, child_pos, child_placement.isOnBorder(), child_placement.isSticky());
            ResAngle child_orientation = posManager.getOrientation(child);
            Residue child_turning_point = child_orientation.equals(orientation) ? turning_point : child;
            this.assignPosition(child, child_placement.isSticky(), child_orientation, child_turning_point, posManager);
        }
    }

    @Override
    public String makeCompositionText(Glycan g, boolean styled) {
        return AbstractGlycanRenderer.makeCompositionText(g, GraphicOptions.getOrientationAngle(0), styled);
    }

    public static String makeCompositionTextPlain(Glycan g) {
        if (!g.isComposition()) {
            g = g.getComposition();
        }
        return AbstractGlycanRenderer.makeCompositionText(g.getRoot(), g.getBracket(), new ResAngle(0), false);
    }

    public static String makeCompositionText(Glycan g, ResAngle orientation, boolean styled) {
        if (!g.isComposition()) {
            g = g.getComposition();
        }
        return AbstractGlycanRenderer.makeCompositionText(g.getRoot(), g.getBracket(), orientation, styled);
    }

    protected static String makeCompositionText(Residue root, Residue bracket, ResAngle orientation, boolean styled) {
        Vector<String> cleavages = new Vector<String>();
        TreeMap<String, Integer> residues = new TreeMap<String, Integer>();
        for (Linkage l : bracket.getChildrenLinkages()) {
            Residue residue = l.getChildResidue();
            if (residue.isCleavage()) {
                if (residue.getType().isLCleavage()) continue;
                cleavages.add(residue.getCleavageType());
                continue;
            }
            String type = residue.getResidueName();
            Integer old_num = (Integer)residues.get(type);
            if (old_num == null) {
                residues.put(type, 1);
                continue;
            }
            residues.put(type, old_num + 1);
        }
        StringBuilder text = new StringBuilder();
        if (orientation.equals(180) || orientation.equals(90)) {
            if (cleavages.size() > 0) {
                for (String string : cleavages) {
                    text.append(string);
                }
                text.append('-');
            }
        } else if (!root.getTypeName().equals("freeEnd")) {
            if (root.isCleavage()) {
                text.append(root.getCleavageType());
            } else {
                text.append(root.getResidueName());
            }
            text.append('-');
        }
        for (Map.Entry entry : residues.entrySet()) {
            text.append((String)entry.getKey());
            if (styled) {
                text.append("_{");
                text.append(entry.getValue());
                text.append('}');
                continue;
            }
            text.append(entry.getValue());
        }
        if (orientation.equals(180) || orientation.equals(90)) {
            if (!root.getTypeName().equals("freeEnd")) {
                text.append('-');
                if (root.isCleavage()) {
                    text.append(root.getCleavageType());
                } else {
                    text.append(root.getResidueName());
                }
            }
        } else if (cleavages.size() > 0) {
            text.append('-');
            for (String string : cleavages) {
                text.append(string);
            }
        }
        return text.toString();
    }

    private void computeBoundingBoxesComposition(Residue root, Residue bracket, PositionManager posManager, BBoxManager bboxManager) {
        ResAngle orientation = posManager.getOrientation(root);
        String text = AbstractGlycanRenderer.makeCompositionText(root, bracket, orientation, true);
        Font font = new Font(this.theGraphicOptions.COMPOSITION_FONT_FACE, 0, this.theGraphicOptions.COMPOSITION_FONT_SIZE);
        StyledTextCellRenderer stcr = new StyledTextCellRenderer(false);
        stcr.getRendererComponent(font, Color.black, Color.white, text);
        Dimension d = stcr.getPreferredSize();
        if (orientation.equals(0) || orientation.equals(180)) {
            bboxManager.setAllBBoxes(bracket, new Rectangle(0, 0, d.width, d.height));
        } else {
            bboxManager.setAllBBoxes(bracket, new Rectangle(0, 0, d.height, d.width));
        }
        bboxManager.linkSubtree(bracket, root);
        bboxManager.linkSubtree(bracket, bracket);
    }

    private void computeBoundingBoxes(Residue node, PositionManager posManager, BBoxManager bboxManager) throws Exception {
        if (node == null) {
            return;
        }
        ResAngle orientation = posManager.getOrientation(node);
        if (orientation.equals(0)) {
            this.computeBoundingBoxesLR(node, posManager, bboxManager);
        } else if (orientation.equals(180)) {
            this.computeBoundingBoxesRL(node, posManager, bboxManager);
        } else if (orientation.equals(90)) {
            this.computeBoundingBoxesTB(node, posManager, bboxManager);
        } else if (orientation.equals(-90)) {
            this.computeBoundingBoxesBT(node, posManager, bboxManager);
        } else {
            throw new Exception("Invalid orientation " + orientation + " at node " + node.id);
        }
    }

    private void computeBoundingBoxesLR(Residue node, PositionManager posManager, BBoxManager bboxManager) throws Exception {
        if (node == null) {
            return;
        }
        Rectangle node_bbox = this.theResidueRenderer.computeBoundingBox(node, posManager.isOnBorder(node), 0, 0, posManager.getOrientation(node), this.theGraphicOptions.NODE_SIZE, Integer.MAX_VALUE);
        bboxManager.setAllBBoxes(node, node_bbox);
        Vector<Residue> region_m90b = posManager.getChildrenAtPosition(node, new ResAngle(-90), true);
        for (int i = 0; i < region_m90b.size(); ++i) {
            this.computeBoundingBoxes(region_m90b.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignBottomsOnRight(region_m90b.subList(0, i), region_m90b.subList(i, i + 1), this.theGraphicOptions.NODE_SUB_SPACE);
        }
        Vector<Residue> region_p90b = posManager.getChildrenAtPosition(node, new ResAngle(90), true);
        for (int i = 0; i < region_p90b.size(); ++i) {
            this.computeBoundingBoxes(region_p90b.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignTopsOnLeft(region_p90b.subList(0, i), region_p90b.subList(i, i + 1), this.theGraphicOptions.NODE_SUB_SPACE);
        }
        Vector<Residue> region_m90 = posManager.getChildrenAtPosition(node, new ResAngle(-90), false);
        for (int i = 0; i < region_m90.size(); ++i) {
            this.computeBoundingBoxes(region_m90.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignBottomsOnRight(region_m90.subList(0, i), region_m90.subList(i, i + 1), this.theGraphicOptions.NODE_SPACE);
        }
        Vector<Residue> region_p90 = posManager.getChildrenAtPosition(node, new ResAngle(90), false);
        for (int i = 0; i < region_p90.size(); ++i) {
            this.computeBoundingBoxes(region_p90.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignTopsOnLeft(region_p90.subList(0, i), region_p90.subList(i, i + 1), this.theGraphicOptions.NODE_SPACE);
        }
        Vector<Residue> region_0 = posManager.getChildrenAtPosition(node, new ResAngle(0));
        for (int i = 0; i < region_0.size(); ++i) {
            this.computeBoundingBoxes(region_0.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignLeftsOnBottom(region_0.subList(0, i), region_0.subList(i, i + 1), this.theGraphicOptions.NODE_SPACE);
        }
        Vector<Residue> region_m45 = posManager.getChildrenAtPosition(node, new ResAngle(-45));
        for (int i = 0; i < region_m45.size(); ++i) {
            this.computeBoundingBoxes(region_m45.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignLeftsOnBottom(region_m45.subList(0, i), region_m45.subList(i, i + 1), this.theGraphicOptions.NODE_SPACE);
        }
        Vector<Residue> region_p45 = posManager.getChildrenAtPosition(node, new ResAngle(45));
        for (int i = 0; i < region_p45.size(); ++i) {
            this.computeBoundingBoxes(region_p45.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignLeftsOnBottom(region_p45.subList(0, i), region_p45.subList(i, i + 1), this.theGraphicOptions.NODE_SPACE);
        }
        bboxManager.alignCentersOnTop(node_bbox, region_m90b, this.theGraphicOptions.NODE_SUB_SPACE);
        bboxManager.alignCentersOnBottom(node_bbox, region_p90b, this.theGraphicOptions.NODE_SUB_SPACE);
        Union<Residue> border_nodes = new Union<Residue>((Collection<Residue>)region_m90b).and(region_p90b);
        Rectangle border_bbox = bboxManager.getComplete(border_nodes.and(node));
        if (region_0.size() > 0) {
            bboxManager.alignLeftsOnTop(region_0, region_m45, this.theGraphicOptions.NODE_SPACE);
            bboxManager.alignLeftsOnBottom(region_0, new Union<Residue>((Collection<Residue>)region_0).and(region_m45), region_p45, region_p45, this.theGraphicOptions.NODE_SPACE);
            bboxManager.alignCentersOnRight(node_bbox, border_nodes, region_0, new Union<Residue>((Collection<Residue>)region_0).and(region_m45).and(region_p45), this.theGraphicOptions.NODE_SPACE);
        } else if (region_m45.size() == 0) {
            bboxManager.alignCornersOnRightAtBottom(node_bbox, border_nodes, region_p45, this.theGraphicOptions.NODE_SPACE, this.theGraphicOptions.NODE_SPACE);
        } else if (region_p45.size() == 0) {
            bboxManager.alignCornersOnRightAtTop(node_bbox, border_nodes, region_m45, this.theGraphicOptions.NODE_SPACE, this.theGraphicOptions.NODE_SPACE);
        } else {
            bboxManager.alignSymmetricOnRight(node_bbox, border_nodes, region_m45, region_p45, this.theGraphicOptions.NODE_SPACE, 2 * this.theGraphicOptions.NODE_SPACE + this.theGraphicOptions.NODE_SIZE);
        }
        Union<Residue> ex_nodes = new Union<Residue>((Collection<Residue>)region_0).and(region_m45).and(region_p45).and(border_nodes);
        bboxManager.alignCentersOnTop(node_bbox, ex_nodes, region_m90, region_m90, this.theGraphicOptions.NODE_SPACE);
        bboxManager.alignCentersOnBottom(node_bbox, ex_nodes, region_p90, region_p90, this.theGraphicOptions.NODE_SPACE);
        Union<Residue> all_nodes = ex_nodes.and(region_m90).and(region_p90).and(node);
        bboxManager.setCurrent(node, node_bbox);
        bboxManager.setBorder(node, border_bbox);
        bboxManager.setComplete(node, bboxManager.getComplete(all_nodes));
        if (node.hasChildren()) {
            bboxManager.setSupport(node, new Rectangle(Geometry.midx(node_bbox) + this.theGraphicOptions.NODE_SPACE + this.theGraphicOptions.NODE_SIZE, Geometry.midy(node_bbox), 0, 0));
        }
        Iterator<Linkage> i = node.iterator();
        while (i.hasNext()) {
            bboxManager.setParent(i.next().getChildResidue(), node_bbox);
        }
    }

    private void computeBoundingBoxesRL(Residue node, PositionManager posManager, BBoxManager bboxManager) throws Exception {
        if (node == null) {
            return;
        }
        Rectangle node_bbox = this.theResidueRenderer.computeBoundingBox(node, posManager.isOnBorder(node), 0, 0, posManager.getOrientation(node), this.theGraphicOptions.NODE_SIZE, Integer.MAX_VALUE);
        bboxManager.setAllBBoxes(node, node_bbox);
        Vector<Residue> region_m90b = posManager.getChildrenAtPosition(node, new ResAngle(-90), true);
        for (int i = 0; i < region_m90b.size(); ++i) {
            this.computeBoundingBoxes(region_m90b.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignTopsOnLeft(region_m90b.subList(0, i), region_m90b.subList(i, i + 1), this.theGraphicOptions.NODE_SUB_SPACE);
        }
        Vector<Residue> region_p90b = posManager.getChildrenAtPosition(node, new ResAngle(90), true);
        for (int i = 0; i < region_p90b.size(); ++i) {
            this.computeBoundingBoxes(region_p90b.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignBottomsOnRight(region_p90b.subList(0, i), region_p90b.subList(i, i + 1), this.theGraphicOptions.NODE_SUB_SPACE);
        }
        Vector<Residue> region_m90 = posManager.getChildrenAtPosition(node, new ResAngle(-90), false);
        for (int i = 0; i < region_m90.size(); ++i) {
            this.computeBoundingBoxes(region_m90.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignTopsOnLeft(region_m90.subList(0, i), region_m90.subList(i, i + 1), this.theGraphicOptions.NODE_SPACE);
        }
        Vector<Residue> region_p90 = posManager.getChildrenAtPosition(node, new ResAngle(90), false);
        for (int i = 0; i < region_p90.size(); ++i) {
            this.computeBoundingBoxes(region_p90.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignBottomsOnRight(region_p90.subList(0, i), region_p90.subList(i, i + 1), this.theGraphicOptions.NODE_SPACE);
        }
        Vector<Residue> region_0 = posManager.getChildrenAtPosition(node, new ResAngle(0), false);
        for (int i = 0; i < region_0.size(); ++i) {
            this.computeBoundingBoxes(region_0.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignRightsOnTop(region_0.subList(0, i), region_0.subList(i, i + 1), this.theGraphicOptions.NODE_SPACE);
        }
        Vector<Residue> region_m45 = posManager.getChildrenAtPosition(node, new ResAngle(-45), false);
        for (int i = 0; i < region_m45.size(); ++i) {
            this.computeBoundingBoxes(region_m45.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignRightsOnTop(region_m45.subList(0, i), region_m45.subList(i, i + 1), this.theGraphicOptions.NODE_SPACE);
        }
        Vector<Residue> region_p45 = posManager.getChildrenAtPosition(node, new ResAngle(45), false);
        for (int i = 0; i < region_p45.size(); ++i) {
            this.computeBoundingBoxes(region_p45.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignRightsOnTop(region_p45.subList(0, i), region_p45.subList(i, i + 1), this.theGraphicOptions.NODE_SPACE);
        }
        bboxManager.alignCentersOnBottom(node_bbox, region_m90b, this.theGraphicOptions.NODE_SUB_SPACE);
        bboxManager.alignCentersOnTop(node_bbox, region_p90b, this.theGraphicOptions.NODE_SUB_SPACE);
        Union<Residue> border_nodes = new Union<Residue>((Collection<Residue>)region_m90b).and(region_p90b);
        Rectangle border_bbox = bboxManager.getComplete(border_nodes.and(node));
        if (region_0.size() > 0) {
            bboxManager.alignRightsOnBottom(region_0, region_m45, this.theGraphicOptions.NODE_SPACE);
            bboxManager.alignRightsOnTop(region_0, new Union<Residue>((Collection<Residue>)region_0).and(region_m45), region_p45, region_p45, this.theGraphicOptions.NODE_SPACE);
            bboxManager.alignCentersOnLeft(node_bbox, border_nodes, region_0, new Union<Residue>((Collection<Residue>)region_0).and(region_m45).and(region_p45), this.theGraphicOptions.NODE_SPACE);
        } else if (region_m45.size() == 0) {
            bboxManager.alignCornersOnLeftAtTop(node_bbox, border_nodes, region_p45, this.theGraphicOptions.NODE_SPACE, this.theGraphicOptions.NODE_SPACE);
        } else if (region_p45.size() == 0) {
            bboxManager.alignCornersOnLeftAtBottom(node_bbox, border_nodes, region_m45, this.theGraphicOptions.NODE_SPACE, this.theGraphicOptions.NODE_SPACE);
        } else {
            bboxManager.alignSymmetricOnLeft(node_bbox, border_nodes, region_p45, region_m45, this.theGraphicOptions.NODE_SPACE, 2 * this.theGraphicOptions.NODE_SPACE + this.theGraphicOptions.NODE_SIZE);
        }
        Union<Residue> ex_nodes = new Union<Residue>((Collection<Residue>)region_0).and(region_m45).and(region_p45).and(border_nodes);
        bboxManager.alignCentersOnBottom(node_bbox, ex_nodes, region_m90, region_m90, this.theGraphicOptions.NODE_SPACE);
        bboxManager.alignCentersOnTop(node_bbox, ex_nodes, region_p90, region_p90, this.theGraphicOptions.NODE_SPACE);
        Union<Residue> all_nodes = ex_nodes.and(region_m90).and(region_p90).and(node);
        bboxManager.setCurrent(node, node_bbox);
        bboxManager.setBorder(node, border_bbox);
        bboxManager.setComplete(node, bboxManager.getComplete(all_nodes));
        if (node.hasChildren()) {
            bboxManager.setSupport(node, new Rectangle(Geometry.midx(node_bbox) - this.theGraphicOptions.NODE_SPACE - this.theGraphicOptions.NODE_SIZE, Geometry.midy(node_bbox), 0, 0));
        }
        Iterator<Linkage> i = node.iterator();
        while (i.hasNext()) {
            bboxManager.setParent(i.next().getChildResidue(), node_bbox);
        }
    }

    private void computeBoundingBoxesTB(Residue node, PositionManager posManager, BBoxManager bboxManager) throws Exception {
        if (node == null) {
            return;
        }
        Rectangle node_bbox = this.theResidueRenderer.computeBoundingBox(node, posManager.isOnBorder(node), 0, 0, posManager.getOrientation(node), this.theGraphicOptions.NODE_SIZE, Integer.MAX_VALUE);
        bboxManager.setAllBBoxes(node, node_bbox);
        Vector<Residue> region_m90b = posManager.getChildrenAtPosition(node, new ResAngle(-90), true);
        for (int i = 0; i < region_m90b.size(); ++i) {
            this.computeBoundingBoxes(region_m90b.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignLeftsOnBottom(region_m90b.subList(0, i), region_m90b.subList(i, i + 1), this.theGraphicOptions.NODE_SUB_SPACE);
        }
        Vector<Residue> region_p90b = posManager.getChildrenAtPosition(node, new ResAngle(90), true);
        for (int i = 0; i < region_p90b.size(); ++i) {
            this.computeBoundingBoxes(region_p90b.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignRightsOnTop(region_p90b.subList(0, i), region_p90b.subList(i, i + 1), this.theGraphicOptions.NODE_SUB_SPACE);
        }
        Vector<Residue> region_m90 = posManager.getChildrenAtPosition(node, new ResAngle(-90), false);
        for (int i = 0; i < region_m90.size(); ++i) {
            this.computeBoundingBoxes(region_m90.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignLeftsOnBottom(region_m90.subList(0, i), region_m90.subList(i, i + 1), this.theGraphicOptions.NODE_SPACE);
        }
        Vector<Residue> region_p90 = posManager.getChildrenAtPosition(node, new ResAngle(90), false);
        for (int i = 0; i < region_p90.size(); ++i) {
            this.computeBoundingBoxes(region_p90.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignRightsOnTop(region_p90.subList(0, i), region_p90.subList(i, i + 1), this.theGraphicOptions.NODE_SPACE);
        }
        Vector<Residue> region_0 = posManager.getChildrenAtPosition(node, new ResAngle(0));
        for (int i = 0; i < region_0.size(); ++i) {
            this.computeBoundingBoxes(region_0.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignTopsOnLeft(region_0.subList(0, i), region_0.subList(i, i + 1), this.theGraphicOptions.NODE_SPACE);
        }
        Vector<Residue> region_m45 = posManager.getChildrenAtPosition(node, new ResAngle(-45));
        for (int i = 0; i < region_m45.size(); ++i) {
            this.computeBoundingBoxes(region_m45.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignTopsOnLeft(region_m45.subList(0, i), region_m45.subList(i, i + 1), this.theGraphicOptions.NODE_SPACE);
        }
        Vector<Residue> region_p45 = posManager.getChildrenAtPosition(node, new ResAngle(45));
        for (int i = 0; i < region_p45.size(); ++i) {
            this.computeBoundingBoxes(region_p45.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignTopsOnLeft(region_p45.subList(i, i + 1), region_p45.subList(0, i), this.theGraphicOptions.NODE_SPACE);
        }
        bboxManager.alignCentersOnRight(node_bbox, region_m90b, this.theGraphicOptions.NODE_SUB_SPACE);
        bboxManager.alignCentersOnLeft(node_bbox, region_p90b, this.theGraphicOptions.NODE_SUB_SPACE);
        Union<Residue> border_nodes = new Union<Residue>((Collection<Residue>)region_m90b).and(region_p90b);
        Rectangle border_bbox = bboxManager.getComplete(border_nodes.and(node));
        if (region_0.size() > 0) {
            bboxManager.alignTopsOnRight(region_0, region_m45, this.theGraphicOptions.NODE_SPACE);
            bboxManager.alignTopsOnLeft(region_0, new Union<Residue>((Collection<Residue>)region_0).and(region_m45), region_p45, region_p45, this.theGraphicOptions.NODE_SPACE);
            bboxManager.alignCentersOnBottom(node_bbox, border_nodes, region_0, new Union<Residue>((Collection<Residue>)region_0).and(region_m45).and(region_p45), this.theGraphicOptions.NODE_SPACE);
        } else if (region_m45.size() == 0) {
            bboxManager.alignCornersOnBottomAtLeft(node_bbox, border_nodes, region_p45, this.theGraphicOptions.NODE_SPACE, this.theGraphicOptions.NODE_SPACE);
        } else if (region_p45.size() == 0) {
            bboxManager.alignCornersOnBottomAtRight(node_bbox, border_nodes, region_m45, this.theGraphicOptions.NODE_SPACE, this.theGraphicOptions.NODE_SPACE);
        } else {
            bboxManager.alignSymmetricOnBottom(node_bbox, border_nodes, region_p45, region_m45, 2 * this.theGraphicOptions.NODE_SPACE, 2 * this.theGraphicOptions.NODE_SPACE + this.theGraphicOptions.NODE_SIZE);
        }
        Union<Residue> ex_nodes = new Union<Residue>((Collection<Residue>)region_0).and(region_m45).and(region_p45).and(border_nodes);
        bboxManager.alignCentersOnRight(node_bbox, ex_nodes, region_m90, region_m90, this.theGraphicOptions.NODE_SPACE);
        bboxManager.alignCentersOnLeft(node_bbox, ex_nodes, region_p90, region_p90, this.theGraphicOptions.NODE_SPACE);
        Union<Residue> all_nodes = ex_nodes.and(region_m90).and(region_p90).and(node);
        bboxManager.setCurrent(node, node_bbox);
        bboxManager.setBorder(node, border_bbox);
        bboxManager.setComplete(node, bboxManager.getComplete(all_nodes));
        if (node.hasChildren()) {
            bboxManager.setSupport(node, new Rectangle(Geometry.midx(node_bbox), Geometry.midy(node_bbox) + this.theGraphicOptions.NODE_SPACE + this.theGraphicOptions.NODE_SIZE, 0, 0));
        }
        Iterator<Linkage> i = node.iterator();
        while (i.hasNext()) {
            bboxManager.setParent(i.next().getChildResidue(), node_bbox);
        }
    }

    private void computeBoundingBoxesBT(Residue node, PositionManager posManager, BBoxManager bboxManager) throws Exception {
        if (node == null) {
            return;
        }
        Rectangle node_bbox = this.theResidueRenderer.computeBoundingBox(node, posManager.isOnBorder(node), 0, 0, posManager.getOrientation(node), this.theGraphicOptions.NODE_SIZE, Integer.MAX_VALUE);
        bboxManager.setAllBBoxes(node, node_bbox);
        Vector<Residue> region_m90b = posManager.getChildrenAtPosition(node, new ResAngle(-90), true);
        for (int i = 0; i < region_m90b.size(); ++i) {
            this.computeBoundingBoxes(region_m90b.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignRightsOnTop(region_m90b.subList(0, i), region_m90b.subList(i, i + 1), this.theGraphicOptions.NODE_SUB_SPACE);
        }
        Vector<Residue> region_p90b = posManager.getChildrenAtPosition(node, new ResAngle(90), true);
        for (int i = 0; i < region_p90b.size(); ++i) {
            this.computeBoundingBoxes(region_p90b.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignLeftsOnBottom(region_p90b.subList(0, i), region_p90b.subList(i, i + 1), this.theGraphicOptions.NODE_SUB_SPACE);
        }
        Vector<Residue> region_m90 = posManager.getChildrenAtPosition(node, new ResAngle(-90), false);
        for (int i = 0; i < region_m90.size(); ++i) {
            this.computeBoundingBoxes(region_m90.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignRightsOnTop(region_m90.subList(0, i), region_m90.subList(i, i + 1), this.theGraphicOptions.NODE_SPACE);
        }
        Vector<Residue> region_p90 = posManager.getChildrenAtPosition(node, new ResAngle(90), false);
        for (int i = 0; i < region_p90.size(); ++i) {
            this.computeBoundingBoxes(region_p90.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignLeftsOnBottom(region_p90.subList(0, i), region_p90.subList(i, i + 1), this.theGraphicOptions.NODE_SPACE);
        }
        Vector<Residue> region_0 = posManager.getChildrenAtPosition(node, new ResAngle(0));
        for (int i = 0; i < region_0.size(); ++i) {
            this.computeBoundingBoxes(region_0.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignBottomsOnRight(region_0.subList(0, i), region_0.subList(i, i + 1), this.theGraphicOptions.NODE_SPACE);
        }
        Vector<Residue> region_m45 = posManager.getChildrenAtPosition(node, new ResAngle(-45));
        for (int i = 0; i < region_m45.size(); ++i) {
            this.computeBoundingBoxes(region_m45.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignBottomsOnRight(region_m45.subList(0, i), region_m45.subList(i, i + 1), this.theGraphicOptions.NODE_SPACE);
        }
        Vector<Residue> region_p45 = posManager.getChildrenAtPosition(node, new ResAngle(45));
        for (int i = 0; i < region_p45.size(); ++i) {
            this.computeBoundingBoxes(region_p45.elementAt(i), posManager, bboxManager);
            if (i <= 0) continue;
            bboxManager.alignBottomsOnRight(region_p45.subList(0, i), region_p45.subList(i, i + 1), this.theGraphicOptions.NODE_SPACE);
        }
        bboxManager.alignCentersOnLeft(node_bbox, region_m90b, this.theGraphicOptions.NODE_SUB_SPACE);
        bboxManager.alignCentersOnRight(node_bbox, region_p90b, this.theGraphicOptions.NODE_SUB_SPACE);
        Union<Residue> border_nodes = new Union<Residue>((Collection<Residue>)region_m90b).and(region_p90b);
        Rectangle border_bbox = bboxManager.getComplete(border_nodes.and(node));
        if (region_0.size() > 0) {
            bboxManager.alignBottomsOnLeft(region_0, region_m45, this.theGraphicOptions.NODE_SPACE);
            bboxManager.alignBottomsOnRight(region_0, new Union<Residue>((Collection<Residue>)region_0).and(region_m45), region_p45, region_p45, this.theGraphicOptions.NODE_SPACE);
            bboxManager.alignCentersOnTop(node_bbox, border_nodes, region_0, new Union<Residue>((Collection<Residue>)region_0).and(region_m45).and(region_p45), this.theGraphicOptions.NODE_SPACE);
        } else if (region_m45.size() == 0) {
            bboxManager.alignCornersOnTopAtRight(node_bbox, border_nodes, region_p45, this.theGraphicOptions.NODE_SPACE, this.theGraphicOptions.NODE_SPACE);
        } else if (region_p45.size() == 0) {
            bboxManager.alignCornersOnTopAtLeft(node_bbox, border_nodes, region_m45, this.theGraphicOptions.NODE_SPACE, this.theGraphicOptions.NODE_SPACE);
        } else {
            bboxManager.alignSymmetricOnTop(node_bbox, border_nodes, region_m45, region_p45, this.theGraphicOptions.NODE_SPACE, 2 * this.theGraphicOptions.NODE_SPACE + this.theGraphicOptions.NODE_SIZE);
        }
        Union<Residue> ex_nodes = new Union<Residue>((Collection<Residue>)region_0).and(region_m45).and(region_p45).and(border_nodes);
        bboxManager.alignCentersOnLeft(node_bbox, ex_nodes, region_m90, region_m90, this.theGraphicOptions.NODE_SPACE);
        bboxManager.alignCentersOnRight(node_bbox, ex_nodes, region_p90, region_p90, this.theGraphicOptions.NODE_SPACE);
        Union<Residue> all_nodes = ex_nodes.and(region_m90).and(region_p90).and(node);
        bboxManager.setCurrent(node, node_bbox);
        bboxManager.setBorder(node, border_bbox);
        bboxManager.setComplete(node, bboxManager.getComplete(all_nodes));
        if (node.hasChildren()) {
            bboxManager.setSupport(node, new Rectangle(Geometry.midx(node_bbox), Geometry.midy(node_bbox) - this.theGraphicOptions.NODE_SPACE - this.theGraphicOptions.NODE_SIZE, 0, 0));
        }
        Iterator<Linkage> i = node.iterator();
        while (i.hasNext()) {
            bboxManager.setParent(i.next().getChildResidue(), node_bbox);
        }
    }

    private void computeBoundingBoxesBracket(Residue bracket, Residue root, boolean collapse_multiple_antennae, PositionManager posManager, BBoxManager bboxManager) throws Exception {
        if (bracket == null || root == null) {
            return;
        }
        ResAngle orientation = posManager.getOrientation(bracket);
        if (orientation.equals(0)) {
            this.computeBoundingBoxesBracketLR(bracket, root, collapse_multiple_antennae, posManager, bboxManager);
        } else if (orientation.equals(180)) {
            this.computeBoundingBoxesBracketRL(bracket, root, collapse_multiple_antennae, posManager, bboxManager);
        } else if (orientation.equals(90)) {
            this.computeBoundingBoxesBracketTB(bracket, root, collapse_multiple_antennae, posManager, bboxManager);
        } else if (orientation.equals(-90)) {
            this.computeBoundingBoxesBracketBT(bracket, root, collapse_multiple_antennae, posManager, bboxManager);
        } else {
            throw new Exception("Invalid orientation " + orientation);
        }
    }

    private void computeBoundingBoxesBracketLR(Residue bracket, Residue root, boolean collapse_multiple_antennae, PositionManager posManager, BBoxManager bboxManager) throws Exception {
        if (bracket == null || root == null) {
            return;
        }
        ResAngle orientation = posManager.getOrientation(bracket);
        int id = 0;
        int max_quantity = 1;
        Vector<Residue> antennae = new Vector<Residue>();
        TreeMap<String, Pair<Residue, Integer>> unique_antennae = new TreeMap<String, Pair<Residue, Integer>>();
        for (int i = 0; i < bracket.getNoChildren(); ++i) {
            Residue child = bracket.getChildAt(i);
            String child_str = collapse_multiple_antennae ? GWSParser.writeSubtree(child, false) : "" + id++;
            Pair value = (Pair)unique_antennae.get(child_str);
            if (value == null) {
                Residue antenna = child;
                if (!posManager.isOnBorder(antenna)) {
                    antenna = ResidueDictionary.newResidue("#attach");
                    child.insertParent(antenna);
                    posManager.add(antenna, orientation, new ResAngle(), false, true);
                }
                this.computeBoundingBoxesLR(antenna, posManager, bboxManager);
                if (antennae.size() > 0) {
                    bboxManager.alignLeftsOnBottom(antennae.lastElement(), antenna, this.theGraphicOptions.NODE_SPACE);
                }
                antennae.add(antenna);
                unique_antennae.put(child_str, new Pair<Residue, Integer>(child, 1));
                continue;
            }
            bboxManager.linkSubtrees((Residue)value.getFirst(), child);
            int new_quantity = (Integer)value.getSecond() + 1;
            unique_antennae.put(child_str, new Pair(value.getFirst(), new_quantity));
            max_quantity = Math.max(max_quantity, new_quantity);
        }
        Rectangle structure_bbox = new Rectangle(bboxManager.getComplete(root));
        Rectangle bracket_bbox = new Rectangle(Geometry.right(structure_bbox), Geometry.top(structure_bbox), this.theGraphicOptions.NODE_SIZE, structure_bbox.height);
        if (antennae.size() > 0) {
            bboxManager.alignCentersOnRight(bracket_bbox, antennae, 0);
        }
        Rectangle antennae_bbox = antennae.size() > 0 ? new Rectangle(bboxManager.getComplete(antennae)) : null;
        Rectangle all_bbox = Geometry.union(bracket_bbox, antennae_bbox);
        if (max_quantity > 1) {
            Dimension quantity_text_dim = Geometry.textBounds(max_quantity + "x", this.theGraphicOptions.NODE_FONT_FACE, this.theGraphicOptions.NODE_FONT_SIZE);
            all_bbox.width += quantity_text_dim.width + 2;
        }
        for (Residue antenna : antennae) {
            if (posManager.isOnBorder(antenna)) continue;
            bracket.removeChild(antenna);
        }
        bboxManager.setParent(bracket, structure_bbox);
        bboxManager.setCurrent(bracket, bracket_bbox);
        bboxManager.setBorder(bracket, bracket_bbox);
        bboxManager.setComplete(bracket, all_bbox);
        bboxManager.setSupport(bracket, bracket_bbox);
    }

    private void computeBoundingBoxesBracketRL(Residue bracket, Residue root, boolean collapse_multiple_antennae, PositionManager posManager, BBoxManager bboxManager) throws Exception {
        if (bracket == null || root == null) {
            return;
        }
        ResAngle orientation = posManager.getOrientation(bracket);
        int id = 0;
        int max_quantity = 1;
        Vector<Residue> antennae = new Vector<Residue>();
        TreeMap<String, Pair<Residue, Integer>> unique_antennae = new TreeMap<String, Pair<Residue, Integer>>();
        for (int i = 0; i < bracket.getNoChildren(); ++i) {
            Residue child = bracket.getChildAt(i);
            String child_str = collapse_multiple_antennae ? GWSParser.writeSubtree(child, false) : "" + id++;
            Pair value = (Pair)unique_antennae.get(child_str);
            if (value == null) {
                Residue antenna = child;
                if (!posManager.isOnBorder(antenna)) {
                    antenna = ResidueDictionary.newResidue("#attach");
                    child.insertParent(antenna);
                    posManager.add(antenna, orientation, new ResAngle(), false, true);
                }
                this.computeBoundingBoxesRL(antenna, posManager, bboxManager);
                if (antennae.size() > 0) {
                    bboxManager.alignRightsOnTop(antennae.lastElement(), antenna, this.theGraphicOptions.NODE_SPACE);
                }
                antennae.add(antenna);
                unique_antennae.put(child_str, new Pair<Residue, Integer>(child, 1));
                continue;
            }
            bboxManager.linkSubtrees((Residue)value.getFirst(), child);
            int new_quantity = (Integer)value.getSecond() + 1;
            unique_antennae.put(child_str, new Pair(value.getFirst(), new_quantity));
            max_quantity = Math.max(max_quantity, new_quantity);
        }
        Rectangle structure_bbox = new Rectangle(bboxManager.getComplete(root));
        Rectangle bracket_bbox = new Rectangle(Geometry.left(structure_bbox) - this.theGraphicOptions.NODE_SIZE, Geometry.top(structure_bbox), this.theGraphicOptions.NODE_SIZE, structure_bbox.height);
        if (antennae.size() > 0) {
            bboxManager.alignCentersOnLeft(bracket_bbox, antennae, 0);
        }
        Rectangle antennae_bbox = antennae.size() > 0 ? new Rectangle(bboxManager.getComplete(antennae)) : null;
        Rectangle all_bbox = Geometry.union(bracket_bbox, antennae_bbox);
        if (max_quantity > 1) {
            Dimension quantity_text_dim = Geometry.textBounds(max_quantity + "x", this.theGraphicOptions.NODE_FONT_FACE, this.theGraphicOptions.NODE_FONT_SIZE);
            all_bbox.x -= quantity_text_dim.width + 2;
            all_bbox.width += quantity_text_dim.width + 2;
        }
        for (Residue antenna : antennae) {
            if (posManager.isOnBorder(antenna)) continue;
            bracket.removeChild(antenna);
        }
        bboxManager.setParent(bracket, structure_bbox);
        bboxManager.setCurrent(bracket, bracket_bbox);
        bboxManager.setBorder(bracket, bracket_bbox);
        bboxManager.setComplete(bracket, all_bbox);
        bboxManager.setSupport(bracket, bracket_bbox);
    }

    private void computeBoundingBoxesBracketTB(Residue bracket, Residue root, boolean collapse_multiple_antennae, PositionManager posManager, BBoxManager bboxManager) throws Exception {
        if (bracket == null || root == null) {
            return;
        }
        ResAngle orientation = posManager.getOrientation(bracket);
        int id = 0;
        int max_quantity = 1;
        Vector<Residue> antennae = new Vector<Residue>();
        TreeMap<String, Pair<Residue, Integer>> unique_antennae = new TreeMap<String, Pair<Residue, Integer>>();
        for (int i = 0; i < bracket.getNoChildren(); ++i) {
            Residue child = bracket.getChildAt(i);
            String child_str = collapse_multiple_antennae ? GWSParser.writeSubtree(child, false) : "" + id++;
            Pair value = (Pair)unique_antennae.get(child_str);
            if (value == null) {
                Residue antenna = child;
                if (!posManager.isOnBorder(antenna)) {
                    antenna = ResidueDictionary.newResidue("#attach");
                    child.insertParent(antenna);
                    posManager.add(antenna, orientation, new ResAngle(), false, true);
                }
                this.computeBoundingBoxesTB(antenna, posManager, bboxManager);
                if (antennae.size() > 0) {
                    bboxManager.alignBottomsOnLeft(antennae.lastElement(), antenna, this.theGraphicOptions.NODE_SPACE);
                }
                antennae.add(antenna);
                unique_antennae.put(child_str, new Pair<Residue, Integer>(child, 1));
                continue;
            }
            bboxManager.linkSubtrees((Residue)value.getFirst(), child);
            int new_quantity = (Integer)value.getSecond() + 1;
            unique_antennae.put(child_str, new Pair(value.getFirst(), new_quantity));
            max_quantity = Math.max(max_quantity, new_quantity);
        }
        Rectangle structure_bbox = new Rectangle(bboxManager.getComplete(root));
        Rectangle bracket_bbox = new Rectangle(Geometry.left(structure_bbox), Geometry.bottom(structure_bbox), Geometry.width(structure_bbox), this.theGraphicOptions.NODE_SIZE);
        if (antennae.size() > 0) {
            bboxManager.alignCentersOnBottom(bracket_bbox, antennae, 0);
        }
        Rectangle antennae_bbox = antennae.size() > 0 ? new Rectangle(bboxManager.getComplete(antennae)) : null;
        Rectangle all_bbox = Geometry.union(bracket_bbox, antennae_bbox);
        if (max_quantity > 1) {
            Dimension quantity_text_dim = Geometry.textBounds(max_quantity + "x", this.theGraphicOptions.NODE_FONT_FACE, this.theGraphicOptions.NODE_FONT_SIZE);
            all_bbox.height += quantity_text_dim.width + 2;
        }
        for (Residue antenna : antennae) {
            if (posManager.isOnBorder(antenna)) continue;
            bracket.removeChild(antenna);
        }
        bboxManager.setParent(bracket, structure_bbox);
        bboxManager.setCurrent(bracket, bracket_bbox);
        bboxManager.setBorder(bracket, bracket_bbox);
        bboxManager.setComplete(bracket, all_bbox);
        bboxManager.setSupport(bracket, bracket_bbox);
    }

    private void computeBoundingBoxesBracketBT(Residue bracket, Residue root, boolean collapse_multiple_antennae, PositionManager posManager, BBoxManager bboxManager) throws Exception {
        if (bracket == null || root == null) {
            return;
        }
        ResAngle orientation = posManager.getOrientation(bracket);
        int id = 0;
        int max_quantity = 1;
        Vector<Residue> antennae = new Vector<Residue>();
        TreeMap<String, Pair<Residue, Integer>> unique_antennae = new TreeMap<String, Pair<Residue, Integer>>();
        for (int i = 0; i < bracket.getNoChildren(); ++i) {
            Residue child = bracket.getChildAt(i);
            String child_str = collapse_multiple_antennae ? GWSParser.writeSubtree(child, false) : "" + id++;
            Pair value = (Pair)unique_antennae.get(child_str);
            if (value == null) {
                Residue antenna = child;
                if (!posManager.isOnBorder(antenna)) {
                    antenna = ResidueDictionary.newResidue("#attach");
                    child.insertParent(antenna);
                    posManager.add(antenna, orientation, new ResAngle(), false, true);
                }
                this.computeBoundingBoxesBT(antenna, posManager, bboxManager);
                if (antennae.size() > 0) {
                    bboxManager.alignTopsOnRight(antennae.lastElement(), antenna, this.theGraphicOptions.NODE_SPACE);
                }
                antennae.add(antenna);
                unique_antennae.put(child_str, new Pair<Residue, Integer>(child, 1));
                continue;
            }
            bboxManager.linkSubtrees((Residue)value.getFirst(), child);
            int new_quantity = (Integer)value.getSecond() + 1;
            unique_antennae.put(child_str, new Pair(value.getFirst(), new_quantity));
            max_quantity = Math.max(max_quantity, new_quantity);
        }
        Rectangle structure_bbox = new Rectangle(bboxManager.getComplete(root));
        Rectangle bracket_bbox = new Rectangle(Geometry.left(structure_bbox), Geometry.top(structure_bbox) - this.theGraphicOptions.NODE_SIZE, Geometry.width(structure_bbox), this.theGraphicOptions.NODE_SIZE);
        if (antennae.size() > 0) {
            bboxManager.alignCentersOnTop(bracket_bbox, antennae, 0);
        }
        Rectangle antennae_bbox = antennae.size() > 0 ? new Rectangle(bboxManager.getComplete(antennae)) : null;
        Rectangle all_bbox = Geometry.union(bracket_bbox, antennae_bbox);
        if (max_quantity > 1) {
            Dimension quantity_text_dim = Geometry.textBounds(max_quantity + "x", this.theGraphicOptions.NODE_FONT_FACE, this.theGraphicOptions.NODE_FONT_SIZE);
            all_bbox.y -= quantity_text_dim.width + 2;
            all_bbox.height += quantity_text_dim.width + 2;
        }
        for (Residue antenna : antennae) {
            if (posManager.isOnBorder(antenna)) continue;
            bracket.removeChild(antenna);
        }
        bboxManager.setParent(bracket, structure_bbox);
        bboxManager.setCurrent(bracket, bracket_bbox);
        bboxManager.setBorder(bracket, bracket_bbox);
        bboxManager.setComplete(bracket, all_bbox);
        bboxManager.setSupport(bracket, bracket_bbox);
    }

    protected void paintBracket(Paintable paintable, Residue bracket, HashSet<Residue> selected_residues, HashSet<Linkage> selected_linkages, Collection<Residue> active_residues, PositionManager posManager, BBoxManager bboxManager) {
        if (bracket == null) {
            return;
        }
        Rectangle parent_bbox = bboxManager.getParent(bracket);
        Rectangle bracket_bbox = bboxManager.getCurrent(bracket);
        Rectangle support_bbox = bboxManager.getSupport(bracket);
        boolean selected = selected_residues.contains(bracket);
        boolean active = active_residues == null || active_residues.contains(bracket);
        this.theResidueRenderer.paint(paintable, bracket, selected, active, false, parent_bbox, bracket_bbox, support_bbox, posManager.getOrientation(bracket));
        for (Linkage link : bracket.getChildrenLinkages()) {
            Residue child = link.getChildResidue();
            int quantity = bboxManager.getLinkedResidues(child).size() + 1;
            Rectangle node_bbox = bboxManager.getParent(child);
            Rectangle child_bbox = bboxManager.getCurrent(child);
            Rectangle child_border_bbox = bboxManager.getBorder(child);
            if (child_bbox == null) continue;
            if (!posManager.isOnBorder(child)) {
                selected = selected_residues.contains(bracket) && selected_residues.contains(child) || selected_linkages.contains(link);
                active = active_residues == null || active_residues.contains(bracket) && active_residues.contains(child);
                this.theLinkageRenderer.paintEdge(paintable, link, selected, node_bbox, node_bbox, child_bbox, child_border_bbox);
            }
            this.paintResidue(paintable, child, selected_residues, selected_linkages, active_residues, posManager, bboxManager);
            if (!posManager.isOnBorder(child)) {
                this.theLinkageRenderer.paintInfo(paintable, link, node_bbox, node_bbox, child_bbox, child_border_bbox);
            }
            if (quantity <= 1) continue;
            this.paintQuantity(paintable, child, quantity, bboxManager);
        }
    }

    @Override
    public BufferedImage getImage(Glycan structure, boolean opaque, boolean show_masses, boolean show_redend) {
        Vector<Glycan> structures = new Vector<Glycan>();
        if (structure != null) {
            structures.add(structure);
        }
        return this.getImage(structures, opaque, show_masses, show_redend, 1.0);
    }

    @Override
    public BufferedImage getImage(Glycan structure, boolean opaque, boolean show_masses, boolean show_redend, double scale) {
        Vector<Glycan> structures = new Vector<Glycan>();
        if (structure != null) {
            structures.add(structure);
        }
        return this.getImage(structures, opaque, show_masses, show_redend, scale);
    }

    @Override
    public BufferedImage getImage(Collection<Glycan> structures, boolean opaque, boolean show_masses, boolean show_redend) {
        return this.getImage(structures, opaque, show_masses, show_redend, 1.0);
    }

    @Override
    public BufferedImage getImage(Collection<Glycan> structures, boolean opaque, boolean show_masses, boolean show_redend, double scale) {
        return this.getImage(structures, opaque, show_masses, show_redend, scale, new PositionManager(), new BBoxManager());
    }

    @Override
    public abstract BufferedImage getImage(Collection<Glycan> var1, boolean var2, boolean var3, boolean var4, double var5, PositionManager var7, BBoxManager var8);
}

