/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eurocarbdb.MolecularFramework.io.GlycoCT.SugarExporterGlycoCT;
import org.eurocarbdb.MolecularFramework.io.GlycoCT.SugarImporterGlycoCT;
import org.eurocarbdb.MolecularFramework.io.namespace.GlycoVisitorFromGlycoCT;
import org.eurocarbdb.MolecularFramework.io.namespace.GlycoVisitorToGlycoCT;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.NonMonosaccharides.HistoricalEntity;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitRepeat;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.eurocarbdb.MolecularFramework.sugar.UnvalidatedGlycoNode;
import org.eurocarbdb.application.glycanbuilder.BBoxManager;
import org.eurocarbdb.application.glycanbuilder.Bond;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanParser;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbMonosaccharide;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConversion;
import org.eurocarbdb.resourcesdb.io.MonosaccharideConverter;
import org.eurocarbdb.resourcesdb.io.MonosaccharideExchangeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlycoCTParser
implements GlycanParser {
    private static Pattern iupac_sub_pattern = Pattern.compile("^(.+)(\\-?[1-9][a-zA-Z]+)$");
    private SugarImporterGlycoCT importer = null;
    private SugarExporterGlycoCT exporter = null;
    private MonosaccharideConverter converter = null;
    private GlycoVisitorFromGlycoCT visitor_import = null;
    private GlycoVisitorToGlycoCT visitor_export = null;
    private boolean tolerate_unknown_residues = false;

    public GlycoCTParser(boolean tolerate) {
        try {
            this.tolerate_unknown_residues = tolerate;
            this.importer = new SugarImporterGlycoCT();
            this.exporter = new SugarExporterGlycoCT();
            this.converter = new MonosaccharideConverter(new Config());
            this.visitor_import = new GlycoVisitorFromGlycoCT((MonosaccharideConversion)this.converter);
            this.visitor_import.setNameScheme(GlycanNamescheme.GWB);
            this.visitor_export = new GlycoVisitorToGlycoCT((MonosaccharideConversion)this.converter);
            this.visitor_export.setNameScheme(GlycanNamescheme.GWB);
            this.visitor_export.setUseFusion(true);
        }
        catch (Exception e) {
            LogUtils.report(e);
        }
    }

    @Override
    public void setTolerateUnknown(boolean f) {
        this.tolerate_unknown_residues = f;
    }

    @Override
    public String writeGlycan(Glycan structure) {
        return this.toGlycoCT(structure);
    }

    @Override
    public Glycan readGlycan(String buffer, MassOptions default_mass_options) throws Exception {
        return this.fromGlycoCT(buffer, default_mass_options);
    }

    public SugarImporterGlycoCT getImporter() {
        return this.importer;
    }

    public SugarExporterGlycoCT getExporter() {
        return this.exporter;
    }

    public MonosaccharideConverter getConverter() {
        return this.converter;
    }

    public GlycoVisitorFromGlycoCT getVisitorImport() {
        return this.visitor_import;
    }

    public GlycoVisitorToGlycoCT getVisitorExport() {
        return this.visitor_export;
    }

    public String toGlycoCT(Glycan structure) {
        return this.toGlycoCT(structure, null);
    }

    public String toGlycoCT(Glycan structure, BBoxManager manager) {
        try {
            this.exporter.start(this.toSugar(structure, manager));
            return this.exporter.getXMLCode();
        }
        catch (Exception e) {
            LogUtils.report(e);
            return "";
        }
    }

    public Sugar toSugar(Glycan structure, BBoxManager manager) throws Exception {
        Sugar sugar = new Sugar();
        if (structure == null) {
            return sugar;
        }
        if (structure.isFragment()) {
            throw new Exception("fragments not supported for the moment");
        }
        if (structure.getRoot() != null) {
            Residue root = structure.getRoot();
            if (!root.isSaccharide()) {
                if (root.getTypeName().equals("freeEnd")) {
                    this.toSugar(root.firstChild(), (GlycoGraph)sugar, false, null, null, manager);
                } else if (root.getTypeName().equals("redEnd")) {
                    this.toSugar(root.firstChild(), (GlycoGraph)sugar, true, null, null, manager);
                } else {
                    this.toSugar(root.firstChild(), (GlycoGraph)sugar, false, null, null, manager);
                }
            } else {
                this.toSugar(root, (GlycoGraph)sugar, false, null, null, manager);
            }
        }
        if (structure.getBracket() != null) {
            ArrayList parents = (ArrayList)sugar.getNodes().clone();
            for (Linkage link : structure.getBracket().getChildrenLinkages()) {
                Residue antenna = link.getChildResidue();
                UnderdeterminedSubTree nm_antenna = new UnderdeterminedSubTree();
                this.toSugar(antenna, (GlycoGraph)nm_antenna, false, null, null, manager);
                nm_antenna.setConnection(this.toSugar(link));
                sugar.addUndeterminedSubTree(nm_antenna);
                for (GlycoNode n : parents) {
                    sugar.addUndeterminedSubTreeParent(nm_antenna, n);
                }
            }
        }
        this.visitor_export.start(sugar);
        return this.visitor_export.getNormalizedSugar();
    }

    private GlycoNode toSugar(Residue current, GlycoGraph nm_graph, boolean alditol, Residue stop_at, HashMap<Residue, GlycoNode> map, BBoxManager bboxManager) throws Exception {
        if (nm_graph == null) {
            return null;
        }
        if (current == stop_at) {
            return null;
        }
        Residue parent = null;
        SugarUnitRepeat nm_current = null;
        if (current.isStartRepetition()) {
            nm_current = this.toSugarUnitRepeat(current, bboxManager);
            parent = current.findEndRepetition();
        } else {
            UnvalidatedGlycoNode toadd = new UnvalidatedGlycoNode();
            toadd.setName(this.getIupacName(current, alditol));
            if (bboxManager != null && bboxManager.border_bboxes.containsKey(current)) {
                toadd.setCenterPosition(bboxManager.border_bboxes.get(current));
            }
            nm_current = toadd;
            parent = current;
        }
        nm_graph.addNode((GlycoNode)nm_current);
        if (map != null) {
            map.put(current, (GlycoNode)nm_current);
        }
        for (Linkage link : parent.getChildrenLinkages()) {
            GlycoNode nm_child = this.toSugar(link.getChildResidue(), nm_graph, false, stop_at, map, bboxManager);
            if (nm_child == null) continue;
            nm_graph.addEdge((GlycoNode)nm_current, nm_child, this.toSugar(link));
        }
        return nm_current;
    }

    private SugarUnitRepeat toSugarUnitRepeat(Residue start, BBoxManager manager) throws Exception {
        SugarUnitRepeat unit = new SugarUnitRepeat();
        Residue root = start.getChildAt(0);
        Residue end = start.findEndRepetition();
        HashMap<Residue, GlycoNode> map = new HashMap<Residue, GlycoNode>();
        this.toSugar(root, (GlycoGraph)unit, false, end, map, manager);
        unit.setMinRepeatCount(end.getMinRepetitions());
        unit.setMaxRepeatCount(end.getMaxRepetitions());
        unit.setRepeatLinkage(this.toSugar(root.getParentLinkage()), map.get(end.getParent()), map.get(root));
        return unit;
    }

    public Glycan fromGlycoCT(String str, MassOptions default_mass_opt) throws Exception {
        return this.fromSugar(this.importer.parse(str), default_mass_opt);
    }

    public Glycan fromSugar(Sugar sugar, MassOptions default_mass_opt) throws Exception {
        return GlycoCTParser.fromSugar(sugar, (MonosaccharideConversion)this.converter, this.visitor_import, default_mass_opt, this.tolerate_unknown_residues);
    }

    public static Glycan fromSugar(Sugar sugar, MonosaccharideConversion converter, GlycoVisitorFromGlycoCT visitor, MassOptions default_mass_opt, boolean tolerate_unknown_residues) throws Exception {
        GlycoNode gn_root;
        if (sugar == null) {
            return null;
        }
        if (sugar.getRootNodes().size() == 1 && (gn_root = (GlycoNode)sugar.getRootNodes().iterator().next()) instanceof HistoricalEntity) {
            sugar.removeNode(gn_root);
        }
        visitor.start(sugar);
        sugar = visitor.getNormalizedSugar();
        if (sugar.getRootNodes().size() > 1) {
            throw new Exception("Multiple roots are not currently supported");
        }
        if (sugar.getRootNodes().size() == 0) {
            return new Glycan(null, false, default_mass_opt);
        }
        gn_root = (GlycoNode)sugar.getRootNodes().iterator().next();
        Residue root = GlycoCTParser.fromSugar(gn_root, converter, tolerate_unknown_residues, null);
        if (root != null && !root.isReducingEnd()) {
            Residue redend;
            if (root.isAlditol()) {
                redend = ResidueDictionary.newResidue("redEnd");
                redend.addChild(root);
                root = redend;
            } else {
                redend = ResidueDictionary.newResidue("freeEnd");
                redend.addChild(root);
                root = redend;
            }
        }
        Glycan ret = new Glycan(root, false, default_mass_opt);
        for (UnderdeterminedSubTree antenna : sugar.getUndeterminedSubTrees()) {
            if (antenna.getRootNodes().size() > 1) {
                throw new Exception("Multiple roots in antenna are not currently supported");
            }
            if (antenna.getRootNodes().size() == 0) continue;
            GlycoNode antenna_root = (GlycoNode)antenna.getRootNodes().iterator().next();
            Residue toadd = GlycoCTParser.fromSugar(antenna_root, converter, tolerate_unknown_residues, null);
            Vector<Bond> bonds = GlycoCTParser.fromSugar(antenna.getConnection());
            ret.addAntenna(toadd, bonds);
        }
        return ret;
    }

    private static Residue fromSugar(GlycoNode nm_current, MonosaccharideConversion converter, boolean tolerate_unknown_residues, HashMap<GlycoNode, Residue> map) throws Exception {
        if (nm_current == null) {
            return null;
        }
        Residue ret = null;
        Residue parent = null;
        if (nm_current instanceof SugarUnitRepeat) {
            ret = GlycoCTParser.fromSugarUnitRepeat((SugarUnitRepeat)nm_current, converter, tolerate_unknown_residues);
            parent = ret.findEndRepetition();
            if (map != null) {
                map.put(nm_current, ret);
            }
        } else {
            String iupac_name = ((UnvalidatedGlycoNode)nm_current).getName();
            Residue current = GlycoCTParser.fromIupacName(iupac_name, converter, converter == null);
            if (current == null) {
                Vector<String> subs = new Vector<String>();
                current = GlycoCTParser.fromIupacName(iupac_name = GlycoCTParser.removeSubstitutions(subs, iupac_name), converter, tolerate_unknown_residues);
                if (current == null) {
                    throw new Exception("Unrecognized residue type: " + iupac_name + " " + tolerate_unknown_residues);
                }
                GlycoCTParser.addModifications(current, subs, converter, tolerate_unknown_residues);
            }
            ret = parent = current;
            if (map != null) {
                map.put(nm_current, current);
            }
        }
        for (GlycoEdge edge : nm_current.getChildEdges()) {
            Residue child = GlycoCTParser.fromSugar(edge.getChild(), converter, tolerate_unknown_residues, map);
            Vector<Bond> bonds = GlycoCTParser.fromSugar(edge);
            parent.addChild(child, bonds);
            child.setAnomericCarbon(bonds.lastElement().getChildPosition());
        }
        return ret;
    }

    private static Residue fromSugarUnitRepeat(SugarUnitRepeat unit, MonosaccharideConversion converter, boolean tolerate_unknown_residues) throws Exception {
        if (unit.getRootNodes().size() > 1) {
            throw new Exception("Multiple roots are not currently supported in repeat units");
        }
        GlycoNode gn_root = (GlycoNode)unit.getRootNodes().iterator().next();
        HashMap<GlycoNode, Residue> map = new HashMap<GlycoNode, Residue>();
        Residue root = GlycoCTParser.fromSugar(gn_root, converter, tolerate_unknown_residues, map);
        Residue start = ResidueDictionary.createStartRepetition();
        start.addChild(root, GlycoCTParser.fromSugar(unit.getRepeatLinkage()));
        Residue end = ResidueDictionary.createEndRepetition();
        end.setMinRepetitions("" + unit.getMinRepeatCount());
        end.setMaxRepetitions("" + unit.getMaxRepeatCount());
        start.setEndRepitionResidue(end);
        Residue last = map.get(unit.getRepeatLinkage().getParent());
        last.addChild(end);
        return start;
    }

    private static String removeSubstitutions(Vector<String> subs, String iupac_name) throws Exception {
        Matcher m;
        while (iupac_name.length() > 0 && (m = iupac_sub_pattern.matcher(iupac_name)).matches()) {
            iupac_name = m.group(1);
            subs.add(m.group(2));
        }
        return iupac_name;
    }

    private static void addModifications(Residue current, Vector<String> children_iupac_names, MonosaccharideConversion converter, boolean tolerate_unknown_residues) throws Exception {
        for (String s : children_iupac_names) {
            char pos = s.charAt(0);
            String type = s.substring(1);
            Residue child = GlycoCTParser.fromIupacName(type, converter, tolerate_unknown_residues);
            if (child == null) {
                throw new Exception("Unrecognized residue type: " + type);
            }
            current.addChild(child, pos);
        }
    }

    public String getIupacName(Residue current, boolean alditol) throws Exception {
        if (!current.getType().hasIupacName()) {
            throw new Exception("Unsupported IUPAC name for type " + current.getTypeName());
        }
        return GlycoCTParser.getIupacName(current.getType(), alditol, current.getAnomericCarbon(), current.getAnomericState(), current.getChirality(), current.getRingSize());
    }

    private static String getIupacName(ResidueType type, boolean alditol, char anomeric_carbon, char anomeric_state, char chirality, char ring_size) {
        String iupac_name = type.getIupacName();
        if (type.isSaccharide()) {
            if (type.hasChirality()) {
                iupac_name = chirality + "-" + iupac_name;
            }
            if (alditol) {
                return TextUtils.delete(iupac_name, '$') + "-ol";
            }
            iupac_name = anomeric_state + "-" + iupac_name;
            if (ring_size == 'o') {
                if (anomeric_carbon == '2') {
                    return "keto-" + TextUtils.delete(iupac_name, '$');
                }
                return "aldehydo-" + TextUtils.delete(iupac_name, '$');
            }
            if (ring_size == '?') {
                return TextUtils.delete(iupac_name, '$');
            }
            return iupac_name.replace('$', ring_size);
        }
        return iupac_name;
    }

    private static Residue fromIupacName(String iupac_name, MonosaccharideConversion converter, boolean tolerate_unknown_residues) throws Exception {
        if (converter == null) {
            if (tolerate_unknown_residues) {
                return new Residue(ResidueType.createSaccharide(iupac_name));
            }
            throw new Exception("Cannot convert iupac name to residue");
        }
        EcdbMonosaccharide type = null;
        try {
            MonosaccharideExchangeObject data = converter.convertResidue(iupac_name, GlycanNamescheme.GWB, GlycanNamescheme.GLYCOCT);
            type = data.getBasetype();
        }
        catch (Exception e) {
            if (tolerate_unknown_residues) {
                return new Residue(ResidueType.createSaccharide(iupac_name));
            }
            return null;
        }
        if (type != null) {
            char anomeric_state = type.getAnomer().getSymbol().charAt(0);
            if (anomeric_state == 'x') {
                anomeric_state = '?';
            }
            char ring_size = '?';
            if (type.getRingEnd() - type.getRingStart() == 4) {
                ring_size = 'p';
            } else if (type.getRingEnd() - type.getRingStart() == 3) {
                ring_size = 'f';
            } else if (type.getRingStart() == 0) {
                ring_size = 'o';
                anomeric_state = '?';
            }
            char chirality = '?';
            if (type.getBaseTypeCount() > 0 && (chirality = (char)Character.toUpperCase(type.getBaseType(0).getName().charAt(0))) == 'X') {
                chirality = '?';
            }
            for (ResidueType t : ResidueDictionary.allResidues()) {
                if (GlycoCTParser.getIupacName(t, false, t.getAnomericCarbon(), anomeric_state, chirality, ring_size).compareToIgnoreCase(iupac_name) == 0) {
                    Residue ret = new Residue(t);
                    ret.setAnomericState(anomeric_state);
                    ret.setChirality(chirality);
                    ret.setRingSize(ring_size);
                    ret.setAlditol(false);
                    return ret;
                }
                if (GlycoCTParser.getIupacName(t, true, t.getAnomericCarbon(), anomeric_state, chirality, ring_size).compareToIgnoreCase(iupac_name) != 0) continue;
                Residue ret = new Residue(t);
                ret.setAnomericState(anomeric_state);
                ret.setChirality(chirality);
                ret.setRingSize(ring_size);
                ret.setAlditol(true);
                return ret;
            }
            if (tolerate_unknown_residues) {
                Residue ret = new Residue(ResidueType.createSaccharide(iupac_name));
                ret.setAnomericState(anomeric_state);
                ret.setChirality(chirality);
                ret.setRingSize(ring_size);
                ret.setAlditol(true);
                return ret;
            }
        } else {
            for (ResidueType t : ResidueDictionary.allResidues()) {
                if (GlycoCTParser.getIupacName(t, false, '?', '?', '?', '?').compareToIgnoreCase(iupac_name) != 0) continue;
                return new Residue(t);
            }
            if (tolerate_unknown_residues) {
                return new Residue(ResidueType.createSubstituent(iupac_name));
            }
        }
        return null;
    }

    private GlycoEdge toSugar(Linkage link) throws Exception {
        GlycoEdge nm_edge = new GlycoEdge();
        for (Bond b : link.getBonds()) {
            org.eurocarbdb.MolecularFramework.sugar.Linkage nm_link = new org.eurocarbdb.MolecularFramework.sugar.Linkage();
            char[] p_poss = b.getParentPositions();
            for (int i = 0; i < p_poss.length; ++i) {
                nm_link.addParentLinkage(GlycoCTParser.toIntPosition(p_poss[i]));
            }
            nm_link.addChildLinkage(GlycoCTParser.toIntPosition(b.getChildPosition()));
            nm_edge.addGlycosidicLinkage(nm_link);
        }
        return nm_edge;
    }

    private static Vector<Bond> fromSugar(GlycoEdge nm_edge) {
        if (nm_edge.getGlycosidicLinkages().size() == 0) {
            return Bond.single();
        }
        Vector<Bond> ret = new Vector<Bond>();
        for (org.eurocarbdb.MolecularFramework.sugar.Linkage nm_link : nm_edge.getGlycosidicLinkages()) {
            ArrayList nm_ppos = nm_link.getParentLinkages();
            char[] p_poss = new char[nm_ppos.size()];
            for (int i = 0; i < nm_ppos.size(); ++i) {
                p_poss[i] = GlycoCTParser.fromIntPosition((Integer)nm_ppos.get(i));
            }
            char c_pos = nm_link.getChildLinkages().size() == 1 ? (char)GlycoCTParser.fromIntPosition((Integer)nm_link.getChildLinkages().get(0)) : (char)'?';
            ret.add(new Bond(p_poss, c_pos));
        }
        return ret;
    }

    private static char fromIntPosition(int pos) {
        if (pos == -1) {
            return '?';
        }
        return (char)(pos + 48);
    }

    private static int toIntPosition(char pos) {
        if (pos == 'N') {
            return 2;
        }
        if (pos == '?' || pos == 'N') {
            return -1;
        }
        return pos - 48;
    }

    @Override
    public String writeGlycan(Glycan structure, BBoxManager bboxManager) {
        return this.toGlycoCT(structure, bboxManager);
    }

    public Sugar toSugar(Glycan glycan) throws Exception {
        return this.toSugar(glycan, null);
    }
}

