/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.SwingWorker;
import javax.swing.event.EventListenerList;
import org.pushingpixels.flamingo.api.common.AsynchronousLoadListener;
import org.pushingpixels.flamingo.api.common.AsynchronousLoading;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

public class ImageResizableIconReducedMem
implements Icon,
AsynchronousLoading,
ResizableIcon {
    protected BufferedImage originalImage;
    protected InputStream imageInputStream;
    protected Image image;
    protected Map<String, BufferedImage> cachedImages;
    protected int width;
    protected int height;
    protected int minScale = -1;
    protected EventListenerList listenerList = new EventListenerList();
    protected static HashMap<String, ImageResizableIconReducedMem> imageCache = new HashMap();

    public void minScale(int _minScale) {
        this.minScale = _minScale;
    }

    public static ImageResizableIconReducedMem getIcon(URL location, Dimension initialDim) {
        String key = location.toString() + "-" + initialDim.getWidth() + "-" + initialDim.getHeight();
        if (imageCache.containsKey(key)) {
            if (location.toString().contains("database_annotate")) {
                System.err.println("Hit cache! " + location.toString() + "-" + initialDim.getWidth() + "-" + initialDim.getHeight());
            }
            ImageResizableIconReducedMem test = imageCache.get(key);
            ImageResizableIconReducedMem test1 = null;
            try {
                test1 = new ImageResizableIconReducedMem(location.openStream(), (int)initialDim.getWidth(), (int)initialDim.getHeight(), false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            test1.cachedImages = test.cachedImages;
            return test1;
        }
        try {
            ImageResizableIconReducedMem test = new ImageResizableIconReducedMem(location.openStream(), (int)initialDim.getWidth(), (int)initialDim.getHeight(), true);
            imageCache.put(key, test);
            return test;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public ImageResizableIconReducedMem(InputStream inputStream, int w, int h, boolean preSize) {
        this.imageInputStream = inputStream;
        this.width = w;
        this.height = h;
        this.listenerList = new EventListenerList();
        this.cachedImages = new LinkedHashMap<String, BufferedImage>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, BufferedImage> eldest) {
                return this.size() > 5;
            }
        };
        if (preSize) {
            this.presize(this.width, this.height);
        }
    }

    public ImageResizableIconReducedMem(Image image, int w, int h) {
        this.imageInputStream = null;
        this.image = image;
        this.width = w;
        this.height = h;
        this.listenerList = new EventListenerList();
        this.cachedImages = new LinkedHashMap<String, BufferedImage>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, BufferedImage> eldest) {
                return this.size() > 5;
            }
        };
        this.presize(this.width, this.height);
    }

    public void addAsynchronousLoadListener(AsynchronousLoadListener l) {
        this.listenerList.add(AsynchronousLoadListener.class, l);
    }

    public void removeAsynchronousLoadListener(AsynchronousLoadListener l) {
        this.listenerList.remove(AsynchronousLoadListener.class, l);
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        BufferedImage image = this.cachedImages.get(this.getIconWidth() + ":" + this.getIconHeight());
        if (image != null) {
            int dx = (this.width - image.getWidth()) / 2;
            int dy = (this.height - image.getHeight()) / 2;
            g.drawImage(image, x + dx, y + dy, null);
        }
    }

    public synchronized void setPreferredSize(Dimension dim) {
        if (dim.width == this.width && dim.height == this.height) {
            return;
        }
        this.width = dim.width;
        this.height = dim.height;
        this.renderImage(this.width, this.height);
    }

    protected synchronized void renderImage(final int renderWidth, final int renderHeight) {
        String key = renderWidth + ":" + renderHeight;
        if (this.cachedImages.containsKey(key)) {
            this.fireAsyncCompleted(true);
            return;
        }
        SwingWorker<BufferedImage, Void> worker = new SwingWorker<BufferedImage, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected BufferedImage doInBackground() throws Exception {
                if (ImageResizableIconReducedMem.this.imageInputStream != null) {
                    InputStream inputStream = ImageResizableIconReducedMem.this.imageInputStream;
                    synchronized (inputStream) {
                        if (ImageResizableIconReducedMem.this.originalImage == null) {
                            ImageResizableIconReducedMem.this.originalImage = ImageIO.read(ImageResizableIconReducedMem.this.imageInputStream);
                        }
                    }
                } else {
                    GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice d = e.getDefaultScreenDevice();
                    GraphicsConfiguration c = d.getDefaultConfiguration();
                    ImageResizableIconReducedMem.this.originalImage = c.createCompatibleImage(ImageResizableIconReducedMem.this.image.getWidth(null), ImageResizableIconReducedMem.this.image.getHeight(null), 3);
                    Graphics g = ImageResizableIconReducedMem.this.originalImage.getGraphics();
                    g.drawImage(ImageResizableIconReducedMem.this.image, 0, 0, null);
                    g.dispose();
                }
                BufferedImage result = ImageResizableIconReducedMem.this.originalImage;
                float scaleX = (float)ImageResizableIconReducedMem.this.originalImage.getWidth() / (float)renderWidth;
                float scaleY = (float)ImageResizableIconReducedMem.this.originalImage.getHeight() / (float)ImageResizableIconReducedMem.this.height;
                float scale = Math.max(scaleX, scaleY);
                if (ImageResizableIconReducedMem.this.minScale > -1 && (float)ImageResizableIconReducedMem.this.minScale < scale) {
                    return ImageResizableIconReducedMem.this.originalImage;
                }
                if (scale > 1.0f) {
                    int finalWidth = (int)((float)ImageResizableIconReducedMem.this.originalImage.getWidth() / scale);
                    result = FlamingoUtilities.createThumbnail((BufferedImage)ImageResizableIconReducedMem.this.originalImage, (int)finalWidth);
                }
                return result;
            }

            @Override
            protected void done() {
                try {
                    BufferedImage bufferedImage = (BufferedImage)this.get();
                    ImageResizableIconReducedMem.this.cachedImages.put(renderWidth + ":" + renderHeight, bufferedImage);
                    ImageResizableIconReducedMem.this.fireAsyncCompleted(true);
                }
                catch (Exception exc) {
                    ImageResizableIconReducedMem.this.fireAsyncCompleted(false);
                }
            }
        };
        worker.execute();
    }

    protected void fireAsyncCompleted(Boolean event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != AsynchronousLoadListener.class) continue;
            ((AsynchronousLoadListener)listeners[i + 1]).completed(event.booleanValue());
        }
    }

    public synchronized boolean isLoading() {
        BufferedImage image = this.cachedImages.get(this.getIconWidth() + ":" + this.getIconHeight());
        return image == null;
    }

    public void setDimension(Dimension dim) {
        this.setPreferredSize(dim);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void presize(int renderWidth, int renderHeight) {
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        if (this.imageInputStream != null) {
            InputStream inputStream = this.imageInputStream;
            synchronized (inputStream) {
                if (this.originalImage == null) {
                    try {
                        this.originalImage = ImageIO.read(this.imageInputStream);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        this.originalImage = c.createCompatibleImage(this.image.getWidth(null), this.image.getHeight(null), 3);
        Graphics g = this.originalImage.getGraphics();
        g.drawImage(this.image, 0, 0, null);
        g.dispose();
        BufferedImage result = this.originalImage;
        float scaleX = (float)this.originalImage.getWidth() / (float)renderWidth;
        float scaleY = (float)this.originalImage.getHeight() / (float)this.height;
        float scale = Math.max(scaleX, scaleY);
        if (scale > 1.0f) {
            int finalWidth = (int)((float)this.originalImage.getWidth() / scale);
            result = FlamingoUtilities.createThumbnail((BufferedImage)this.originalImage, (int)finalWidth);
        }
        this.cachedImages.put(renderWidth + ":" + renderHeight, result);
        this.image = result;
    }
}

