/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.Configuration;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResidueHistory {
    private static final int RECENT_RESIDUES_QUEUE_SIZE = 3;
    protected LinkedList<String> recent_residues = new LinkedList();
    protected Vector<Listener> listeners = new Vector();

    public void addHistoryChangedListener(Listener l) {
        if (l != null) {
            this.listeners.add(l);
        }
    }

    public void removeHistoryChangedListener(Listener l) {
        if (l != null) {
            this.listeners.remove(l);
        }
    }

    public void clear() {
        this.recent_residues.clear();
    }

    public int size() {
        return this.recent_residues.size();
    }

    public void add(Residue r) {
        if (r != null) {
            this.add(r.getType());
        }
    }

    public void add(ResidueType type) {
        if (type != null && type.getToolbarOrder() == 0 && !this.recent_residues.contains(type.getName())) {
            if (this.recent_residues.size() == 3) {
                this.recent_residues.removeLast();
            }
            this.recent_residues.addFirst(type.getName());
            Iterator<Listener> i = this.listeners.iterator();
            while (i.hasNext()) {
                i.next().residueHistoryChanged();
            }
        }
    }

    public Collection<String> getRecentResidues() {
        return this.recent_residues;
    }

    public Iterator<String> iterator() {
        return this.recent_residues.iterator();
    }

    public void store(Configuration config) {
        int c = 0;
        config.put("ResidueHistory", "queue_size", this.recent_residues.size());
        for (String typename : this.recent_residues) {
            config.put("ResidueHistory", "type_name" + c, typename);
            ++c;
        }
    }

    public void retrieve(Configuration config) {
        this.recent_residues.clear();
        int queue_size = config.get("ResidueHistory", "queue_size", 0);
        for (int c = 0; c < queue_size && c < 3; ++c) {
            this.recent_residues.add(config.get("ResidueHistory", "type_name" + c));
        }
    }

    public static interface Listener {
        public void residueHistoryChanged();
    }
}

