/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.resize.event;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;

public class RowResizeEvent
extends RowStructuralChangeEvent {
    public RowResizeEvent(ILayer layer, int rowPosition) {
        super(layer, new Range(rowPosition, rowPosition + 1));
    }

    public RowResizeEvent(ILayer layer, Range rowPositionRange) {
        super(layer, rowPositionRange);
    }

    protected RowResizeEvent(RowResizeEvent event) {
        super(event);
    }

    @Override
    public RowResizeEvent cloneEvent() {
        return new RowResizeEvent(this);
    }

    @Override
    public Collection<StructuralDiff> getRowDiffs() {
        ArrayList<StructuralDiff> rowDiffs = new ArrayList<StructuralDiff>();
        for (Range range : this.getRowPositionRanges()) {
            new StructuralDiff(StructuralDiff.DiffTypeEnum.CHANGE, range, range);
        }
        return rowDiffs;
    }
}

