/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.part.editsupport;

import java.util.List;
import java.util.Objects;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.MeasurementUnit;
import org.grits.toolbox.entry.sample.part.providers.BooleanContentProvider;

public class EditingSupportForUnit
extends EditingSupport {
    private ComboBoxViewerCellEditor unitComboCellEditor = null;
    private MDirtyable dirtyable = null;

    public EditingSupportForUnit(TreeViewer treeViewer, MDirtyable dirtyable) {
        super((ColumnViewer)treeViewer);
        this.init((Composite)treeViewer.getTree());
        this.dirtyable = dirtyable;
    }

    public EditingSupportForUnit(TableViewer tableViewer) {
        super((ColumnViewer)tableViewer);
        this.init((Composite)tableViewer.getTable());
    }

    private void init(Composite comp) {
        this.unitComboCellEditor = new ComboBoxViewerCellEditor(comp, 8);
        this.unitComboCellEditor.setContenProvider((IStructuredContentProvider)new BooleanContentProvider());
    }

    protected void setValue(Object element, Object value) {
        if (element instanceof Descriptor) {
            String stringUri;
            Descriptor descriptor = (Descriptor)element;
            String string = stringUri = value == null ? null : descriptor.getUnitUriFromLabel(value.toString());
            if (!Objects.equals(stringUri, descriptor.getSelectedMeasurementUnit())) {
                descriptor.setSelectedMeasurementUnit(stringUri);
                ColumnViewer viewer = this.getViewer();
                viewer.refresh((Object)descriptor);
                if (this.dirtyable != null) {
                    this.dirtyable.setDirty(true);
                }
            }
        }
    }

    protected Object getValue(Object element) {
        Descriptor descriptor;
        String mUnitLabel = null;
        if (element instanceof Descriptor && (descriptor = (Descriptor)element).getSelectedMeasurementUnit() != null) {
            mUnitLabel = descriptor.getUnitLabelFromUri(descriptor.getSelectedMeasurementUnit());
        }
        return mUnitLabel;
    }

    protected CellEditor getCellEditor(Object element) {
        Descriptor descriptor;
        if (element instanceof Descriptor && (descriptor = (Descriptor)element).getValidUnits() != null && !descriptor.getValidUnits().isEmpty()) {
            String[] units = new String[]{};
            int size = descriptor.getValidUnits().size();
            units = new String[size];
            List<MeasurementUnit> measureUnits = descriptor.getValidUnits();
            int i = 0;
            for (MeasurementUnit mUnit : measureUnits) {
                units[i++] = mUnit.getLabel();
            }
            this.unitComboCellEditor.setInput((Object)units);
            return this.unitComboCellEditor;
        }
        return null;
    }

    protected boolean canEdit(Object element) {
        boolean editable = false;
        if (element instanceof Descriptor) {
            Descriptor descriptor = (Descriptor)element;
            editable = descriptor.getValidUnits() != null && !descriptor.getValidUnits().isEmpty();
        }
        return editable;
    }
}

