/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.part.providers;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Color;
import org.grits.toolbox.entry.sample.config.Config;
import org.grits.toolbox.entry.sample.model.Category;
import org.grits.toolbox.entry.sample.model.CategoryTemplate;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.model.Namespace;
import org.grits.toolbox.entry.sample.part.providers.CategoryTreeContentProvider;

public class DescriptorValueLabelProvider
extends ColumnLabelProvider {
    private TreeViewer treeViewer = null;

    public DescriptorValueLabelProvider(TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
    }

    public String getText(Object element) {
        if (element instanceof Descriptor) {
            return ((Descriptor)element).getValue();
        }
        return null;
    }

    public Color getBackground(Object element) {
        Color backgroundColor;
        block2: {
            Category category;
            Descriptor descriptor;
            block3: {
                backgroundColor = null;
                if (!(element instanceof Descriptor) || (descriptor = (Descriptor)element).getValue() != null && !descriptor.getValue().isEmpty()) break block2;
                category = (Category)this.treeViewer.getInput();
                if (!category.getDescriptors().contains(descriptor)) break block3;
                CategoryTemplate categoryTemplate = ((CategoryTreeContentProvider)this.treeViewer.getContentProvider()).getCategoryTemplate();
                if (categoryTemplate == null) break block2;
                backgroundColor = Config.HIGHLIGHT_COLOR_WARN;
                for (Descriptor desc : categoryTemplate.getMandatoryDescriptors()) {
                    if (!desc.getUri().equals(descriptor.getUri())) continue;
                    backgroundColor = Config.HIGHLIGHT_COLOR_ERROR;
                    break block2;
                }
                break block2;
            }
            for (DescriptorGroup dg : category.getDescriptorGroups()) {
                backgroundColor = Config.HIGHLIGHT_COLOR_WARN;
                if (!dg.getMandatoryDescriptors().contains(descriptor)) continue;
                backgroundColor = Config.HIGHLIGHT_COLOR_ERROR;
                break;
            }
        }
        return backgroundColor;
    }

    public String getToolTipText(Object obj) {
        String toolTipText = "";
        if (obj instanceof Descriptor) {
            Descriptor desc = (Descriptor)obj;
            toolTipText = String.valueOf(toolTipText) + desc.getLabel() + " \n\n     ";
            if (desc.getDescription() != null) {
                toolTipText = String.valueOf(toolTipText) + desc.getDescription() + " \n\n     ";
            }
            if (!desc.getNamespaces().isEmpty()) {
                toolTipText = String.valueOf(toolTipText) + "The values can be added from the following namespaces.\n     Namespaces - ";
                for (Namespace namespace : desc.getNamespaces()) {
                    toolTipText = String.valueOf(toolTipText) + namespace.getLabel() + " (" + namespace.getUri() + ")\n     ";
                }
                toolTipText = String.valueOf(toolTipText) + "\n     ";
            }
            String maxOccurrence = desc.getMaxOccurrence() == null ? "Infinite" : "" + desc.getMaxOccurrence();
            toolTipText = String.valueOf(toolTipText) + "Max.ocurrence is \"" + maxOccurrence + "\"  i.e. the maximum number of times this Descriptor can be added.\n";
        } else if (obj instanceof DescriptorGroup) {
            DescriptorGroup dg = (DescriptorGroup)obj;
            toolTipText = String.valueOf(toolTipText) + dg.getLabel() + " \n\n     ";
            if (dg.getDescription() != null) {
                toolTipText = String.valueOf(toolTipText) + dg.getDescription() + " \n\n     ";
            }
            String maxOccurrence = dg.getMaxOccurrence() == null ? "Infinite" : "" + dg.getMaxOccurrence();
            toolTipText = String.valueOf(toolTipText) + "Max.ocurrence is \"" + maxOccurrence + "\"  i.e. the maximum number of times this DescriptorGroup can be added.\n";
        }
        return toolTipText;
    }
}

