/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.dango;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eurocarbdb.application.glycanbuilder.Atom;
import org.eurocarbdb.application.glycanbuilder.BuilderWorkspace;
import org.eurocarbdb.application.glycanbuilder.FragmentCollection;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.Fragmenter;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.IonCloud;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.Molecule;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.Union;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.grits.toolbox.ms.annotation.structure.GlycanDatabase;
import org.grits.toolbox.ms.annotation.structure.GlycanPreDefinedOptions;
import org.grits.toolbox.ms.annotation.structure.GlycanStructure;
import org.grits.toolbox.ms.om.data.Fragment;
import org.grits.toolbox.ms.om.data.GlycanSettings;
import org.grits.toolbox.tools.gsl.util.analyze.glycan.GWBSequenceToComposition;
import org.grits.toolbox.tools.gsl.util.io.glycan.GlycanDatabaseFileHandler;
import org.grits.toolbox.tools.gsl.util.mass.ChemicalComposition;
import org.grits.toolbox.utils.image.GlycanImageProvider;

public class GlycanAnnotationUtils {
    public static final Logger logger = Logger.getLogger(GlycanAnnotationUtils.class);
    private static Map<String, String> mapGWBSeqToComposition = new HashMap<String, String>();
    private static GlycanWorkspace glycanWorkspase = new GlycanWorkspace(null, false, (GlycanRenderer)new GlycanRendererAWT());
    private static boolean isInitializedGWS = false;

    private static void initGraphicOptions() {
        GlycanAnnotationUtils.glycanWorkspase.getGraphicOptions().ORIENTATION = 0;
        GlycanAnnotationUtils.glycanWorkspase.getGraphicOptions().SHOW_INFO = true;
        GlycanAnnotationUtils.glycanWorkspase.getGraphicOptions().SHOW_MASSES = false;
        GlycanAnnotationUtils.glycanWorkspase.getGraphicOptions().SHOW_REDEND = true;
        isInitializedGWS = true;
    }

    public static List<String[]> generateGlycanFragments(String a_strGSeq, boolean a_bMono, String a_strPerDeriv, List<Fragment> a_lFragments, int a_nMaxClvg, int a_nMaxClvgCR) {
        ArrayList<String[]> t_lFragmentSeqs = new ArrayList<String[]>();
        new BuilderWorkspace((GlycanRenderer)new GlycanRendererAWT());
        Fragmenter t_fragmenter = new Fragmenter();
        t_fragmenter.setComputeBFragments(false);
        t_fragmenter.setComputeYFragments(false);
        t_fragmenter.setComputeCFragments(false);
        t_fragmenter.setComputeZFragments(false);
        t_fragmenter.setComputeAFragments(false);
        t_fragmenter.setComputeXFragments(false);
        t_fragmenter.setIterate_ion_combinations(false);
        for (Fragment fragment : a_lFragments) {
            if (fragment.getType().equals("B")) {
                t_fragmenter.setComputeBFragments(true);
                continue;
            }
            if (fragment.getType().equals("Y")) {
                t_fragmenter.setComputeYFragments(true);
                continue;
            }
            if (fragment.getType().equals("C")) {
                t_fragmenter.setComputeCFragments(true);
                continue;
            }
            if (fragment.getType().equals("Z")) {
                t_fragmenter.setComputeZFragments(true);
                continue;
            }
            if (fragment.getType().equals("A")) {
                t_fragmenter.setComputeAFragments(true);
                continue;
            }
            if (!fragment.getType().equals("X")) continue;
            t_fragmenter.setComputeXFragments(true);
        }
        t_fragmenter.setMaxNoCleavages(a_nMaxClvg);
        t_fragmenter.setMaxNoCrossRings(a_nMaxClvgCR);
        try {
            Glycan t_glycan = Glycan.fromString((String)a_strGSeq);
            GlycanAnnotationUtils.setMassOptions(t_glycan, a_bMono, a_strPerDeriv);
            FragmentCollection fc = t_fragmenter.computeAllFragments(t_glycan);
            for (FragmentEntry t_ent : (List)fc.getFragments()) {
                String[] t_strStructureAndFragType = new String[]{t_ent.getStructure(), t_ent.name};
                t_lFragmentSeqs.add(t_strStructureAndFragType);
            }
        }
        catch (Exception e) {
            logger.error((Object)"An error in glycan fragment generation", (Throwable)e);
        }
        return t_lFragmentSeqs;
    }

    public static String generateGlycanComposition(String a_strGSeq) {
        if (!mapGWBSeqToComposition.containsKey(a_strGSeq)) {
            GWBSequenceToComposition t_exchange = new GWBSequenceToComposition();
            mapGWBSeqToComposition.put(a_strGSeq, t_exchange.getCompositionString(a_strGSeq));
        }
        return mapGWBSeqToComposition.get(a_strGSeq);
    }

    public static double calculateGlycanMass(String a_strGSeq, boolean a_bMono, String t_strPerDerivType) {
        Glycan t_glycan = Glycan.fromString((String)a_strGSeq);
        GlycanAnnotationUtils.setMassOptions(t_glycan, a_bMono, t_strPerDerivType);
        double t_dGMass = t_glycan.computeMass();
        if (a_strGSeq.contains("S/#lcleavage") || a_strGSeq.contains("P/#lcleavage")) {
            t_dGMass -= 18.0105646844;
        }
        return t_dGMass;
    }

    public static ChemicalComposition calculateGlycanComposition(String a_strGSeq, boolean a_bMono, String t_strPerDerivType) {
        Glycan t_glycan = Glycan.fromString((String)a_strGSeq);
        GlycanAnnotationUtils.setMassOptions(t_glycan, a_bMono, t_strPerDerivType);
        try {
            String t_strComposistion = "";
            Molecule m = t_glycan.computeMolecule();
            for (Map.Entry a : m.getAtoms()) {
                t_strComposistion = String.valueOf(t_strComposistion) + ((Atom)a.getKey()).getSymbol() + a.getValue();
                System.out.println(t_strComposistion);
            }
            ChemicalComposition t_cc = ChemicalComposition.parseFormula(t_strComposistion);
            return t_cc;
        }
        catch (Exception e) {
            logger.error((Object)"Cannot calculate chemical composition from Glycan.", (Throwable)e);
            return null;
        }
    }

    public static Map<String, String> getGlycanSequenceToID(GlycanSettings a_gSettings) {
        HashMap<String, String> t_mapGSeqToID = new HashMap<String, String>();
        GlycanDatabase t_gDB = GlycanDatabaseFileHandler.getGlycanDatabase(a_gSettings.getFilter().getDatabase());
        if (t_gDB == null) {
            return t_mapGSeqToID;
        }
        for (GlycanStructure t_gs : t_gDB.getStructures()) {
            t_mapGSeqToID.put(t_gs.getGWBSequence(), t_gs.getId());
        }
        return t_mapGSeqToID;
    }

    public static List<String> getGWBSequences(GlycanSettings a_gSettings) {
        ArrayList<String> t_lGWBSequences = new ArrayList<String>();
        GlycanDatabase t_gDB = GlycanDatabaseFileHandler.getGlycanDatabase(a_gSettings.getFilter().getDatabase());
        if (t_gDB != null) {
            for (GlycanStructure t_gStructure : t_gDB.getStructures()) {
                t_lGWBSequences.add(t_gStructure.getGWBSequence());
            }
        }
        return t_lGWBSequences;
    }

    public static List<String[]> getGWBSequencesAndGlycanID(GlycanSettings a_gSettings) {
        ArrayList<String[]> t_lGWBSeqIDs = new ArrayList<String[]>();
        GlycanDatabase t_gDB = GlycanDatabaseFileHandler.getGlycanDatabase(a_gSettings.getFilter().getDatabase());
        if (t_gDB != null) {
            boolean t_bHasDuplicated = false;
            HashMap t_mapIdToStructures = new HashMap();
            for (GlycanStructure t_gStructure : t_gDB.getStructures()) {
                if (!t_mapIdToStructures.containsKey(t_gStructure.getId())) {
                    t_mapIdToStructures.put(t_gStructure.getId(), new ArrayList());
                }
                ((List)t_mapIdToStructures.get(t_gStructure.getId())).add(t_gStructure);
                if (t_bHasDuplicated || ((List)t_mapIdToStructures.get(t_gStructure.getId())).size() <= 1) continue;
                t_bHasDuplicated = true;
            }
            if (t_bHasDuplicated) {
                for (String t_strId : t_mapIdToStructures.keySet()) {
                    List t_lStructures = (List)t_mapIdToStructures.get(t_strId);
                    if (t_lStructures.size() == 1) continue;
                    int i = 1;
                    for (GlycanStructure t_gStructure : t_lStructures) {
                        t_gStructure.setId(String.valueOf(t_strId) + "." + i++);
                    }
                }
            }
            for (GlycanStructure t_gStructure : t_gDB.getStructures()) {
                String[] t_GWBSeqID = new String[]{t_gStructure.getGWBSequence(), t_gStructure.getId()};
                t_lGWBSeqIDs.add(t_GWBSeqID);
            }
        }
        return t_lGWBSeqIDs;
    }

    public static List<String> getGlycanIDs(GlycanSettings a_gSettings) {
        ArrayList<String> t_lGlycanIDs = new ArrayList<String>();
        GlycanDatabase t_gDB = GlycanDatabaseFileHandler.getGlycanDatabase(a_gSettings.getFilter().getDatabase());
        if (t_gDB != null) {
            for (GlycanStructure t_gStructure : t_gDB.getStructures()) {
                t_lGlycanIDs.add(t_gStructure.getId());
            }
        }
        return t_lGlycanIDs;
    }

    public static BufferedImage combineGlycanImages(List<BufferedImage> a_lImages) {
        return GlycanImageProvider.createCombinedImage(a_lImages);
    }

    public static BufferedImage createGlycanImage(String a_strGWBSeq) {
        return GlycanAnnotationUtils.createGlycanImage(a_strGWBSeq, null);
    }

    public static BufferedImage createGlycanImage(String a_strGWBSeq, String a_strRedEnd) {
        BufferedImage t_image;
        if (!isInitializedGWS) {
            GlycanAnnotationUtils.initGraphicOptions();
        }
        Glycan t_convertedGlycan = null;
        try {
            t_convertedGlycan = Glycan.fromString((String)a_strGWBSeq);
        }
        catch (Exception e) {
            logger.error((Object)"Glycan image conversion from GWB sequece was failed", (Throwable)e);
            return null;
        }
        if (a_strRedEnd != null) {
            t_convertedGlycan.setReducingEndType(ResidueType.createOtherResidue((String)a_strRedEnd, (double)-1.0));
        }
        if ((t_image = glycanWorkspase.getGlycanRenderer().getImage((Collection)new Union((Object)t_convertedGlycan), true, false, true, 0.5)).getWidth() == 1 && t_image.getHeight() == 1) {
            return null;
        }
        return t_image;
    }

    public static boolean isPermethylated(String a_strPerDerivForGRITS) {
        return a_strPerDerivForGRITS.equals(GlycanPreDefinedOptions.DERIVITIZATION_PERMETHYLATED);
    }

    public static boolean canConnectReducingEnd(String a_strGSeq) {
        return a_strGSeq.startsWith("freeEnd");
    }

    public static void setMassOptions(Glycan a_glycan, boolean a_bIsMono, String a_strPerDerivForGRITS) {
        MassOptions t_massOptions = new MassOptions();
        String t_strDerivTypeForMassOption = a_strPerDerivForGRITS.equals(GlycanPreDefinedOptions.DERIVITIZATION_PERMETHYLATED) ? "perMe" : (a_strPerDerivForGRITS.equals(GlycanPreDefinedOptions.DERIVITIZATION_HEAVYPERMETHYLATION) ? "perMe(C^13)" : (a_strPerDerivForGRITS.equals(GlycanPreDefinedOptions.DERIVITIZATION_PERDMETHYLATED) ? "perDMe" : (a_strPerDerivForGRITS.equals(GlycanPreDefinedOptions.DERIVITIZATION_PERACETYLATED) ? "perAc" : (a_strPerDerivForGRITS.equals(GlycanPreDefinedOptions.DERIVITIZATION_PERDACETYLATED) ? "perDAc" : "Und"))));
        t_massOptions.setDerivatization(t_strDerivTypeForMassOption);
        if (a_bIsMono) {
            t_massOptions.setIsotope("MONO");
        } else {
            t_massOptions.setIsotope("AVG");
        }
        t_massOptions.ION_CLOUD = new IonCloud();
        t_massOptions.NEUTRAL_EXCHANGES = new IonCloud();
        t_massOptions.setReducingEndType(ResidueDictionary.findResidueType((String)"freeEnd"));
        a_glycan.setMassOptions(t_massOptions);
    }
}

