/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.util.generator;

import org.grits.toolbox.tools.gsl.database.lipid.LipidClass;
import org.grits.toolbox.tools.gsl.database.lipid.LipidParameters;
import org.grits.toolbox.tools.gsl.structure.lipid.Ceramide;
import org.grits.toolbox.tools.gsl.structure.lipid.ILipid;
import org.grits.toolbox.tools.gsl.util.generator.LipidDatabaseGeneratorAbstract;
import org.grits.toolbox.tools.gsl.util.generator.LipidParametersIO;
import org.grits.toolbox.tools.gsl.util.generator.structure.CeramidesGenerator;
import org.grits.toolbox.tools.gsl.util.generator.structure.LipidsGeneratorAbstract;
import org.grits.toolbox.tools.gsl.util.mass.CeramideChemicalComposition;
import org.grits.toolbox.tools.gsl.util.mass.ChemicalComposition;

public class CeramideDatabaseGenerator
extends LipidDatabaseGeneratorAbstract {
    private LipidParametersIO m_paramsImporterSphingosine;
    private LipidParametersIO m_paramsImporterFattyAcid;

    public CeramideDatabaseGenerator() {
        this.setLipidClass(LipidClass.CERAMIDE);
        this.m_paramsImporterSphingosine = new LipidParametersIO();
        this.m_paramsImporterSphingosine.setLipidClass(LipidClass.SPHINGOSINE);
        this.m_paramsImporterFattyAcid = new LipidParametersIO();
        this.m_paramsImporterFattyAcid.setLipidClass(LipidClass.FATTY_ACID);
    }

    public boolean setCarbonLengthesForSphingosine(String a_strParams) {
        return this.m_paramsImporterSphingosine.setCarbonLengths(a_strParams);
    }

    public boolean setNumbersOfHydrxylGroupsForSphingosine(String a_strParams) {
        return this.m_paramsImporterSphingosine.setNumbersOfHydroxylGroups(a_strParams);
    }

    public boolean setNumbersOfOAcetylGroupsForSphingosine(String a_strParams) {
        return this.m_paramsImporterSphingosine.setNumbersOfOAcetylGroups(a_strParams);
    }

    public boolean setNumbersOfUnsaturationsForSphingosine(String a_strParams) {
        return this.m_paramsImporterSphingosine.setNumbersOfUnsaturations(a_strParams);
    }

    public void allowOnlyEvenNumberedCarbonLengthOfSphingosine(boolean a_bOnlyEven) {
        this.m_paramsImporterSphingosine.allowOnlyEvenNumberedCarbonLength(a_bOnlyEven);
    }

    public boolean setCarbonLengthesForFattyAcid(String a_strParams) {
        return this.m_paramsImporterFattyAcid.setCarbonLengths(a_strParams);
    }

    public boolean setNumbersOfHydrxylGroupsForFattyAcid(String a_strParams) {
        return this.m_paramsImporterFattyAcid.setNumbersOfHydroxylGroups(a_strParams);
    }

    public boolean setNumbersOfOAcetylGroupsForFattyAcid(String a_strParams) {
        return this.m_paramsImporterFattyAcid.setNumbersOfOAcetylGroups(a_strParams);
    }

    public boolean setNumbersOfUnsaturationsForFattyAcid(String a_strParams) {
        return this.m_paramsImporterFattyAcid.setNumbersOfUnsaturations(a_strParams);
    }

    public void allowOnlyEvenNumberedCarbonLengthOfFattyAcid(boolean a_bOnlyEven) {
        this.m_paramsImporterFattyAcid.allowOnlyEvenNumberedCarbonLength(a_bOnlyEven);
    }

    @Override
    public void generate() {
        LipidParameters t_paramsSp = new LipidParameters();
        t_paramsSp.setCarbonLengths(this.m_paramsImporterSphingosine.printCarbonLengths());
        t_paramsSp.setNumberOfHydroxylGroups(this.m_paramsImporterSphingosine.printNumbersOfHydroxylGroups());
        t_paramsSp.setNumberOfOAcetylGroups(this.m_paramsImporterSphingosine.printNumbersOfOAcetylGroups());
        t_paramsSp.setNumberOfDoubleBonds(this.m_paramsImporterSphingosine.printNumbersOfUnsaturations());
        t_paramsSp.setIsAllowedOnlyEvenNumbers(this.m_paramsImporterSphingosine.isOnlyEvenNumberForCarbonLength());
        this.getLipidGenerationSettings().setSphingosine(t_paramsSp);
        LipidParameters t_paramsFA = new LipidParameters();
        t_paramsFA.setCarbonLengths(this.m_paramsImporterFattyAcid.printCarbonLengths());
        t_paramsFA.setNumberOfHydroxylGroups(this.m_paramsImporterFattyAcid.printNumbersOfHydroxylGroups());
        t_paramsFA.setNumberOfOAcetylGroups(this.m_paramsImporterFattyAcid.printNumbersOfOAcetylGroups());
        t_paramsFA.setNumberOfDoubleBonds(this.m_paramsImporterFattyAcid.printNumbersOfUnsaturations());
        t_paramsFA.setIsAllowedOnlyEvenNumbers(this.m_paramsImporterFattyAcid.isOnlyEvenNumberForCarbonLength());
        this.getLipidGenerationSettings().setFattyAcid(t_paramsFA);
        super.generate();
    }

    @Override
    protected LipidsGeneratorAbstract getLipidsGenerator() {
        CeramidesGenerator t_genCers = new CeramidesGenerator();
        t_genCers.setParametersForSphingosine(this.m_paramsImporterSphingosine);
        t_genCers.setParametersForFattyAcid(this.m_paramsImporterFattyAcid);
        return t_genCers;
    }

    @Override
    protected ChemicalComposition getChemicalComposition(ILipid a_ILip) {
        return new CeramideChemicalComposition((Ceramide)a_ILip);
    }
}

