/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.util.generator.structure;

import java.util.ArrayList;
import org.grits.toolbox.tools.gsl.structure.lipid.Ceramide;
import org.grits.toolbox.tools.gsl.structure.lipid.FattyAcid;
import org.grits.toolbox.tools.gsl.structure.lipid.Lipid;
import org.grits.toolbox.tools.gsl.structure.lipid.Sphingosine;
import org.grits.toolbox.tools.gsl.util.generator.LipidParametersIO;
import org.grits.toolbox.tools.gsl.util.generator.structure.FattyAcidsGenerator;
import org.grits.toolbox.tools.gsl.util.generator.structure.LipidsGeneratorAbstract;
import org.grits.toolbox.tools.gsl.util.generator.structure.SphingosinesGenerator;

public class CeramidesGenerator
extends LipidsGeneratorAbstract {
    private LipidParametersIO m_paramSph = new LipidParametersIO();
    private LipidParametersIO m_paramFA = new LipidParametersIO();

    public void setParametersForSphingosine(LipidParametersIO a_params) {
        this.m_paramSph = a_params;
    }

    public LipidParametersIO getParametersForSphingosine() {
        return this.m_paramSph;
    }

    public void setParametersForFattyAcid(LipidParametersIO a_params) {
        this.m_paramFA = a_params;
    }

    public LipidParametersIO getParametersForFattyAcid() {
        return this.m_paramFA;
    }

    @Override
    public void generate() {
        SphingosinesGenerator t_genSph = new SphingosinesGenerator();
        t_genSph.setParameters(this.m_paramSph);
        t_genSph.generate();
        ArrayList<Sphingosine> t_aSphs = t_genSph.getSphingosines();
        FattyAcidsGenerator t_genFA = new FattyAcidsGenerator();
        t_genFA.setParameters(this.m_paramFA);
        t_genFA.generate();
        ArrayList<FattyAcid> t_aFAs = t_genFA.getFattyAcids();
        for (Sphingosine t_oSph : t_aSphs) {
            for (FattyAcid t_oFA : t_aFAs) {
                if (!this.canGenerate(t_oSph, t_oFA)) continue;
                Ceramide t_oCer = this.getNewLipid(t_oSph, t_oFA);
                this.addLipid(t_oCer);
            }
        }
    }

    protected Ceramide getNewLipid(Sphingosine a_oSph, FattyAcid a_oFA) {
        return new Ceramide(a_oSph, a_oFA);
    }

    protected boolean canGenerate(Sphingosine a_oSph, FattyAcid a_oFA) {
        return true;
    }

    @Override
    public String printParameters() {
        String t_strParams = "";
        t_strParams = String.valueOf(t_strParams) + this.m_paramSph.printParameters();
        t_strParams = String.valueOf(t_strParams) + this.m_paramFA.printParameters();
        return t_strParams;
    }

    @Override
    protected Lipid generateLipid(int a_nC, int a_nOH, int a_nOAc, int a_nDB) {
        return null;
    }
}

