/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.handler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.entry.ms.property.FileLockManager;
import org.grits.toolbox.entry.ms.property.FileLockingUtils;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.importer.ms.annotation.glycan.simiansearch.wizard.MSGlycanAnnotationWizard;
import org.grits.toolbox.ms.om.data.Method;
import org.grits.toolbox.tools.gsl.handler.DANGOHandler;
import org.grits.toolbox.tools.gsl.wizard.annotation.MSGlycolipidAnnotationWizard;
import org.grits.toolbox.util.structure.glycan.util.FilterUtils;

public class OpenDANGOWizardHandler {
    private static final Logger logger = Logger.getLogger(OpenDANGOWizardHandler.class);
    @Inject
    private static IGritsDataModelService injectGritsDataModelService = null;
    @Inject
    static IGritsUIService injectGritsUIService = null;
    @Inject
    MApplication m_mApp;

    @Execute
    public Object execute(@Named(value="org.eclipse.ui.selection") Object object, IEventBroker eventBroker, @Named(value="activeShell") Shell shell, EPartService partService) {
        MSGlycolipidAnnotationWizard wizard;
        List<Entry> msEntries;
        block11: {
            logger.debug((Object)"BEGIN OpenDANGOWizardHandler");
            msEntries = this.getMSEntries(object);
            wizard = this.createNewMSAnnotationWizerd(shell, msEntries);
            if (wizard != null && wizard.getInitial().getMsEntryList() != null) break block11;
            return null;
        }
        try {
            Entry[] curEntries;
            int i;
            Shell shell2 = new Shell(shell);
            DANGOHandler handler = new DANGOHandler();
            handler.setWizard(wizard);
            handler.setMsEntries(msEntries);
            List resultEntries = handler.process(shell2);
            if (resultEntries != null) {
                i = 0;
                while (i < resultEntries.size()) {
                    curEntries = (Entry[])resultEntries.get(i);
                    injectGritsDataModelService.addEntry(curEntries[0], curEntries[1]);
                    ++i;
                }
            }
            if (resultEntries != null && !resultEntries.isEmpty() && ((Entry[])resultEntries.get(resultEntries.size() - 1))[1] != null) {
                try {
                    ProjectFileHandler.saveProject((Entry)((Entry[])resultEntries.get(resultEntries.size() - 1))[0].getParent().getParent());
                }
                catch (IOException e) {
                    logger.error((Object)("Something went wrong while saving project entry \n" + e.getMessage()), (Throwable)e);
                    logger.fatal((Object)("Closing project entry \"" + ((Entry[])resultEntries.get(resultEntries.size() - 1))[0].getParent().getParent().getDisplayName() + "\""));
                    injectGritsDataModelService.closeProject(((Entry[])resultEntries.get(resultEntries.size() - 1))[0].getParent().getParent());
                    throw e;
                }
                i = 0;
                while (i < resultEntries.size()) {
                    curEntries = (Entry[])resultEntries.get(i);
                    this.lockFiles(wizard, curEntries[0], curEntries[1]);
                    ++i;
                }
                Entry lastMSEntry = ((Entry[])resultEntries.get(resultEntries.size() - 1))[1];
                eventBroker.send("grits_entry_selected", (Object)lastMSEntry);
                try {
                    injectGritsUIService.setPartService(partService);
                    injectGritsUIService.openEntryInPart(lastMSEntry);
                }
                catch (Exception e) {
                    logger.debug((Object)"Could not open the part", (Throwable)e);
                }
            }
            return resultEntries;
        }
        catch (Exception ex) {
            logger.error((Object)"General Exception executing OpenDANGOWizardHandler.", (Throwable)ex);
            logger.debug((Object)"END OpenDANGOWizardHandler");
            return null;
        }
    }

    private void lockFiles(MSGlycanAnnotationWizard wizard, Entry msEntry, Entry msAnnotationEntry) {
        MassSpecProperty prop = (MassSpecProperty)msEntry.getProperty();
        try {
            String lockFileLocation = prop.getLockFilePath(msEntry);
            FileLockManager mng = FileLockingUtils.readLockFile((String)lockFileLocation);
            MSPropertyDataFile file = (MSPropertyDataFile)wizard.getInitial().getFileMap().get(msEntry.getDisplayName());
            if (file != null) {
                mng.lockFile(file.getName(), msAnnotationEntry);
                FileLockingUtils.writeLockFile((FileLockManager)mng, (String)lockFileLocation);
            }
        }
        catch (IOException e) {
            logger.error((Object)"Could not lock the file", (Throwable)e);
        }
        catch (JAXBException e) {
            logger.error((Object)"Could not lock the file", (Throwable)e);
        }
    }

    private void serialize(Method method) {
        try {
            ArrayList<Class> contextList = new ArrayList<Class>(Arrays.asList(FilterUtils.filterClassContext));
            contextList.add(Method.class);
            JAXBContext context = JAXBContext.newInstance((Class[])contextList.toArray(new Class[contextList.size()]));
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal((Object)method, new File("E:\\method.xml"));
        }
        catch (JAXBException e) {
            logger.error((Object)"An error during serializing method object.", (Throwable)e);
        }
    }

    private MSGlycolipidAnnotationWizard createNewMSAnnotationWizerd(Shell shell, List<Entry> msEntries) {
        MSGlycolipidAnnotationWizard wizard = new MSGlycolipidAnnotationWizard();
        wizard.setMSEntries(msEntries);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        try {
            if (dialog.open() == 0) {
                return wizard;
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Exception", (Exception)e);
        }
        return null;
    }

    private List<Entry> getMSEntries(Object object) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        StructuredSelection structuredEntries = null;
        Entry selectedEntry = null;
        if (object instanceof Entry) {
            selectedEntry = (Entry)object;
        }
        if (object instanceof StructuredSelection && ((StructuredSelection)object).getFirstElement() instanceof Entry) {
            structuredEntries = (StructuredSelection)object;
        }
        if (selectedEntry == null && injectGritsDataModelService.getLastSelection() != null && injectGritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
            structuredEntries = injectGritsDataModelService.getLastSelection();
        }
        if (structuredEntries == null) {
            if (selectedEntry != null && selectedEntry.getProperty().getType().equals("org.grits.toolbox.property.ms")) {
                entries.add(selectedEntry);
            }
            return entries;
        }
        List selList = structuredEntries.toList();
        int i = 0;
        while (i < selList.size()) {
            Entry msEntry = (Entry)selList.get(i);
            if (msEntry.getProperty().getType().equals("org.grits.toolbox.property.ms")) {
                entries.add(msEntry);
            }
            ++i;
        }
        return entries;
    }
}

