/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.grits.toolbox.core.Activator;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.core.utilShare.ErrorUtils;

public class GritsIntroPart {
    private static final Logger logger = Logger.getLogger(GritsIntroPart.class);
    private Image gritsWelcomeImage = Activator.imageDescriptorFromPlugin("org.grits.toolbox.core", "icons/GRITS-Welcome.png").createImage();
    @Inject
    ECommandService commandService;
    @Inject
    EHandlerService handlerService;

    @Inject
    public GritsIntroPart() {
    }

    @PostConstruct
    public void postConstruct(Composite parent, final IGritsUIService gritsUIService) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 2816);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        scrolledComposite.setBackground(parent.getDisplay().getSystemColor(25));
        scrolledComposite.setBackgroundMode(2);
        Composite outerContainer = new Composite((Composite)scrolledComposite, 4);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginTop = 80;
        gridLayout.marginBottom = 80;
        gridLayout.marginRight = 80;
        gridLayout.marginLeft = 80;
        gridLayout.verticalSpacing = 40;
        outerContainer.setLayout((Layout)gridLayout);
        scrolledComposite.setContent((Control)outerContainer);
        scrolledComposite.setMinWidth(1000);
        scrolledComposite.setMinHeight(900);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        String[] welcomeText = this.getHeaderAndBody();
        StyledText styledText = new StyledText(outerContainer, 0x1000040);
        styledText.setText(welcomeText[0]);
        StyleRange style1 = new StyleRange();
        style1.start = 0;
        style1.length = styledText.getCharCount();
        style1.underline = true;
        styledText.setStyleRange(style1);
        GridData gd = new GridData(512);
        gd.horizontalAlignment = 0x1000000;
        gd.verticalAlignment = 4;
        gd.verticalSpan = 2;
        styledText.setLayoutData((Object)gd);
        Link link = new Link(outerContainer, 0x1000040);
        link.setText(welcomeText[1]);
        gd = new GridData(512);
        gd.horizontalAlignment = 0x1000000;
        gd.verticalAlignment = 4;
        gd.verticalSpan = 2;
        link.setLayoutData((Object)gd);
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.openWebPage(e.text);
            }

            private void openWebPage(String webURL) {
                try {
                    Program.launch((String)webURL);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logger.fatal((Object)"Error opening browser");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.openWebPage(e.text);
            }
        });
        Composite projectContainer = new Composite(outerContainer, 4);
        GridLayout projectContainerLayout = new GridLayout(1, true);
        projectContainerLayout.verticalSpacing = 10;
        projectContainer.setLayout((Layout)projectContainerLayout);
        GridData projectGridData = new GridData();
        projectGridData.horizontalAlignment = 2;
        projectGridData.verticalAlignment = 4;
        projectGridData.verticalSpan = 1;
        projectContainer.setLayoutData((Object)projectGridData);
        Label label = new Label(projectContainer, 0x1000040);
        label.setText("Your first step in GRITS Toolbox is to create a new project in your workspace. Do you want to create a project now?\n\n");
        gd = new GridData(1536);
        gd.horizontalAlignment = 2;
        gd.verticalAlignment = 1;
        label.setLayoutData((Object)gd);
        Button button = new Button(projectContainer, 8);
        button.setText("Yes, create a new Project");
        gd = new GridData(512);
        gd.horizontalAlignment = 2;
        gd.verticalAlignment = 1;
        gd.widthHint = 250;
        button.setLayoutData((Object)gd);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.createProject();
            }

            private void createProject() {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("org.grits.toolbox.core.commandparameter.eventtrigger.classname", GritsIntroPart.class.getName());
                try {
                    gritsUIService.selectPerspective("org.grits.toolbox.core.perspective.projectexplorer");
                    GritsIntroPart.this.handlerService.executeHandler(GritsIntroPart.this.commandService.createCommand("org.grits.toolbox.core.command.projectexplorer.new.project", parameters));
                }
                catch (Exception e) {
                    logger.fatal((Object)e.getMessage(), (Throwable)e);
                    ErrorUtils.createErrorMessageBox(Display.getCurrent().getActiveShell(), "Something went wrong. Please check with the GRITS developers team.\n", e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.createProject();
            }
        });
        button = new Button(projectContainer, 8);
        button.setText("No, take me to the workspace");
        gd = new GridData(512);
        gd.horizontalAlignment = 2;
        gd.verticalAlignment = 1;
        gd.widthHint = 250;
        button.setLayoutData((Object)gd);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.closeThis();
            }

            private void closeThis() {
                gritsUIService.selectPerspective("org.grits.toolbox.core.perspective.projectexplorer");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.closeThis();
            }
        });
        Label imgLabel = new Label(outerContainer, 0);
        imgLabel.setImage(this.gritsWelcomeImage);
        imgLabel.setSize(imgLabel.computeSize(-1, -1));
        gd = new GridData(512);
        gd.horizontalAlignment = 2;
        gd.verticalAlignment = 3;
        imgLabel.setLayoutData((Object)gd);
    }

    private String[] getHeaderAndBody() {
        String[] welcomeMessage = new String[]{"", ""};
        String header = "";
        String body = "";
        BufferedInputStream bufferedInputStream = null;
        try {
            URL resourceURL = FileLocator.toFileURL((URL)Platform.getBundle((String)"org.grits.toolbox.core").getResource("preference"));
            String fileLocation = String.valueOf(resourceURL.getPath()) + File.separator + "display_text" + File.separator + "welcomeMessage.txt";
            bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(fileLocation)));
            byte[] contents = new byte[10240];
            int bytesRead = 0;
            String message = "";
            while ((bytesRead = bufferedInputStream.read(contents)) != -1) {
                message = new String(contents, 0, bytesRead);
            }
            header = message.substring(message.indexOf("<TITLE>") + 7, message.indexOf("</TITLE>"));
            body = message.substring(message.indexOf("<BODY>") + 6, message.indexOf("</BODY>"));
        }
        catch (FileNotFoundException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (Exception ex) {
            logger.fatal((Object)ex.getMessage(), (Throwable)ex);
        }
        welcomeMessage[0] = header.isEmpty() ? "WELCOME TO GRITS Toolbox" : header;
        welcomeMessage[1] = body;
        return welcomeMessage;
    }

    @PreDestroy
    void predestroy() {
    }
}

