/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.log;

import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.grits.toolbox.core.log.GritsLogAppender;

public class GRITSLog {
    public static void startLog() {
        WriterAppender gritsAppender = GritsLogAppender.createAppender();
        gritsAppender.setLayout((Layout)new PatternLayout("[%-5p] %d{ISO8601} [%C %M %L] - %m%n"));
        gritsAppender.setThreshold(GritsLogAppender.getDefaultThreshold());
        gritsAppender.activateOptions();
        gritsAppender.addFilter(new Filter(){

            public int decide(LoggingEvent event) {
                try {
                    int decision = 0;
                    String loggingClassName = event.getLocationInformation().getClassName();
                    decision = loggingClassName.startsWith("org.grits.") ? (event.getLevel().toInt() >= GritsLogAppender.getGritsLoggingLevel() ? 1 : -1) : (event.getLevel().toInt() >= GritsLogAppender.getNonGritsLoggingLevel() ? 1 : -1);
                    return decision;
                }
                catch (Exception exception) {
                    return 1;
                }
            }
        });
        Logger.getRootLogger().addAppender((Appender)gritsAppender);
    }
}

