/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.datamodel.property.project.ProjectTasklist;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;

public class AddEditTaskDialog
extends TitleAreaDialog {
    private static final Logger logger = Logger.getLogger(AddEditTaskDialog.class);
    private ProjectTasklist tasklist = null;
    private ComboViewer taskCombo = null;
    private ComboViewer personCombo = null;
    private ComboViewer statusCombo = null;
    private ComboViewer roleCombo = null;
    private Text groupPIText = null;

    public AddEditTaskDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setTasklist(ProjectTasklist tasklist) {
        this.tasklist = tasklist;
    }

    public ProjectTasklist getTasklist() {
        return this.tasklist;
    }

    public Control createDialogArea(Composite parent) {
        super.createDialogArea(parent);
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 20;
        layout.horizontalSpacing = 10;
        layout.marginTop = 20;
        layout.marginBottom = 20;
        layout.marginLeft = 10;
        layout.marginRight = 10;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        this.getShell().setText("Task");
        this.setTitle("Project Task");
        if (this.tasklist == null) {
            this.setMessage("Create a new Task");
            this.tasklist = new ProjectTasklist();
            this.tasklist.setTask(ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.TASK).getDefaultValue());
            this.tasklist.setPerson(ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.PERSON).getDefaultValue());
            this.tasklist.setStatus(ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.STATUS).getDefaultValue());
            this.tasklist.setRole(ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.ROLE).getDefaultValue());
            this.tasklist.setGroupOrPIName("");
        } else if (this.tasklist.getTask() != null) {
            this.setMessage(this.tasklist.getTask());
        }
        this.taskCombo = this.createComboLine(composite, "Task");
        this.taskCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setInputInCombo(this.taskCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.TASK).getAllValues());
        this.taskCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddEditTaskDialog.this.tasklist.setTask(AddEditTaskDialog.this.taskCombo.getCombo().getText());
            }
        });
        this.personCombo = this.createComboLine(composite, "Person");
        this.personCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setInputInCombo(this.personCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.PERSON).getAllValues());
        this.personCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddEditTaskDialog.this.tasklist.setPerson(AddEditTaskDialog.this.personCombo.getCombo().getText());
            }
        });
        this.statusCombo = this.createComboLine(composite, "Status");
        this.statusCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setInputInCombo(this.statusCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.STATUS).getAllValues());
        this.statusCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddEditTaskDialog.this.tasklist.setStatus(AddEditTaskDialog.this.statusCombo.getCombo().getText());
            }
        });
        this.roleCombo = this.createComboLine(composite, "Role");
        this.roleCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setInputInCombo(this.roleCombo, ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.ROLE).getAllValues());
        this.roleCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddEditTaskDialog.this.tasklist.setRole(AddEditTaskDialog.this.roleCombo.getCombo().getText());
            }
        });
        this.groupPIText = this.createTextLine(composite, "Group/P.I.");
        this.groupPIText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddEditTaskDialog.this.tasklist.setGroupOrPIName(AddEditTaskDialog.this.groupPIText.getText().trim());
            }
        });
        GridData compositeLayoutData = new GridData(1808);
        compositeLayoutData.grabExcessHorizontalSpace = true;
        compositeLayoutData.grabExcessVerticalSpace = false;
        compositeLayoutData.horizontalSpan = 3;
        compositeLayoutData.verticalSpan = 1;
        composite.setLayoutData((Object)compositeLayoutData);
        this.selectInCombo(this.taskCombo, this.tasklist.getTask());
        this.selectInCombo(this.personCombo, this.tasklist.getPerson());
        this.selectInCombo(this.statusCombo, this.tasklist.getStatus());
        this.selectInCombo(this.roleCombo, this.tasklist.getRole());
        if (this.tasklist.getGroupOrPIName() != null) {
            this.groupPIText.setText(this.tasklist.getGroupOrPIName());
        }
        logger.debug((Object)"END   : Creating Tasklist Dialog");
        return composite;
    }

    private void selectInCombo(ComboViewer comboViewer, String value) {
        int selectionIndex = -1;
        int i = 0;
        String[] stringArray = comboViewer.getCombo().getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (Objects.equals(item, value)) {
                selectionIndex = i;
                break;
            }
            ++i;
            ++n2;
        }
        comboViewer.getCombo().select(selectionIndex);
    }

    private void setInputInCombo(ComboViewer comboViewer, Set<String> values) {
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.addAll(values);
        Collections.sort(valueList);
        String[] items = new String[valueList.size()];
        int i = 0;
        for (String value : valueList) {
            items[i++] = value;
        }
        comboViewer.getCombo().setItems(items);
    }

    private Text createTextLine(Composite composite, String label) {
        Label textLabel = new Label(composite, 0);
        textLabel.setText(label);
        GridData createNewData = new GridData(32);
        createNewData.horizontalSpan = 1;
        createNewData.verticalSpan = 1;
        textLabel.setLayoutData((Object)createNewData);
        Text text = new Text(composite, 2048);
        GridData newTasklistData = new GridData(768);
        newTasklistData.grabExcessHorizontalSpace = true;
        newTasklistData.horizontalSpan = 1;
        newTasklistData.verticalSpan = 1;
        text.setLayoutData((Object)newTasklistData);
        return text;
    }

    private ComboViewer createComboLine(Composite composite, String label) {
        Label textLabel = new Label(composite, 0);
        textLabel.setText(label);
        GridData createNewData = new GridData(32);
        createNewData.horizontalSpan = 1;
        createNewData.verticalSpan = 1;
        textLabel.setLayoutData((Object)createNewData);
        ComboViewer comboViewer = new ComboViewer(composite, 8);
        GridData newTasklistData = new GridData(768);
        newTasklistData.grabExcessHorizontalSpace = true;
        newTasklistData.horizontalSpan = 1;
        newTasklistData.verticalSpan = 1;
        comboViewer.getCombo().setLayoutData((Object)newTasklistData);
        return comboViewer;
    }
}

