/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.utilShare;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;

public class XMLUtils {
    private static final Logger logger = Logger.getLogger(XMLUtils.class);

    public static Object getObjectFromXML(String xmlString, Class<?> sourceClass) {
        Object obj = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{sourceClass});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            obj = unmarshaller.unmarshal((Reader)new StringReader(xmlString));
        }
        catch (JAXBException e) {
            logger.error((Object)("The object could not be read from xml." + e.getMessage()), (Throwable)e);
        }
        return obj;
    }

    public static String marshalObjectXML(Object object) {
        String xmlString = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal(object, (OutputStream)os);
            xmlString = os.toString();
        }
        catch (JAXBException e) {
            e.printStackTrace();
            logger.error((Object)("The object could not be serialized as xml." + e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)("The object could not be serialized as xml." + e.getMessage()), (Throwable)e);
        }
        return xmlString;
    }

    public static Object unmarshalObjectXML(String xmlFile, Class<?> destClass) {
        Object obj = null;
        try {
            FileInputStream inputStream = new FileInputStream(xmlFile);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{destClass});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            obj = unmarshaller.unmarshal((Reader)reader);
        }
        catch (JAXBException e) {
            logger.error((Object)("The file could not be unmarshalled." + e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("The file could not be unmarshalled." + e.getMessage()), (Throwable)e);
        }
        return obj;
    }
}

