/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.ResourceBundle;
import org.apache.logging.log4j.message.AbstractMessageFactory;
import org.apache.logging.log4j.message.LocalizedMessage;
import org.apache.logging.log4j.message.Message;

public class LocalizedMessageFactory
extends AbstractMessageFactory {
    private static final long serialVersionUID = 1L;
    private final ResourceBundle resourceBundle;
    private final String baseName;

    public LocalizedMessageFactory(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.baseName = null;
    }

    public LocalizedMessageFactory(String baseName) {
        this.resourceBundle = null;
        this.baseName = baseName;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    @Override
    public Message newMessage(String message, Object ... params) {
        if (this.resourceBundle == null) {
            return new LocalizedMessage(this.baseName, message, params);
        }
        return new LocalizedMessage(this.resourceBundle, message, params);
    }
}

