/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.jrap.grits.stax;

import java.util.ArrayList;
import java.util.List;
import org.systemsbiology.jrap.grits.stax.MSXMLParser;
import org.systemsbiology.jrap.grits.stax.Scan;
import org.systemsbiology.jrap.grits.stax.ScanHeader;

public class GRITSMSXMLParser {
    MSXMLParser parser = null;

    public GRITSMSXMLParser(String sFileName) {
        this.parser = new MSXMLParser(sFileName);
    }

    public List<Integer> getMS1ScanList() {
        ArrayList<Integer> ms1ScanList = new ArrayList<Integer>();
        try {
            if (this.parser != null) {
                for (int i = 1; i < this.parser.getMaxScanNumber() + 1; ++i) {
                    ScanHeader header = this.parser.rapHeader(i);
                    if (header == null || header.getMsLevel() != 1) continue;
                    ms1ScanList.add(i);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ms1ScanList;
    }

    public List<Scan> getScanAndSubScans(int iScanNumber) {
        ArrayList<Scan> scanList = new ArrayList<Scan>();
        try {
            Scan parentScan;
            if (this.parser != null && (parentScan = this.parser.rap(iScanNumber)) != null) {
                scanList.add(parentScan);
                boolean bGo = true;
                for (int i = iScanNumber + 1; bGo && i < this.parser.getMaxScanNumber(); ++i) {
                    ScanHeader header = this.parser.rapHeader(i);
                    if (header.getMsLevel() == parentScan.getHeader().msLevel) {
                        bGo = false;
                        continue;
                    }
                    if (header.getPrecursorScanNum() != iScanNumber) continue;
                    Scan scan = this.parser.rap(i);
                    scanList.add(scan);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return scanList;
    }

    public Scan getScan(int iScanNumber) {
        try {
            if (this.parser != null) {
                return this.parser.rap(iScanNumber);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

