/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.commands;

import java.util.List;
import org.eclipse.gef.commands.Command;
import org.grits.toolbox.editor.experimentdesigner.model.Connection;
import org.grits.toolbox.editor.experimentdesigner.model.ExperimentGraph;
import org.grits.toolbox.editor.experimentdesigner.model.GraphNode;
import org.grits.toolbox.editor.experimentdesigner.model.InputNode;
import org.grits.toolbox.editor.experimentdesigner.model.OutputNode;

public class GraphNodeShapeDeleteCommand
extends Command {
    private final GraphNode child;
    private final ExperimentGraph parent;
    private List sourceConnections;
    private List targetConnections;
    private boolean wasRemoved;

    public GraphNodeShapeDeleteCommand(ExperimentGraph parent, GraphNode child) {
        if (parent == null || child == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel("shape deletion");
        this.parent = parent;
        this.child = child;
    }

    private void addConnections(List connections) {
        for (Connection conn : connections) {
            conn.reconnect();
        }
    }

    public boolean canUndo() {
        return this.wasRemoved;
    }

    public boolean canExecute() {
        if (this.child instanceof InputNode || this.child instanceof OutputNode) {
            return false;
        }
        return super.canExecute();
    }

    public void execute() {
        this.sourceConnections = this.child.getSourceConnections();
        this.targetConnections = this.child.getTargetConnections();
        this.redo();
    }

    public void redo() {
        this.wasRemoved = this.parent.removeChild(this.child);
        if (this.wasRemoved) {
            this.removeConnections(this.sourceConnections);
            this.removeConnections(this.targetConnections);
        }
    }

    private void removeConnections(List connections) {
        for (Connection conn : connections) {
            conn.disconnect();
        }
    }

    public void undo() {
        if (this.parent.addChild(this.child)) {
            this.addConnections(this.sourceConnections);
            this.addConnections(this.targetConnections);
        }
    }
}

