/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.dialog;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.grits.toolbox.editor.experimentdesigner.model.GraphNode;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.ontology.ExperimentDesignOntologyAPI;

public class ProtocolCreationDialog
extends FormDialog {
    private static final Logger logger = Logger.getLogger(ProtocolCreationDialog.class);
    private GraphNode templateNode;
    private Text nameText;
    private Text descriptionText;
    Label errorLabel;
    ControlDecoration dec;
    String name = "";
    String description;
    ProtocolNode existing;
    Shell shell;
    ListDialog dialog;
    Text selectedProtocolDescription;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ProtocolNode getExisting() {
        return this.existing;
    }

    public void setExisting(ProtocolNode existing) {
        this.existing = existing;
    }

    public ProtocolCreationDialog(Shell shell, GraphNode node) {
        super(shell);
        this.templateNode = node;
        this.shell = shell;
    }

    protected void createFormContent(IManagedForm mform) {
        mform.getForm().setText("Please select a protocol");
        ScrolledForm scrolledForm = mform.getForm();
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.numColumns = 3;
        scrolledForm.getBody().setLayout((Layout)tableWrapLayout);
        FormToolkit toolkit = mform.getToolkit();
        Label nameLabel = toolkit.createLabel(scrolledForm.getBody(), "Name *", 0);
        TableWrapData twd_nameLabel = new TableWrapData(8, 16, 1, 1);
        twd_nameLabel.align = 2;
        nameLabel.setLayoutData((Object)twd_nameLabel);
        this.nameText = this.templateNode != null ? toolkit.createText(scrolledForm.getBody(), this.templateNode.getLabel(), 0) : toolkit.createText(scrolledForm.getBody(), "", 0);
        this.nameText.setLayoutData((Object)new TableWrapData(256, 16, 1, 1));
        this.dec = new ControlDecoration((Control)this.nameText, 16512);
        Image image = JFaceResources.getImage((String)"dialog_message_error_image");
        this.dec.setImage(image);
        this.dec.setDescriptionText("Name cannot be left empty");
        this.dec.hide();
        Button btnBrowseButton = new Button(scrolledForm.getBody(), 8);
        btnBrowseButton.setText("Browse");
        btnBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProtocolCreationDialog.this.dialog = new ListDialog(ProtocolCreationDialog.this.shell){

                    protected void okPressed() {
                        super.okPressed();
                        Object[] result = this.getResult();
                        int i = 0;
                        while (i < result.length) {
                            (this).ProtocolCreationDialog.this.existing = (ProtocolNode)result[i];
                            ProtocolCreationDialog.this.nameText.setText((this).ProtocolCreationDialog.this.existing.getLabel());
                            ProtocolCreationDialog.this.descriptionText.setText((this).ProtocolCreationDialog.this.existing.getDescription());
                            ++i;
                        }
                    }

                    protected Control createDialogArea(Composite container) {
                        Composite parent = (Composite)super.createDialogArea(container);
                        GridData descriptionTextData = new GridData();
                        descriptionTextData.minimumHeight = 80;
                        descriptionTextData.grabExcessHorizontalSpace = true;
                        descriptionTextData.grabExcessVerticalSpace = true;
                        descriptionTextData.horizontalAlignment = 4;
                        descriptionTextData.horizontalSpan = 3;
                        (this).ProtocolCreationDialog.this.selectedProtocolDescription = new Text(parent, 2562);
                        (this).ProtocolCreationDialog.this.selectedProtocolDescription.setLayoutData((Object)descriptionTextData);
                        (this).ProtocolCreationDialog.this.selectedProtocolDescription.setEditable(false);
                        return parent;
                    }
                };
                ProtocolCreationDialog.this.dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                ProtocolCreationDialog.this.dialog.setTitle("Protocol Selection");
                ProtocolCreationDialog.this.dialog.setLabelProvider((ILabelProvider)new ArrayLabelProvider());
                List<Object> input = new ArrayList();
                try {
                    input = ProtocolCreationDialog.this.templateNode != null && ((ProtocolNode)ProtocolCreationDialog.this.templateNode).getTemplateUri() != null ? new ExperimentDesignOntologyAPI().getProtocolVariantsByUri(((ProtocolNode)ProtocolCreationDialog.this.templateNode).getTemplateUri()) : new ExperimentDesignOntologyAPI().getAllProtocolVariants();
                }
                catch (Exception e) {
                    logger.warn((Object)"org.grits.toolbox.editor.experimentdesigner Cannot load the protocol variants! ", (Throwable)e);
                }
                ProtocolCreationDialog.this.dialog.setInput(input);
                ProtocolCreationDialog.this.dialog.setBlockOnOpen(false);
                ProtocolCreationDialog.this.dialog.open();
                ProtocolCreationDialog.this.dialog.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        ISelection object = event.getSelection();
                        Object node = ((StructuredSelection)object).getFirstElement();
                        (this).ProtocolCreationDialog.this.selectedProtocolDescription.setText(((ProtocolNode)node).getDescription());
                    }
                });
            }
        });
        toolkit.adapt((Control)btnBrowseButton, true, true);
        Label lblDescription = toolkit.createLabel(scrolledForm.getBody(), "Description", 0);
        lblDescription.setLayoutData((Object)new TableWrapData(8, 16, 1, 1));
        this.descriptionText = toolkit.createText(scrolledForm.getBody(), "", 578);
        this.descriptionText.setTextLimit(10000);
        TableWrapData twd_description = new TableWrapData(256, 16, 1, 1);
        twd_description.heightHint = 60;
        this.descriptionText.setLayoutData((Object)twd_description);
        this.descriptionText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && e.keyCode == 97) {
                    ((Text)e.widget).selectAll();
                }
            }
        });
        if (this.templateNode != null && this.templateNode.getDescription() != null) {
            this.descriptionText.setText(this.templateNode.getDescription());
        }
        Label empty = toolkit.createLabel(scrolledForm.getBody(), "", 0);
        empty.setLayoutData((Object)new TableWrapData(8, 16, 1, 1));
        this.errorLabel = toolkit.createLabel(scrolledForm.getBody(), "", 0);
        this.errorLabel.setLayoutData((Object)new TableWrapData(256, 64, 3, 3));
        toolkit.paintBordersFor(scrolledForm.getBody());
    }

    protected void okPressed() {
        this.name = this.nameText.getText();
        this.description = this.descriptionText.getText();
        DataBindingContext dataBindingContext = new DataBindingContext();
        Binding binding = dataBindingContext.bindValue((IObservableValue)SWTObservables.observeText((Control)this.nameText, (int)24), PojoProperties.value(ProtocolCreationDialog.class, (String)"name").observe((Object)this), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new StringRequiredValidator("Name cannot be left empty", this.dec)), null);
        if (((Status)binding.getValidationStatus().getValue()).isOK()) {
            try {
                List<ProtocolNode> existingTemplates;
                if ((this.templateNode == null || this.templateNode.getLabel() == null) && this.existing == null && (existingTemplates = new ExperimentDesignOntologyAPI().getProtocolsByLabel(this.name)) != null && existingTemplates.size() > 0) {
                    this.errorLabel.setForeground(ColorConstants.red);
                    this.errorLabel.setText("Please provide a unique name. A protocol template with this name already exists!");
                    return;
                }
            }
            catch (Exception e) {
                logger.warn((Object)"org.grits.toolbox.editor.experimentdesigner Cannot retrieve the protocol templates! ", (Throwable)e);
            }
            super.okPressed();
        } else {
            this.errorLabel.setForeground(ColorConstants.red);
            this.errorLabel.setText("Please provide a name");
        }
    }

    static class ArrayLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ArrayLabelProvider() {
        }

        public String getText(Object element) {
            return ((ProtocolNode)element).getLabel();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((ProtocolNode)element).getLabel();
        }

        public void dispose() {
            super.dispose();
        }
    }

    class StringRequiredValidator
    implements IValidator {
        private final String errorText;
        private final ControlDecoration controlDecoration;

        public StringRequiredValidator(String errorText, ControlDecoration controlDecoration) {
            this.errorText = errorText;
            this.controlDecoration = controlDecoration;
        }

        public IStatus validate(Object value) {
            String text;
            if (value instanceof String && (text = (String)value).trim().length() == 0) {
                this.controlDecoration.show();
                return ValidationStatus.error((String)this.errorText);
            }
            this.controlDecoration.hide();
            ProtocolCreationDialog.this.errorLabel.setText("");
            return Status.OK_STATUS;
        }
    }
}

