/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.handler;

import java.io.File;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.Property;
import org.grits.toolbox.core.editor.EditorHandler;
import org.grits.toolbox.core.service.IGritsDataModelService;
import org.grits.toolbox.core.service.IGritsUIService;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.editor.experimentdesigner.handler.NewExperimentHandler;
import org.grits.toolbox.entry.sample.property.SampleProperty;

public class ViewExperimentDesignHandler {
    private static final Logger logger = Logger.getLogger(ViewExperimentDesignHandler.class);
    @Inject
    private static IGritsDataModelService gritsDataModelService = null;
    @Inject
    static IGritsUIService gritsUIService = null;
    @Inject
    ECommandService commandService;
    @Inject
    EHandlerService handlerService;

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") Object object, IEventBroker eventBroker, @Named(value="activeShell") Shell shell) {
        Entry entry = null;
        if (object instanceof Entry) {
            entry = (Entry)object;
        } else if (object instanceof StructuredSelection && ((StructuredSelection)object).getFirstElement() instanceof Entry) {
            entry = (Entry)((StructuredSelection)object).getFirstElement();
        }
        if (entry == null && gritsDataModelService.getLastSelection() != null && gritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
            entry = (Entry)gritsDataModelService.getLastSelection().getFirstElement();
        }
        if (entry == null) {
            return;
        }
        Property prop = entry.getProperty();
        if (prop instanceof SampleProperty) {
            String experimentFileName = ((SampleProperty)prop).getSampleFile().getName().replace("sample", "experiment");
            File experimentFolder = NewExperimentHandler.getExperimentDirectory(entry);
            File file = new File(String.valueOf(experimentFolder.getAbsolutePath()) + File.separator + experimentFileName);
            if (!file.exists()) {
                ParameterizedCommand myCommand = this.commandService.createCommand("projectexplorer.command.newexperiment", null);
                try {
                    this.handlerService.executeHandler(myCommand);
                }
                catch (Exception ex) {
                    ErrorUtils.createErrorMessageBox((Shell)shell, (String)"Cannot create the Experiment", (Exception)ex);
                    logger.error((Object)"org.grits.toolbox.editor.experimentdesigner Cannot create the Experiment", (Throwable)ex);
                }
            } else {
                List children = entry.getChildren();
                for (Entry entry2 : children) {
                    Property prop2 = entry2.getProperty();
                    if (!prop2.getType().equals("org.grits.toolbox.property.experiment")) continue;
                    EditorHandler.openEditorForEntry((Entry)entry2);
                    PropertyHandler.changePerspective((String)"org.grits.toolbox.editor.experimentdesigner.designPerspective");
                    PropertyHandler.changePerspective((String)"org.grits.toolbox.editor.experimentdesigner.designPerspective.<Experiment Design>");
                    break;
                }
            }
        }
    }

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") Object object) {
        Entry entry = null;
        if (object instanceof Entry) {
            entry = (Entry)object;
        } else if (object instanceof StructuredSelection && ((StructuredSelection)object).getFirstElement() instanceof Entry) {
            entry = (Entry)((StructuredSelection)object).getFirstElement();
        }
        if (entry == null && gritsDataModelService.getLastSelection() != null && gritsDataModelService.getLastSelection().getFirstElement() instanceof Entry) {
            entry = (Entry)gritsDataModelService.getLastSelection().getFirstElement();
        }
        return entry != null && entry.getProperty().getType().equals("org.grits.toolbox.property.sample");
    }
}

