/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.eclipse.draw2d.geometry.Dimension;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.editor.experimentdesigner.model.Connection;
import org.grits.toolbox.editor.experimentdesigner.model.GraphNode;
import org.grits.toolbox.editor.experimentdesigner.model.InputNode;
import org.grits.toolbox.editor.experimentdesigner.model.ModelElement;
import org.grits.toolbox.editor.experimentdesigner.model.OutputNode;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;

@XmlRootElement
@XmlType(propOrder={"description", "nodes", "connections"})
public class ExperimentGraph
extends ModelElement {
    public static String CURRENT_VERSION = "1.0";
    public static final String CHILD_ADDED_PROP = "Graph.ChildAdded";
    public static final String CHILD_REMOVED_PROP = "Graph.ChildRemoved";
    private static final long serialVersionUID = 1L;
    private List<GraphNode> nodes = new ArrayList<GraphNode>();
    private List<Connection> connections = new ArrayList<Connection>();
    private String name;
    private String description;
    private String createdBy;
    private Date dateCreated;
    private String uri;
    private Entry projectEntry;

    public boolean addChild(GraphNode n) {
        if (n != null && this.nodes.add(n)) {
            n.setId(this.getNextAvailableNodeId());
            this.firePropertyChange(CHILD_ADDED_PROP, null, n);
            if (this.connections == null) {
                this.connections = new ArrayList<Connection>();
            }
            this.connections.addAll(n.getSourceConnections());
            this.connections.addAll(n.getTargetConnections());
            return true;
        }
        return false;
    }

    private Integer getNextAvailableNodeId() {
        Integer lastMaxId = 0;
        for (GraphNode node : this.nodes) {
            if (node.getId() == null || node.getId() <= lastMaxId) continue;
            lastMaxId = node.getId();
        }
        return lastMaxId + 1;
    }

    public List getChildren() {
        return this.nodes;
    }

    public boolean removeChild(GraphNode n) {
        if (n != null && this.nodes.remove(n)) {
            this.firePropertyChange(CHILD_REMOVED_PROP, null, n);
            if (this.connections != null) {
                this.connections.removeAll(n.getSourceConnections());
                this.connections.removeAll(n.getTargetConnections());
            }
            return true;
        }
        return false;
    }

    @XmlElements(value={@XmlElement(name="input", type=InputNode.class), @XmlElement(name="output", type=OutputNode.class), @XmlElement(name="protocol", type=ProtocolNode.class)})
    public List<GraphNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<GraphNode> nodes) {
        this.nodes = nodes;
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlAttribute
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @XmlAttribute
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @XmlAttribute
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public List<Connection> getConnections() {
        if (this.connections != null) {
            for (GraphNode node : this.nodes) {
                List<Connection> sourceConnections = node.getSourceConnections();
                for (Connection connection : sourceConnections) {
                    if (this.connections.contains(connection)) continue;
                    this.connections.add(connection);
                }
                List<Connection> targetConnections = node.getTargetConnections();
                for (Connection connection : targetConnections) {
                    if (this.connections.contains(connection)) continue;
                    this.connections.add(connection);
                }
            }
        }
        return this.connections;
    }

    @XmlElementWrapper(name="connections")
    public void setConnections(List<Connection> connections) {
        this.connections = connections;
    }

    public void setConnectionsToNodes() {
        if (this.connections == null) {
            return;
        }
        block0: for (Connection connection : this.connections) {
            GraphNode source = connection.getSource();
            for (GraphNode node : this.nodes) {
                if (!node.equals(source)) continue;
                connection.setSource(node);
                node.addConnection(connection);
                break;
            }
            GraphNode target = connection.getTarget();
            for (GraphNode node : this.nodes) {
                if (!node.equals(target)) continue;
                connection.setTarget(node);
                node.addConnection(connection);
                continue block0;
            }
        }
    }

    public void setProjectEntry(Entry parent) {
        this.projectEntry = parent;
    }

    @XmlTransient
    public Entry getProjectEntry() {
        return this.projectEntry;
    }

    public Dimension calculateSize() {
        Dimension size = new Dimension();
        float offsetX = 0.0f;
        float rightX = 0.0f;
        float bottomY = 0.0f;
        int i = 0;
        for (GraphNode node : this.nodes) {
            if (i == 0) {
                offsetX = node.getLocation().x;
            }
            bottomY = Math.max((float)(node.getLocation().y + node.getSize().height), bottomY);
            rightX = Math.max((float)(node.getLocation().x + node.getSize().width), rightX);
            ++i;
        }
        size.setSize((int)Math.ceil(rightX + offsetX), (int)Math.ceil(bottomY));
        return size;
    }

    public void removeConnection(Connection connection) {
        if (connection != null) {
            this.connections.remove(connection);
        }
    }

    public void addConnection(Connection connection) {
        if (connection != null && !this.connections.contains(connection)) {
            this.connections.add(connection);
        }
    }
}

