/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.views;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.impl.DirectToolItemImpl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityEditor;
import org.grits.toolbox.editor.experimentdesigner.editor.GraphEditor;
import org.grits.toolbox.editor.experimentdesigner.model.Paper;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.parts.GraphNodeEditPart;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class PaperView {
    public static final String VIEW_ID = "org.grits.toolbox.editor.experimentdesigner.part.paperview";
    public static final String EVENT_TOPIC_PAPER = "Paper_to_be_deleted";
    private static Logger logger = Logger.getLogger(PaperView.class);
    private ProtocolNode protocol = null;
    private TableViewer tableViewer;
    @Inject
    ESelectionService selectionService;
    @Inject
    IEventBroker eventBroker;
    private DirectToolItemImpl deleteToolItem;
    private final EventHandler closePartEventHandler = new EventHandler(){

        public void handleEvent(Event event) {
            Object part = event.getProperty("ChangedElement");
            if (part == null) {
                return;
            }
            boolean toBeRendered = (Boolean)event.getProperty("NewValue");
            if (!toBeRendered && part instanceof MPart && ((MPart)part).getObject() instanceof CompatibilityEditor && ((CompatibilityEditor)((MPart)part).getObject()).getEditor() instanceof GraphEditor && !PaperView.this.tableViewer.getTable().isDisposed()) {
                PaperView.this.tableViewer.setInput(null);
                PaperView.this.protocol = null;
            }
        }
    };

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public ProtocolNode getProtocol() {
        return this.protocol;
    }

    @PostConstruct
    public void createPartControl(Composite parent, MPart part, EModelService modelService) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.tableViewer = new TableViewer((Composite)scrolledComposite, 67584);
        Table table = this.tableViewer.getTable();
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn idColumn = tableViewerColumn.getColumn();
        idColumn.setText("Article");
        idColumn.setWidth(680);
        tableViewerColumn.setLabelProvider((CellLabelProvider)new OwnerDrawLabelProvider(){

            protected void measure(org.eclipse.swt.widgets.Event event, Object element) {
                Paper paper = (Paper)element;
                Point size = event.gc.textExtent(paper.toString());
                event.width = size.x;
                event.height = size.y;
                int currentWidth = PaperView.this.tableViewer.getTable().getColumn(event.index).getWidth();
                if (size.x > currentWidth) {
                    PaperView.this.tableViewer.getTable().getColumn(event.index).setWidth(size.x + 1);
                }
            }

            protected void paint(org.eclipse.swt.widgets.Event event, Object element) {
                Paper entry = (Paper)element;
                event.gc.drawText(entry.toString(), event.x, event.y, true);
            }
        });
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                List<Paper> papers;
                if (inputElement != null && (papers = ((ProtocolNode)inputElement).getPapers()) != null) {
                    return papers.toArray();
                }
                return super.getElements(inputElement);
            }
        });
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Table t = (Table)e.getSource();
                TableItem[] selection = t.getSelection();
                if (selection.length == 0) {
                    PaperView.this.eventBroker.send("org/eclipse/e4/ui/renderer/requestEnablementUpdate", (Object)"ALL");
                    PaperView.this.deleteToolItem.setEnabled(false);
                }
                int i = 0;
                while (i < selection.length) {
                    Object s = selection[i].getData();
                    if (s instanceof Paper) {
                        PaperView.this.selectionService.setSelection((Object)((Paper)s));
                        PaperView.this.eventBroker.send("org/eclipse/e4/ui/renderer/requestEnablementUpdate", (Object)"ALL");
                        PaperView.this.deleteToolItem.setEnabled(true);
                        break;
                    }
                    ++i;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        scrolledComposite.setContent((Control)table);
        scrolledComposite.setSize(table.computeSize(-1, -1));
        this.deleteToolItem = (DirectToolItemImpl)modelService.find("org.grits.toolbox.editor.experimentdesigner.directtoolitem.deletepaper", (MUIElement)part.getToolbar());
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", this.closePartEventHandler);
    }

    @PreDestroy
    public void preDestroy(MPart part) {
        this.eventBroker.unsubscribe(this.closePartEventHandler);
    }

    @Focus
    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    @Inject
    void setSelection(@Optional @Named(value="org.eclipse.ui.selection") Object selection) {
        if (selection != null && !(selection instanceof StructuredSelection)) {
            return;
        }
        if (selection == null || !(((StructuredSelection)selection).getFirstElement() instanceof GraphNodeEditPart)) {
            this.protocol = null;
            if (this.tableViewer != null && !this.tableViewer.getTable().isDisposed()) {
                this.tableViewer.setInput(null);
            }
        } else if (((StructuredSelection)selection).getFirstElement() instanceof GraphNodeEditPart) {
            Object modelObject = ((GraphNodeEditPart)((StructuredSelection)selection).getFirstElement()).getModel();
            if (modelObject instanceof ProtocolNode) {
                this.protocol = (ProtocolNode)modelObject;
                if (this.tableViewer != null && !this.tableViewer.getTable().isDisposed()) {
                    this.tableViewer.setInput((Object)this.protocol);
                }
            } else {
                this.protocol = null;
                if (this.tableViewer != null && !this.tableViewer.getTable().isDisposed()) {
                    this.tableViewer.setInput(null);
                }
            }
        }
    }
}

