/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.datamodel.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.swt.widgets.Display;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.datamodel.io.MissingReaderException;
import org.grits.toolbox.core.datamodel.io.PropertyReader;
import org.grits.toolbox.core.datamodel.io.project.ProjectFileReader;
import org.grits.toolbox.core.datamodel.io.project.ProjectFileWriter;
import org.grits.toolbox.core.datamodel.property.ProjectProperty;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.utilShare.ErrorUtils;

@Singleton
public class ProjectFileHandler {
    private static final Logger logger = Logger.getLogger(ProjectFileHandler.class);
    public static final SimpleDateFormat DATEFORMATER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);
    private static ProjectFileReader projectFileReader = null;
    private static ProjectFileWriter projectFileWriter = null;
    @Inject
    @Named(value="workspace_location")
    static String workspaceLocation;

    @Inject
    public ProjectFileHandler(IEclipseContext eclipseContext) {
        projectFileReader = (ProjectFileReader)ContextInjectionFactory.make(ProjectFileReader.class, (IEclipseContext)eclipseContext);
        projectFileWriter = (ProjectFileWriter)ContextInjectionFactory.make(ProjectFileWriter.class, (IEclipseContext)eclipseContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Entry createProject(String projectName, String description) throws FileAlreadyExistsException, IOException {
        Entry projectEntry = null;
        if (projectName != null) {
            String projectFolderName = String.valueOf(workspaceLocation) + projectName;
            File projectFolder = new File(projectFolderName);
            if (projectFolder.exists()) throw new FileAlreadyExistsException("Cannot create project as project folder already exists : " + projectFolderName + " at " + projectFolder.getAbsolutePath());
            projectFolder.mkdir();
            projectEntry = new Entry();
            projectEntry.setDisplayName(projectName);
            projectEntry.setCreationDate(new Date());
            projectEntry.setProperty(new ProjectProperty());
            projectFileWriter.createProjectFiles(projectEntry, description);
            return projectEntry;
        } else {
            logger.error((Object)"project name is null.");
        }
        return projectEntry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Entry loadProject(String projectName) throws FileNotFoundException, IOException, UnsupportedVersionException, MissingReaderException {
        Entry projectEntry = null;
        if (projectName != null) {
            String projectFolderName = String.valueOf(workspaceLocation) + projectName + File.separator + ".project.xml";
            File projectXmlFile = new File(projectFolderName);
            if (!projectXmlFile.exists()) throw new FileNotFoundException("\".project.xml\" file is missing : " + projectFolderName + " at " + projectXmlFile.getAbsolutePath());
            try {
                projectEntry = projectFileReader.readProjectXMLFile(projectXmlFile);
                if (!PropertyReader.UPDATE_PROJECT_XML) return projectEntry;
                projectFileWriter.createProjectXMLFile(projectEntry);
                PropertyReader.UPDATE_PROJECT_XML = false;
                return projectEntry;
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                throw new IOException("Error reading project : " + projectName + ".\n" + ex.getMessage(), ex);
            }
        } else {
            logger.error((Object)"project name is null.");
        }
        return projectEntry;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Entry loadPartialProject(String projectName) throws FileNotFoundException, IOException {
        Entry projectEntry = null;
        if (projectName != null) {
            String projectFolderName = String.valueOf(workspaceLocation) + projectName + File.separator + ".project.xml";
            File projectXmlFile = new File(projectFolderName);
            if (!projectXmlFile.exists()) throw new FileNotFoundException("\".project.xml\" file is missing : " + projectFolderName + " at " + projectXmlFile.getAbsolutePath());
            try {
                return projectFileReader.readPartialProjectXMLFile(projectXmlFile);
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                throw new IOException("Error reading project : " + projectName + ".\n" + ex.getMessage(), ex);
            }
        }
        logger.error((Object)"project name is null.");
        return projectEntry;
    }

    public static boolean saveProject(Entry projectEntry) throws FileNotFoundException, IOException {
        boolean saved = false;
        if (projectEntry != null) {
            projectFileWriter.createProjectXMLFile(projectEntry);
            saved = true;
        } else {
            logger.error((Object)"project entry is null.");
        }
        return saved;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean renameEntryInProject(Entry entryToBeRenamed, String newName) throws FileNotFoundException, IOException {
        boolean renamed = false;
        if (entryToBeRenamed != null && newName != null && !newName.isEmpty()) {
            Entry projectEntry = DataModelSearch.findParentByType(entryToBeRenamed, "org.grits.toolbox.property.project");
            String projectFolderLocation = String.valueOf(workspaceLocation) + projectEntry.getDisplayName();
            try {
                File projectFolder = new File(projectFolderLocation);
                if (!projectFolder.exists() || !projectFolder.isDirectory()) return renamed;
                File projectXmlFile = null;
                File[] fileArray = projectFolder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File childFile = fileArray[n2];
                    if (childFile.isFile() && childFile.getName().equals(".project.xml")) {
                        projectXmlFile = childFile;
                        break;
                    }
                    ++n2;
                }
                if (projectXmlFile == null) return renamed;
                projectFileWriter.renameEntryInProject(projectXmlFile, entryToBeRenamed, newName);
                return renamed;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                ErrorUtils.createErrorMessageBox(Display.getCurrent().getActiveShell(), "Unable to update project xml", e);
                return false;
            }
        } else {
            logger.error((Object)"project entry is null.");
        }
        return renamed;
    }

    public static boolean deleteEntryFromProject(Entry childEntry) throws FileAlreadyExistsException, IOException {
        boolean deleted = false;
        if (childEntry != null) {
            Entry projectEntry = DataModelSearch.findParentByType(childEntry, "org.grits.toolbox.property.project");
            if (ProjectFileHandler.removeEntry(projectEntry, childEntry)) {
                projectFileWriter.createProjectXMLFile(projectEntry);
                deleted = true;
            }
        } else {
            logger.error((Object)"project entry is null.");
        }
        return deleted;
    }

    private static boolean removeEntry(Entry parentEntry, Entry childToRemove) {
        boolean removed = false;
        removed = parentEntry.removeChild(childToRemove);
        if (!removed) {
            for (Entry child : parentEntry.getChildren()) {
                if (!ProjectFileHandler.removeEntry(child, childToRemove)) continue;
                removed = true;
                break;
            }
        }
        return removed;
    }
}

