/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.datamodel.io.project;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.grits.toolbox.core.datamodel.UnsupportedVersionException;
import org.grits.toolbox.core.datamodel.io.PropertyReader;
import org.grits.toolbox.core.datamodel.io.project.readers.ReaderVersion0;
import org.grits.toolbox.core.datamodel.io.project.readers.ReaderVersion1;
import org.grits.toolbox.core.datamodel.property.ProjectProperty;
import org.grits.toolbox.core.datamodel.property.Property;
import org.jdom.Element;

public class ProjectPropertyReader
extends PropertyReader {
    private static final Logger logger = Logger.getLogger(ProjectPropertyReader.class);

    @Override
    public Property read(Element propertyElement) throws IOException, UnsupportedVersionException {
        ProjectProperty property = new ProjectProperty();
        PropertyReader.addGenericInfo(propertyElement, property);
        if (property.getVersion() == null) {
            logger.debug((Object)"Loading pre-versioning project.");
            return ReaderVersion0.read(propertyElement, property);
        }
        if (property.getVersion().equals("1.0")) {
            logger.debug((Object)"Loading project version \"1.0\"");
            return ReaderVersion1.read(propertyElement, property);
        }
        throw new UnsupportedVersionException("This project version is currently not supported.", property.getVersion());
    }
}

