/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.editor;

import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.util.DataModelSearch;
import org.grits.toolbox.core.editor.ICancelableEditor;
import org.grits.toolbox.core.editor.ViewInput;
import org.grits.toolbox.core.utilShare.ErrorUtils;
import org.grits.toolbox.core.utilShare.SaveUtils;

@Deprecated
public class EditorHandler {
    private static final Logger logger = Logger.getLogger(EditorHandler.class);
    @Inject
    private static IEventBroker eventBroker;

    private static String openInEditor(Entry a_entry, boolean forceClose) throws PartInitException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        ViewInput input = new ViewInput();
        input.setEntry(a_entry);
        String t_editorId = EditorHandler.findEditorId(a_entry);
        if (t_editorId != null) {
            IEditorPart editorPart;
            IEditorPart editor;
            String perspectiveId;
            if (t_editorId.contains("experimentdesigner")) {
                logger.debug((Object)"Switching into org.grits.toolbox.editor.experimentdesigner.designPerspective1");
                perspectiveId = "org.grits.toolbox.editor.experimentdesigner.designPerspective1";
                try {
                    PlatformUI.getWorkbench().showPerspective(perspectiveId, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }
                catch (WorkbenchException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    PropertyHandler.changePerspective("org.grits.toolbox.core.perspective.projectexplorer");
                    throw new PartInitException(e.getMessage(), (Throwable)e);
                }
            } else if (t_editorId.contains("glycanarray")) {
                perspectiveId = "uk.ac.imperial.glycosciences.glycanarray.perspective";
                try {
                    PlatformUI.getWorkbench().showPerspective(perspectiveId, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }
                catch (WorkbenchException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    PropertyHandler.changePerspective("org.grits.toolbox.core.perspective.projectexplorer");
                    throw new PartInitException(e.getMessage(), (Throwable)e);
                }
            } else if (t_editorId.contains("qrtpcr")) {
                perspectiveId = "org.grits.toolbox.entry.qrtpcr.perspective";
                try {
                    PlatformUI.getWorkbench().showPerspective(perspectiveId, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                }
                catch (WorkbenchException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    PropertyHandler.changePerspective("org.grits.toolbox.core.perspective.projectexplorer");
                    throw new PartInitException(e.getMessage(), (Throwable)e);
                }
            } else {
                PropertyHandler.changePerspective("org.grits.toolbox.core.perspective.projectexplorer");
            }
            if (forceClose && (editor = page.findEditor((IEditorInput)input)) != null) {
                page.closeEditor(editor, false);
            }
            if ((editorPart = page.openEditor((IEditorInput)input, t_editorId, true, 3)) instanceof ICancelableEditor && ((ICancelableEditor)editorPart).isCanceled()) {
                IEditorPart editor2 = page.findEditor((IEditorInput)input);
                page.closeEditor(editor2, false);
                return "CANCELED";
            }
        }
        return t_editorId;
    }

    private static String findEditorId(Entry a_entry) {
        IExtension[] t_extentions;
        String t_editorId = null;
        IExtension[] iExtensionArray = t_extentions = Platform.getExtensionRegistry().getExtensionPoint("org.grits.toolbox.core", "entryeditor").getExtensions();
        int n = t_extentions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] t_configElements;
            IExtension t_extention = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = t_configElements = t_extention.getConfigurationElements();
            int n3 = t_configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement t_configurationElement = iConfigurationElementArray[n4];
                if (t_configurationElement.getName().equals("editor")) {
                    if (t_configurationElement.getAttribute("propertyId") == null) {
                        logger.fatal((Object)("entry editor misses propertyId attibute: " + t_configurationElement.toString()));
                    } else if (t_configurationElement.getAttribute("propertyId").equals(a_entry.getProperty().getType())) {
                        String t_newEditorId = t_configurationElement.getAttribute("editorId");
                        if (t_newEditorId == null) {
                            logger.fatal((Object)("entry editor misses editorId attibute: " + t_configurationElement.toString()));
                        } else {
                            if (a_entry.getLastEditorId() != null && a_entry.getLastEditorId().equals(t_editorId)) {
                                return t_newEditorId;
                            }
                            String t_defaultAttribute = t_configurationElement.getAttribute("default");
                            boolean t_newDefault = false;
                            if (t_defaultAttribute != null && t_defaultAttribute.equalsIgnoreCase("true")) {
                                t_newDefault = true;
                            }
                            if (t_newDefault) {
                                t_editorId = t_newEditorId;
                            } else if (t_editorId == null) {
                                t_editorId = t_newEditorId;
                            }
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return t_editorId;
    }

    public static void openEditorForEntry(Entry a_entry) {
        EditorHandler.openEditorForEntry(a_entry, false);
    }

    public static void openEditorForEntry(Entry a_entry, boolean forceClose) {
        try {
            String t_editor = EditorHandler.openInEditor(a_entry, forceClose);
            if (t_editor == null) {
                logger.debug((Object)("Unable to find editor for property type: " + a_entry.getProperty().getType()));
                ErrorUtils.createErrorMessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Unable to find editor for property type: " + a_entry.getProperty().getType());
            } else {
                if (t_editor.equals("CANCELED")) {
                    return;
                }
                a_entry.setLastEditorId(t_editor);
                try {
                    SaveUtils.saveProjectWithEntry(a_entry);
                }
                catch (IOException e) {
                    logger.error((Object)("Error updating the editor: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ErrorUtils.createErrorMessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), e.getMessage(), e);
        }
    }

    public static void selectEntry(Entry a_entry) {
        try {
            if (a_entry != null) {
                eventBroker.send("grits_entry_selected", (Object)a_entry);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            ErrorUtils.createErrorMessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), e.getMessage(), e);
        }
    }

    public static void closeEditorsForEntry(Entry entry) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ArrayList<IEditorReference> toCloseEditor = new ArrayList<IEditorReference>();
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference ref = iEditorReferenceArray[n2];
            try {
                ViewInput input = (ViewInput)ref.getEditorInput();
                Entry found = DataModelSearch.findParentByType(input.getEntry(), entry.getProperty().getType());
                if (found != null && found.equals(entry)) {
                    toCloseEditor.add(ref);
                }
            }
            catch (PartInitException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                ErrorUtils.createErrorMessageBox(Display.getCurrent().getActiveShell(), e.getMessage(), (Exception)((Object)e));
            }
            ++n2;
        }
        IEditorReference[] closeEditor = new IEditorReference[toCloseEditor.size()];
        toCloseEditor.toArray(closeEditor);
        page.closeEditors(closeEditor, true);
    }
}

