/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.project;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.grits.toolbox.core.datamodel.property.project.ProjectCollaborator;
import org.grits.toolbox.core.part.toolitem.SaveCollaborator;
import org.grits.toolbox.core.preference.project.CollaboratorInfoDialog;
import org.grits.toolbox.core.preference.share.MultiChoicePreference;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.utilShare.CheckboxTableViewer;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.core.utilShare.sort.TableColumnComparatorListener;
import org.grits.toolbox.core.utilShare.sort.TableViewerComparator;

public class CollaboratorPreference
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(CollaboratorPreference.class);
    private MultiChoicePreference<ProjectCollaborator> collaboratorPreference = null;
    public List<ProjectCollaborator> defaultCollaborators = null;
    public List<ProjectCollaborator> otherCollaborators = null;
    private CheckboxTableViewer checkboxTableViewer = null;
    private Button addButton = null;
    private Button editButton = null;
    private Button removeButton = null;
    private CollaboratorInfoDialog dialog = null;

    private void loadValues() {
        logger.info((Object)("Loading preference " + ProjectPreferenceStore.ParameterizedPreference.COLLABORATOR.getPreferenceName()));
        this.collaboratorPreference = ProjectPreferenceStore.getMultiChoicePreference(ProjectPreferenceStore.ParameterizedPreference.COLLABORATOR);
        ProjectCollaborator copiedCollaborator = null;
        this.defaultCollaborators = new ArrayList<ProjectCollaborator>();
        for (ProjectCollaborator collaborator : this.collaboratorPreference.getSelectedValues()) {
            copiedCollaborator = collaborator.getACopy();
            copiedCollaborator.setAddByDefault(true);
            this.defaultCollaborators.add(copiedCollaborator);
        }
        this.otherCollaborators = new ArrayList<ProjectCollaborator>();
        for (ProjectCollaborator collaborator : this.collaboratorPreference.getOtherValues()) {
            copiedCollaborator = collaborator.getACopy();
            copiedCollaborator.setAddByDefault(false);
            this.otherCollaborators.add(copiedCollaborator);
        }
        this.dialog = new CollaboratorInfoDialog(this.getShell());
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.marginBottom = 8;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 10;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        this.createTablePart(container);
        this.createButtonPart(container);
        this.loadValues();
        this.initializeTable();
        return container;
    }

    private void createTablePart(Composite container) {
        Table collaboratorsTable = new Table(container, 68356);
        GridData tableLayouData = new GridData(1808);
        tableLayouData.horizontalSpan = 3;
        tableLayouData.verticalSpan = 1;
        tableLayouData.minimumHeight = 150;
        tableLayouData.heightHint = 300;
        collaboratorsTable.setLayoutData((Object)tableLayouData);
        this.checkboxTableViewer = new CheckboxTableViewer(collaboratorsTable, "Default");
        TableViewerColumn tableColumn2 = new TableViewerColumn((TableViewer)this.checkboxTableViewer, 4, 1);
        tableColumn2.getColumn().setText("Collaborators");
        tableColumn2.getColumn().setWidth(300);
        this.checkboxTableViewer.getTable().setHeaderVisible(true);
        this.checkboxTableViewer.getTable().setLinesVisible(true);
        this.checkboxTableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        this.checkboxTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                String value = null;
                if (columnIndex == 1 && element instanceof ProjectCollaborator) {
                    ProjectCollaborator collaborator = (ProjectCollaborator)element;
                    value = String.valueOf(collaborator.getName()) + " (";
                    value = String.valueOf(value) + (collaborator.getFundingAgency() == null || collaborator.getFundingAgency().isEmpty() ? " -- " : collaborator.getFundingAgency());
                    value = String.valueOf(value) + " ";
                    value = String.valueOf(value) + (collaborator.getGrantNumber() == null || collaborator.getGrantNumber().isEmpty() ? " -- " : collaborator.getGrantNumber());
                    value = String.valueOf(value) + ")";
                }
                return value;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        this.checkboxTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)CollaboratorPreference.this.checkboxTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    ProjectCollaborator selectedCollaborator = (ProjectCollaborator)selection.getFirstElement();
                    CollaboratorPreference.this.dialog.setCollaborator(selectedCollaborator.getACopy());
                    if (CollaboratorPreference.this.dialog.open() == 0) {
                        ProjectCollaborator editedCollaborator = CollaboratorPreference.this.dialog.getCollaborator();
                        List collaborators = (List)CollaboratorPreference.this.checkboxTableViewer.getInput();
                        collaborators.set(collaborators.indexOf(selectedCollaborator), editedCollaborator);
                        CollaboratorPreference.this.checkboxTableViewer.refresh();
                        CollaboratorPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)editedCollaborator));
                    }
                }
            }
        });
        this.checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectCollaborator projectCollaborator = (ProjectCollaborator)event.getElement();
                boolean checked = event.getChecked();
                projectCollaborator.setAddByDefault(checked);
                CollaboratorPreference.this.checkboxTableViewer.setChecked(projectCollaborator, checked);
            }
        });
        this.checkboxTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                if (element instanceof ProjectCollaborator) {
                    return ((ProjectCollaborator)element).isAddByDefault();
                }
                return false;
            }
        });
        this.addViewerComparator(this.checkboxTableViewer);
    }

    private void initializeTable() {
        ArrayList<ProjectCollaborator> input = new ArrayList<ProjectCollaborator>();
        input.addAll(this.otherCollaborators);
        input.addAll(this.defaultCollaborators);
        this.checkboxTableViewer.setInput(input);
        this.checkboxTableViewer.refresh();
    }

    private void addViewerComparator(TableViewer tableViewer) {
        tableViewer.setComparator((ViewerComparator)new TableViewerComparator());
        int totalColumns = tableViewer.getTable().getColumns().length;
        int i = 0;
        while (i < totalColumns) {
            tableViewer.getTable().getColumn(i).addSelectionListener((SelectionListener)new TableColumnComparatorListener(tableViewer));
            ++i;
        }
    }

    private void createButtonPart(Composite container) {
        Composite composite = new Composite(container, 4);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.marginTop = 20;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 10;
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        this.addButton = this.createButton(composite, "Add");
        this.editButton = this.createButton(composite, "Edit");
        this.removeButton = this.createButton(composite, "Delete");
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List collaborators = (List)CollaboratorPreference.this.checkboxTableViewer.getInput();
                CollaboratorPreference.this.dialog.setCollaborator(null);
                if (CollaboratorPreference.this.dialog.open() == 0) {
                    ProjectCollaborator newCollaborator = CollaboratorPreference.this.dialog.getCollaborator();
                    collaborators.add(newCollaborator);
                    CollaboratorPreference.this.checkboxTableViewer.refresh();
                    CollaboratorPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)newCollaborator));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)CollaboratorPreference.this.checkboxTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    ProjectCollaborator selectedCollaborator = (ProjectCollaborator)selection.getFirstElement();
                    CollaboratorPreference.this.dialog.setCollaborator(selectedCollaborator.getACopy());
                    if (CollaboratorPreference.this.dialog.open() == 0) {
                        ProjectCollaborator editedCollaborator = CollaboratorPreference.this.dialog.getCollaborator();
                        List collaborators = (List)CollaboratorPreference.this.checkboxTableViewer.getInput();
                        collaborators.set(collaborators.indexOf(selectedCollaborator), editedCollaborator);
                        CollaboratorPreference.this.checkboxTableViewer.refresh();
                        CollaboratorPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)editedCollaborator));
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List collaborators = (List)CollaboratorPreference.this.checkboxTableViewer.getInput();
                StructuredSelection selection = (StructuredSelection)CollaboratorPreference.this.checkboxTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    ProjectCollaborator selectedCollaborator = (ProjectCollaborator)selection.getFirstElement();
                    int selectionIndex = CollaboratorPreference.this.checkboxTableViewer.getTable().getSelectionIndex();
                    collaborators.remove(selectedCollaborator);
                    CollaboratorPreference.this.checkboxTableViewer.refresh();
                    selectionIndex = Math.max(selectionIndex - 1, 0);
                    CollaboratorPreference.this.checkboxTableViewer.getTable().select(selectionIndex);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private Button createButton(Composite composite, String buttonLabel) {
        Button button = new Button(composite, 0);
        button.setText(buttonLabel);
        GridData addButtonData = new GridData(0x1000008, 1, true, true, 1, 1);
        addButtonData.widthHint = 80;
        button.setLayoutData((Object)addButtonData);
        GridData compositeLayoutData = new GridData(0x1000008, 1, true, true);
        compositeLayoutData.horizontalSpan = 3;
        compositeLayoutData.verticalSpan = 1;
        composite.setLayoutData((Object)compositeLayoutData);
        return button;
    }

    protected void performDefaults() {
        this.defaultCollaborators = new ArrayList<ProjectCollaborator>();
        this.otherCollaborators = new ArrayList<ProjectCollaborator>();
        this.initializeTable();
        super.performDefaults();
    }

    protected void performApply() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage == null) {
            this.save();
        }
    }

    public boolean performOk() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage != null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("There is an error in \"Collaborator\" preference values. Please fix before saving! Error: " + errorMessage));
        }
        return errorMessage == null ? this.save() : false;
    }

    private String validateInput() {
        String errorMessage = null;
        List tableInput = (List)this.checkboxTableViewer.getInput();
        ArrayList<ProjectCollaborator> collaborators = new ArrayList<ProjectCollaborator>();
        for (ProjectCollaborator projectCollaborator : tableInput) {
            if (!SaveCollaborator.isUnique(collaborators, projectCollaborator)) {
                errorMessage = "Similar collaborators : " + projectCollaborator.getName();
                break;
            }
            collaborators.add(projectCollaborator);
        }
        return errorMessage;
    }

    private boolean save() {
        List tableInput = (List)this.checkboxTableViewer.getInput();
        this.defaultCollaborators = new ArrayList<ProjectCollaborator>();
        this.otherCollaborators = new ArrayList<ProjectCollaborator>();
        for (ProjectCollaborator projectCollaborator : tableInput) {
            if (this.checkboxTableViewer.getChecked(projectCollaborator)) {
                this.defaultCollaborators.add(projectCollaborator);
                continue;
            }
            this.otherCollaborators.add(projectCollaborator);
        }
        this.collaboratorPreference.setSelectedValues(this.defaultCollaborators);
        this.collaboratorPreference.setOtherValues(this.otherCollaborators);
        return this.collaboratorPreference.savePreference();
    }
}

