/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.project;

import org.apache.commons.collections4.trie.PatriciaTrie;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.typeahead.NamespaceHandler;
import org.grits.toolbox.core.typeahead.PatriciaTrieContentProposalProvider;

public class CountryPreference
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(CountryPreference.class);
    private Text text = null;
    private NamespaceHandler handler = null;
    private PatriciaTrie<String> trie = null;
    private PatriciaTrieContentProposalProvider contentProposalProvider = null;
    private ContentProposalAdapter contentProposalAdapter = null;
    private ProjectPreferenceStore.StringPreference countryPreference = null;
    protected IContentProposal[] proposals = null;

    public void initializeValue() {
        logger.info((Object)("Loading preference " + (Object)((Object)ProjectPreferenceStore.StringPreference.COUNTRY)));
        this.countryPreference = ProjectPreferenceStore.StringPreference.COUNTRY;
        String defaultCountry = this.countryPreference.getValue() == null ? "" : this.countryPreference.getValue();
        this.text.setText(defaultCountry);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 4);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 10;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText("Default Country");
        GridData selectExistingData = new GridData(32);
        selectExistingData.horizontalSpan = 1;
        selectExistingData.verticalSpan = 1;
        label.setLayoutData((Object)selectExistingData);
        this.text = new Text(container, 2048);
        GridData newcollaboratorData = new GridData(768);
        newcollaboratorData.grabExcessHorizontalSpace = true;
        newcollaboratorData.horizontalSpan = 1;
        newcollaboratorData.verticalSpan = 1;
        this.text.setLayoutData((Object)newcollaboratorData);
        try {
            this.handler = new NamespaceHandler("country", "preference", "countries.txt");
            this.trie = this.handler.getTrieForNamespace();
            this.contentProposalProvider = new PatriciaTrieContentProposalProvider(this.trie);
            this.contentProposalAdapter = new ContentProposalAdapter((Control)this.text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)this.contentProposalProvider, null, null);
            this.contentProposalAdapter.setProposalAcceptanceStyle(2);
            this.contentProposalAdapter.addContentProposalListener(new IContentProposalListener2(){

                public void proposalPopupOpened(ContentProposalAdapter adapter) {
                    CountryPreference.this.proposals = CountryPreference.this.contentProposalAdapter.getContentProposalProvider().getProposals(CountryPreference.this.contentProposalAdapter.getControlContentAdapter().getControlContents((Control)CountryPreference.this.text), CountryPreference.this.contentProposalAdapter.getControlContentAdapter().getCursorPosition((Control)CountryPreference.this.text));
                }

                public void proposalPopupClosed(ContentProposalAdapter adapter) {
                }
            });
        }
        catch (Exception ex) {
            logger.fatal((Object)ex.getMessage(), (Throwable)ex);
        }
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.keyCode == 27) {
                    e.doit = false;
                    if (CountryPreference.this.contentProposalAdapter != null && CountryPreference.this.contentProposalAdapter.isProposalPopupOpen()) {
                        CountryPreference.this.text.setText("");
                    }
                    e.detail = 0;
                }
            }
        });
        this.initializeValue();
        return container;
    }

    protected void performDefaults() {
        this.text.setText("");
    }

    protected void performApply() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage == null) {
            this.save();
        }
    }

    private String validateInput() {
        String country = this.text.getText();
        String errorMessage = "Not a valid country";
        if (this.proposals != null) {
            IContentProposal[] iContentProposalArray = this.proposals;
            int n = this.proposals.length;
            int n2 = 0;
            while (n2 < n) {
                IContentProposal proposal = iContentProposalArray[n2];
                if (proposal.getContent().equals(country)) {
                    errorMessage = null;
                    break;
                }
                ++n2;
            }
        } else {
            errorMessage = country.trim().isEmpty() ? null : errorMessage;
        }
        return errorMessage;
    }

    public boolean performOk() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage != null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("There is an error in \"Country\" preference values. Please fix before saving! Error: " + errorMessage));
        }
        return errorMessage == null ? this.save() : false;
    }

    private boolean save() {
        String defaultCountry = this.text.getText().trim();
        defaultCountry = defaultCountry.isEmpty() ? null : defaultCountry;
        this.countryPreference.setValue(defaultCountry);
        return this.countryPreference.savePreference();
    }
}

