/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.grits.toolbox.core.preference.project.StringLabelProvider;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.preference.share.SingleChoicePreference;
import org.grits.toolbox.core.utilShare.CheckboxTableViewer;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.core.utilShare.sort.CheckboxStringSorter;

public class PersonPreference
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(PersonPreference.class);
    public static final String PREFERENCE_PAGE_ID = "org.grits.toolbox.core.preference.project.tasklist.person";
    public static String lastSelection = null;
    private SingleChoicePreference personPreference = null;
    private List<String> allPersons = null;
    private String defaultPerson = null;
    private CheckboxTableViewer checkboxTableViewer = null;
    private TableViewerColumn tableColumn2 = null;

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.verticalSpacing = 15;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText("Persons");
        label.setLayoutData((Object)new GridData(32, 2, true, false, 2, 1));
        this.checkboxTableViewer = this.createPersonsTableViewer(container);
        Button addButton = this.createButton(container, "Add", true);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int newPersonCount = 1;
                while (PersonPreference.this.allPersons.contains("Person " + newPersonCount)) {
                    ++newPersonCount;
                }
                String newPerson = "Person " + newPersonCount;
                PersonPreference.this.allPersons.add(newPerson);
                if (PersonPreference.this.allPersons.size() == 1) {
                    PersonPreference.this.defaultPerson = newPerson;
                }
                PersonPreference.this.checkboxTableViewer.refresh();
                PersonPreference.this.tableColumn2.getViewer().editElement((Object)newPerson, 1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button removeButton = this.createButton(container, "Remove", false);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.remove();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.remove();
            }

            private void remove() {
                StructuredSelection selection = (StructuredSelection)PersonPreference.this.checkboxTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    String selectedPerson = (String)selection.getFirstElement();
                    int selectionIndex = PersonPreference.this.checkboxTableViewer.getTable().getSelectionIndex();
                    PersonPreference.this.allPersons.remove(selectedPerson);
                    if (selectedPerson.equals(PersonPreference.this.defaultPerson)) {
                        PersonPreference.this.defaultPerson = PersonPreference.this.allPersons.isEmpty() ? null : (String)PersonPreference.this.allPersons.iterator().next();
                    }
                    PersonPreference.this.checkboxTableViewer.refresh();
                    if (!PersonPreference.this.allPersons.isEmpty()) {
                        selectionIndex = Math.min(selectionIndex, PersonPreference.this.allPersons.size() - 1);
                        PersonPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection(PersonPreference.this.checkboxTableViewer.getElementAt(selectionIndex)));
                    }
                }
            }
        });
        this.checkboxTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)PersonPreference.this.checkboxTableViewer.getSelection();
                lastSelection = selection.isEmpty() ? lastSelection : (String)selection.getFirstElement();
            }
        });
        this.checkboxTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return element.equals(PersonPreference.this.defaultPerson);
            }
        });
        this.checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PersonPreference.this.defaultPerson = (String)event.getElement();
            }
        });
        this.loadValues();
        this.initializeTable();
        return container;
    }

    private void loadValues() {
        logger.info((Object)("Loading preference " + ProjectPreferenceStore.Preference.PERSON.getPreferenceName()));
        this.personPreference = ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.PERSON);
        this.allPersons = new ArrayList<String>();
        this.allPersons.addAll(this.personPreference.getAllValues());
        this.defaultPerson = this.personPreference.getDefaultValue();
    }

    private Button createButton(Composite container, String buttonText, boolean grabHorizontal) {
        Button button = new Button(container, 0);
        button.setText(buttonText);
        GridData buttonData = new GridData(128);
        buttonData.widthHint = 80;
        buttonData.verticalSpan = 1;
        buttonData.grabExcessHorizontalSpace = grabHorizontal;
        buttonData.verticalAlignment = 2;
        buttonData.grabExcessVerticalSpace = true;
        button.setLayoutData((Object)buttonData);
        return button;
    }

    private void initializeTable() {
        Collections.sort(this.allPersons, String.CASE_INSENSITIVE_ORDER);
        this.checkboxTableViewer.setInput(this.allPersons);
        this.checkboxTableViewer.refresh();
    }

    private CheckboxTableViewer createPersonsTableViewer(Composite container) {
        Table personsTable = new Table(container, 68356);
        GridData tableLayouData = new GridData(1808);
        tableLayouData.horizontalSpan = 2;
        tableLayouData.verticalSpan = 1;
        tableLayouData.minimumHeight = 260;
        tableLayouData.heightHint = 300;
        personsTable.setLayoutData((Object)tableLayouData);
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(personsTable, "Default", true);
        this.tableColumn2 = new TableViewerColumn((TableViewer)tableViewer, 4, 1);
        this.tableColumn2.getColumn().setText("Persons");
        this.tableColumn2.getColumn().setWidth(300);
        this.tableColumn2.setEditingSupport(new EditingSupport((ColumnViewer)tableViewer, tableViewer){
            TextCellEditor textEditor;
            {
                this.textEditor = new TextCellEditor((Composite)checkboxTableViewer.getTable());
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof String && value instanceof String) {
                    String newValue = ((String)value).trim();
                    if (PersonPreference.this.checkboxTableViewer.getChecked(element)) {
                        PersonPreference.this.defaultPerson = newValue;
                    }
                    if (PersonPreference.this.allPersons.contains(element)) {
                        PersonPreference.this.allPersons.set(PersonPreference.this.allPersons.indexOf(element), newValue);
                    }
                    PersonPreference.this.checkboxTableViewer.refresh();
                    PersonPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)newValue));
                }
            }

            protected Object getValue(Object element) {
                return element;
            }

            protected CellEditor getCellEditor(Object element) {
                return element instanceof String ? this.textEditor : null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof String;
            }
        });
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLinesVisible(true);
        tableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new StringLabelProvider());
        this.tableColumn2.getColumn().addSelectionListener((SelectionListener)new CheckboxStringSorter(tableViewer));
        return tableViewer;
    }

    protected void performDefaults() {
        Map<String, Boolean> allPersonsMap = this.personPreference.loadDefaultValues(ProjectPreferenceStore.Preference.PERSON);
        this.allPersons = new ArrayList<String>();
        this.defaultPerson = null;
        for (String person : allPersonsMap.keySet()) {
            this.allPersons.add(person);
            if (!allPersonsMap.get(person).booleanValue()) continue;
            this.defaultPerson = person;
        }
        this.initializeTable();
        super.performDefaults();
    }

    protected void performApply() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage == null) {
            this.save();
        }
    }

    public boolean performOk() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage != null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("There is an error in \"Person\" preference values. Please fix before saving! Error: " + errorMessage));
        }
        return errorMessage == null ? this.save() : false;
    }

    private String validateInput() {
        String errorMessage = null;
        HashSet<String> uniquePersons = new HashSet<String>();
        uniquePersons.addAll(this.allPersons);
        String string = errorMessage = uniquePersons.size() == this.allPersons.size() ? errorMessage : "Non-unique Persons";
        if (uniquePersons.contains("")) {
            errorMessage = "Empty Person";
            this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)""));
        }
        return errorMessage;
    }

    private boolean save() {
        this.personPreference.setAllValues(new HashSet<String>());
        this.personPreference.setDefaultValue(null);
        for (String person : this.allPersons) {
            if (this.checkboxTableViewer.getChecked(person) && this.personPreference.getDefaultValue() == null) {
                this.personPreference.setDefaultValue(person);
            }
            this.personPreference.addValue(person);
        }
        return this.personPreference.savePreference();
    }
}

