/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.project;

import java.text.SimpleDateFormat;
import org.grits.toolbox.core.datamodel.property.project.ProjectTasklist;

public class TasklistTableColumn {
    private static final String TASK = "Task";
    private static final String PERSON = "Person";
    private static final String STATUS = "Status";
    private static final String DUE_DATE = "Due Date";
    private static final String ROLE = "Role";
    private static final String GROUP_PI = "Group/P.I.";
    private static final String NUMBER_OF_TASKS = "# of Tasks";
    private static final String DESCRIPTION = "Description";
    public static final String[] COLUMNS = new String[]{"Task", "Person", "Status", "Due Date", "Role", "Group/P.I.", "# of Tasks", "Description"};

    public static String getColumnValue(ProjectTasklist projectTasklist, String columnName) {
        String value = null;
        switch (columnName) {
            case "Task": {
                value = projectTasklist.getTask();
                break;
            }
            case "Person": {
                value = projectTasklist.getPerson();
                break;
            }
            case "Status": {
                value = projectTasklist.getStatus();
                break;
            }
            case "Due Date": {
                if (projectTasklist.getDueDate() == null) break;
                value = new SimpleDateFormat("MM/dd/yyyy").format(projectTasklist.getDueDate());
                break;
            }
            case "Role": {
                value = projectTasklist.getRole();
                break;
            }
            case "Group/P.I.": {
                value = projectTasklist.getGroupOrPIName();
                break;
            }
            case "# of Tasks": {
                value = String.valueOf(projectTasklist.getNumberOfTasks());
                break;
            }
            case "Description": {
                value = projectTasklist.getDescription();
            }
        }
        return value;
    }

    public static int getColumnNumber(String columnName) {
        int columnNum = -1;
        int index = 0;
        while (index < COLUMNS.length) {
            if (COLUMNS[index].equals(columnName)) {
                columnNum = index;
                break;
            }
            ++index;
        }
        return columnNum;
    }
}

