/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.projectexplorer.handler;

import java.io.IOException;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.io.ProjectFileHandler;
import org.grits.toolbox.core.datamodel.property.NotImplementedException;
import org.grits.toolbox.core.projectexplorer.dialog.CopyEntryDialog;
import org.grits.toolbox.core.service.IGritsDataModelService;

public class CopyEntryHandler {
    private static final Logger logger = Logger.getLogger(CopyEntryHandler.class);

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") Object object, EPartService partService, IGritsDataModelService gritsDataModelService) {
        logger.info((Object)"- START COMMAND : Copy entry");
        if (object instanceof Entry) {
            Entry currentEntry = (Entry)object;
            CopyEntryDialog dialog = new CopyEntryDialog(Display.getCurrent().getActiveShell());
            dialog.setCurrentEntry(currentEntry);
            if (dialog.open() == 0) {
                Entry destinationParent = dialog.getDestinationParentEntry();
                try {
                    Entry copiedEntry = currentEntry.copyToEntry(destinationParent);
                    gritsDataModelService.addEntry(destinationParent, copiedEntry);
                    Entry projectEntry = gritsDataModelService.findParentByType(copiedEntry, "org.grits.toolbox.property.project");
                    try {
                        ProjectFileHandler.saveProject(projectEntry);
                        logger.info((Object)"- END COMMAND : Copied entry");
                    }
                    catch (IOException e) {
                        gritsDataModelService.deleteEntry(copiedEntry);
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw e;
                    }
                }
                catch (IOException | NotImplementedException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Copy unsuccessful", (String)e.getMessage());
                }
            }
        }
    }

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") Object object) {
        return object instanceof Entry;
    }
}

