/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.utilShare.validator;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.IInputValidator;
import org.grits.toolbox.core.datamodel.DataModelHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.property.WorkspaceProperty;

public class EntryNameValidator
implements IInputValidator {
    private static final Logger logger = Logger.getLogger(EntryNameValidator.class);
    private static final String ALLOWED_REGEX = "^[a-zA-Z0-9_-]*";
    private String entryPropertyType = null;
    private Set<String> existingNames = new HashSet<String>();

    public EntryNameValidator(Entry entry) {
        if (entry != null) {
            if (entry.getProperty() != null) {
                this.entryPropertyType = entry.getProperty().getType();
            }
            if (entry.getParent() != null) {
                Entry parentEntry = entry.getParent();
                this.existingNames = EntryNameValidator.getExistingNames(parentEntry, this.entryPropertyType, entry.getDisplayName());
            }
        }
    }

    public String isValid(String newText) {
        newText = newText.trim();
        String errorMessage = null;
        if (newText == null || newText.isEmpty()) {
            errorMessage = "Name cannot be empty. Please select a unique name.";
        } else if (this.entryPropertyType != null && this.entryPropertyType == "org.grits.toolbox.property.project") {
            errorMessage = EntryNameValidator.validateProjectName(this.existingNames, newText);
        } else if (this.existingNames.contains(newText)) {
            errorMessage = "This name already exists. Please choose a unique name";
        }
        return errorMessage;
    }

    public static final Set<String> getExistingNames(Entry parentEntry, String entryPropertyType, String currentName) {
        HashSet<String> existingNames = new HashSet<String>();
        if (entryPropertyType != null && entryPropertyType.equals("org.grits.toolbox.property.project")) {
            try {
                File workspaceFolder = new File(((WorkspaceProperty)DataModelHandler.instance().getRoot().getProperty()).getLocation());
                File[] fileArray = workspaceFolder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    existingNames.add(file.getName());
                    ++n2;
                }
            }
            catch (Exception ex) {
                logger.fatal((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        for (Entry siblingEntry : parentEntry.getChildren()) {
            existingNames.add(siblingEntry.getDisplayName());
        }
        if (currentName != null) {
            existingNames.remove(currentName);
        }
        return existingNames;
    }

    public static final String validateProjectName(Set<String> existingNames, String newText) {
        String errorMessage = null;
        if (newText == null || newText.isEmpty()) {
            errorMessage = "Name cannot be null or empty.";
        } else if (!newText.matches(ALLOWED_REGEX)) {
            errorMessage = "Project name cannot use special characters. \"-\" and \"_\" are the only allowed special characters. Please use other characters.";
        } else if (newText.length() > 32) {
            errorMessage = "Name cannot be longer than 32 characters";
        } else {
            for (String name : existingNames) {
                if (!name.equalsIgnoreCase(newText)) continue;
                errorMessage = "This name already exists (case-insensitive or hidden) in the workspace. Please choose a unique name";
                break;
            }
        }
        return errorMessage;
    }
}

