/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.Component;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.TextUtils;

public class MultiLineHeaderRenderer
extends JList
implements TableCellRenderer {
    protected GlycanRenderer theGlycanRenderer;

    public MultiLineHeaderRenderer(GlycanRenderer gr) {
        this.theGlycanRenderer = gr;
        this.setOpaque(true);
        this.setForeground(UIManager.getColor("TableHeader.foreground"));
        this.setBackground(UIManager.getColor("TableHeader.background"));
        Border border = UIManager.getBorder("TableHeader.cellBorder");
        EmptyBorder margin = new EmptyBorder(2, 2, 2, 2);
        this.setBorder(new CompoundBorder(border, margin));
        this.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.setHorizontalAlignment(2);
                this.setVerticalAlignment(0);
                if (value instanceof Glycan) {
                    this.setIcon(new ImageIcon(MultiLineHeaderRenderer.this.theGlycanRenderer.getImage((Glycan)value, false, false, false, 0.4)));
                    this.setText(null);
                } else {
                    this.setIcon(null);
                    this.setText(value.toString());
                }
                return this;
            }
        });
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setFont(table.getFont());
        if (value == null) {
            this.setListData(new Vector());
        } else if (value instanceof Vector) {
            this.setListData((Vector)value);
        } else if (value instanceof Glycan) {
            Vector<Glycan> v = new Vector<Glycan>();
            v.add((Glycan)value);
            this.setListData(v);
        } else {
            this.setListData(TextUtils.splitLines((String)value.toString()));
        }
        return this;
    }
}

