/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.STOCK_ICON;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.NotesDocument;
import org.eurocarbdb.application.glycoworkbench.plugin.DocumentPanel;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;

public class NotesPanel
extends DocumentPanel<NotesDocument>
implements ActionListener,
DocumentListener,
Printable {
    private static final long serialVersionUID = 0L;
    protected JTextPane theTextPane;
    protected JToolBar theToolBar;
    boolean ignore_text_change = false;

    @Override
    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.theTextPane = new JTextPane();
        this.add((Component)new JScrollPane(this.theTextPane), "Center");
        this.theTextPane.getDocument().addDocumentListener(this);
        this.theToolBar = this.createToolBar();
        this.add((Component)this.theToolBar, "South");
    }

    @Override
    public NotesDocument getDocumentFromWorkspace(GlycanWorkspace workspace) {
        return workspace != null ? workspace.getNotes() : null;
    }

    @Override
    public void setDocumentFromWorkspace(GlycanWorkspace workspace) {
        if (this.theDocument != null) {
            ((NotesDocument)((Object)this.theDocument)).removeDocumentChangeListener(this);
        }
        this.theDocument = this.getDocumentFromWorkspace(workspace);
        if (this.theDocument == null) {
            this.theDocument = new NotesDocument();
        }
        ((NotesDocument)((Object)this.theDocument)).addDocumentChangeListener(this);
        this.updateView();
        this.updateActions();
    }

    @Override
    protected void createActions() {
        this.theActionManager.add("new", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.REFRESH, Plugin.DEFAULT_ICON_SIZE), "Clear", 78, "", (ActionListener)this);
        this.theActionManager.add("open", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_OPEN, Plugin.DEFAULT_ICON_SIZE), "Open", 79, "", (ActionListener)this);
        this.theActionManager.add("save", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_SAVE, Plugin.DEFAULT_ICON_SIZE), "Save", 83, "", (ActionListener)this);
        this.theActionManager.add("saveas", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_SAVE_AS, Plugin.DEFAULT_ICON_SIZE), "Save as...", 65, "", (ActionListener)this);
        this.theActionManager.add("print", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.DOCUMENT_PRINT, Plugin.DEFAULT_ICON_SIZE), "Print...", 80, "", (ActionListener)this);
        this.theActionManager.add("undo", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.UNDO, Plugin.DEFAULT_ICON_SIZE), "Undo", 85, "", (ActionListener)this);
        this.theActionManager.add("redo", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.REDO, Plugin.DEFAULT_ICON_SIZE), "Redo", 82, "", (ActionListener)this);
        this.theActionManager.add("add", FileUtils.defaultThemeManager.getImageIcon("add"), "Add peak", 68, "", (ActionListener)this);
        this.theActionManager.add("cut", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.CUT, Plugin.DEFAULT_ICON_SIZE), "Cut", 84, "", (ActionListener)this);
        this.theActionManager.add("copy", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.COPY, Plugin.DEFAULT_ICON_SIZE), "Copy", 67, "", (ActionListener)this);
        this.theActionManager.add("paste", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.PASTE, Plugin.DEFAULT_ICON_SIZE), "Paste", 80, "", (ActionListener)this);
        this.theActionManager.add("delete", GlycoWorkbench.getDefaultThemeManager().getResizableIcon("deleteNew", Plugin.DEFAULT_ICON_SIZE), "Delete", 127, "", (ActionListener)this);
        this.theActionManager.add("selectall", FileUtils.defaultThemeManager.getImageIcon("selectall"), "Select all", 65, "", (ActionListener)this);
    }

    @Override
    protected void updateActions() {
        boolean has_selection = this.theTextPane.getSelectionStart() != -1;
        this.theActionManager.get("save").setEnabled(((NotesDocument)((Object)this.theDocument)).hasChanged());
        this.theActionManager.get("undo").setEnabled(((NotesDocument)((Object)this.theDocument)).getUndoManager().canUndo());
        this.theActionManager.get("redo").setEnabled(((NotesDocument)((Object)this.theDocument)).getUndoManager().canRedo());
        this.theActionManager.get("cut").setEnabled(has_selection);
        this.theActionManager.get("copy").setEnabled(has_selection);
        this.theActionManager.get("delete").setEnabled(has_selection);
    }

    private JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("new"));
        toolbar.add((Action)this.theActionManager.get("open"));
        toolbar.add((Action)this.theActionManager.get("save"));
        toolbar.add((Action)this.theActionManager.get("saveas"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("print"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("undo"));
        toolbar.add((Action)this.theActionManager.get("redo"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("cut"));
        toolbar.add((Action)this.theActionManager.get("copy"));
        toolbar.add((Action)this.theActionManager.get("paste"));
        toolbar.add((Action)this.theActionManager.get("delete"));
        return toolbar;
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add((Action)this.theActionManager.get("cut"));
        menu.add((Action)this.theActionManager.get("copy"));
        menu.add((Action)this.theActionManager.get("paste"));
        menu.add((Action)this.theActionManager.get("delete"));
        return menu;
    }

    public boolean checkDocumentChanges() {
        if (((NotesDocument)((Object)this.theDocument)).hasChanged() && ((NotesDocument)((Object)this.theDocument)).wasSaved() && !((NotesDocument)((Object)this.theDocument)).isEmpty()) {
            int ret = JOptionPane.showConfirmDialog(this, "Save changes to notes?", null, 1, 3);
            if (ret == 2) {
                return false;
            }
            if (ret == 0 && !this.theApplication.onSaveAs((BaseDocument)this.theDocument)) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void updateData() {
    }

    @Override
    protected void updateView() {
        if (!this.ignore_text_change) {
            this.ignore_text_change = true;
            this.theTextPane.setText(((NotesDocument)((Object)this.theDocument)).getText());
            this.ignore_text_change = false;
        }
    }

    public void onPrint() {
        try {
            PrinterJob pj = this.theWorkspace.getPrinterJob();
            HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
            if (pj.printDialog(aset)) {
                SimpleDoc doc = new SimpleDoc(((NotesDocument)((Object)this.theDocument)).getText(), DocFlavor.STRING.TEXT_PLAIN, null);
                PrintService ps = pj.getPrintService();
                DocPrintJob job = ps.createPrintJob();
                job.print(doc, aset);
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > 0) {
            return 1;
        }
        this.theTextPane.print(graphics);
        return 0;
    }

    public void onUndo() {
        try {
            ((NotesDocument)((Object)this.theDocument)).getUndoManager().undo();
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public void onRedo() {
        try {
            ((NotesDocument)((Object)this.theDocument)).getUndoManager().redo();
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
    }

    public void cut() {
        this.theTextPane.cut();
    }

    public void copy() {
        this.theTextPane.copy();
    }

    public void delete() {
        this.theTextPane.cut();
    }

    public void paste() {
        this.theTextPane.paste();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = GlycanAction.getAction((ActionEvent)e);
        if (action.equals("new")) {
            this.theApplication.onNew((BaseDocument)this.theDocument);
        } else if (action.equals("open")) {
            this.theApplication.onOpen(null, (BaseDocument)this.theDocument, false);
        } else if (action.equals("save")) {
            this.theApplication.onSave((BaseDocument)this.theDocument);
        } else if (action.equals("saveas")) {
            this.theApplication.onSaveAs((BaseDocument)this.theDocument);
        } else if (action.equals("print")) {
            this.onPrint();
        } else if (action.equals("undo")) {
            this.onUndo();
        } else if (action.equals("redo")) {
            this.onRedo();
        } else if (action.equals("cut")) {
            this.cut();
        } else if (action.equals("copy")) {
            this.copy();
        } else if (action.equals("paste")) {
            this.paste();
        } else if (action.equals("delete")) {
            this.delete();
        }
        this.updateActions();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (!this.ignore_text_change) {
            this.ignore_text_change = true;
            ((NotesDocument)((Object)this.theDocument)).setText(this.theTextPane.getText());
            this.ignore_text_change = false;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (!this.ignore_text_change) {
            this.ignore_text_change = true;
            ((NotesDocument)((Object)this.theDocument)).setText(this.theTextPane.getText());
            this.ignore_text_change = false;
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!this.ignore_text_change) {
            this.ignore_text_change = true;
            ((NotesDocument)((Object)this.theDocument)).setText(this.theTextPane.getText());
            this.ignore_text_change = false;
        }
    }
}

