/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.GlycanAction;
import org.eurocarbdb.application.glycanbuilder.ICON_SIZE;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.Molecule;
import org.eurocarbdb.application.glycanbuilder.ThemeManager;
import org.eurocarbdb.application.glycoworkbench.Annotation;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.MMFCreator;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotationMultiple;
import org.eurocarbdb.application.glycoworkbench.PeakData;
import org.eurocarbdb.application.glycoworkbench.plugin.MSUtils;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.eurocarbdb.application.glycoworkbench.plugin.PluginManager;
import org.eurocarbdb.application.glycoworkbench.plugin.grammar.Grammar;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.AnnotationReportChoiceDialog;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.AnnotationReportDocument;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.AnnotationReportEditor;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.AnnotationReportOptions;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.ProfilesComparisonReportChartFrame;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.ProfilesComparisonReportDialog;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.ProfilesComparisonReportDocument;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.ProfilesComparisonReportOptions;
import org.eurocarbdb.application.glycoworkbench.plugin.reporting.ProfilesComparisonReportTableFrame;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;

public class ReportingPlugin
implements Plugin,
ActionListener {
    protected PluginManager theManager = null;
    protected GlycoWorkbench theApplication = null;
    protected GlycanWorkspace theWorkspace = null;
    protected Grammar theGrammar = null;
    protected AnnotationReportOptions theAnnotationReportOptions = new AnnotationReportOptions();
    protected ProfilesComparisonReportOptions theProfilesComparisonReportOptions = new ProfilesComparisonReportOptions();
    protected HashMap<AnnotationReportDocument, AnnotationReportEditor> openAnnotationReportEditors = new HashMap();
    protected HashMap<String, GlycanAction> publicActionMap = new HashMap();
    public static String PLUGIN_NAME = "Reporting";

    public ReportingPlugin(GlycoWorkbench bench) {
        this.theApplication = bench;
        try {
            this.theGrammar = new Grammar("/conf/sim_human_ng_grammar.gwg", false);
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
        }
        GlycanAction glycanAction = new GlycanAction("reportAnnotations", GlycoWorkbench.getDefaultThemeManager().getResizableIcon("report", Plugin.DEFAULT_ICON_SIZE), "Generate annotation report", 78, "", (ActionListener)this);
        this.addActionToPublicMap(glycanAction);
    }

    public GlycanAction getAction(String action) {
        return this.publicActionMap.get(action);
    }

    private void addActionToPublicMap(GlycanAction glycanAction) {
        this.publicActionMap.put(glycanAction.getActionCommand(), glycanAction);
    }

    @Override
    public void init() {
        if (this.theWorkspace != null) {
            this.theAnnotationReportOptions.retrieve(this.theWorkspace.getConfiguration());
            this.theProfilesComparisonReportOptions.retrieve(this.theWorkspace.getConfiguration());
        }
    }

    @Override
    public void exit() {
        if (this.theWorkspace != null) {
            this.theAnnotationReportOptions.store(this.theWorkspace.getConfiguration());
            this.theProfilesComparisonReportOptions.store(this.theWorkspace.getConfiguration());
        }
    }

    @Override
    public String getName() {
        return PLUGIN_NAME;
    }

    @Override
    public int getMnemonic() {
        return 82;
    }

    public ResizableIcon getResizableIcon() {
        return FileUtils.getThemeManager().getResizableIcon("report", Plugin.DEFAULT_ICON_SIZE).getResizableIcon();
    }

    @Override
    public ImageIcon getIcon() {
        return FileUtils.defaultThemeManager.getImageIcon("report");
    }

    @Override
    public int getViewPosition(String view) {
        return 1;
    }

    @Override
    public Component getLeftComponent() {
        return null;
    }

    @Override
    public Component getRightComponent() {
        return null;
    }

    @Override
    public Component getBottomComponent() {
        return null;
    }

    @Override
    public Collection<String> getViews() {
        Vector<String> views = new Vector<String>();
        return views;
    }

    @Override
    public Collection<GlycanAction> getActions() {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        actions.add(new GlycanAction("reportAnnotations", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Create a report of the annotations", 67, "", (ActionListener)this));
        actions.add(new GlycanAction("openAnnotationsReport", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Open a previous annotations report", 79, "", (ActionListener)this));
        actions.add(null);
        actions.add(new GlycanAction("deisotope", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Deisotope the annotated peaklist using the annotations", 68, "", (ActionListener)this));
        actions.add(new GlycanAction("reportProfilesComparison", ThemeManager.getResizableEmptyIcon((ICON_SIZE)Plugin.DEFAULT_ICON_SIZE), "Create a report comparing different profiles", 80, "", (ActionListener)this));
        return actions;
    }

    @Override
    public Collection<GlycanAction> getToolbarActions() {
        return new Vector<GlycanAction>();
    }

    @Override
    public Collection<GlycanAction> getObjectActions(Object prototype, ActionListener al) {
        Vector<GlycanAction> actions = new Vector<GlycanAction>();
        return actions;
    }

    @Override
    public void setManager(PluginManager manager) {
        this.theManager = manager;
    }

    @Override
    public void setApplication(GlycoWorkbench application) {
        this.theApplication = application;
    }

    @Override
    public void setWorkspace(GlycanWorkspace workspace) {
        this.theWorkspace = workspace;
        if (this.theWorkspace != null) {
            this.theAnnotationReportOptions.retrieve(this.theWorkspace.getConfiguration());
            this.theProfilesComparisonReportOptions.retrieve(this.theWorkspace.getConfiguration());
        }
    }

    @Override
    public PluginManager getManager() {
        return this.theManager;
    }

    @Override
    public GlycoWorkbench getApplication() {
        return this.theApplication;
    }

    @Override
    public GlycanWorkspace getWorkspace() {
        return this.theWorkspace;
    }

    public AnnotationReportOptions getAnnotationReportOptions() {
        return this.theAnnotationReportOptions;
    }

    @Override
    public void show(String view) throws Exception {
        throw new Exception("Invalid view: " + view);
    }

    @Override
    public boolean runAction(String action) throws Exception {
        return this.runAction(action, (Object)this.theWorkspace.getPeakList());
    }

    @Override
    public boolean runAction(String action, Object params) throws Exception {
        if (action.equals("reportAnnotations")) {
            return this.reportAnnotations();
        }
        if (action.equals("reportProfilesComparison")) {
            return this.reportProfilesComparison();
        }
        if (action.equals("deisotope")) {
            return this.deisotopeAnnotatedPeakList(false);
        }
        if (action.equals("openAnnotationsReport")) {
            return this.openAnnotationsReport();
        }
        throw new Exception("Invalid action: " + action);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.runAction(GlycanAction.getAction((ActionEvent)e));
        }
        catch (Exception ex) {
            LogUtils.report((Exception)ex);
        }
    }

    @Override
    public void updateViews() {
    }

    @Override
    public void updateMasses() {
    }

    public boolean reportAnnotations() {
        if (this.theWorkspace.getAnnotatedPeakList().size() > 0) {
            AnnotationReportChoiceDialog dlg = new AnnotationReportChoiceDialog((Frame)((Object)this.theApplication), this.theWorkspace, this.theAnnotationReportOptions);
            dlg.setVisible(true);
            if (dlg.getReturnStatus().equals("OK")) {
                try {
                    PeakData peakData = this.theAnnotationReportOptions.SHOW_COMPLETE_PEAK_LIST ? new PeakData(this.theWorkspace.getPeakList().getData(), new MMFCreator()) : dlg.getPeakData();
                    AnnotationReportDocument doc = new AnnotationReportDocument(dlg.getStartMZ(), dlg.getEndMZ(), peakData, dlg.getParentStructure(), dlg.getPeakAnnotationCollection(), this.theAnnotationReportOptions, this.theWorkspace.getGraphicOptions());
                    this.theWorkspace.addAnnotationReport(doc);
                    this.showAnnotationsReport(doc, true);
                }
                catch (Exception ex) {
                    LogUtils.report((Exception)ex);
                }
                return true;
            }
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this.theApplication), "There are not annotation to display.", "Error", 0);
        }
        return false;
    }

    public boolean reportProfilesComparison() {
        ProfilesComparisonReportDialog dlg = new ProfilesComparisonReportDialog((Frame)((Object)this.theApplication), this.theWorkspace, this.theProfilesComparisonReportOptions);
        dlg.setVisible(true);
        if (dlg.getReturnStatus().equals("OK") && dlg.getFirstGroup().size() > 0) {
            this.theApplication.haltInteractions();
            try {
                ProfilesComparisonReportDocument doc = new ProfilesComparisonReportDocument(dlg.getFirstGroup(), dlg.getSecondGroup(), dlg.getScanNameMap(), this.theGrammar, this.theProfilesComparisonReportOptions);
                this.theApplication.restoreInteractions();
                if (this.theProfilesComparisonReportOptions.REPRESENTATION == 1) {
                    new ProfilesComparisonReportTableFrame(this.theApplication, doc, this.theProfilesComparisonReportOptions).setVisible(true);
                } else {
                    new ProfilesComparisonReportChartFrame(this.theApplication, doc, this.theProfilesComparisonReportOptions).setVisible(true);
                }
                return true;
            }
            catch (Exception e) {
                LogUtils.report((Exception)e);
                this.theApplication.restoreInteractions();
                return false;
            }
        }
        return false;
    }

    public boolean openAnnotationsReport() {
        AnnotationReportDocument doc = new AnnotationReportDocument();
        if (this.theApplication.onOpen(null, doc, false)) {
            this.showAnnotationsReport(doc, false);
        }
        return true;
    }

    public boolean showAnnotationsReport(AnnotationReportDocument doc, boolean init) {
        if (doc != null) {
            AnnotationReportEditor are = this.openAnnotationReportEditors.get((Object)doc);
            if (are == null || !are.isVisible()) {
                are = new AnnotationReportEditor(this.theApplication, this, doc, init);
                this.openAnnotationReportEditors.put(doc, are);
                are.setVisible(true);
            }
            return true;
        }
        return false;
    }

    public boolean deisotopeAnnotatedPeakList(boolean show_all) {
        if (this.theWorkspace.getAnnotatedPeakList().size() == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this.theApplication), "The annotated peaklis is empty", "Error", 0);
            return false;
        }
        if (JOptionPane.showConfirmDialog((Component)((Object)this.theApplication), "Attention, the method will compute invalid intensities if the peaklist has already been deisotoped. Do you still want to continue?", null, 0, 2) != 0) {
            return false;
        }
        try {
            HashSet compositions;
            Peak p;
            TreeMap<Peak, HashSet> data = new TreeMap<Peak, HashSet>();
            for (PeakAnnotationMultiple peakAnnotationMultiple : this.theWorkspace.getAnnotatedPeakList().getAnnotations()) {
                p = peakAnnotationMultiple.getPeak();
                compositions = new HashSet();
                for (Vector<Annotation> annotations : peakAnnotationMultiple.getAnnotations()) {
                    for (Annotation annotation : annotations) {
                        if (annotation.isEmpty()) continue;
                        compositions.add(annotation.getFragmentEntry().fragment.computeIon());
                    }
                }
                data.put(p.clone(), compositions);
            }
            block5: for (Map.Entry entry : data.entrySet()) {
                int i;
                p = (Peak)entry.getKey();
                compositions = (HashSet)entry.getValue();
                if (p.getIntensity() == 0.0 || compositions.size() == 0) continue;
                Vector<double[][]> all_curves = new Vector<double[][]>();
                for (Molecule m : compositions) {
                    double[][] curve = MSUtils.getIsotopesCurve(1, m, show_all);
                    MSUtils.adjust(curve, p.getMZ(), p.getIntensity());
                    all_curves.add(curve);
                }
                double[][] avg_curve = MSUtils.average(all_curves, show_all);
                double sum = 0.0;
                for (i = 0; i < avg_curve[0].length; ++i) {
                    sum += avg_curve[1][i];
                }
                p.setIntensity(sum);
                i = 1;
                int no_isotopes = avg_curve[0].length;
                double mass_tol = show_all ? 1.0E-4 : 0.5;
                for (Map.Entry t : data.tailMap(p).entrySet()) {
                    Peak tp = t.getKey();
                    if (i == no_isotopes) continue block5;
                    while (i < no_isotopes && tp.getMZ() > avg_curve[0][i] + mass_tol) {
                        ++i;
                    }
                    if (i >= no_isotopes || !(Math.abs(tp.getMZ() - avg_curve[0][i]) <= mass_tol)) continue;
                    tp.setIntensity(Math.max(0.0, tp.getIntensity() - avg_curve[1][i]));
                }
            }
            this.theWorkspace.getAnnotatedPeakList().updatePeaks(data.keySet());
            if (JOptionPane.showConfirmDialog((Component)((Object)this.theApplication), "Do you want to update the intensities in the peaklist as well?", null, 0) == 0) {
                this.theWorkspace.getPeakList().updatePeaks(data.keySet());
            }
            return true;
        }
        catch (Exception ex) {
            LogUtils.report((Exception)ex);
            return false;
        }
    }

    @Override
    public void completeSetup() {
    }

    @Override
    public List<JRibbonBand> getBandsForToolBar() {
        return null;
    }

    @Override
    public RibbonTask getRibbonTask() {
        return null;
    }
}

